<?php

namespace App\Http\Middleware;

use Closure;
use Auth; //at the top
class Administrator
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    function handle($request, Closure $next, $guard = null)
  {
    
    if(!empty(Auth::user()->is_role)){
      if(Auth::check()){
          $role = Auth::user()->is_role;

          switch ($role) {
                case 'Administrator':
                  return $next($request);
                  break;
                case 'MerchantIn':
                  return redirect()->route('dashboard_merchant');
                break;
                case 'MerchantOut':
                  return redirect()->route('dashboard_merchant');
                  break;
                case 'Driver':
                  return redirect()->route('dashboard_driver');
                  break;
                default:
                  return response()->view('errors.403', [], 403);
                  break;
              }
      }
    }
    return redirect()->guest('login');
    
  }
}