<?php

namespace App\Http\Controllers\Merchant;

use App\CategoryModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use Auth;
use DB;
use App\RequestPendingPickup;
use App\RequestPickup;
use App\RequestPickupDetailModel;
use phpDocumentor\Reflection\Location;

class RequestController extends Controller
{
    public function store(Request $request){
        $req = new RequestPickup();
        $req->merchant_id = Auth::user()->id;
        $req->exchange_rate = $request->exchange_rate;
        $req->date =  date('Y-m-d',strtotime($request->date));
        $req->status = 1;
        $req->type = 1;
        $req->save();
        $pending_merchant_pickup = RequestPendingPickup::where('user_id','=',Auth::user()->id)->get(); 
        $merchant_request_detail = new RequestPickupDetailModel(); 
        foreach( $pending_merchant_pickup as $item){ 
            $data = LocationModel::where('id',$item->location_id)->first(); 
            $merchant_request_detail                         = new RequestPickupDetailModel(); 
            $merchant_request_detail->request_pickup_id      = $req->id;
            $merchant_request_detail->user_id                = $item->user_id;
            $merchant_request_detail->category_id            = $item->category_id;
            $merchant_request_detail->customer_receive       = $item->customer_receive;
            $merchant_request_detail->zoon_id                = $data->pearent_id;
            $merchant_request_detail->location_id            = $item->location_id;
            $merchant_request_detail->delivery_fee           = $item->delivery_fee;
            $merchant_request_detail->delivery_status        = $item->delivery_status;
            $merchant_request_detail->price                  = $item->price;
            $merchant_request_detail->delivery_option        = $item->delivery_option;
            $merchant_request_detail->taxi_number            = $item->taxi_number;
            $merchant_request_detail->description            = $item->description;
            $merchant_request_detail->date_delivery            = $item->date_delivery;
            $merchant_request_detail->delivery_pay_or_paid = 'pay';
            $merchant_request_detail->taxi_status = 1;
            $merchant_request_detail->taxi_shop_fee = 0;
            $merchant_request_detail->taxi_pay_or_paid= 'pay';
            $merchant_request_detail->other_services_type =1;
            $merchant_request_detail->other_services_fee =0;
            $merchant_request_detail->other_services_pay_or_paid = 'pay';
            $merchant_request_detail->save();
            $item->delete();

        }
        // dd( $merchant_request_detail);


        return redirect('/dashboard-merchant/pick-up');
    }
    public function index(){

        $mr = RequestPickup::where('merchant_id','=',Auth::user()->id)
        ->leftjoin('users','users.id','nso007_request_pickup.merchant_id')
        ->leftjoin('users As driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*','users.shop_name','driver.name AS driver_name','driver.phone')->get();

        return view('merchant.pickup.index',compact('mr'));
    }
    public function merchant_in_import_stock(Request $request){
        $req = new RequestPickup();
        $req->merchant_id = Auth::user()->id;
        $req->exchange_rate = $request->exchange_rate;
        $req->date =  date('Y-m-d',strtotime($request->date));
        $req->status = 2;
        $req->description = $request->description;
        $req->type = 2;
        $req->save();
        return redirect('/dashboard-merchant/pick-up');
    }
    public function cancel($id){
        $req = RequestPickup::find($id);
        $req->delete();
        RequestPickupDetailModel::where('request_pickup_id', '=' , $id)->delete();
        return back();

    }
    public function show ($id){
        $req = RequestPickup::leftjoin('users','users.id','nso007_request_pickup.driver_pick_up_id')->where('nso007_request_pickup.id',$id)
        ->select('nso007_request_pickup.*','users.name','users.phone')
        ->first();
        $reqdetail = RequestPickupDetailModel::where('request_pickup_id', '=' , $id)->get();
        $categories = CategoryModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select Category', '')->toArray();
        // $zoon = LocationModel::where([['status',1],['pearent_id',null]])->pluck('name_km', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where([['status',1],['pearent_id','!=',null]])->pluck('name_km', 'id')->prepend(__('administrator.location'), '');
        $bus = \DB::table('nso007_bus')->where('status',1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();
        if($req->type == 1){
            return view('merchant.pickup.show_out', compact('req','reqdetail','categories','location','bus'));
        }
        else if($req->type == 2){
            return view('merchant.pickup.show_in', compact('req'));
        }

    }



    public function show_edit(Request $request){
        $reqdetail = RequestPickupDetailModel::where('id', '=' ,$request->id)->first();
        return $reqdetail;
    }



    public function show_delete(Request $request){
        $reqdetail = RequestPickupDetailModel::where('id', '=' ,$request->id)->first();
        return $reqdetail;
    } 

    public function show_update(Request $request){
        // dd($request->date_delivery);
        $mpp = RequestPickupDetailModel::find($request->id);
        $mpp->user_id = Auth::user()->id;
        $cat ='';
        if($request->category_id==null){
            $cat ='another';
        }
        else {
            $cat =$request->category_id;
        }
        $data = LocationModel::where('id',$request->location_id)->first(); 
        $mpp->category_id           =  $cat;
        $mpp->customer_receive      = $request->customer_receive;
        $mpp->zoon_id               = $data->pearent_id;
        $mpp->location_id           = $request->location_id;
        $mpp->delivery_fee          = $request->delivery_fee;
        $mpp->delivery_status       = $request->delivery_status;
        $mpp->price                 = $request->price;
        $mpp->delivery_option       = $request->bus_id;
        $mpp->taxi_number           = $request->taxi_number;
        $mpp->description           = $request->description;
        $mpp->date_delivery            = date('Y-m-d', strtotime($request->date_delivery));
        $mpp->delivery_pay_or_paid = 'pay';
        $mpp->taxi_status = 1;
        $mpp->taxi_shop_fee = 0;
        $mpp->taxi_pay_or_paid= 'pay';
        $mpp->other_services_type =1;
        $mpp->other_services_fee =0;
        $mpp->other_services_pay_or_paid = 'pay';
        $mpp->update();
        // dd($mpp);

        $merchant_pending_pickup = DB::table('nso007_request_pickup_detail')->where('nso007_request_pickup_detail.id',$mpp->id)
        ->join('nso007_category','nso007_category.id', 'nso007_request_pickup_detail.category_id')
       ->join('nso007_location','nso007_location.id','nso007_request_pickup_detail.location_id')

       ->select('nso007_request_pickup_detail.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
       ->first();
       $by ='';
       if($merchant_pending_pickup->delivery_option == 1){
           $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_option == 2){
        $by ='ខាងអតិថិជន';
       }
       $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
            <div class="mobile-detail">
                <div class="mobile-text">
                    <div class="texted-left">
                        <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                        <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                        <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                        <li>បង់ដោយ: <span>'.$by.'</span></li>
                    </div>
                    <div class="texted-right">
                        <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                        <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                        <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
                    </div>
                    <div class="diver-boxdelete">
                        <div class="mobile-button">
                            <button class="btn-edit button-edit" data-id="'.$merchant_pending_pickup->id.'">Edit </button>
                            <button class="btn-delete button-delete" data-id="'.$merchant_pending_pickup->id.'">Delete</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
        return response()->json(['box'=>$box]);
    }

    public function show_store(Request $request){

        $mpp =  new RequestPickupDetailModel();
        $mpp->user_id = Auth::user()->id;
        $cat ='';
        if($request->category_id==null){
            $cat ='another';
        }
        else {
            $cat =$request->category_id;
        }
        $mpp->request_pickup_id = $request->id;
        $mpp->category_id =  $cat;
        $mpp->customer_receive = $request->customer_receive;
        $mpp->zoon_id = $request->zoon_id;
        $mpp->location_id = $request->location_id;
        $mpp->delivery_fee = $request->delivery_fee;
        $mpp->delivery_status = $request->delivery_status;
        $mpp->price = $request->price;
        $mpp->delivery_option = $request->bus_id;
        $mpp->taxi_number = $request->taxi_number;
        $mpp->description = $request->description;
        $mpp->date_delivery            =date('Y-m-d', strtotime($request->date_delivery)); 
        $mpp->delivery_pay_or_paid = 'pay';
        $mpp->taxi_status = 1;
        $mpp->taxi_shop_fee = 0;
        $mpp->taxi_pay_or_paid= 'pay';
        $mpp->other_services_type =1;
        $mpp->other_services_fee =0;
        $mpp->other_services_pay_or_paid = 'pay';
        // dd($request->date_delivery);
        $mpp->save();

        $merchant_pending_pickup = DB::table('nso007_request_pickup_detail')->where('nso007_request_pickup_detail.id',$mpp->id)
        ->where('user_id','=', Auth::user()->id)
        ->join('nso007_category','nso007_category.id', 'nso007_request_pickup_detail.category_id')
       ->join('nso007_location','nso007_location.id', 'nso007_request_pickup_detail.location_id')

       ->select('nso007_request_pickup_detail.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
       ->first();

       $by ='';
       if($merchant_pending_pickup->delivery_status == 1){
           $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_status == 2){
        $by ='ខាងអតិថិជន';
       }
       $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
       <div class="mobile-detail">
           <div class="mobile-text">
               <div class="texted-left">
                   <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                   <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                   <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                   <li>បង់ដោយ: <span>'.$by.'</span></li>
               </div>
               <div class="texted-right">
                   <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                   <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                   <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
               </div>
               <div class="diver-boxdelete">
                   <div class="mobile-button">
                       <button class="btn-edit button-edit" data-id="'.$merchant_pending_pickup->id.'">Edit </button>
                       <button class="btn-delete button-delete" data-id="'.$merchant_pending_pickup->id.'">Delete</button>
                   </div>
               </div>
           </div>
       </div>
   </div>';
//    dd($box);
return response()->json(['box'=>$box]);
}
}
