<?php

namespace App\Http\Controllers\Merchant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use App\RequestPickup;
use App\DeliveryOrderModel;
use App\ExportStockModel;

class ReportController extends Controller
{
    public function report_stock(){
        $products = DB::table('nos007__stocks')
        ->where('merchant_id', Auth::user()->id)
        ->join('nso007_products','nso007_products.barcode','nos007__stocks.barcode')
        ->select('nso007_products.*','nos007__stocks.*')
        ->get();
        // dd($products);
        return view('merchant.report.instock', compact('products'));
    }
    public function report_inprocessing(){
        $on_proccess = DeliveryOrderModel::join('nso007_delivery_order_detail_proccessing','nso007_delivery_order.id','nso007_delivery_order_detail_proccessing.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('users As merchant','merchant.id','nso007_export_stock.merchant_id')
        ->join('users As driver','driver.id','nso007_delivery_order.driver_id')
        // ->join('users AS driver ','driver.id','nso007_delivery_order.driver_id')
        ->select(
            'merchant.name AS merchant_name',
            'driver.name AS driver_name',
            'driver.phone AS driver_phone',
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            'nso007_export_stock.taxi_shop_fee',
            'nso007_export_stock.taxi_cust_fee',
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail_proccessing.total_riel',
            'nso007_delivery_order_detail_proccessing.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price')
        )

        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->where('merchant.id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        // dd($on_proccess);
        return view('merchant.report.inprocessing', compact('on_proccess'));
    }
    public function report_success(){
        $success = DeliveryOrderModel::join('nso007_delivery_order_detail_success','nso007_delivery_order.id','nso007_delivery_order_detail_success.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('users As merchant','merchant.id','nso007_export_stock.merchant_id')
        ->join('users As driver','driver.id','nso007_delivery_order.driver_id')
        // ->join('users AS driver ','driver.id','nso007_delivery_order.driver_id')
        ->select(
            'merchant.name AS merchant_name',
            'driver.name AS driver_name',
            'driver.phone AS driver_phone',
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            'nso007_export_stock.taxi_shop_fee',
            'nso007_export_stock.taxi_cust_fee',
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail_success.total_riel',
            'nso007_delivery_order_detail_success.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price')
        )

        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->where('merchant.id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        // dd($success);
        return view('merchant.report.success', compact('success'));
    }
    public function report_cancel(){
        $cancel = DeliveryOrderModel::join('nso007_delivery_order_detail_cancel','nso007_delivery_order.id','nso007_delivery_order_detail_cancel.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_cancel.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('users As merchant','merchant.id','nso007_export_stock.merchant_id')
        ->join('users As driver','driver.id','nso007_delivery_order.driver_id')
        // ->join('users AS driver ','driver.id','nso007_delivery_order.driver_id')
        ->select(
            'merchant.name AS merchant_name',
            'driver.name AS driver_name',
            'driver.phone AS driver_phone',
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            'nso007_export_stock.taxi_shop_fee',
            'nso007_export_stock.taxi_cust_fee',
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail_cancel.reason',
            'nso007_delivery_order_detail_cancel.total_riel',
            'nso007_delivery_order_detail_cancel.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price')
        )
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->where('merchant.id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        // dd($cancel);
        return view('merchant.report.cancel', compact('cancel'));
    }


    public function report_pending(){
        $pending = DeliveryOrderModel::join('nso007_delivery_order_detail_padding','nso007_delivery_order.id','nso007_delivery_order_detail_padding.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_padding.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('users As merchant','merchant.id','nso007_export_stock.merchant_id')
        ->join('users As driver','driver.id','nso007_delivery_order.driver_id')
        // ->join('users AS driver ','driver.id','nso007_delivery_order.driver_id')
        ->select(
            'merchant.name AS merchant_name',
            'driver.name AS driver_name',
            'driver.phone AS driver_phone',
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            'nso007_export_stock.taxi_shop_fee',
            'nso007_export_stock.taxi_cust_fee',
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail_padding.reason',
            'nso007_delivery_order_detail_padding.total_riel',
            'nso007_delivery_order_detail_padding.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price')
        )

        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->where('merchant.id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        // dd($pending);
        return view('merchant.report.pending', compact('pending'));
    }
    public function report_history(Request $request){
        $history = DeliveryOrderModel::join('nso007_delivery_order_detail_padding','nso007_delivery_order.id','nso007_delivery_order_detail_padding.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_padding.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('users As merchant','merchant.id','nso007_export_stock.merchant_id')
        ->join('users As driver','driver.id','nso007_delivery_order.driver_id')
        // ->join('users AS driver ','driver.id','nso007_delivery_order.driver_id')
        ->select(
            'merchant.name AS merchant_name',
            'driver.name AS driver_name',
            'driver.phone AS driver_phone',
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            'nso007_export_stock.taxi_shop_fee',
            'nso007_export_stock.taxi_cust_fee',
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail_padding.reason',
            'nso007_delivery_order_detail_padding.total_riel',
            'nso007_delivery_order_detail_padding.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price')
        )

        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->where('merchant.id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->groupBy('nso007_export_stock.box_code')
        ->get();
    }

    public function report_history_delivery(Request $request){
        $history = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('users As merchant','merchant.id','nso007_export_stock.merchant_id')
        ->join('users As driver','driver.id','nso007_delivery_order.driver_id')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
    // ->join('users AS driver ','driver.id','nso007_delivery_order.driver_id')
        ->select(
        'merchant.name AS merchant_name',
        'driver.name AS driver_name',
        'driver.phone AS driver_phone',
        'nso007_export_stock.id',
        'nso007_export_stock.box_code',
        'nso007_export_stock.delivery_fee',
        'nso007_export_stock.customer_receive',
        'nso007_export_stock.delivery_option',
        'nso007_export_stock.delivery_status',
        'nso007_export_stock.taxi_status',
        'nso007_export_stock.taxi_shop_fee',
        'nso007_export_stock.taxi_cust_fee',
        'nso007_export_stock.taxi_number',
        'nso007_location.name_km AS location',
        'nso007_delivery_order.delivery_date',
        'nso007_export_stock.extra_fee_type',
        'nso007_export_stock.extra_fee',
        'nso007_delivery_order_detail.status',
        'nso007_delivery_order_detail.reason',
        'nso007_delivery_order_detail.total_riel',
        'nso007_delivery_order_detail.total_dollar',
        'nso007_export_stock_details.currency',
        \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price')
        )
        ->where('merchant.id',Auth::user()->id)
        ->groupBy('nso007_export_stock.box_code')
        ->orderBy('nso007_delivery_order.inovice','desc')
        ->paginate(10);
        //   dd($history);
        if ($request->ajax()) {
            $view = view('merchant.report.data-list',compact('history'))->render();
            return response()->json(['html'=>$view]);
        }
        return view('merchant.report.history', compact('history'));

    }

    public function report_history_pickup(Request $request){

        $pickup = RequestPickup::join('users','users.id','nso007_request_pickup.driver_pick_up_id')
            ->where('nso007_request_pickup.merchant_id', Auth::user()->id)
            ->whereIn('nso007_request_pickup.status', [3, 4])
            ->select(
                'nso007_request_pickup.date',
                \DB::raw("COUNT(nso007_request_pickup.status) AS amount_request")
            )
            ->groupBy('nso007_request_pickup.date')
            ->paginate(10);
        if ($request->ajax()) {
            $view = view('merchant.report.data-list-pickup',compact('pickup'))->render();
            return response()->json(['html'=>$view]);
        }
        return view('merchant.report.history_pickup', compact('pickup'));
    }
    public function history_pickup_detail( $date ){
        $pickup = DB::table('nso007_request_pickup')
        ->leftjoin('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->leftjoin('nso007_category','nso007_category.id','nso007_request_pickup_detail.category_id')
        ->leftjoin('nso007_location','nso007_location.id','nso007_request_pickup_detail.location_id')
        ->join('users','users.id','nso007_request_pickup.driver_pick_up_id')
        ->where('nso007_request_pickup.merchant_id', Auth::user()->id)
        ->whereIn('nso007_request_pickup.status', [3, 4])
        ->where('nso007_request_pickup.date', $date)
        ->get();
        return view('merchant.report.history_pickup_detail', compact('pickup'));
    }

    public function report_package(){

        $package = ExportStockModel::join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->select('nso007_export_stock.*' ,
            'nso007_category.name_km AS category',
            'nso007_location.name_km AS location',
            'nso007_export_stock_details.*',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'))
        ->where('nso007_export_stock.status' ,1)
        ->where('users.id',Auth::user()->id)
        ->groupBy('nso007_export_stock.box_code')->get();

        return view('merchant.report.report-package', compact('package'));
    }
}
