<?php

namespace App\Http\Controllers\Merchant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DeliveryOrderModel;
use Auth;
use App\CategoryModel;
use App\LocationModel;
use App\RequestPendingPickup;
use App\ExportStockModel;
use App\BranchModel;
use DB;
use App\ProductModel;

class PickUpController extends Controller
{
    public function create(){
        $exchange_rate = DB::table('nso007_currency')->first();
        $merchant_name = Auth::user()->shop_name;
        $categories = CategoryModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select Category', '')->toArray();
        // $zoon = LocationModel::where([['status',1],['pearent_id',null]])->pluck('name_km', 'id')->prepend(__('administrator.select_zone'), '');
        $location = LocationModel::where([['status',1],['pearent_id','!=',null]])->pluck('name_km', 'id')->prepend(__('administrator.location'), '');
        $bus = \DB::table('nso007_bus')->where('status',1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();
        $mpp = RequestPendingPickup::where('user_id',Auth::user()->id)->get();
        foreach($mpp as $m){
            if(date('Y-m-d H:i:s') >= date('Y-m-d H:i:s', strtotime("+1 day", strtotime($m->updated_at)))){
                $m->delete();
            }
        } 
        if(Auth::user()->type_of_merchant == 1){
            return view('merchant.pickup.pickup_merchantin');
        }
        elseif(Auth::user()->type_of_merchant == 2){
            return view('merchant.pickup.pickup_merchantout',compact(['merchant_name','categories','location','bus','mpp','exchange_rate']));
        }

    }

    public function create_merchant_in(){
        $exchange_rate = DB::table('nso007_currency')->first();
        $merchant_name = Auth::user()->shop_name;
        $categories = CategoryModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select Category', '')->toArray();
        // $zoon = LocationModel::where([['status',1],['pearent_id',null]])->pluck('name_km', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where([['status',1],['pearent_id','!=',null]])->pluck('name_km', 'id')->prepend(__('administrator.location'), '');
        $bus = \DB::table('nso007_bus')->where('status',1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();

        $mpp = RequestPendingPickup::where('user_id',Auth::user()->id)->get();
        foreach($mpp as $m){
            if(date('Y-m-d H:i:s') >= date('Y-m-d H:i:s', strtotime("+1 day", strtotime($m->updated_at)))){
                $m->delete();
            }
        }
        return view('merchant.pickup.merchantIn.outstock',compact(['merchant_name','categories','location','bus','mpp','exchange_rate']));
    }

    public function find_location(Request $request){
        $location = LocationModel:: where('status',1)->where('pearent_id',$request->id)->get();

        return $location;
    }
    public function find_delivery_fee(Request $request){
        $data = LocationModel::find($request->id);
        $price = $data->price;
        return $price ;
    }
    public function merchant_pending_pickup_store(Request $request){

        $mpp = new RequestPendingPickup();
        $mpp->user_id = Auth::user()->id;
        $cat ='';
        if($request->category_id==null){
            $cat ='another';
        }
        else {
            $cat =$request->category_id;
        }
        $mpp->category_id =  $cat;
        $mpp->customer_receive = $request->customer_receive;
        // $mpp->zoon_id = $request->zoon_id;
        $mpp->location_id = $request->location_id;
        $mpp->delivery_fee = $request->delivery_fee;
        $mpp->delivery_status = $request->delivery_status;
        $mpp->price = $request->price;
        $mpp->delivery_option = $request->bus_id;
        $mpp->taxi_number = $request->taxi_number;
        $mpp->description = $request->description;
        $mpp->date_delivery = date('Y-m-d', strtotime($request->date_delivery));
        $mpp->save();

        $merchant_pending_pickup = DB::table('nso007_pending_pickup')->where('nso007_pending_pickup.id',$mpp->id)
        ->where('user_id','=', Auth::user()->id)
        ->join('nso007_category','nso007_category.id', 'nso007_pending_pickup.category_id')
       ->join('nso007_location','nso007_location.id', 'nso007_pending_pickup.location_id')

       ->select('nso007_pending_pickup.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
       ->first();

       $by ='';
       if($merchant_pending_pickup->delivery_status == 1){
           $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_status == 2){
        $by ='ខាងអតិថិជន';
       }
       $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
            <div class="mobile-detail">
                <div class="mobile-text">
                    <div class="texted-left">
                        <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                        <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                        <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                        <li>បង់ដោយ: <span>'.$by.'</span></li>
                    </div>
                    <div class="texted-right">
                        <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                        <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                        <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
                    </div>
                    <div class="diver-boxdelete">
                        <div class="mobile-button">
                            <button class="btn-edit button-edit" data-id="'.$merchant_pending_pickup->id.'">Edit </button>
                            <button class="btn-delete button-delete" data-id="'.$merchant_pending_pickup->id.'">Delete</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
        return response()->json(['box'=>$box]);
    }

    public function merchant_pending_pickup_edit(Request $request){
        $mpp = RequestPendingPickup::find($request->id);
        return $mpp;
    }

    public function  merchant_pending_pickup_delete(Request $request){
        $mpp = RequestPendingPickup::find($request->id);
        $mpp->delete();
        return $mpp;

    }

    public function merchant_pending_pickup_update(Request $request){
      
        $mpp = RequestPendingPickup::find($request->id);
        $mpp->user_id = Auth::user()->id;
        $cat ='';
        if($request->category_id==null){
            $cat ='another';
        }
        else {
            $cat =$request->category_id;
        }
        $mpp->category_id =  $cat;
        $mpp->customer_receive = $request->customer_receive;
        // $mpp->zoon_id = $request->zoon_id;
        $mpp->location_id = $request->location_id;
        $mpp->delivery_fee = $request->delivery_fee;
        $mpp->delivery_status = $request->delivery_status;
        $mpp->price = $request->price;
        $mpp->delivery_option = $request->bus_id;
        $mpp->taxi_number = $request->taxi_number;
        $mpp->description = $request->description;
        $mpp->date_delivery = date('Y-m-d', strtotime($request->date_delivery)); 
        $mpp->update();

        $merchant_pending_pickup = DB::table('nso007_pending_pickup')->where('nso007_pending_pickup.id',$mpp->id)
        ->join('nso007_category','nso007_category.id', 'nso007_pending_pickup.category_id')
       ->join('nso007_location','nso007_location.id','nso007_pending_pickup.location_id')

       ->select('nso007_pending_pickup.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
       ->first();
       $by ='';
       if($merchant_pending_pickup->delivery_status == 1){
           $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_status == 2){
        $by ='ខាងអតិថិជន';
       }
       $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
       <div class="mobile-detail">
           <div class="mobile-text">
               <div class="texted-left">
                   <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                   <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                   <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                   <li>បង់ដោយ: <span>'.$by.'</span></li>
               </div>
               <div class="texted-right">
                   <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                   <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                   <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
               </div>
               <div class="diver-boxdelete">
                   <div class="mobile-button">
                       <button class="btn-edit button-edit" data-id="'.$merchant_pending_pickup->id.'">Edit </button>
                       <button class="btn-delete button-delete" data-id="'.$merchant_pending_pickup->id.'">Delete</button>
                   </div>
               </div>
           </div>
       </div>
   </div>';
        return response()->json(['box'=>$box]);
    }

    public function merchant_in_import_stock(){
        $exchange_rate = DB::table('nso007_currency')->first();
        $merchant_name = Auth::user()->shop_name;
        return view('merchant.pickup.merchantIn.import_stock',compact(['exchange_rate','merchant_name']));
    }

    public function find_product_name(Request $request){
        $pros = ProductModel::where('name_km','LIKE','%'.$request->pro_name.'%')->orWhere('name_en','LIKE','%'.$request->pro_name.'%')->get();
        $products = '<ul class="list-pros">';
        foreach ($pros as $pro) {
          $products .= '<li class="item-pro '.$pro->id.'">' . $pro->name_km . '</li>';
        }
        $products .= '</ul>';
        return response()->json(['products'=>$products]);
    }



    //in stock delivery
    public function merchant_in_stock(){
        $exchange_rate = DB::table('nso007_currency')->first();
        $merchant_name = Auth::user()->shop_name;
        $pros = DB::table('nos007__stocks')->where('merchant_id',Auth::user()->id)
        ->join('nso007_products','nso007_products.barcode','nos007__stocks.barcode')
        ->select('nso007_products.*')->pluck('name_km', 'id')->prepend('Please Select Product', '')->toArray();
        // dd($pros);

        // $pros = ProductModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select Product', '')->toArray();
        // $zoon = LocationModel::where([['status',1],['pearent_id',null]])->pluck('name_km', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where([['status',1],['pearent_id','!=',null]])->pluck('name_km', 'id')->prepend(__('administrator.location'), '');
        $bus = \DB::table('nso007_bus')->where('status',1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();

        $mpp = RequestPendingPickup::where('user_id',Auth::user()->id)->get();
        foreach($mpp as $m){
            if(date('Y-m-d H:i:s') >= date('Y-m-d H:i:s', strtotime("+1 day", strtotime($m->updated_at)))){
                $m->delete();
            }
        }
        return view('merchant.pickup.merchantIn.stock',compact(['merchant_name','pros','location','bus','mpp','exchange_rate']));
    }

}
