<?php

namespace App\Http\Controllers\Merchant;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DeliveryOrderModel;
use Auth;
use App\CategoryModel;
use App\LocationModel;
use App\ExportStockModel;
class DashboardController extends Controller
{
    public function index()
    {
        $on_proccess = DeliveryOrderModel::join('nso007_delivery_order_detail_proccessing','nso007_delivery_order.id','nso007_delivery_order_detail_proccessing.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
        ->where('nso007_export_stock.merchant_id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->count();
        // dd($on_proccess);
        $on_success = DeliveryOrderModel::join('nso007_delivery_order_detail_success','nso007_delivery_order.id','nso007_delivery_order_detail_success.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
        ->where('nso007_export_stock.merchant_id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->count();

        $cancel = DeliveryOrderModel::join('nso007_delivery_order_detail_cancel','nso007_delivery_order.id','nso007_delivery_order_detail_cancel.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_cancel.export_id')
        ->where('nso007_export_stock.merchant_id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->count();

        $pending = DeliveryOrderModel::join('nso007_delivery_order_detail_padding','nso007_delivery_order.id','nso007_delivery_order_detail_padding.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_padding.export_id')
        ->where('nso007_export_stock.merchant_id',Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->count();


        $on_delivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->count();

        $history = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
         ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->where('nso007_export_stock.merchant_id',Auth::user()->id)
        ->count();

        $payback = DeliveryOrderModel::join('nso007_delivery_order_detail_success','nso007_delivery_order.id','nso007_delivery_order_detail_success.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->select(
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.delivery_status',
            \DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price")
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        // ->where('nso007_delivery_order_detail_success.status',3)
        ->groupBy('nso007_export_stock.box_code')
        ->get();

        $package = ExportStockModel::join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->where('nso007_export_stock.merchant_id',Auth::user()->id)
        ->where('nso007_export_stock.status',1)
        ->count();
       
        

        $commission = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->select(
            'nso007_delivery_order_detail.driver_commission',
            'nso007_delivery_order_detail.commission_type',
            \DB::raw("SUM(nso007_export_stock.delivery_fee) AS delivery_fee"),
            \DB::raw("COUNT(nso007_export_stock.id) AS all_box")
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order_detail.status',3)
        ->first();

        $totalPayback = 0 ;
        $totalDelivery = 0 ;
        foreach ($payback as $key => $value) {
            if($value->delivery_status == 2){
                $totalDelivery += $value->delivery_fee ;
            }
            $totalPayback += $value->price ;
        }
        $totalPay = $totalPayback + $totalDelivery;

        return view('merchant.dashboard',compact('on_proccess','on_success','on_delivery','cancel','pending','history','totalPay','commission','package'));
    }


}
