<?php

namespace App\Http\Controllers\Driver;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderModel;
use App\ExportStockModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\Helpers\Globals;
use App\PickupAdminModel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;

class DriverDetailController extends Controller
{
    public function deliveryToSuccessful ()
    {
      $successful = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
      ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
      ->join('users','users.id','nso007_export_stock.merchant_id')
      ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
      ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
      ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')

      ->select(
          'nso007_discount.*',
          'nso007_export_stock.*',
          'nso007_export_stock.id',
          'nso007_location.name_km AS location',
          'nso007_delivery_order.delivery_date',
          'users.shop_name',
          'users.phone',
          'nso007_delivery_order_detail.total_riel',
          'nso007_delivery_order_detail.total_dollar',
          'nso007_export_stock_details.currency',
          \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'),
          \DB::raw('(CASE
              WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
              WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
              ELSE nso007_export_stock.taxi_shop_fee
              END) AS taxi_fee')
      )
      ->where('nso007_delivery_order_detail.status',3)
      ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
      ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
      ->groupBy('nso007_export_stock.box_code')
      ->get();
      return view('driver.delivery-successful',compact('successful'));
    }

    public function onDeliveryToDay(Request $request)
    {
        $boxcode=$request->box_code;

        $on_proccess = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->join('users','users.id','nso007_export_stock.merchant_id')
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
            ->select(
                'nso007_discount.*',
                'nso007_export_stock.*',
                'nso007_discount.id AS nso007_discount_id',
                'nso007_location.name_km AS location',
                'nso007_delivery_order.delivery_date',
                'users.shop_name',
                'users.phone',
                'users.user_currency',
                'nso007_delivery_order_detail.pay_to',
                'nso007_delivery_order_detail.amount_pay_to',
                'nso007_delivery_order_detail.total_riel',
                'nso007_delivery_order_detail.total_dollar',
                'nso007_export_stock_details.currency',
                \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'),
                \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            )
            ->where('nso007_delivery_order_detail.status',1)
            ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
            ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
            ->when(request('box_code'), function ($query) use ($boxcode) {
                $query->where('nso007_export_stock.box_code','LIKE','%'.$boxcode.'%');
            })
            ->groupBy('nso007_export_stock.box_code')
            ->orderBy('nso007_export_stock.box_code', 'asc')
            ->take(10)->get();

        return view('driver.on-delivery-today',compact('on_proccess'));

    }
    public function pickupAdmin(){
        $data = PickupAdminModel::join('users','users.id','nso007_pickup_admin.driver_id')
                    ->join('users as shop','shop.id','nso007_pickup_admin.shop_id')
                    ->selectRaw('nso007_pickup_admin.id,nso007_pickup_admin.delivery_date,nso007_pickup_admin.date,nso007_pickup_admin.description,users.name,shop.shop_name,shop.phone,shop.address')
                    ->where('users.id',auth()->id())
                    ->where('nso007_pickup_admin.status',1);
        return view('driver.admin-pickup',compact('data'));
    }
    public function deliveryAction($id,$status,$reason=null)
    {
    	// try {
        //     \DB::beginTransaction();
            if($status == 1){
                $money = \DB::table('nso007_export_stock')
                ->join('nso007_export_stock_details', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                ->select(
                    'nso007_discount.*',
                    'nso007_export_stock.*',
                    \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                    \DB::raw("( CASE WHEN nso007_export_stock.extra_fee_type = 2 THEN nso007_export_stock.extra_fee END ) AS total_extra_fee_cus"),

                    \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),

                    'nso007_export_stock.id'
                    )
                    ->whereIn('nso007_export_stock.id', explode(',', $id))->groupBy('nso007_export_stock.id')->get();


                $total = 0;
                foreach ($money as $key => $value) {
                    if($value->discount_type != null || $value->discount_type != '')
                        {
                            if($value->discount_type == 1){
                                $delivery_fee = $value->discount;
                            }
                            else{
                                $delivery_fee = ( (100 - $value->discount) * $value->delivery_fee ) / 100;
                            }
                        }
                        else{
                            $delivery_fee  =  $value->delivery_fee;
                        }

                    $other_services_fee =  0;
                    if($value->other_services_fee > 0 && $value->other_services_pay_or_paid == 'pay' && $value->other_services_type == 2){
                        $other_services_fee = $value->other_services_fee ;
                    }


                    if ($value->delivery_status == 1) {
                        $total = $value->total  + $value->total_extra_fee_cus  + $other_services_fee;;
                    } else {
                        $total = $value->total + $delivery_fee + $value->total_extra_fee_cus  + $other_services_fee;
                    }
                    // dd($total );


                    $checkMoney = \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->first();

                    if ($checkMoney->total_riel != 0 || $checkMoney->total_dollar != 0) {
                        \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3]);
                    } else {
                        \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3,'total_dollar'=>$total,'total_riel'=>0]);
                    }
                    update_status_by($value->id,3,'status_last');

                }

            }else if($status == 2){
                // this box code is padding
                try{
                    DB::beginTransaction();
                        $auth_id = Auth::user()->id;
                        $from_text_status = "";
                        $increas = '';
                        $old_deliveryorder = DeliveryOrderModel::join(DB::raw("(select delivery_order_id,export_id from nso007_delivery_order_detail) as nso007_delivery_order_detail"), 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                            ->where('export_id', $id)
                            ->orderBy('nso007_delivery_order.id', 'DESC')
                            ->first();

                        if ($old_deliveryorder->delivery_date != date('Y-m-d')) {
                            $old_date = $old_deliveryorder->delivery_date;
                            // check exist
                            $check = DeliveryOrderModel::where('delivery_date', date('Y-m-d'))->where('driver_id', $old_deliveryorder->driver_id)
                                ->where('time_policy', $old_deliveryorder->time_policy)
                                ->first();
                            if (empty($check)) {
                                $last_id =  DeliveryOrderModel::max('id');
                                if ($last_id) {
                                    $inovice = DeliveryOrderModel::latest('id')->first();
                                    $tran_num = $inovice->inovice;
                                    $tran_num = explode('DV', $tran_num);
                                    $increas = sprintf('DV' . '%08d', ($tran_num[1] + 1));
                                } else {
                                    $increas = 'DV00000001';
                                }
                                $deliveryorder = new  DeliveryOrderModel();
                                $deliveryorder->inovice         = $increas;
                                $deliveryorder->driver_id       = $old_deliveryorder->driver_id;
                                $deliveryorder->time_policy       = $old_deliveryorder->time_policy;
                                $deliveryorder->driver_name       = FindDriver($old_deliveryorder->driver_id);
                                $deliveryorder->delivery_date   =    date('Y-m-d');
                                $deliveryorder->save();
                                $old_deliveryorder = $deliveryorder;
                                $deivery_note = " With Old Date : ".$old_date." to New Date : ".date('Y-m-d');
                            } else {
                                $old_deliveryorder = $check;
                            }
                        }
                        \DB::table('nso007_export_stock')
                            ->where('id', $id)->update(['status' => 4, 'done_date' => date('Y-m-d')]);
                        \DB::table('nso007_delivery_order_detail')
                            ->where('export_id', $id)
                            ->update(['status' => 2, 'invoice_payment_id' => '', 'invoice_payment_id' => null, 'delivery_order_id' => $old_deliveryorder->id,'reason'=>$reason]);


                        $history = array(
                            'export_id' => $id,
                            'user_id'   => $auth_id,
                            'status'    => 4,
                            'reason'    => $reason,
                            'reason_dev'    => "Update From ".Globals::status(2)." To Pending".@$deivery_note
                        );
                        Globals::historyBox($history);
                    DB::commit();
                }
                catch (\Exception $e) {
                    DB::rollback();
                    return redirect()->back()->with($e->getMessage());
                }
            }else if($status == 3){
                //this box code is cancel
                try{
                    DB::beginTransaction();
                        $auth_id = Auth::user()->id;
                        $from_text_status = "";
                        $increas = '';
                        $old_deliveryorder = DeliveryOrderModel::join(DB::raw("(select delivery_order_id,export_id from nso007_delivery_order_detail) as nso007_delivery_order_detail"), 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                            ->where('export_id',$id)
                            ->orderBy('nso007_delivery_order.id', 'DESC')
                            ->first();

                        if ($old_deliveryorder->delivery_date != date('Y-m-d')) {
                            $old_date = $old_deliveryorder->delivery_date;
                            // check exist
                            $check = DeliveryOrderModel::where('delivery_date', date('Y-m-d'))->where('driver_id', $old_deliveryorder->driver_id)
                                ->where('time_policy', $old_deliveryorder->time_policy)
                                ->first();
                            if (empty($check)) {
                                $last_id =  DeliveryOrderModel::max('id');
                                if ($last_id) {
                                    $inovice = DeliveryOrderModel::latest('id')->first();
                                    $tran_num = $inovice->inovice;
                                    $tran_num = explode('DV', $tran_num);
                                    $increas = sprintf('DV' . '%08d', ($tran_num[1] + 1));
                                } else {
                                    $increas = 'DV00000001';
                                }
                                $deliveryorder = new  DeliveryOrderModel();
                                $deliveryorder->inovice         = $increas;
                                $deliveryorder->driver_id       = $old_deliveryorder->driver_id;
                                $deliveryorder->time_policy       = $old_deliveryorder->time_policy;
                                $deliveryorder->driver_name       = FindDriver($old_deliveryorder->driver_id);
                                $deliveryorder->delivery_date   =    date('Y-m-d');
                                $deliveryorder->save();
                                $old_deliveryorder = $deliveryorder;
                                $deivery_note = " With Old Date : ".$old_date." to New Date : ".date('Y-m-d');
                            } else {
                                $old_deliveryorder = $check;
                            }
                        }
                        \DB::table('nso007_export_stock')
                            ->where('id',$id)->update(['status' => 5, 'done_date' => date('Y-m-d')]);
                        \DB::table('nso007_delivery_order_detail')
                            ->where('export_id',$id)
                            ->update(['status' => 4, 'invoice_payment_id' => '', 'invoice_payment_id' => null, 'delivery_order_id' => $old_deliveryorder->id,'reason'=>$reason]);


                        $history = array(
                            'export_id' =>$id,
                            'user_id'   => $auth_id,
                            'status'    => 5,
                            'reason'    => $reason,
                            'reason_dev'    => "Update From ".Globals::status(2)." To Cancel".@$deivery_note
                        );
                        Globals::historyBox($history);
                    DB::commit();
                }
                catch (\Exception $e) {
                    DB::rollback();
                    return redirect()->back()->with($e->getMessage());
                }

            }

        return redirect()->back();

    }



    public function deliveryActionEditPrice(Request $request){

        $pay_dol = $request->currency_usd ? floatval($request->currency_usd) : 0;
        $pay_riel = $request->currency_rial ? floatval($request->currency_rial) : 0;
        $aba_pay = $request->amount_pay_to_aba ? floatval($request->amount_pay_to_aba) : 0;

        $rate = $request->rate ? $request->rate : 4100;
        $convert_to_dol = ($pay_riel / $rate);
        $total_paid = ($pay_dol + $convert_to_dol + $aba_pay);
        $price = $request->total_price ? floatval($request->total_price) : 0;
        $missing = round($price,2) - round($total_paid,2);
        if($missing != 0){
            //Pay less than 10 dollars || ខ្វះ 500 ៛
            if($missing > 0.12){
                return response()->json([
                    'status'=>403,
                    'message'=>'Sorry You Pay Not Engough'
                ]);
            }
            if($missing < -0.24){
                return response()->json([
                    'status'=>403,
                    'message'=>'You have overpaid'
                ]);
            }
        }

        try {
            \DB::beginTransaction();
            $delivery = DeliveryOrderModel::join('nso007_delivery_order_detail as dod', 'dod.delivery_order_id', 'nso007_delivery_order.id')
            ->where('dod.export_id', $request->id)
            ->first();
        if ($delivery->delivery_date != date('Y-m-d')) {

            $deliveryorder = DeliveryOrderModel::where('delivery_date', date('Y-m-d'))->where('driver_id', $delivery->driver_id)
                ->where('time_policy', $delivery->time_policy)
                ->first();
            if (empty($deliveryorder)) {
                $last_id =  DeliveryOrderModel::max('id');

                if ($last_id) {
                    $inovice = DeliveryOrderModel::latest('id')->first();
                    $tran_num = $inovice->inovice;
                    $tran_num = explode('DV', $tran_num);
                    $increas = sprintf('DV' . '%08d', ($tran_num[1] + 1));
                } else {
                    $increas = 'DV00000001';
                }
                $deliveryorder = new  DeliveryOrderModel();
                $deliveryorder->inovice         = $increas;
                $deliveryorder->driver_id       = $delivery->driver_id;
                $deliveryorder->time_policy       = $delivery->time_policy;
                $deliveryorder->driver_name       = FindDriver($delivery->driver_id);

                $deliveryorder->delivery_date   =    date('Y-m-d');
                $deliveryorder->save();
            }
        }
            if($request->status == 'no_taxi'){

                $export_stock = ExportStockModel::find($request->id);
                $export_stock->driver_note  = $request->driver_note ;

                if($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0){
                    $export_stock->extra_fee_type       =   $request->extra_fee_type;
                    $export_stock->extra_fee            =   $request->extra_fee;
                    $export_stock->done_date            =   date('Y-m-d');
                    $export_stock->update();
                }
                else{
                    $export_stock->extra_fee_type       =   null;
                    $export_stock->extra_fee            =   0;
                    $export_stock->done_date            =   date('Y-m-d');
                    $export_stock->update();
                }


                $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id',$request->id)->where('status',1)->first();
                $deliveryorderdetail->total_riel                =      $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;

                if(@$deliveryorder){
                    $deliveryorderdetail->delivery_order_id                      =       $deliveryorder->id;
                }

                $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetail->pay_to                    =       $request->pay_to;
                $deliveryorderdetail->status                    =       3;
                $deliveryorderdetail->done_date                 =   date('Y-m-d');
                $deliveryorderdetail->update();
            }
            else{
                $export_stock = ExportStockModel::find($request->id);
                $export_stock->driver_note  = $request->driver_note ;
                if($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0){
                    $export_stock->extra_fee_type       =   $request->extra_fee_type;
                    $export_stock->extra_fee            =   $request->extra_fee;
                    $export_stock->done_date            =   date('Y-m-d');
                    $export_stock->update();
                }
                else{
                    $export_stock->extra_fee_type       =   null;
                    $export_stock->extra_fee            =   0;
                    $export_stock->done_date            =   date('Y-m-d');
                    $export_stock->update();
                }
                $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id',$request->id)->where('status',1)->first();
                $deliveryorderdetail->total_riel                =      $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetail->pay_to                    =       $request->pay_to;
                $deliveryorderdetail->status                    =       3;
                $deliveryorderdetail->done_date                 =   date('Y-m-d');
                if(@$deliveryorder){
                    $deliveryorderdetail->delivery_order_id                      =       $deliveryorder->id;
                }
                $deliveryorderdetail->update();

                $export_stock = ExportStockModel::find($request->id);
                if($request->taxi_status == 1){
                    $export_stock->taxi_shop_fee    =   $request->taxi_fee;
                    $export_stock->taxi_cust_fee    =   0;
                }else{
                    $export_stock->taxi_cust_fee    =   $request->taxi_fee;
                    $export_stock->taxi_shop_fee    =   0;
                }
                $export_stock->taxi_number      = $request->taxi_number;
                $export_stock->taxi_status      =  $request->taxi_status;
                $export_stock->done_date        =   date('Y-m-d');
                $export_stock->update();
            }
            \DB::table('nso007_export_stock')->where('id',  $request->id)->update(['status'=>3]);
            $history = array(
                'export_id' => $request->id,
                'user_id'   => Auth::user()->id,
                'status'    => 3,
                'reason'    => $request->driver_note,
                'reason_dev'=> 'KHR : '.$request->currency_rial.'/ USD : '.$request->currency_usd.'/ ABA : '.$request->amount_pay_to_aba
            );
            Globals::historyBox($history);
            \DB::commit();
                return response ()->json(200) ;
            } catch (\Exception $e) {
            DB::rollBack();
                throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
        }
    }

    public function dailyDelivery()
    {
        $from_date = date("Y-m-d",strtotime(date("Y-m",strtotime("-1 MONTH")).'-26'));
        $to_date = date("Y-m-d",strtotime(date("Y-m").'-25'));
          $dailyDelivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
          ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
          ->join('users','users.id','nso007_export_stock.merchant_id')
          ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
          ->select(
              'nso007_delivery_order.delivery_date',
              \DB::raw("COUNT(nso007_delivery_order_detail.status) AS all_box"),
              \DB::raw('(CASE
                        WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                        WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                        ELSE nso007_export_stock.taxi_shop_fee
                        END) AS taxi_fee')
          )
          ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
          ->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date])
          ->groupBy('nso007_delivery_order.delivery_date')
          ->orderBy('nso007_delivery_order.delivery_date','DESC')
          ->whereNotIn('nso007_export_stock.status',[7])
          ->get();
          return view('driver.daily-delivery',compact('dailyDelivery'));
    }
    public function dailyDeliveryDetail ($date)
    {
        $dailyDelivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')

        ->select(
            'nso007_discount.*',
            'nso007_export_stock.*',
            'nso007_export_stock.id',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'users.shop_name',
            'users.phone',
            'nso007_delivery_order_detail.status',
            'nso007_delivery_order_detail.total_riel',
            'nso007_delivery_order_detail.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'),
            \DB::raw('(CASE
            WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
            WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
            ELSE nso007_export_stock.taxi_shop_fee
            END) AS taxi_fee')
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',$date)
        ->whereNotIn('nso007_export_stock.status',[7])
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        return view('driver.daily-delivery-detail',compact('dailyDelivery'));
    }

    public function historyDriver(Request $request)
    {
        $from_date = date("Y-m-d",strtotime(date("Y-m",strtotime("-1 MONTH")).'-26'));
        $to_date = date("Y-m-d",strtotime(date("Y-m").'-25'));
          $dailyDelivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
          ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
          ->join('users','users.id','nso007_export_stock.merchant_id')
          ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
          ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')

          ->select(
              'nso007_discount.*',
              'nso007_discount.id AS discount_1',
              'nso007_export_stock.id',
              'nso007_export_stock.*',
              'nso007_location.name_km AS location',
              'nso007_delivery_order.delivery_date',
              'users.shop_name',
              'users.phone',
              'nso007_delivery_order_detail.status',
              'nso007_delivery_order_detail.total_riel',
              'nso007_delivery_order_detail.total_dollar',
              'nso007_export_stock_details.currency',
              \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'),
              \DB::raw('(CASE
              WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
              WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
              ELSE nso007_export_stock.taxi_shop_fee
              END) AS taxi_fee')
          )
          ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
          ->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date])
          ->where('nso007_export_stock.status',3)
          ->groupBy('nso007_export_stock.box_code')
          ->orderBy('nso007_delivery_order.inovice','desc')
          ->paginate(10);
          if ($request->ajax()) {
              $view = view('driver.data-list',compact('dailyDelivery'))->render();
              return response()->json(['html'=>$view]);
          }
          return view('driver.history-driver',compact('dailyDelivery'));
    }

    public function dailyCommission()
    {
        $from_date = date("Y-m-d",strtotime(date("Y-m",strtotime("-1 MONTH")).'-26'));
        $to_date = date("Y-m-d",strtotime(date("Y-m").'-25'));
        $dailyDelivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->select(
            'nso007_export_stock.*' ,
            'nso007_delivery_order.*',
            'nso007_delivery_order_detail.driver_commission AS share_fee',
            'nso007_delivery_order_detail.commission_type AS share_fee_type',
            'nso007_delivery_order.delivery_date',
            'nso007_delivery_order_detail.driver_commission',
            'nso007_delivery_order_detail.commission_type'

        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date])
        ->orderBy("nso007_delivery_order.delivery_date","DESC")
        ->get();
        return view('driver.daily-commission',compact('dailyDelivery'));
    }


    public function dailyDailyCollectMoney()
    {
        //   $dailyCollectMoney = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        //   ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        //   ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        //   ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
        //   ->select(
        //       'nso007_discount.*',
        //       'nso007_delivery_order.delivery_date',
        //       'nso007_export_stock.*',
        //       'nso007_delivery_order_detail.*',
        //       \DB::raw(" nso007_export_stock_details.export_qty * nso007_export_stock_details.price  AS price")
        //   )
        //   ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        //   ->get();
          $dailyCollectMoney = DeliveryOrderModel::join(DB::raw('(select delivery_order_id,export_id,status,total_riel,total_dollar,amount_pay_to,pay_to from nso007_delivery_order_detail) as dod'),'dod.delivery_order_id','nso007_delivery_order.id')
                        ->join(DB::raw('(select id,status as exs_status from nso007_export_stock) as exs'),'exs.id','dod.export_id')
                        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
                        ->groupBy('nso007_delivery_order.delivery_date')
                        ->select(   DB::raw('SUM(CASE WHEN exs_status = 3 THEN 1 ELSE 0 END) as success'),
                                    DB::raw('SUM(1) as all_box'),
                                    DB::raw('SUM(total_riel) as total_kh'),
                                    DB::raw('SUM(CASE WHEN pay_to = "delivery" THEN amount_pay_to + total_dollar  ELSE total_dollar END) as total_usd'),
                                    'nso007_delivery_order.delivery_date'
                                )
                        ->get();
          return view('driver.daily-collect-meney',compact('dailyCollectMoney'));
    }
    public function confirmPickup($id,Request $request){
        if($request->isMethod("GET")){
            $pickupAdmin = PickupAdminModel::find($id);
            return response()->json([
                'success'=>true,
                'view'=> view('driver.confirm-pickup',compact('pickupAdmin'))->render()
            ]);
        }
        if($request->isMethod("POST")){
            $qty = $request->qty;
            if(!$qty){
                return response()->json([
                    'success'=>false,
                    'msg'=>"Please Input Qty.",
                ]);
            }
            $pickupAdmin = PickupAdminModel::where('id',$id)
                ->where('driver_id',auth()->id())
                ->where('status',1)
                ->update([
                    'status'=>2,
                    'qty'=>$qty,
                    'delivery_date'=>date('Y-m-d'),
                ]);
            return response()->json([
                'success'=>true,
                'msg'=>'Confirm Successfully.'
            ]);
        }
    }
    public function pickupAdminHistory(){
        $data = PickupAdminModel::join('users','users.id','nso007_pickup_admin.driver_id')
            ->join('users as shop','shop.id','nso007_pickup_admin.shop_id')
            ->selectRaw('nso007_pickup_admin.id,nso007_pickup_admin.date,nso007_pickup_admin.description,users.name,shop.shop_name,shop.phone,shop.address')
            ->where('nso007_pickup_admin.status',4)
            ->where('nso007_pickup_admin.driver_id',auth()->id());
        return view('driver.pickup-admin-history',compact('data'));
    }
}
