<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\DeliveryOrderModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\ShareLinkModel;
use App\User;
use Illuminate\Support\Facades\Crypt;

class ShareLinkConroller extends Controller
{


    public function share_links($id , $date = '')
    {
        $url = url('/').'/share-links/'.$id;
        $date        =   empty($date)? date('Y-m-d') : date('Y-m-d',strtotime($date));

        $shop = User::whereShare_links($id)->first();

        $data = \DB::table('nso007_export_stock')
                ->leftjoin('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                ->leftjoin('nso007_delivery_order_detail','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->leftjoin('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
                ->select(
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order.driver_name',
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee'),
                    'nso007_export_stock_details.currency'
                )
                ->where(function($query) use ($date){
                    $query->whereDate('nso007_export_stock.export_date',date('Y-m-d',strtotime($date)));
                })

                ->where('nso007_export_stock.merchant_id',$shop->id)
                ->groupBy('nso007_export_stock_details.export_id')
                ->orderBy('nso007_delivery_order.inovice','ASC')
                ->get(); 
                $branch  =  BranchModel::first();
                return view('public.share_link',compact('date','data','branch','shop','id','url'));
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        if ($request->export_id) {
            $data   =   new ShareLinkModel();
            $data->date     = date('Y-m-d');
            $data->note     = $request->note;
            $data->merchant_id = $request->merchant;
            $data->export_id = $request->export_id;
            if ($data->save()) {
                $link =  route("share-link.show", Crypt::encrypt($data->id));
                echo json_encode(['error' => false, 'link' => $link]);
            }
        } else {
            echo json_encode(['error' => true, 'text' => 'Not Item']);
        }
    }
 
    public function show($id)
    {
        // try {
            $id = ShareLinkModel::find(Crypt::decrypt($id));

            if ($id->export_id) {
                $data = \DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                ->select(
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order.driver_name',
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee'),
                    'nso007_export_stock_details.currency'
                )

                ->whereIn('nso007_export_stock.id',(explode(',',$id->export_id)))
                ->groupBy('nso007_export_stock_details.export_id')

                ->orderBy('nso007_delivery_order.inovice','desc')
                ->get();
                $branch  =  BranchModel::first();
                $shop = User::find($data[0]->merchant_id);
                return view('public.index',compact('data','branch','shop','id'));
            }
        // } catch (\Exception $e) {
        //     // return $e->getMessage();
        //     return view('errors.404');
        // }
    }

    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        //
    }

     
    public function destroy($id)
    {
        //
    }
}
