<?php

namespace App\Http\Controllers\Administrator;

use App\CategoryModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
use Auth;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;
class ReportController extends Controller
{   
    public function history_delivery()
    { 
        $secondArray = [];
        $firstArray = [];
        $users = \DB::table('users')->where('user_type',1)->select('name','id')->get();

        $data = User::where('user_type',3)->where('status',1)
                    ->get();
        $from_date  = date('Y-m-d', strtotime("-5 day", strtotime(date('Y-m-d'))));
        $to_date    =  date('Y-m-d')  ;

        foreach($data as $key => $value)
        {
            $export  =   DeliveryOrderDetailModel::
            select('nso007_delivery_order_detail.created_at','nso007_delivery_order_detail.status_paid')
            ->join('nso007_export_stock','nso007_delivery_order_detail.export_id','nso007_export_stock.id')
            
            ->when(request('from_date','to_date'), function($query) use($from_date,$to_date){
                if($from_date){
                    $query->whereDate('nso007_delivery_order_detail.created_at','>=',$from_date) ;
                }
                if($to_date){
                    $query->whereDate('nso007_delivery_order_detail.created_at','<=',$to_date);
                }
            })
            ->where('nso007_delivery_order_detail.status_paid',null)
            ->where('nso007_delivery_order_detail.invoice_payment_id',null)

            ->where('nso007_delivery_order_detail.status',3)
            ->where('merchant_id',$value->id)
            ->groupBy('merchant_id')
            ->get();

            if( $export->count() > 0 ){
                $value->shop_name       =   '->  ' .$value->shop_name  ;
                $firstArray[$value->id] = $value->shop_name;
            }else{
                $value->shop_name  =  $value->shop_name  ;
                $secondArray[$value->id] = $value->shop_name;
            }
        }
        $merchant = array(
            ''=> __('administrator.shop_name'),
        );

        foreach($firstArray as $key => $value){
            $merchant[$key] = $value;
        }
        foreach($secondArray as $key => $value){
            $merchant[$key] = $value;
        }

        $category = CategoryModel::where('status',1);
        if(\Globals::check_lang() == 'en'){
            $category = $category->select('nso007_category.*','nso007_category.name_en AS category_name')->pluck('category_name', 'id')->prepend('Please Select', '');
        }else{
            $category = $category->select('nso007_category.*','nso007_category.name_km AS category_name')->pluck('category_name', 'id')->prepend('Please Select', '');
        }
        return view('administrator.report.history-delivery',compact( 'merchant','users'));

    }
    public function get_merchant(Request $request){
        $data = User::where('user_type',3)->where('status',1)->where('staff_id',$request->id)->get();
        $secondArray = []; $firstArray = [];
        $from_date      =   empty($request->from_date)? date('Y-m-d', strtotime("-5 day", strtotime(date('Y-m-d')))):date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)?date('Y-m-d'):date('Y-m-d',strtotime($request->to_date));

        foreach($data as $key => $value)
        {
            $export  =   DeliveryOrderDetailModel::
            select('nso007_delivery_order_detail.created_at','nso007_delivery_order_detail.status_paid')
            ->join('nso007_export_stock','nso007_delivery_order_detail.export_id','nso007_export_stock.id')
            ->when(request('from_date','to_date'), function($query) use($from_date,$to_date){
                if($from_date){
                    $query->whereDate('nso007_delivery_order_detail.created_at','>=',$from_date) ;
                }
                if($to_date){
                    $query->whereDate('nso007_delivery_order_detail.created_at','<=',$to_date);
                }
            })
            ->where('nso007_delivery_order_detail.status_paid',null)
            ->where('nso007_delivery_order_detail.status',3)
            ->where('merchant_id',$value->id)
            ->groupBy('merchant_id')
            ->get();

            if( $export->count() > 0 ){
                $value->shop_name       =   '->  ' .$value->shop_name  ;
                $firstArray[$value->id] = $value->shop_name;
            }else{
                $value->shop_name  =  $value->shop_name  ;
                $secondArray[$value->id] = $value->shop_name;
            }
        }
        $merchant = array(
            ''=> __('administrator.shop_name'),
        );
        foreach($firstArray as $key => $value){
            $merchant[$key] = $value;
        }
        foreach($secondArray as $key => $value){

            $merchant[$key] = $value;
        }
        $data ='<select name="merchant" id="" class="merchant  form-control chosen-select">';
        foreach ($merchant as $key=>$item){
        $data .=' <option value="'.$key.'">'.$item.'</option>';
        }
        $data .='</select>';
        return response()->json($data);
    }
    public function datable_history_delivery(Request $request)
    {
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;


        $data = DB::table('nso007_delivery_order_detail')
                            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
                            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                            ->select(
                                'nso007_delivery_order_detail.delivery_order_id',
                                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                                'nso007_delivery_order.delivery_date',
                                'nso007_export_stock.*',
                                'nso007_export_stock.total_product AS total_price',
                                'nso007_delivery_order_detail.status AS status_detail',
                                'nso007_delivery_order_detail.status_paid',
                                'nso007_delivery_order_detail.reason AS detail_reason',
                                'nso007_delivery_order_detail.status AS status_',
                                'nso007_delivery_order.driver_name',
                                'nso007_delivery_order_detail.approve' ,
                                'nso007_delivery_order_detail.clear_box_code' 
                            )
                            ->where('nso007_delivery_order_detail.status_paid',null)
                            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')

                            ->when($from_date,function($q , $from_date){
                                    $q->where('nso007_delivery_order.delivery_date','>=',$from_date);
                            } )

                            ->when($to_date,function($q , $to_date){
                                $q->where('nso007_delivery_order.delivery_date','<=',$to_date);
                            } )

                       
                            ->when(request('status'),function($query) use ($status){
                                if(!empty($status)){
                                    $status_1 ='';
                                    foreach ($status as $key => $value) {
                                        $status_1  .= $status[$key].',' ;
                                    }
                                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                                }
                            })
                            ->where('nso007_delivery_order_detail.status','!=',0)
                            ->where('nso007_export_stock.merchant_id','LIKE',$merchant)
                            ->orderBy('nso007_export_stock.box_code','desc');
            
                
            return DataTables::of($data)
                     ->editColumn('total', function ($data)  {
                        $delivery_fee_shop =0;
                        $delivery_fee_cus =0;
                        $total = 0;
                        $delivery_fee  = 0;
                        $dis = DiscountModel::find($data->discount_id);
                        if( $dis )
                        {
                            if($dis->discount_type == 1){
                                $delivery_fee = $dis->discount;
                            }
                            elseif($dis->discount_type == 2){
                                $delivery_fee = ( (100 - $dis->discount )* $data->delivery_fee / $data->delivery_fee_rate ) / 100;
                            }
                            else{
                                $delivery_fee =$data->delivery_fee / $data->delivery_fee_rate;
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee / $data->delivery_fee_rate;
                        }
                        if($data->delivery_status == 1){
                            $delivery_fee_shop  =  $delivery_fee ;
                        }
                        else{
                            $delivery_fee_cus  =  $delivery_fee ;
                        }
                        if($data->extra_fee_type == 1) {
                            $extra_fee_shop = $data->extra_fee ;
                            $extra_fee_cus  = 0 ;
                            }
                        else if($data->extra_fee_type == 2)   {

                            $extra_fee_shop = 0;
                            $extra_fee_cus  = $data->extra_fee ;

                            }
                        else  {
                            $extra_fee_shop = 0;
                            $extra_fee_cus = 0;
                            }

                        if($data->taxi_status == 1){
                            $taxi_fee =   $data->taxi_shop_fee  ;
                        } else{
                            $taxi_fee =  0  ;
                        }

                        if($data->delivery_status == 1){  //shop
                            $total =  $data->total_price / $data->total_product_rate ;
                        }else{   //customer
                            $total = $data->total_price / $data->total_product_rate  ;
                        }
                        return  '$'. number_format( $total - $delivery_fee_shop  -  $extra_fee_shop ,2);
                    })
                    ->editColumn('taxi_fee', function ($data)  {
                            if($data->taxi_status == 1){
                                if($data->taxi_fee_symbol == '$'){
                                    $taxi_fee = '$'.number_format( $data->taxi_shop_fee,2);
                                }
                                if ($data->taxi_fee_symbol == '៛') {
                                    $taxi_fee = number_format( $data->taxi_shop_fee,0).' ៛';
                                }
                            }
                            else{
                                if($data->taxi_fee_symbol == '$'){
                                    $taxi_fee = '$'.number_format( $data->taxi_cust_fee,2);
                                }
                                if ($data->taxi_fee_symbol == '៛') {
                                    $taxi_fee = number_format( $data->taxi_cust_fee,0).' ៛';
                                }
                            }
                            
                            return $taxi_fee;
                    })
                    ->editColumn('reason', function ($data)  {
                        return $data->reason == null ? "N/A" :  $data->reason;
                    })

                    ->editColumn('status', function ($data)  {
                        if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else if($data->status ==5)   // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                    else if($data->status ==6)   // 6 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.paid') . ' </strong>';
                    else if($data->status ==7)   // 7 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>';
                        // if($data->status_ == 1)  // 1 = Processing,
                        //         return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> '.__('administrator.processing').'</strong>';
                        // else if($data->status_ == 2)  // 2 = Padding,
                        //         return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> '.__('administrator.padding').' </strong>';
                        //     else if($data->status_ == 3)  //  3 = Done ,
                        //     return ' <strong class="text-info"><span class="fa fa-check"></span>  '.__('administrator.done').' </strong>';
                        // else if($data->status_ == 4)  // 4 = Cancel
                        //     return ' <strong class="text-danger"><span class="fa fa-ban"></span>  '.__('administrator.cancel').'</strong>';
                        // else{
                        //     return ' <strong class="text-muted"><span class="fa fa-check"></span>  '.__('administrator.paid').'</strong>';
                        // }
                    })
                    ->addColumn('export_date', function ($data) {
                        return date('d-m-Y', strtotime($data->export_date));
                    })
                    ->addColumn('delivery_date', function ($data) {
                        return date('d-m-Y', strtotime($data->delivery_date));
                    })

                    ->editColumn('status_paid', function ($data)  {
                        if($data->status_paid == 'paid'){
                                $paid = '<strong class="" style="color: #37c61a;"><span class=" fa fa-check"></span> '.__('administrator.paid').'</strong>';
                            }
                            else{
                                $paid = '';
                            }

                            if($data->approve =='approve'){
                                $paid = '<strong class="" style="color: #1914c4;"><span class=" fa fa-check"></span> '.__('administrator.approve').'</strong>';
                            }
                            return $paid;
                    })

                    ->editColumn('extra_fee', function ($data)  {
                        if($data->extra_fee_type == 1) {
                            return  '$'.number_format( $data->extra_fee,2)  . ' s'; }
                        else if($data->extra_fee_type == 2)   {
                            return  '$'.number_format( $data->extra_fee,2) . ' c';    }
                        else  {
                            return '$0';  }
                    })
                    ->editColumn('total_price', function ($data)  {
                        if($data->total_product_symbol == '$'){
                            return '$'.number_format( $data->total_price,2);
                        }else if($data->total_product_symbol == '៛'){
                            return number_format( $data->total_price).' ៛';
                        }

                        
                    })


                    ->editColumn('status_clear', function ($data)  {
                        if($data->clear_box_code){
                            return '<span class="label label-default">close</span>';
                        }
                    })


                    ->editColumn('delivery_fee', function ($data)  {
                            $delivery_fee  = 0;
                            $dis = DiscountModel::find($data->discount_id);
                            if($dis)
                            {
                                if($data->discount_type == 1){
                                    $delivery_fee = $data->discount;
                                }
                                elseif($data->discount_type == 2){
                                    $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                                }
                                else{
                                    $delivery_fee =$data->delivery_fee;
                                }
                            }
                            else{
                                $delivery_fee  =  $data->delivery_fee;
                            }

                            if($data->delivery_fee_symbol == '$'){
                                return  "$" . (number_format($delivery_fee,2));
                            }
                            if ($data->delivery_fee_symbol == '៛') {
                                return $delivery_fee.'៛';
                            }
                            // if($data->delivery_status == 1){
                            //     $delivery_fee = '$'.number_format( $delivery_fee,2);
                            // }
                            // else{
                            //     $delivery_fee = '$'.number_format( $delivery_fee,2);
                            // }
                            // return $delivery_fee;
                        })
                        ->addColumn('approve',function($data){

                            if($data->status_paid == 'paid' && $data->approve == null){

                                return '<input type="checkbox" name="check" class="checkbox" data-box_code="'.$data->box_code.'"  data-export_id="'.$data->id.'" >';

                            }
                        })
                    ->rawColumns(['status_clear'=>'status_clear','status' => 'status','status_paid'=>'status_paid','approve'=>'approve'])
                    ->addIndexColumn()
                    ->make(true);

    } 

    public function report_for_shop_print(Request $request ,$type){     
        $currency  = CurrencyModel::first();
        $invoice = '';
        $from_date  = empty  ($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date    = empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant   = isset($request->merchant)?$request->merchant:null;
        // dd( $merchant );
        $status     = isset($request->status)?$request->status:null ;
        $referance  = isset($request->referance)?$request->referance:null ;
        $ids = array(3,1,2,4); 
        $ids_ordered = implode(',', $ids);
        $cus = User::find($merchant);
        $data = DeliveryOrderModel::
                join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock.description',
                    'nso007_export_stock.*',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
            }else{
                $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name',
                    'nso007_export_stock.*',
                    'nso007_delivery_order_detail.status',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.description',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                );
            }
            $data = $data
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                if(!empty($from_date) && !empty($to_date)){
                    $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
                }
            })
            ->when(request('status'),function($query) use ($status){
                if(!empty($status)){
                    $status_1 ='';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key].',' ;
                    }
                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                }
            })
            ->where(function($query) use ($merchant){
                if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                    $query->where('merchant_id',\Auth::user()->id);
                }else if(\Globals::is_Driver() == 'Driver'){
                    $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
                }else{
                    $query->where('merchant_id','LIKE',$merchant);
            }
        })

        ->where('nso007_delivery_order_detail.status_paid',null)
        ->where('nso007_delivery_order_detail.status','!=',0)
        ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')

        // ->orderBy('nso007_delivery_order.inovice','desc')
        ->orderByRaw("FIELD(nso007_delivery_order_detail.status, $ids_ordered)")


        ->get();
        $package = [];
        $increas = '';

        $id = '';
        // if ($type ==2) {

        //     if(empty($data)){
        //         return redirect()->back()->with('danger','Not Data');
        //     }
        //     $increas = '';
        //     $last_id =  DB::table('nso007_invoice_payment')->max('id');
        //     $inovice = DB::table('nso007_invoice_payment')->latest('id')->first();
            
        //     if ($inovice) {
        //         $tran_num = $inovice->invoice_payment;
        //         $tran_num =substr($tran_num, -6);
        //         $increas = sprintf('IV-'.date('ym').'%06d', ($tran_num+1));
        //     } else {
        //         $increas = 'IV-'.date('ym').'000001';
        //     }
        //     $invoicepayment     =   new InvoicePaymentModel();
        //     $invoicepayment->invoice_payment    =   $increas;
        //     $invoicepayment->user_create        =   Auth::user()->id;
        //     $invoicepayment->date               =   date('Y-m-d');
        //     $invoicepayment->from_date          =   $from_date;
        //     $invoicepayment->to_date            =   $to_date ;
        //     $invoicepayment->shop_id            =   $merchant ;

        //     $deliveryOrder=  DeliveryOrderModel::
        //         join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
        //         ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
        //         ->select('nso007_delivery_order_detail.status', 'nso007_delivery_order_detail.export_id')
        //         ->when(request('from_date', 'to_date'), function ($query) use ($from_date,$to_date) {
        //             if (!empty($from_date) && !empty($to_date)) {
        //                 $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date,$to_date]);
        //             }
        //         })

        //     ->where(function ($query) use ($merchant) {
        //         if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
        //             $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
        //         } elseif (\Globals::is_Driver() == 'Driver') {
        //             $query->where('nso007_delivery_order.driver_id', \Auth::user()->id);
        //         } else {
        //             $query->where('nso007_export_stock.merchant_id', 'LIKE', $merchant);
        //         }
        //     })

        //     ->when(request('referance'), function ($query) use ($referance) {
        //         if (!empty($referance)) {
        //             $query->where('nso007_export_stock.referance', $referance);
        //         }
        //     })

        //     ->where(function ($query) {
        //         $query->orwhere('nso007_delivery_order_detail.status', 3);
        //     })
        //     ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
        //     ->whereNull('nso007_delivery_order_detail.status_paid');

        //     $deliveryOrder1  = $deliveryOrder;
        //     $deliveryOrder2  = $deliveryOrder->get();

        //     $id_ = '';
        //     if ($deliveryOrder1->count() != 0) {
        //         $invoicepayment->save();
        //         $id = $invoicepayment->id;
        //         $invoice        = $invoicepayment->invoice_payment;
        //         $deliveryOrder->update(['nso007_delivery_order_detail.invoice_payment_id'=>$invoicepayment->id]);
        //         foreach ($deliveryOrder2 as $key => $value) {
        //             $id_ .= $deliveryOrder2[$key]->export_id.',';
        //         }
        //         DeliveryOrderDetailCancelModel::WhereIn('nso007_delivery_order_detail_cancel.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_cancel.invoice_payment_id'=>$invoicepayment->id]);
        //         ;
        //         DeliveryOrderDetailSuccessModel::WhereIn('nso007_delivery_order_detail_success.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_success.invoice_payment_id'=>$invoicepayment->id]);
        //         ;
        //     }

            
        // }
        // $count = ExportStockModel::where('nso007_export_stock.merchant_id', $merchant)->where('nso007_export_stock.status' ,1)->count();

        $package = [] ;
        // if($count  > 0){
        //     $package = ExportStockModel::join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')

        //     ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
        //     ->select('nso007_export_stock.*' ,
        //         'nso007_export_stock_details.category_name AS category',
        //         'nso007_export_stock.location_name AS location',
        //         'nso007_discount.*',
        //         'nso007_export_stock_details.*',
        //         'nso007_export_stock.delivery_fee AS delivery_fee1',
        //         \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'))
        //     ->where('nso007_export_stock.status' ,1)
        //     ->where('nso007_export_stock.merchant_id', $merchant)
        //     ->groupBy('nso007_export_stock.box_code')->get();
        // }
        return  view('administrator.report.report_for_shop_print',compact('data','from_date','to_date','invoice','currency','package','cus','id'))->render();
    }


    public function SummaryDeliveryList(Request $request){

        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $from_date      =   $request->from_date == '' ? date('Y-m-d') : $request->from_date;
        $to_date        =   $request->to_date == '' ? date('Y-m-d') : $request->to_date;
        $merchant_id       =   $request->merchant;
        $status         =   $request->status;
        $search         =   $request->input('search.value');

        if($request->ajax()){
            $count_total = DeliveryOrderModel::
                    join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                    ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                    ->groupBy('nso007_export_stock.merchant_id')
                    ->get() ->count();


                    $count_filter = DeliveryOrderModel::
                    join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                    ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                    ->groupBy('nso007_export_stock.merchant_id')
                    ->where(function ($query) use ($from_date, $to_date, $merchant_id ) {
                        if($from_date){
                            $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                        }
                        if($to_date){
                            $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                        }
                        if($merchant_id){
                            $query->where('nso007_export_stock.merchant_id', $merchant_id);
                        }
                    })
                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                        }
                    })
            ->get()->count();
            $data = DeliveryOrderModel::
                select('merchant.name AS merchant_name','merchant.id AS merchant_id','merchant.phone AS merchant_phone','nso007_delivery_order.delivery_date')
                ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                ->groupBy('nso007_export_stock.merchant_id')
                ->where(function ($query) use ($from_date, $to_date, $merchant_id) {
                    if($from_date){
                        $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                    }
                    if($to_date){
                        $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                    }
                    if($merchant_id){
                        $query->where('nso007_export_stock.merchant_id', $merchant_id);
                    }
                })
                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                    }
                })
            ->take(20)->orderBy('nso007_export_stock.id','DESC');
            return DataTables::of($data)
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addColumn('date', function ($data) {
                    return $data->delivery_date;
                })
                ->editColumn('merchant', function ($data){
                    return $data->merchant_name .' / '.  $data->merchant_phone ;
                })
                ->editColumn('transaction', function($data) {
                    $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
                    $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
                    $status         =   request()->status;
                    $delivery = DeliveryOrderDetailModel::
                                join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                                ->join('nso007_delivery_order','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                                ->where('nso007_export_stock.merchant_id',$data->merchant_id)
                                ->where(function ($query) use ($from_date, $to_date) {
                                    if($from_date){
                                        $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                                    }
                                    if($to_date){
                                        $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                                    }
                                })
                                ->when(request('status'),function($query) use ($status){
                                    if(!empty($status)){
                                        $status_1 ='';
                                        foreach ($status as $key => $value) {
                                            $status_1  .= $status[$key].',' ;
                                        }
                                        $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                                    }
                                })
                                ->count();
                    return $delivery ;
                })
                ->editColumn('received', function($data) {
                        $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
                        $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
                        $status         =   request()->status;
                        $delivery = DeliveryOrderDetailModel::
                        select(
                            // 'nso007_export_stock_details.price',
                            // \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                            \DB::raw('SUM(nso007_delivery_order_detail.total_riel) as total_riel'),
                            \DB::raw('SUM(nso007_delivery_order_detail.total_dollar) as total_dollar'),
                    )
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                    // ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                    ->join('nso007_delivery_order','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                    ->where('nso007_export_stock.merchant_id',$data->merchant_id)
                    ->where(function ($query) use ($from_date, $to_date) {
                        if($from_date){
                            $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                        }
                        if($to_date){
                            $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                        }
                    })
                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                        }
                    })
                    ->first();
                    $data->total_dollar_view = $delivery->total_dollar ;
                    $data->total_riel_view = $delivery->total_riel ;
                    // session()->put('total_dollar',$delivery->total_dollar);
                    // session()->put('total_riel',$delivery->total_riel);

                    return    '$'.number_format( $delivery->total_dollar  ,2)  .' / '.number_format( $delivery->total_riel,2). '៛' ;
                })
                ->editColumn('payment', function ($data) {

                    $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
                    $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
                    $status         =   request()->status;

                    $payment = DeliveryOrderModel::
                    select(
                        \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee'),
                            'nso007_export_stock.*',
                            'nso007_export_stock.status',
                            'nso007_delivery_order_detail.total_riel',
                            'nso007_delivery_order_detail.total_dollar',
                            'nso007_delivery_order_detail.commission_type AS share_fee_type',
                            'nso007_delivery_order_detail.driver_commission AS share_fee',
                            'nso007_discount.discount',
                            'nso007_discount.discount_type',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order_detail.pay_to',
                            'nso007_delivery_order_detail.amount_pay_to'
                    )
                    ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                    ->leftJoin('nso007_discount','nso007_export_stock.discount_id','nso007_discount.id')

                    ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                    ->where('nso007_export_stock.merchant_id',$data->merchant_id)
                    ->where(function ($query) use ($from_date, $to_date) {
                        if($from_date){
                            $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                        }
                        if($to_date){
                            $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                        }
                    })
                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                        }
                    })
                    ->groupBy('nso007_export_stock_details.export_id')
                    ->groupBy('nso007_delivery_order_detail.delivery_order_id')
                    ->groupBy('nso007_delivery_order_detail.status')
                    ->get();

                        $total = 0;
                        $total_dollar = 0;
                        $total_riel = 0;
                        $delivery_fee_paid = 0;

                        $other_services_paid   = 0;
                        $other_services_pay   = 0;
                        $other_services_pay_cus   = 0;
                        $delivery_fee_pay   = 0;
                        $delivery_fee_pay_cus   = 0;

                        $taxi_paid   = 0;
                        $taxi_pay   = 0;
                        $commission_driver   = 0;
                        $taxi_pay_cus   = 0;

                        foreach ($payment as $key => $value) {
                            if( $value->status == 3){


                                if($value->share_fee_type == 1){
                                    $commission_driver += number_format($value->share_fee, 3) ;
                                }else{
                                    $commission_driver += number_format(($value->share_fee/100)*($value->delivery_fee   +   $value->extra_fee),3)   ;
                                }

                                if ($value->other_services_fee > 0 || $value->other_services_fee != null) {
                                    if ($value->other_services_type == 1) {
                                        if ($value->other_services_pay_or_paid == 'pay') {
                                            $other_services_pay     +=  $value->other_services_fee ;
                                        } else {
                                            $other_services_paid    +=  $value->other_services_fee ;
                                        }
                                    } else {
                                        $other_services_pay_cus     += $value->other_services_fee ;
                                    }
                                }
                                $total_riel         +=  $value->total_riel;
                                $total_dollar       +=  $value->total_dollar;

                                if ($value->delivery_status == 1) {   //shop
                                    if ($value->delivery_pay_or_paid == 'pay') {
                                        $delivery_fee_pay     +=  $value->delivery_fee ;
                                    } else {
                                        $delivery_fee_paid    +=  $value->delivery_fee ;
                                    }
                                } else {
                                    $delivery_fee_pay_cus     += $value->delivery_fee ;
                                }

                                if ($value->taxi_status == 1) {   //shop
                                    if ($value->taxi_pay_or_paid == 'pay') {
                                        $taxi_pay     +=  $value->taxi_fee ;
                                    } else {
                                        $taxi_paid    +=  $value->taxi_fee ;
                                    }
                                } else {
                                    $taxi_pay_cus     += $value->taxi_fee ;
                                }
                            }
                        }

                    $total_paid =  $other_services_paid  +  $delivery_fee_paid   +   $taxi_paid   ;
                    $total_serve =  $other_services_pay_cus +  $other_services_pay +  $delivery_fee_pay  +  $delivery_fee_pay_cus + $taxi_pay_cus + $taxi_pay;
                    $total  =  number_format( $total_dollar  -  $other_services_pay_cus  -  $other_services_pay  - $delivery_fee_pay   -  $delivery_fee_pay_cus -$taxi_pay_cus -$taxi_pay ,2)    ;
                    // session()->put('total_paid',$total_paid);

                    $data->total_paid           = $total_serve;
                    $data->total_serve          = $total_serve;
                    $data->commission_driver    = $commission_driver;
                    $data->total_receive        = $total;

                    // session()->put('total_serve',$total_serve);
                    // session()->put('commission_driver',$commission_driver);
                    // session()->put('total_receive',$total);
                    return  ('$'. $total .' / '. number_format( $total_riel ,2).'៛') ;
                })
                ->editColumn('Services', function($data) {

                    return '$'.number_format( $data->total_serve ,2) .'(pay)   /  '.'$'.number_format($data->total_paid,2) .'(paid)  ';
                })

                ->editColumn('action', function($data) {

                    $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
                    $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
                    $status         =   request()->status;
                    $status_1 ='';

                    if(!empty($status)){
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                    }

                    $data_view =    $data->total_dollar_view .','.
                                    $data->total_riel_view   .','.
                                    $data->total_serve.','.
                                    $data->total_paid.','.
                                    $data->commission_driver.','.
                                    $data->total_receive  ;
                    return '<a data-href="'.route('summary-delivery-print',[
                                $from_date,$to_date,
                                $data->merchant_id,
                                $data_view,
                                $status_1,
                                ]).'" class="button_primary bt-print">'.__('administrator.print').'</a>'  ;

                })
                ->editColumn('commission_driver', function($data) {

                    return '$'.number_format($data->commission_driver ,2) ;
                })
                ->editColumn('total', function($data) {

                    return '$'. number_format(($data->total_serve  + $data->total_paid ) - $data->commission_driver,2);


                })


                ->rawColumns(['merchant' => 'merchant','date'=>'date','received'=>'received','payment'=>'payment','action'=>'action'])
                ->addIndexColumn()
                ->make(true);
            }
        return  view('administrator.report.summary-delivery',compact('merchant'));
    }

    // public function SummaryDeliveryList(Request $request){

    //     $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
    //     $from_date      =   $request->from_date == '' ? date('Y-m-d') : $request->from_date;
    //     $to_date        =   $request->to_date == '' ? date('Y-m-d') : $request->to_date;
    //     $merchant_id       =   $request->merchant;
    //     $status         =   $request->status;
    //     $search         =   $request->input('search.value');


    //     if($request->ajax()){
    //         $count_total = DeliveryOrderModel::
    //                 join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //                 ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //                 ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
    //                 ->groupBy('nso007_export_stock.merchant_id')
    //                 ->get() ->count();

    //                 $count_filter = DeliveryOrderModel::
    //                 join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //                 ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //                 ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
    //                 ->groupBy('nso007_export_stock.merchant_id')
    //                 ->where(function ($query) use ($from_date, $to_date, $merchant_id ) {
    //                     if($from_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
    //                     }
    //                     if($to_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
    //                     }
    //                     if($merchant_id){
    //                         $query->where('nso007_export_stock.merchant_id', $merchant_id);
    //                     }
    //                 })
    //                 ->when(request('status'),function($query) use ($status){
    //                     if(!empty($status)){
    //                         $status_1 ='';
    //                         foreach ($status as $key => $value) {
    //                             $status_1  .= $status[$key].',' ;
    //                         }
    //                         $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
    //                     }
    //                 })
    //         ->get()->count();
    //         $data = DeliveryOrderModel::
    //             select('merchant.name AS merchant_name','merchant.id AS merchant_id','merchant.phone AS merchant_phone','nso007_delivery_order.delivery_date')
    //             ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //             ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //             ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
    //             ->groupBy('nso007_export_stock.merchant_id')
    //             ->where(function ($query) use ($from_date, $to_date, $merchant_id) {
    //                 if($from_date){
    //                     $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
    //                 }
    //                 if($to_date){
    //                     $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
    //                 }
    //                 if($merchant_id){
    //                     $query->where('nso007_export_stock.merchant_id', $merchant_id);
    //                 }
    //             })
    //             ->when(request('status'),function($query) use ($status){
    //                 if(!empty($status)){
    //                     $status_1 ='';
    //                     foreach ($status as $key => $value) {
    //                         $status_1  .= $status[$key].',' ;
    //                     }
    //                     $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
    //                 }
    //             })
    //         ->take(20)->orderBy('nso007_export_stock.id','DESC');
    //         return DataTables::of($data)
    //             ->with([
    //                 "recordsTotal" => $count_total,
    //                 "recordsFiltered" => $count_filter,
    //             ])
    //             ->addColumn('date', function ($data) {
    //                 return $data->delivery_date;
    //             })
    //             ->editColumn('merchant', function ($data){
    //                 return $data->merchant_name .' / '.  $data->merchant_phone ;
    //             })
    //             ->editColumn('transaction', function($data) {
    //                 $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
    //                 $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
    //                 $status         =   request()->status;
    //                 $delivery = DeliveryOrderDetailModel::
    //                             join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //                             ->join('nso007_delivery_order','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //                             ->where('nso007_export_stock.merchant_id',$data->merchant_id)
    //                             ->where(function ($query) use ($from_date, $to_date) {
    //                                 if($from_date){
    //                                     $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
    //                                 }
    //                                 if($to_date){
    //                                     $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
    //                                 }
    //                             })
    //                             ->when(request('status'),function($query) use ($status){
    //                                 if(!empty($status)){
    //                                     $status_1 ='';
    //                                     foreach ($status as $key => $value) {
    //                                         $status_1  .= $status[$key].',' ;
    //                                     }
    //                                     $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
    //                                 }
    //                             })
    //                             ->count();
    //                 return $delivery ;
    //             })
    //             ->editColumn('received', function($data) {
    //                     $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
    //                     $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
    //                     $status         =   request()->status;
    //                     $delivery = DeliveryOrderDetailModel::
    //                     select(
    //                         // 'nso007_export_stock_details.price',
    //                         // \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
    //                         \DB::raw('SUM(nso007_delivery_order_detail.total_riel) as total_riel'),
    //                         \DB::raw('SUM(nso007_delivery_order_detail.total_dollar) as total_dollar'),
    //                 )
    //                 ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //                 // ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
    //                 ->join('nso007_delivery_order','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //                 ->where('nso007_export_stock.merchant_id',$data->merchant_id)
    //                 ->where(function ($query) use ($from_date, $to_date) {
    //                     if($from_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
    //                     }
    //                     if($to_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
    //                     }
    //                 })
    //                 ->when(request('status'),function($query) use ($status){
    //                     if(!empty($status)){
    //                         $status_1 ='';
    //                         foreach ($status as $key => $value) {
    //                             $status_1  .= $status[$key].',' ;
    //                         }
    //                         $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
    //                     }
    //                 })
    //                 ->first();
    //                 session()->put('total_dollar',$delivery->total_dollar);
    //                 session()->put('total_riel',$delivery->total_riel);

    //                 return    '$'.number_format( $delivery->total_dollar  ,2)  .' / '.number_format( $delivery->total_riel,2). '៛' ;
    //             })
    //             ->editColumn('payment', function ($data) {
    //                 $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
    //                 $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
    //                 $status         =   request()->status;

    //                 $payment = DeliveryOrderModel::
    //                 select(
    //                     \DB::raw('(CASE
    //                             WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
    //                             WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
    //                             ELSE nso007_export_stock.taxi_shop_fee
    //                             END) AS taxi_fee'),
    //                         'nso007_export_stock.*',
    //                         'nso007_export_stock.status',
    //                         'nso007_delivery_order_detail.total_riel',
    //                         'nso007_delivery_order_detail.total_dollar',
    //                         'nso007_delivery_order_detail.commission_type AS share_fee_type',
    //                         'nso007_delivery_order_detail.driver_commission AS share_fee',
    //                         'nso007_discount.discount',
    //                         'nso007_discount.discount_type',
    //                         'nso007_delivery_order.delivery_date'
    //                 )
    //                 ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //                 ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //                 ->leftJoin('nso007_discount','nso007_export_stock.discount_id','nso007_discount.id')

    //                 ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
    //                 ->where('nso007_export_stock.merchant_id',$data->merchant_id)
    //                 ->where(function ($query) use ($from_date, $to_date) {
    //                     if($from_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
    //                     }
    //                     if($to_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
    //                     }
    //                 })
    //                 ->when(request('status'),function($query) use ($status){
    //                     if(!empty($status)){
    //                         $status_1 ='';
    //                         foreach ($status as $key => $value) {
    //                             $status_1  .= $status[$key].',' ;
    //                         }
    //                         $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
    //                     }
    //                 })
    //                 ->groupBy('nso007_export_stock_details.export_id')
    //                 ->groupBy('nso007_delivery_order_detail.delivery_order_id')
    //                 ->groupBy('nso007_delivery_order_detail.status')
    //                 ->get();

    //                     $total = 0;
    //                     $total_dollar = 0;
    //                     $total_riel = 0;
    //                     $delivery_fee_paid = 0;

    //                     $other_services_paid   = 0;
    //                     $other_services_pay   = 0;
    //                     $other_services_pay_cus   = 0;
    //                     $delivery_fee_pay   = 0;
    //                     $delivery_fee_pay_cus   = 0;

    //                     $taxi_paid   = 0;
    //                     $taxi_pay   = 0;
    //                     $commission_driver   = 0;
    //                     $taxi_pay_cus   = 0;

    //                     foreach ($payment as $key => $value) {
    //                         if( $value->status == 3){


    //                             if($value->share_fee_type == 1){
    //                                 $commission_driver += number_format($value->share_fee, 3) ;
    //                             }else{
    //                                 $commission_driver += number_format(($value->share_fee/100)*($value->delivery_fee   +   $value->extra_fee),3)   ;
    //                             }

    //                             if ($value->other_services_fee > 0 || $value->other_services_fee != null) {
    //                                 if ($value->other_services_type == 1) {
    //                                     if ($value->other_services_pay_or_paid == 'pay') {
    //                                         $other_services_pay     +=  $value->other_services_fee ;
    //                                     } else {
    //                                         $other_services_paid    +=  $value->other_services_fee ;
    //                                     }
    //                                 } else {
    //                                     $other_services_pay_cus     += $value->other_services_fee ;
    //                                 }
    //                             }
    //                             $total_riel         +=  $value->total_riel;
    //                             $total_dollar       +=  $value->total_dollar;

    //                             if ($value->delivery_status == 1) {   //shop
    //                                 if ($value->delivery_pay_or_paid == 'pay') {
    //                                     $delivery_fee_pay     +=  $value->delivery_fee ;
    //                                 } else {
    //                                     $delivery_fee_paid    +=  $value->delivery_fee ;
    //                                 }
    //                             } else {
    //                                 $delivery_fee_pay_cus     += $value->delivery_fee ;
    //                             }

    //                             if ($value->taxi_status == 1) {   //shop
    //                                 if ($value->taxi_pay_or_paid == 'pay') {
    //                                     $taxi_pay     +=  $value->taxi_fee ;
    //                                 } else {
    //                                     $taxi_paid    +=  $value->taxi_fee ;
    //                                 }
    //                             } else {
    //                                 $taxi_pay_cus     += $value->taxi_fee ;
    //                             }
    //                         }
    //                     }

    //                 $total_paid =  $other_services_paid  +  $delivery_fee_paid   +   $taxi_paid   ;
    //                 $total_serve =  $other_services_pay_cus +  $other_services_pay +  $delivery_fee_pay  +  $delivery_fee_pay_cus + $taxi_pay_cus + $taxi_pay;
    //                 $total  =  number_format( $total_dollar  -  $other_services_pay_cus  -  $other_services_pay  - $delivery_fee_pay   -  $delivery_fee_pay_cus -$taxi_pay_cus -$taxi_pay ,2)    ;
    //                 session()->put('total_paid',$total_paid);
    //                 session()->put('total_serve',$total_serve);
    //                 session()->put('commission_driver',$commission_driver);
    //                 session()->put('total_receive',$total);
    //                 return  ('$'. $total .' / '. number_format( $total_riel ,2).'៛') ;
    //             })
    //             ->editColumn('Services', function($data) {
    //                 return '$'.number_format(session()->get('total_serve'),2) .'(pay)   /  '.'$'.number_format(session()->get('total_paid'),2) .'(paid)  ';
    //             })
    //             ->editColumn('commission_driver', function($data) {
    //                 return '$'.number_format(session()->get('commission_driver'),2) ;
    //             })
    //             ->addColumn('action', function($data) {
    //                 $from_date      =   request()->from_date == '' ? date('Y-m-d') : request()->from_date;
    //                 $to_date        =   request()->to_date == '' ? date('Y-m-d') : request()->to_date;
    //                 $status         =   request()->status;
    //                 $status_1 ='';

    //                 if(!empty($status)){
    //                     foreach ($status as $key => $value) {
    //                         $status_1  .= $status[$key].',' ;
    //                     }
    //                 }

    //                 $data_view =    session()->get('total_dollar') .','.
    //                                 session()->get('total_riel') .','.
    //                                 session()->get('total_serve') .','.
    //                                 session()->get('total_paid') .','.
    //                                 session()->get('commission_driver').','.
    //                                 session()->get('total_receive')
    //                                 ;
    //                 return '<a data-href="'.route('summary-delivery-print',[
    //                             $from_date,$to_date,
    //                             $data->merchant_id,
    //                             $data_view,
    //                             $status_1,
    //                             ]).'" class="button_primary bt-print">'.__('administrator.print').'</a>' ;

    //             })

    //             ->addColumn('total', function($data) {

    //                 return '$'. number_format(( session()->get('total_serve')  + session()->get('total_paid') ) - session()->get('commission_driver'),2);


    //             })


    //             ->rawColumns(['merchant' => 'merchant','date'=>'date','received'=>'received','payment'=>'payment','action'=>'action'])
    //             ->addIndexColumn()
    //             ->make(true);
    //         }
    //     return  view('administrator.report.summary-delivery',compact('merchant'));
    // }


    public function SummaryDeliveryPrint($from_date ,$to_date,$merchant_id,$data_view,$status = null){

        $from_date  = empty  ($from_date)? '':date('Y-m-d',strtotime($from_date));
        $to_date    = empty($to_date)? '':date('Y-m-d',strtotime($to_date));

        $data = DeliveryOrderModel::
            select(
                'nso007_delivery_order_detail.status',
                'nso007_export_stock.merchant_id'
            )
        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
        ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
            if(!empty($from_date) && !empty($to_date)){
                $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
            }
        })
        ->when(request('status'),function($query) use ($status){
            if(!empty($status)){
                $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status));
            }
        })
        ->where(function($query) use ($merchant_id){
            if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                $query->where('merchant_id',\Auth::user()->id);
            }else if(\Globals::is_Driver() == 'Driver'){
                $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
            }else{
                $query->where('merchant_id','LIKE',$merchant_id);
            }
        })
        ->orderBy('nso007_delivery_order.inovice','desc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->get();
        $done = 0;
        $cancel = 0;
        $padding = 0;
        $processing = 0;

        foreach ($data as $key => $value) {
            if($value->status == 1){
                $processing = $processing + 1;
            }
            elseif($value->status == 2){
                $padding = $padding + 1;
            }
            elseif($value->status == 3){
                $done = $done + 1;
            }
            else{
                $cancel = $cancel + 1;
            }
        }
        return view('administrator.report.summary-driver-print',compact('merchant_id','data_view','done','cancel','padding','processing'))->render();  //

    }

    public function SummaryDeliveryListAll( Request $request){
        $from_date      =   $request->from_date == '' ? date('Y-m-d') : $request->from_date;
        $to_date        =   $request->to_date == '' ? date('Y-m-d') : $request->to_date;
        $merchant_id       =   $request->merchant;
        $status         =   $request->status;

        $data = DeliveryOrderModel::
        select('merchant.name AS merchant_name','merchant.id AS merchant_id','merchant.phone AS merchant_phone','nso007_delivery_order.delivery_date')
        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
        ->groupBy('nso007_export_stock.merchant_id')
        ->where(function ($query) use ($from_date, $to_date, $merchant_id) {
            if($from_date){
                $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                }
                if($to_date){
                    $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                }
                if($merchant_id){
                    $query->where('nso007_export_stock.merchant_id', $merchant_id);
                }
            })
            ->when(request('status'),function($query) use ($status){
                if(!empty($status)){
                    $status_1 ='';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key].',' ;
                    }
                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                }
            })
        ->where('nso007_delivery_order.delivery_date','>=',date('Y-m-d', strtotime("-4 day", strtotime(date('Y-m-d')))))
        ->get() ;

        return view('administrator.report.summary-driver-print-all',compact('data','from_date','to_date','merchant_id','status'))->render();
    }



    public function approve( Request $request){
        // dd(explode(',', $request->export_id));
        $deliveryOrder  =  DeliveryOrderModel::
                join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->select('nso007_delivery_order_detail.status', 'nso007_delivery_order_detail.export_id')
                ->whereIn('nso007_delivery_order_detail.export_id',explode(',', $request->export_id))
                ->where(function ($query) {
                    $query->orwhere('nso007_delivery_order_detail.status_paid', 'paid');
                })
                ->update(['nso007_delivery_order_detail.approve'=>'approve']);
                echo json_encode(2);

                // ->when(request('from_date', 'to_date'), function ($query) use ($from_date,$to_date) {
                //     if (!empty($from_date) && !empty($to_date)) {
                //         $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date,$to_date]);
                //     }
                // })

                // ->where(function ($query) use ($merchant) {
                //     if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                //         $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                //     } elseif (\Globals::is_Driver() == 'Driver') {
                //         $query->where('nso007_delivery_order.driver_id', \Auth::user()->id);
                //     } else {
                //         $query->where('nso007_export_stock.merchant_id', 'LIKE', $merchant);
                //     }
                // })

                // ->when(request('referance'), function ($query) use ($referance) {
                //     if (!empty($referance)) {
                //         $query->where('nso007_export_stock.referance', $referance);
                //     }
                // })

                // ->where(function ($query) {
                //     $query->orwhere('nso007_delivery_order_detail.status', 3);
                // })
                // ->whereNull('nso007_delivery_order_detail.status_paid');
 
    }
    public function history_box(Request $request){
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;
        
        // $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
        
        if ($request->ajax()) {
            $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.export_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                ->groupBy('nso007_export_stock.box_code')
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc'); 
            return  Datatables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    return '<span class="btn btn-sm btn-primary show-history" data-id="'.$data->export_stock_id.'">Show History</span>';
                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else if($data->status ==5)   // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                    else if($data->status ==6)   // 6 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.paid') . ' </strong>';
                    else if($data->status ==7)   // 7 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>';
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })
                
                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1) 
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->orderBy('nso007_delivery_order.id','DESC')
                            ->first();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";
                        
                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })

                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name'])
                ->addIndexColumn()
                ->make(true);
        }
        return view('administrator.report.history_box.index');
    }
    public function history_box_show(Request $request){
        $data = DB::table('nso007_box_history')->where('nso007_box_history.export_id',$request->id)
            ->join(DB::raw("(SELECT id as user_id_1,name from users) as users"),"users.user_id_1","nso007_box_history.user_id")
            ->select(
                'nso007_box_history.reason',
                'users.name',
                'nso007_box_history.created_at',
                'nso007_box_history.reason_dev',
                DB::raw(
                    '(CASE 
                    WHEN nso007_box_history.status = 1 THEN "In Stock Delivery"  
                    WHEN nso007_box_history.status = 2 THEN "processing" 
                    WHEN nso007_box_history.status = 3 THEN "Done" 
                    WHEN nso007_box_history.status = 4 THEN "Padding" 
                    WHEN nso007_box_history.status = 5 THEN "Cancel" 
                    WHEN nso007_box_history.status = 6 THEN "Paid" 
                    WHEN nso007_box_history.status = 7 THEN "Return To Shop" 
                    ELSE "not set" END) AS status_text'
                )
                );
        
        return view('administrator.report.history_box.show',compact('data'))->render();
    }
    public function report_driver(Request $request){
        $from_date      = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $drivers        = isset($request->drivers) ? $request->drivers : null;
        $status         = isset($request->status) ? $request->status : null;
        $clear          = isset($request->clear) ? $request->clear : null;
        $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
        if($request->ajax()){
        $data = DB::table('nso007_delivery_order_detail')
        ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
        ->select(
            'nso007_discount.discount',
            'nso007_discount.discount_type',
            'nso007_delivery_order_detail.clear_box_by',
            'nso007_delivery_order_detail.clear_box_code',
            'nso007_delivery_order_detail.delivery_order_id',
            'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.*',
            'nso007_export_stock.total_product AS total_price',
            'nso007_delivery_order_detail.status AS status_detail',
            'nso007_delivery_order_detail.status_paid',
            'nso007_delivery_order_detail.reason AS detail_reason',
            'nso007_delivery_order.driver_name',
            'nso007_delivery_order.inovice As driver_voucher',  
            'nso007_delivery_order_detail.total_riel',
            'nso007_delivery_order_detail.total_dollar',
            'nso007_delivery_order_detail.amount_pay_to',
            'nso007_delivery_order_detail.pay_to',
            'nso007_delivery_order_detail.invoice_payment_id',
            'nso007_delivery_order_detail.verify_by',

            \DB::raw('(CASE
            WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
            WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
            ELSE nso007_export_stock.taxi_shop_fee
            END) AS taxi_fee')
        )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
                } 
            })
 
            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })

            ->when(request('clear'), function ($query) use ($clear) {
                if (!empty($clear)) {
                    if($clear == 'not_clear'){
                        $query->whereNull('nso007_delivery_order_detail.clear_box_code');

                    }else{
                        $query->whereNotNull('nso007_delivery_order_detail.clear_box_code');
                    }
                }
            })
            ->where(function ($query) use ($drivers) {
                if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                    $query->where('merchant_id', \Auth::user()->id);
                } else if (\Globals::is_Driver() == 'Driver') {
                    $query->where('driver_id', \Auth::user()->id);
                } else {
                    $query->where('driver_id', 'LIKE', $drivers);
                }
            })
        ->where('driver_id', 'LIKE', $drivers)
        ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
        ->orderBy('nso007_export_stock.box_code','desc');

            return DataTables::of($data)
                ->editColumn('pay_to_delivery', function ($data)  {
                    if ($data->pay_to == 'delivery'){
                        return    '$'.numberFormat( $data->amount_pay_to); 
                    }else{
                        return    '';
                    }
                })

                ->editColumn('pay_to_shop', function ($data)  {
                    if ($data->pay_to == 'shop'){
                        return   '$'.numberFormat( $data->amount_pay_to); 
                    }else{
                        return    '';
                    }
                })
                
                ->addColumn('price', function ($data) {
                    return '$' . numberFormat($data->total_price);
                })

                ->addColumn('reason', function ($data) {
                    return ($data->detail_reason == null ? "" :  $data->detail_reason ). ' '. ($data->driver_note == null ? "" :  $data->driver_note);
                })

                ->addColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->export_date)) .' <br> '. date('d-m-Y', strtotime($data->delivery_date));
                })


                ->addColumn('verify_by', function ($data) {

                    if($data->verify_by){
                        return      $data->verify_by; 
                    }
                    return      '<span class="class_'.$data->id.'_'.$data->delivery_order_id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("driver.verify_by", [$data->id,$data->delivery_order_id]) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                })

                ->editColumn('taxi_fee', function ($data)  {

                    $return_ = '';
                    if($data->taxi_status == 1){
                        // $return_ = $data->taxi_fee >=1 ?( '$'.numberFormat( $data->taxi_fee).' s') : '';
                        if($data->taxi_fee_symbol == "$"){
                            $return_ = ( '$'.numberFormat( $data->taxi_fee).' s');
                        }else{
                            $return_ = ( numberFormat( $data->taxi_fee).'៛ s');
                        }
                    }
                    else{
                        $return_ =   '';                        
                    }

                    if($data->status_detail != 3){ 
                        return '<samp>'.$return_ .'</samp>';
                    }else{
                        return $return_;
                    }

                })


                ->editColumn('delivery_fee', function ($data)  {
                    $delivery_fee  = 0;
                    if($data->discount_type != null || $data->discount_type != '')
                    {
                        if($data->discount_type == 1){
                            $delivery_fee = $data->discount;
                        }
                        elseif($data->discount_type == 2){
                            $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                        }
                        else{
                            $delivery_fee =$data->delivery_fee;
                        }
                    }
                    else{
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if($data->delivery_status == 1){
                        if($data->delivery_fee_symbol == "$"){
                            $delivery_fee = '$'.numberFormat( $delivery_fee) . ' s';
                        }else{
                            $delivery_fee = ''.numberFormat( $delivery_fee) . '៛ s';
                        }
                        
                    }
                    else{
                        if ($data->delivery_fee_symbol == "$") {
                            $delivery_fee = '$'.numberFormat($delivery_fee). ' c';
                        }else{
                            $delivery_fee = ''.numberFormat($delivery_fee). '៛ c';
                        }
                    }

                    if($data->delivery_pay_or_paid == 'paid'){
                        $delivery_fee =   '  <strike> '.$delivery_fee . '  </strike>';
                    } 

                    if($data->status_detail != 3){ 
                        return '<samp>'.$delivery_fee .'</samp>';
                    }else{
                        return $delivery_fee;
                    } 
                })

                
                ->addColumn('status', function ($data) {
                    if ($data->status_detail == 1)  // 1 = Processing,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '</strong>';
                    else if ($data->status_detail == 2)  // 2 = Padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . ' </strong>';
                    else if ($data->status_detail == 3)  //  3 = Done ,
                        return ' <strong class="text-info"><span class="fa fa-check"></span>  ' . __('administrator.done') . ' </strong>';
                    else if ($data->status_detail == 4)  // 4 = Cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span>  ' . __('administrator.cancel') . '</strong>';
                    else {
                        return ' <strong class="text-muted"><span class="fa fa-check"></span>  ' . __('administrator.paid') . '</strong>';
                    }
                })
                ->addColumn('clear_box_code',function($data){
                    if( request()->drivers && $data->clear_box_code != 1 ){
                        return '<div><input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                    }
                    
                    if($data->clear_box_code){
                        return '<span >  '.explode(',',$data->clear_box_by)[1].'</span>';
                    }
                })

                ->addColumn('clear_with_shop',function($data){
                    if( $data->invoice_payment_id ){
                        return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                    }
                    
                }) 

                ->addColumn('user_currency',function($data){
                    return  (User::find($data->merchant_id)->user_currency);
                })  
               
                ->addColumn('action', function ($data) {
                    if($data->discount_type != null || $data->discount_type != '')
                    {
                        if($data->discount_type == 1){
                            $delivery_fee = $data->discount;
                        }
                        elseif($data->discount_type == 2){
                            $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee ) / 100;
                        }
                        else{
                            $delivery_fee = $data->delivery_fee;
                        }
                    }
                    else{
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if($data->delivery_pay_or_paid == 'paid'){
                        $delivery_fee  =  0;
                    }

                    $other_services_fee =  0;
                    if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                        $other_services_fee = $data->other_services_fee ;
                    }

                    $edit = '';
                    if($data->status_detail == 3 && Gate::check('Report Driver Edit'))
                        {
                            $edit = '<a 
                            data-price ="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                            data-href="' . route("driver.edit_price", $data->id) . '" class="button_primary fa fa-edit bt-edit"></a>';
                        }
                    $delete = '';
                        $delete = '<a data-href="' . route("export_stock_delete_box", [$data->nso007_delivery_order_detail_id,'in_processing']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    if(!$data->invoice_payment_id){
                        return $delete .''.$edit ;
                    }
                })

                ->editColumn('total_dollar', function ($data)  { 
                    if($data->status_detail != 3){ 
                        return '<samp>'.($data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '').'</samp>';
                    }else{
                        return $data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '';
                    } 
                })

                ->editColumn('total_riel', function ($data)  { 
                    if($data->status_detail != 3){ 
                        return '<samp>'.($data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '').'</samp>';
                    }else{
                        return $data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '';
                    } 
                })
                

                ->editColumn('total_price', function ($data)  {

                    if($data->status_detail != 3){ 
                        return '<samp>'. '$'.numberFormat( $data->total_price)  .'</samp>';
                    }else{
                        return '$'.numberFormat( $data->total_price);
                    }
                })
                
                ->rawColumns([ 'verify_by'=>'verify_by', 'other_service_fee'=>'other_service_fee','taxi_fee'=>'taxi_fee','total_price'=>'total_price','extra_fee'=>'extra_fee','delivery_fee'=>'delivery_fee','total_dollar'=>'total_dollar','total_riel'=>'total_riel','status' => 'status','clear_box_code'=>'clear_box_code','clear_by'=>'clear_by','action'=>'action','clear_with_shop'=>'clear_with_shop','date'=>'date'])
                ->addIndexColumn()
                ->make(true);
        }

        return view('administrator.report.driver.report-driver');
    }
    
}
