<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\PickupAdminModel;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class PickupAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            $from_date = $request->from_date ? date('Y-m-d',strtotime($request->from_date)) : "";
            $to_date = $request->to_date ? date('Y-m-d',strtotime($request->to_date)) : "";
            $merchant_id = $request->merchant??"";
            $driver = explode('||',$request->driver_id);
            $driver_id = $driver[0];
            $time_policy = @$driver[1];
            $data = PickupAdminModel::join('users','users.id','nso007_pickup_admin.shop_id')
                ->leftJoin('users as driver','driver.id','nso007_pickup_admin.driver_id')
                ->selectRaw("
                    nso007_pickup_admin.*,users.shop_name,driver.name as driver_name
                ")
                ->when($from_date&&$to_date,function($q) use($from_date,$to_date){
                    $q->whereBetween(DB::raw("(STR_TO_DATE(nso007_pickup_admin.date,'%Y-%m-%d'))"),[$from_date,$to_date]);
                })
                ->when($merchant_id,function($q) use($merchant_id){
                    $q->where('nso007_pickup_admin.shop_id',$merchant_id);
                })
                ->when($driver_id,function($q) use($driver_id){
                    $q->where('nso007_pickup_admin.driver_id',$driver_id);
                })
                ->when($time_policy,function($q) use($time_policy){
                    $q->where('nso007_pickup_admin.time_policy',$time_policy);
                })
                ->orderBy('nso007_pickup_admin.id','DESC');

            return datatables($data)
                ->addColumn('driver_name',function($data){
                    $time = '';
                    if ($data->time_policy == 1) {
                        $time = "ព្រឹក";
                    }
                    if ($data->time_policy == 2) {
                        $time = "ល្ងាច";
                    }
                    if($data->driver_id){
                        $change_driver = "";
                        if($data->status == 1){
                            $change_driver = "chage_driver";
                        }
                        return '<button type="button" class="btn btn-primary btn-sm '.$change_driver.'" data-time="'.$data->time_policy.'"  data-delivery_date="'.$data->delivery_date.'"  data-driver_id="'.$data->driver_id.'" data-id="'.$data->id.'">'.$data->driver_name.' ('.$time.')</button>';
                    }else{
                        return '<button type="button" class="btn btn-danger btn-sm assign_to_driver" data-pickup_id="'.$data->id.'">No Driver Yet</button>';
                    }
                })
                ->addColumn('print_all',function($data){
                    if($data->status == 0){
                        return '
                        <div class="form-check">
                            <input class="form-check-input checkbox" type="checkbox" value="'.$data->id.'" data-status="'.$data->status.'" id="flexCheckDefault">
                            <label class="form-check-label" for="flexCheckDefault">
                            </label>
                        </div>
                        ';
                    }
                })
                ->addColumn('action',function($data){
                    $btn_edit = "";
                    $btn_delete = "";
                    if($data->status == 0 || $data->status == 1){
                        if(Gate::check('Edit Pickup')){
                            $btn_edit = '<a href="javascript:;" class="btn btn-sm btn-info save-edit-pickup" data-title="Edit Pickup" data-href="'.route('pickup-admin.edit',$data->id).'"><i class="fa fa-edit"></i> '.__('administrator.edit').'</a>';
                        }
                        if(Gate::check('Delete Pickup')){
                            $btn_delete = '&nbsp;<a href="javascript:;" class="btn btn-sm btn-danger delete-pickup" data-href="'.route('pickup-admin.destroy',$data->id).'"><i class="fa fa-trash"></i> '.__('administrator.delete').'</a>';
                        }
                    }else{
                        return "<span class='badge badge-success' style='background:green'>Done</span>";
                    }
                    return $btn_edit.$btn_delete;
                })
                ->addIndexColumn()
                ->rawColumns(['print_all','driver_name','action'])
                ->toJson();
        }
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        return view('administrator.pickup-admin.index',compact('merchant_show'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $merchant = User::where('user_type', 3)->where('status', 1)
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();
        return response()->json([
            'success'=>true,
            'view'=>view('administrator.pickup-admin.create',compact('merchant'))->render(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return $this->update($request,null);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $merchant = User::where('user_type', 3)->where('status', 1)
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();
        $pickup = PickupAdminModel::find($id);
        return response()->json([
            'success'=>true,
            'view'=>view('administrator.pickup-admin.edit',compact('merchant','pickup'))->render(),
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'date'=>'required',
            'shop_id'=>'required'
        ]);
        $date = $request->date ? date('Y-m-d H:s:i',strtotime($request->date)) : date('Y-m-d H:s:i');
        if($id){
            $data = [
                'date'=>$date,
                'shop_id'=>$request->shop_id,
                'description'=>$request->description,
            ];
        }else{
            $data = [
                'user_id'=>auth()->id(),
                'date'=>$date,
                'shop_id'=>$request->shop_id,
                'description'=>$request->description,
                'status'=>0,
            ];
        }
        
        PickupAdminModel::updateOrCreate(['id'=>$id],$data);
        $msg = $id ? "Create Pickup Successfully." : "Update Pickup Successfully.";
        return response()->json([
            'success'=>true,
            'msg'=>$msg,
        ]);
        return redirect()->route('pickup-admin.index')
                    ->with('success',$msg);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        PickupAdminModel::where('id',$id)
            ->whereIn('status',[0,1])
            ->delete();
        return response()->json([
            'success'=>true,
            'msg'=>'Delete Successfully.'
        ]);
    }
    public function assign_driver(Request $request){
        $date = $request->delivery_date??'';
        $driver = explode('||',$request->driver_id);
        $driver_id = $driver[0];
        $time_policy = @$driver[1];
        if(!$date){
            return response()->json([
                'success'=>false,
                'error'=>'Please Select Date.'
            ]);
        }
        if(!$driver_id){
            return response()->json([
                'success'=>false,
                'error'=>'Please Select Driver.'
            ]);
        }
        if(!count($request->pickup_id??[])){
            return response()->json([
                'success'=>false,
                'error'=>'Please Select Data.'
            ]);
        }
        $delivery_date = date('Y-m-d',strtotime($request->delivery_date));
        PickupAdminModel::whereIn('id',$request->pickup_id??[])
            ->whereStatus(0)
            ->update([
                'status'=>1,
                'driver_id'=>$driver_id,
                'time_policy'=>$time_policy,
                'delivery_date'=>$delivery_date
            ]);
        return response()->json([
            'success'=>true,
            'msg'=>'Assign Driver Successfully.'
        ]);
    }
    public function driverPickup(Request $request){
        if($request->ajax()){
            $from_date = $request->from_date ? date('Y-m-d',strtotime($request->from_date)) : "";
            $to_date = $request->to_date ? date('Y-m-d',strtotime($request->to_date)) : "";
            $merchant_id = $request->merchant??"";
            $driver = explode('||',$request->driver_id);
            $driver_id = $driver[0];
            $time_policy = @$driver[1];
            $data = PickupAdminModel::join('users','users.id','nso007_pickup_admin.shop_id')
                ->leftJoin('users as driver','driver.id','nso007_pickup_admin.driver_id')
                ->selectRaw("
                    nso007_pickup_admin.*,users.shop_name,driver.name as driver_name
                ")
                ->when($from_date&&$to_date,function($q) use($from_date,$to_date){
                    $q->whereBetween(DB::raw("(STR_TO_DATE(nso007_pickup_admin.date,'%Y-%m-%d'))"),[$from_date,$to_date]);
                })
                ->when($merchant_id,function($q) use($merchant_id){
                    $q->where('nso007_pickup_admin.shop_id',$merchant_id);
                })
                ->when($driver_id,function($q) use($driver_id){
                    $q->where('nso007_pickup_admin.driver_id',$driver_id);
                })
                ->when($time_policy,function($q) use($time_policy){
                    $q->where('nso007_pickup_admin.time_policy',$time_policy);
                })
                ->where('nso007_pickup_admin.status',2)
                ->orderBy('nso007_pickup_admin.id','DESC');

            return datatables($data)
                ->addColumn('driver_name',function($data){
                    $time = '';
                    if ($data->time_policy == 1) {
                        $time = "ព្រឹក";
                    }
                    if ($data->time_policy == 2) {
                        $time = "ល្ងាច";
                    }
                    if($data->driver_id){
                        return '<button type="button" class="btn btn-primary btn-sm" data-time="'.$data->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-driver_id="'.$data->driver_id.'">'.$data->driver_name.' ('.$time.')</button>';
                    }else{
                        return '<button type="button" class="btn btn-danger btn-sm"   data-delivery_date=""  data-driver_id="">No Driver Yet</button>';
                    }
                })
                ->addColumn('action',function($data){
                    $return = "";
                    $approve = "";
                    if(Gate::check('Return Driver Pickup')){
                        $return = "<a href='javascript:;' class='btn btn-sm btn-primary return-pickup' data-route='".route('return-pickup-admin',$data->id)."?status=1'>".__('administrator.return')."</a>";
                    }
                    if(Gate::check('Approve Driver Pickup')){
                        $approve = "&nbsp;<a href='javascript:;' class='btn btn-sm btn-success approve-pickup' data-route='".route('approve-pickup-admin',$data->id)."?status=3'>".__('administrator.approve')."</a>";
                    }
                    return $return.$approve;
                })
                ->addIndexColumn()
                ->rawColumns(['driver_name','action'])
                ->toJson();
        }
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        return view('administrator.pickup-admin.pickup-list',compact('merchant_show'));
    }
    public function return($id,Request $request){
        if($request->isMethod("GET")){
            $pickupAdmin = PickupAdminModel::find($id);
            return response()->json([
                'success'=>false,
                'view'=> view('administrator.pickup-admin.return-pickup',compact('pickupAdmin'))->render(),
            ]);
        }
        if($request->isMethod("POST")){
            $status = $request->status;
            $pickupAdmin = PickupAdminModel::where('id',$id)
                ->whereIn('status',[3,2])
                ->update([
                    'status'=>$status,
                    'reason'=>$request->reason
                ]);
            return response()->json([
                'success'=>true,
            ]);
        }
    }
    public function approve($id,Request $request){
        if($request->isMethod("GET")){
            $pickupAdmin = PickupAdminModel::find($id);
            return response()->json([
                'success'=>false,
                'view'=> view('administrator.pickup-admin.approve-pickup',compact('pickupAdmin'))->render(),
            ]);
        }
        if($request->isMethod("POST")){
            $status = $request->status;
            $pickupAdmin = PickupAdminModel::where('id',$id)
                ->whereIn('status',[3,2])
                ->update([
                    'status'=>$status,
                    'exact_qty'=>$request->exact_qty??0,
                    'reason'=>'',
                ]);
            return response()->json([
                'success'=>true,
            ]);
        }
    }
    public function pickupSuccess(Request $request){
        if($request->ajax()){
            $from_date = $request->from_date ? date('Y-m-d',strtotime($request->from_date)) : "";
            $to_date = $request->to_date ? date('Y-m-d',strtotime($request->to_date)) : "";
            $merchant_id = $request->merchant??"";
            $driver = explode('||',$request->driver_id);
            $driver_id = $driver[0];
            $time_policy = @$driver[1];
            $data = PickupAdminModel::join('users','users.id','nso007_pickup_admin.shop_id')
                ->leftJoin('users as driver','driver.id','nso007_pickup_admin.driver_id')
                ->selectRaw("
                    nso007_pickup_admin.*,users.shop_name,driver.name as driver_name
                ")
                ->when($from_date&&$to_date,function($q) use($from_date,$to_date){
                    $q->whereBetween(DB::raw("(STR_TO_DATE(nso007_pickup_admin.date,'%Y-%m-%d'))"),[$from_date,$to_date]);
                })
                ->when($merchant_id,function($q) use($merchant_id){
                    $q->where('nso007_pickup_admin.shop_id',$merchant_id);
                })
                ->when($driver_id,function($q) use($driver_id){
                    $q->where('nso007_pickup_admin.driver_id',$driver_id);
                })
                ->when($time_policy,function($q) use($time_policy){
                    $q->where('nso007_pickup_admin.time_policy',$time_policy);
                })
                ->whereIn('nso007_pickup_admin.status',[3,4])
                ->orderBy('nso007_pickup_admin.id','DESC');

            return datatables($data)
                ->addColumn('driver_name',function($data){
                    $time = '';
                    if ($data->time_policy == 1) {
                        $time = "ព្រឹក";
                    }
                    if ($data->time_policy == 2) {
                        $time = "ល្ងាច";
                    }
                    if($data->driver_id){
                        return '<button type="button" class="btn btn-primary btn-sm" data-time="'.$data->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-driver_id="'.$data->driver_id.'">'.$data->driver_name.' ('.$time.')</button>';
                    }else{
                        return '<button type="button" class="btn btn-danger btn-sm"   data-delivery_date=""  data-driver_id="">No Driver Yet</button>';
                    }
                })
                ->addColumn('action',function($data){
                    $return = "";
                    $approve = "";
                    if($data->status != 4){
                        if(Gate::check("Return Pickup Success")){
                            $return = "<a href='javascript:;' class='btn btn-sm btn-primary return-pickup' data-route='".route('return-pickup-admin',$data->id)."?status=2'>".__('administrator.return')."</a>";
                        }
                        if(Gate::check("Approve Pickup Success")){
                            $approve = "&nbsp;<a href='javascript:;' class='btn btn-sm btn-success approve-pickup' data-route='".route('approve-pickup-admin',$data->id)."?status=4'>".__('administrator.approve')."</a>";
                        }
                    }else{
                        return "<span class='badge badge-success' style='background:green'>Done</span>";
                    }
                    return $return.$approve;
                })
                ->addIndexColumn()
                ->rawColumns(['driver_name','action'])
                ->toJson();
        }
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        return view('administrator.pickup-admin.pickup-success',compact('merchant_show'));
    }
    public function change_driver($pickId,Request $request){
        $date = $request->delivery_date??'';
        $driver = explode('||',$request->driver_id);
        $driver_id = $driver[0];
        $time_policy = @$driver[1];
        if(!$date){
            return response()->json([
                'success'=>false,
                'error'=>'Please Select Date.'
            ]);
        }
        if(!$driver_id){
            return response()->json([
                'success'=>false,
                'error'=>'Please Select Driver.'
            ]);
        }
        $delivery_date = date('Y-m-d',strtotime($request->delivery_date));
        PickupAdminModel::where('id',$pickId)
            ->whereIn('status',[0,1])
            ->update([
                'driver_id'=>$driver_id,
                'time_policy'=>$time_policy,
                'delivery_date'=>$delivery_date
            ]);
        return response()->json([
            'success'=>true,
            'msg'=>'Assign Driver Successfully.'
        ]);
    }
}
