<?php

namespace App\Http\Controllers\administrator;

use App\BranchModel;
use App\CategoryModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailShopModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\Exports\ExcelExport;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use App\Helpers\Globals;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use App\User;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;
class OutStockNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        $from_date      =   $request->from_date ? date('Y-m-d',strtotime($request->from_date)) : date("Y-m-d",strtotime("-1 week"));
        $to_date        =   $request->to_date ? date('Y-m-d',strtotime($request->to_date)) : date('Y-m-d');
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $driver_id       =   isset($request->driver_id)?$request->driver_id:null;
        $status         =   isset($request->status)?$request->status:[] ;

        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;
        if ($request->ajax()) {
            //Step 3
            $data = ExportStockModel::query()->with([
                'deliveryDetail:status_paid,invoice_payment_id,export_id,delivery_order_id,reason',
                "deliveryDetail.deliveryOrder:id,delivery_date,driver_name,driver_id,time_policy"
                ])
            ->selectRaw("
            CASE
                WHEN
                nso007_export_stock.delivery_option = 'No'
                THEN
                    CONCAT(nso007_export_stock.delivery_option,' (ភ្នំពេញ) ')
                ELSE
                    CONCAT(nso007_export_stock.delivery_option,' (ខេត្ត) ')
                END
            AS delivery_option_text,
            nso007_export_stock.id,nso007_export_stock.status,nso007_export_stock.is_return_to_shop,
            nso007_export_stock.export_date,nso007_export_stock.box_code,nso007_export_stock.shop_name,nso007_export_stock.customer_receive,
            nso007_export_stock.location_name,nso007_export_stock.total_product_symbol,nso007_export_stock.total_product,
            nso007_export_stock.delivery_fee_symbol,nso007_export_stock.delivery_fee
            ")
            ->when($driver_id,function($q) use($driver_id){
                $q->where('deliveryDetail.deliveryOrder:driver_id',$driver_id);
            })
            ->when($merchant,function($q) use($merchant){
                $q->where('nso007_export_stock.merchant_id',$merchant);
            })
            ->when(count($status),function($query) use ($status){
                    $query->whereIn('nso007_export_stock.status',$status);
            })
            ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                if($pro_or_city != null){
                    $operator = "!=";
                    if($pro_or_city != "No"){
                        $operator = "=";
                    }
                    $query->where('nso007_export_stock.delivery_option',$operator,"No");
                }
            })
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                if(!empty($from_date) && !empty($to_date)){
                    $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                }
            })
            ->orderBy('nso007_export_stock.id','DESC');
            return  Datatables::of($data)
                ->editColumn('box_code',function($data){
                    return "<a style='color:#337ab7' href='javascript:;' class='show-history' data-id='".$data->id."' data-box_code='".$data->box_code."'>".$data->box_code."</a>";
                })
                ->addColumn('print_all',function($data){
                    return '
                    <div class="form-check">
                        <input class="form-check-input checkbox" type="checkbox" value="'.$data->id.'" data-status="'.$data->status.'" id="flexCheckDefault">
                        <label class="form-check-label" for="flexCheckDefault">
                        </label>
                    </div>
                    ';
                })
                ->addColumn('driver_name', function ($data) {
                    $deliveryOrder = @$data->deliveryDetail->deliveryOrder;
                    if($deliveryOrder){
                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$deliveryOrder->time_policy.'"  data-delivery_date="'.$deliveryOrder->delivery_date.'"  data-export_id="'.$data->id.'" data-driver_id="'.$deliveryOrder->driver_id.'">'.$deliveryOrder->driver_name.'</button>';
                    }else{
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date=""  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    }
                    })
                ->addColumn('delivery_date', function ($data) {
                    $deliveryOrder = @$data->deliveryDetail->deliveryOrder;
                    return @$deliveryOrder->delivery_date ? date("Y-m-d",strtotime($deliveryOrder->delivery_date)) : '';
                })
                ->editColumn('total_price', function ($data) {
                    if ($data->total_product==null){
                        $val=0;
                    }else{
                        $val=$data->total_product;
                    }
                    return @Globals::currency_render($data->total_product_symbol,$val);
                })
                ->editColumn('status', function ($data) {
                    return Globals::status_render($data->status);
                })
                ->editColumn('delivery_fee', function ($data) {
                    return Globals::currency_render($data->delivery_fee_symbol,$data->delivery_fee);
                })
                ->editColumn('delivery_option', function ($data) {
                    return $data->delivery_option_text;
                })
                ->addColumn('action', function ($data) {
                        // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paid , 7 = return to shop
                        $edit = '';
                        $delete = '';
                        $pedding = '';
                        $cancel = '';
                        $edit = '';
                        $return_to_shop = '';
                        $print = '';
                        $all = '';
                        $return_to_proccess = '';
                        $deliveryDetail = $data->deliveryDetail;
                        if (Gate::check('Delete Order')) {
                            $delete = '<li><a data-href="' . route("export_stock_delete_box", [$data->id,'export_list']) . '" class=" fa fa-trash bt-delete">&nbsp; '. __('administrator.delete') .'</a></li>';
                        }
                        if (Gate::check('Pending Order List')) {
                            $pedding = '<li><a class="bt_pending" data-status="'.$data->status.'" data-export_id="'.$data->id.'">'.__('administrator.pending').'</a>';
                        }
                        if (Gate::check('Cancel Order List')) {
                            $cancel = '<li><a class="bt_cencel fa fa-ban" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'.__('administrator.cancel').'</a></li>';
                        }
                        if (Gate::check('Return To Shop Order List')) {
                            if($data->is_return_to_shop==0){
                                $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-type="request" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                            }
                            if($data->is_return_to_shop==1){
                                $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-reason="'.$deliveryDetail->reason.'" data-type="approve" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'. 'Approve Return To Shop'.'</a></li>';
                            }
                        }
                        if ($data->type_of_stock == 1) {
                            if (Gate::check('Edit Order List')) {
                                $edit = '<li><a href="' . route("export-stock-new.edit", $data->id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                            }
                        } else {
                            if (Gate::check('Edit Order List')) {
                                $edit = '<li><a href="' . route("out-stock-new.edit", $data->id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                            }
                        }
                        if (Gate::check('Print Order List')) {
                            $print = '<li><a data-href="' . route("export-stock.show", $data->id) . '" class="fa fa-print bt-print">&nbsp;'.__('administrator.print').'</a></li>';
                        }
                        $return_to_proccess = '
                            <li><a class="return_to_inpro fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
                        ';
                        if($data->status == 1 || $data->status == 2 || $data->status == 4 || $data->status == 3){
                        if ($data->status == 1) {
                                $all.= $delete.$print.$edit;
                        }

                        if($data->status == 2){
                            $all .= $print.$edit.$pedding.$cancel;
                        }
                        if($data->status != 4){

                        }
                    }
                    if($data->status == 4){
                        if(!@$deliveryDetail->status_paid){
                            if($deliveryDetail->status_paid != 'paid' &&  $deliveryDetail->invoice_payment_id == null ){
                                if($data->is_return_to_shop==1){
                                    $return_to_proccess = "";
                                }
                                $all .= $return_to_proccess.$return_to_shop;
                            }
                        }
                    }
                    if($data->status == 5){
                        if($data->is_return_to_shop==1){
                            $return_to_proccess = "";
                        }
                        $all .= $return_to_proccess.$return_to_shop;;
                    }
                    if($data->status == 3){
                        if(!@$deliveryDetail->invoice_payment_id){
                            $all .=$return_to_proccess;
                        }
                    }
                    if($data->status == 7){
                        $all .= $print.$edit.$delete.$return_to_proccess;
                    }
                    return '
                    <div class="dropdown">
                            <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                            <span class="caret"></span></button>
                            <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                            '.$all.'
                            </ul>
                        </div>
                    ';
                    })

                ->rawColumns(['status','driver_name','print_all','box_code','action'])
                ->addIndexColumn()
                ->toJson();
        }
        return \view('administrator.out-stock-new.index',compact( 'merchant_show'));
    }

    public function create(Request $request)
    {
        $exchang_rate = CurrencyModel::find(1);
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($request){
                if($request->get_zone == "province"){
                    $q->where('province','1');
                }else{
                    $q->whereNull("province");
                }
            })

            ->select('nso007_location.name_en AS name', 'id','location_id');
        $province_id = LocationModel::where('status', 1)
                            ->where('type','zone')
                            ->select('id')
                            ->where('province',1)
                            ->first();
        $province_id = optional($province_id)->id;
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }

        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
            ->whereIn('id',is_array($loc_id_array) ? $loc_id_array : ["no"])
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        if($request->get_zone){
            return response()->json([
                'zone'=>$from_location,
                'location'=>$location
            ]);
        }
        $merchant = User::where('user_type', 3)->where('status', 1)
            // ->where('type_of_merchant', 2)
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();
        $lang = \Globals::check_lang();
        $category = CategoryModel::where('status', 1)
            ->pluck('nso007_category.name_'.$lang.' AS category_name','id')->prepend(__('administrator.category'),'');
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();
        return view('administrator.out-stock-new.create',compact('merchant','from_location','location','category','bus','exchang_rate','province_id'));
    }

    public function CodeIncreament(){
        $last_id = ExportStockModel::max('id');
        $header_invoice = BranchModel::first();
        if ($last_id) {
            $box_code = ExportStockModel::select('box_code')->orderBy('box_code','DESC')->first();
            $tran_num = substr($box_code->box_code, 3);
            return $header_invoice->header_invoice_import . sprintf('%09d', ($tran_num + 1));
        } else {
            return $header_invoice->header_invoice_import . '000000001';
        }
    }
    public function store(Request $request)
    {
        $export_id = array();
        try {
            DB::beginTransaction();
            foreach ($request->delivery_option as $key1 => $value) {
                $category = CategoryModel::find($request->category_id[$key1]);
                if (empty($category)) {
                    $cat = new CategoryModel();
                    $cat->name_en = $request->category_id[$key1];
                    $cat->name_km = $request->category_id[$key1];
                    $cat->image = 'default.jpg';
                    $cat->save();
                    $category_name=$request->category_id[$key1];
                    $category_id_for_detail = $cat->id;
                    $shop = User::find($request->merchant_id[$key1]);
                    $category_id = $shop->category_id.','.$request->category_id[$key1];
                    $shop->category_id = $category_id;
                    $shop->update();
                } else {
                    $category_name = $category->name_km;
                    $category_id_for_detail = $category->id;
                }
                $discount = DiscountModel::where('date', date('Y-m-d'))->first();


                // foreach ($request->delivery_option as $key1 => $value) {
                $exportstock = new ExportStockModel();
                if ($discount) {
                    $arra_  =  explode(',', $discount->shop_id);
                    if (in_array($request->merchant_id, $arra_)) {
                        $exportstock->discount_id  = $discount->id;
                    }
                }
                $increas = $this->CodeIncreament();
                $exportstock->merchant_id                   = $request->merchant_id;
                $exportstock->box_code                      = $increas;
                $exportstock->export_date                   = date('Y-m-d');
                $exportstock->delivery_fee                  = $request->delivery_fee[$key1];
                $exportstock->delivery_fee_rate             = $request->delivery_fee_rate[$key1];
                $exportstock->delivery_fee_symbol           = $request->delivery_fee_symbol[$key1];
                $exportstock->from_location                 = isset($request->from_location[$key1]) ? $request->from_location[$key1] : '';
                $exportstock->location                      = $request->location[$key1];
                $exportstock->customer_receive              = $request->customer_receive[$key1];
                $exportstock->delivery_status               = $request->delivery_status[$key1];
                $exportstock->delivery_option               = $request->delivery_option[$key1];
                $exportstock->created_by                    = Auth::user()->id;
                $exportstock->description                   = $request->description[$key1];
                $exportstock->date_delivery                 =  date('Y-m-d');
                $exportstock->type_of_stock                 = 2; //Out stock
                $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key1];
                $exportstock->taxi_number                   = optional($request->taxi_number)[$key1];
                $exportstock->taxi_status                   = optional($request->taxi_status)[$key1];
                if (optional($request->taxi_status)[$key1] == 1) {
                    $exportstock->taxi_shop_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1] ;
                } else {
                    $exportstock->taxi_cust_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1];
                }
                $exportstock->taxi_fee_rate                = optional($request->taxi_fee_rate)[$key1];
                $exportstock->taxi_fee_symbol              = optional($request->taxi_fee_symbol)[$key1];
                $exportstock->taxi_pay_or_paid              = optional($request->taxi_pay_or_paid)[$key1];
                $exportstock->other_services_fee            = optional($request->other_service_fee)[$key1] == '' ? 0 : optional($request->other_service_fee)[$key1] ;
                $exportstock->other_services_type           = $request->other_service_type;
                $exportstock->other_services_pay_or_paid    = optional($request->other_service_pay_or_paid)[$key1];
                $exportstock->shop_name                     =  FindShop($request->merchant_id);
                $exportstock->location_name                 =  FindLoaction($request->location[$key1]);
                $exportstock->create_by_name                = \Auth::user()->name;
                $exportstock->update_status_by              = update_status_by("", '', '')      ; //  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
                $exportstock->total_product                 = $request->price[$key1];
                $exportstock->total_product_rate            = $request->total_product_rate[$key1];
                $exportstock->total_product_symbol          = $request->total_product_symbol[$key1];
                $exportstock->total_product_status          = $request->total_product_status[$key1];
                $exportstock->recievce_location             = optional($request->recievce_location)[$key1];
                $exportstock->time                          = $request->time[$key1];
                $exportstock->rate                          = $request->rate;
                if ($exportstock->save()) {
                    $check_dpl_code  = DB::table("nso007_export_stock")->where("box_code",$exportstock->box_code);
                    if($check_dpl_code->count() > 1){
                        $increas = $this->CodeIncreament();
                        DB::table("nso007_export_stock")->where("id",$exportstock->id)->update(['box_code'=>$increas]);
                    }
                    array_push($export_id, $exportstock->id);
                    $exportstockdetails = new ExportStockdetailsMode();
                    $exportstockdetails->export_id          = $exportstock->id;
                    $exportstockdetails->barcode            = $increas;
                    $exportstockdetails->currency           = $request->currency;
                    $exportstockdetails->export_qty         = 1;
                    $exportstockdetails->price              = $request->price[$key1];
                    $exportstockdetails->category_id        = $category_id_for_detail;
                    $exportstockdetails->category_name      =  $category_name;

                    // $exportstockdetails->category_name      =  FindCategory($request->category_id);
                    $exportstockdetails->save();
                    // }
                }
                $history = array(
                    "export_id"     =>  $exportstock->id,
                    "status"        =>  1,
                    "user_id"       =>  Auth::user()->id,
                    "created_at"       =>  now(),
                    "reason"        =>  "Create"
                );
                Globals::historyBox($history);
            }
            //check dpl box code
            $data = DB::table('nso007_export_stock')
                ->selectRaw('id,box_code,COUNT(box_code) as count')
                ->groupby('box_code')
                ->having('count', '>', 1);
            foreach ($data->cursor() as $key => $val) {
                $data1 = DB::table('nso007_export_stock')
                    ->where('box_code', $val->box_code)
                    ->orderBy('box_code');
                foreach($data1->cursor() as $key1=> $update){
                        if ($key1 > 0) {
                            DB::table('nso007_export_stock')->where('id', $update->id)->update(['box_code' => $this->CodeIncreament()]);
                        }
                }
            }
            Session::flash('success', 'Create Success');
            DB::commit();
            return response()->json([
                'export_id'=>$export_id,
                'print'=>$request->print
            ]);
            return redirect()->back()->with('success','Create Success');
        }catch(Exception $e){
            DB::rollback();
            throw new Exception($e->getMessage());
        }

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $exchang_rate = CurrencyModel::find(1);
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        $merchant = User::where('user_type', 3)->where('status', 1)
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();

        $lang = \Globals::check_lang();

        $category = CategoryModel::where('status', 1)
            ->pluck('nso007_category.name_'.$lang.' AS category_name','id')->prepend(__('administrator.category'),'');
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();
        $data   =   ExportStockdetailsMode::join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->join('users','users.id','nso007_export_stock.merchant_id')
            ->where('nso007_export_stock_details.export_id', $id)

            ->select(
                'nso007_category.*',
                'nso007_export_stock.*',
                'nso007_export_stock_details.*',
                'nso007_category.name_en As category_name',
                'users.phone as sender_contact'
            )->first();
        $shop = User::find($data->merchant_id);
        $category = CategoryModel::whereIn('id',explode(',',$shop->category_id))
            ->pluck('name_'.$lang.'','id');
        return view('administrator.out-stock-new.edit',compact('data','merchant','from_location','location','category','bus','exchang_rate'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if(!$request->delivery_fee){
            return redirect()->back()->with('danger','Please try again');
        }
        $this->validate($request, [
            'merchant_id'           => 'required',
            'category_id'           => 'required',
            'currency'              => 'required',
            'customer_receive'      => 'required',
            'location'              => 'required',
            'delivery_fee'          => 'required',
            // 'price'                 => 'required|numeric',
            'delivery_option'       => 'required',
        ]);
        $category = CategoryModel::find($request->category_id);
        if(empty($category)){
            $cat = new CategoryModel();
            $cat->name_en = $request->category_id;
            $cat->name_km = $request->category_id;
            $cat->image = 'default.jpg';
            $cat->save();
            $request['category_name']=$request->category_id;
            $request['category_id'] = $cat->id;
            $shop = User::find($request->merchant_id);
            $category_id = $shop->category_id.','.$request->category_id;
            $shop->category_id = $category_id;
            $shop->update();
        }else{
            $request['category_name'] = $category->name_km;
        }
        $exportstock = ExportStockModel::whereBox_code($id)
        ->select(
            'nso007_export_stock.*',
            DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            )
        ->first();

        // dd($id);
        update_status_by($id , '','edit_by');

        // { "create_by":"Super Admin","edit_by":"",  "status_proccess":"",  "status_last":""}


        $exportstock->merchant_id           = $request->merchant_id;
        $check_delivery_status              = $exportstock->delivery_status;
        $exportstock->delivery_fee          = $request->delivery_fee;
        $exportstock->delivery_fee_rate                  = $request->delivery_fee_rate;
        $exportstock->delivery_fee_symbol                  = $request->delivery_fee_symbol;
        $exportstock->from_location         = $request->from_location;
        $exportstock->location              = $request->location;
        $exportstock->customer_receive      = $request->customer_receive;
        $exportstock->delivery_status       = $request->delivery_status;
        $exportstock->delivery_option       = $request->delivery_option;
        $exportstock->modify_by            = \Auth::user()->id;
        $exportstock->description           = $request->description;
        $exportstock->type_of_stock           = 2; //Out stock
        $exportstock->delivery_pay_or_paid           = $request->pay_or_paid;
        $exportstock->taxi_number           = $request->taxi_number;
        $exportstock->taxi_status           = $request->taxi_status;
        if($request->taxi_status==1){
            $exportstock->taxi_shop_fee             =  $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }else{
            $exportstock->taxi_cust_fee             = $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }
        $exportstock->taxi_fee_rate              = $request->taxi_fee_rate;
        $exportstock->taxi_fee_symbol              = $request->taxi_fee_symbol;
        $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid;
        $exportstock->other_services_fee            =   $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
        $exportstock->other_services_type           = $request->other_services_type;
        $exportstock->other_services_pay_or_paid    = $request->other_services_pay_or_paid;
        // $exportstock->date_delivery                 = date('Y-m-d');
        $exportstock->shop_name                     =  FindShop($request->merchant_id);
        $exportstock->location_name                 =  FindLoaction($request->location);
        $exportstock->total_product                 = $request->price;
        $exportstock->total_product_rate            = $request->total_product_rate;
        $exportstock->total_product_symbol          = $request->total_product_symbol;
        $exportstock->total_product_status          = $request->total_product_status;
        $exportstock->recievce_location          = $request->recievce_location;
        $exportstock->rate                          = $request->rate;
        $exportstock->time                          = $request->time;
        if ($exportstock->update()) {
            $exportstockdetails = ExportStockdetailsMode::where('export_id', $exportstock->id)->first();
            $price = $exportstockdetails->price;
            $exportstockdetails->currency           = $request->currency;
            $exportstockdetails->export_qty         = 1;
            $exportstockdetails->price              = $request->price;
            $exportstockdetails->category_id        = $request->category_id;
            $exportstockdetails->category_name      =  $request->category_name;
            // $exportstockdetails->category_name      =  FindCategory($request->category_id);

            if ($request->price != $price || $check_delivery_status != $request->delivery_status) {
                DeliveryOrderDetailModel::where('status',1)->where('export_id',$exportstock->id)->update(['total_riel'=>0,'total_dollar'=>0]);
                DeliveryOrderDetailProccessingModel::where('status',1)->where('export_id',$exportstock->id)->update(['total_riel'=>0,'total_dollar'=>0]);
            }
            $exportstockdetails->update();
        }
        return redirect()->route('out-stock-new.index')->with('sussess', 'Import was add already successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function find_merchant($id=null){
        if(empty($id)){
            return [
                'user'=>'',
                'category'=>''
            ];
        }
        $user = User::find($id);
        $lang = \Fun::lang();
        $category = CategoryModel::whereIn('id',explode(',',$user->category_id))
            ->pluck('name_'.$lang.'','id');
        return response()->json([
            'user'=>$user,
            'category'=>$category
        ]);
    }
    function add_box(Request $request){
        $shop_id = $request->shop_id;
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($request){
                if($request->get_zone == "province"){
                    $q->where('province','1');
                }else{
                    $q->whereNull('province');
                }
            })

            ->select('nso007_location.name_en AS name', 'id','location_id');
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }
        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
            ->whereIn('id',$loc_id_array)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
            $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();
            $category = [];
            if(!empty($shop_id)){
                $user = User::find($shop_id);
                $lang = \Fun::lang();
                $category = CategoryModel::whereIn('id',explode(',',$user->category_id))
                    ->pluck('name_'.$lang.'','id');
            }
        $box_col = $request->box_col;
        $none = $request->none;

        return view('administrator.out-stock-new.add-box',compact('category','from_location','location','bus','box_col','none'))->render();

    }


}
