<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use App\CategoryModel;
use Image;
use Illuminate\Support\Facades\Crypt;
use DB;
use Gate;
use Hash;
use App\LocationModel;
use App\Fun\Fun as FunFun;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\DataTables;

class MerchantController extends Controller
{
    function __construct()
    {
        FunFun::lang();
        $this->middleware('permission:List Shop', ['only' => ['index']]);
        $this->middleware('permission:Create Shop', ['only' => ['create', 'store']]);
        $this->middleware('permission:Edit Shop', ['only' => ['edit', 'update']]);
    }

    public function index(Request $request)
    {
        // selectRaw('id,name,user_type,phone,gender,status,email,avartar')
        $type_of_merchant = $request->type_of_merchant;

        if ($request->ajax()) {
            $search = $request->input('search.value');
            $users = User::where('users.user_type', 3)
                ->where('users.status','!=',0)
                ->when($type_of_merchant,function($q) use($type_of_merchant){
                    $q->where('type_of_merchant',$type_of_merchant);
                })
                ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
                    $q->where('staff_id',Auth::user()->id);
                });
            return Datatables::of($users)
                ->addColumn('image', function ($users) {
                    $path = "images/upload/" . $users->avartar;
                    $full_path = File::exists($path) ?  $path : 'images/default.jpg';
                    return '<img src="/' . $full_path . '" alt="" width="35px" height="35px">';
                })
                ->editColumn('staff_id', function ($data) {
                    if($data->staff_id!=null){
                        $staff = \DB::table('users')->where('id',$data->staff_id)->first();
                        return  optional($staff)->name ;
                    }else{
                        return '';
                    }
                })
                ->addColumn('role', function ($users) {
                    return $users->roles->first() ? ucfirst($users->roles->first()->name) : '';
                })
                ->editColumn('sharelinks', function ($data) {
                    return '<input type="text" class="btn btn-default" id="id_'.$data->id.'" value="'.url('') .'/share-links/'.$data->share_links.'" onclick="myFunction('.$data->id.'   )" style="width: 89%;"> ';
                })
                ->editColumn('location', function ($data) {
                    return '<input type="text" class="btn btn-default" id="loc_'.$data->id.'" value="'.$data->location.'" onclick="myFunctionLoc('.$data->id.'   )" style="width: 89%;"> ';
                })
                ->addColumn('action', function ($users) {
                    $status = $users->status == 0 ? "off" : "";
                                $edit ='';

                                if (\Gate::check('Edit Shop')) {
                                    $edit = '<a  class="button_sm  button_primary ">' . __('administrator.edit') . '</a>';
                                    $edit = '&nbsp;<a href="' . route("merchant.edit", $users->id) . '" data-comf-type="orange" data-route="' . route('users.edit', $users->id) . '"  id="edit" class="btn btn-sm btn-warning fa fa-edit ml-3" data-btn-padding="p-5" data-btn-text="' . __('administrator.update') . '" data-title="Edit User" style="cursor:pointer;margin-top:0px;padding:4px 7px"></a>';
                                }
                                $check = $users->status == 1 ? 'checked' : 'a';
                                $dis_or_en = '<input data-route="'.route('users.destroy',$users->id).'" ' . $check . ' class="toggle dis_and_en" type="checkbox" data-toggle="toggle" data-on="Enabled" data-off="Disabled" value="'.$users->status.'">';
                                $delete = \Gate::check('Delete Shop') ? '&nbsp;<a href="javascript:;" data-comf-type="danger" data-route="' . route('merchant.destroy', $users->id) . '"  id="delete_user" class="btn btn-sm bt-delete btn-danger fa fa-trash ml-3" data-btn-padding="p-5" data-btn-text="' . __('administrator.delete') . '" data-title="Delete" style="cursor:pointer;margin-top:0px;padding:4px 7px"></a>' : "";

                                return '
                                    <a href="#" class="viewPopLink  btn btn-sm  button_success" data-id="' .$users->id . '" data-toggle="modal tooltip" data-target="#myModal" >' . __('administrator.show') . '</a>
                                    '. $edit.'&nbsp;'.$dis_or_en . $delete;

                })
                ->addIndexColumn()
                ->rawColumns(['image', 'action','sharelinks','location'])
                ->make(true);
        }
        return view('administrator.merchant.index');
    }

    public function datable_merchant(Request $request)
    {

        $data = User::where('user_type', 3)
            ->where('type_of_merchant', 'LIKE', isset($request->type_of_merchant) ? $request->type_of_merchant : NULL)
            ->get();
        echo json_encode($data);
    }

    public function create()
    {
        $lang = \Fun::lang();
        $users = \DB::table('users')->where('user_type',1)
                    ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
                        $q->where('id',Auth::user()->id);
                    })
                    ->pluck('name','id');
        $category = \DB::table('nso007_category')->where('status',1)->pluck('name_'.$lang.'','id');
        return view('administrator.merchant.create',compact('users','category'));
    }


    public function store(Request $request)
    {
        // try {
        //     DB::beginTransaction();
        $this->validate($request, [
            // 'type_of_merchant' => 'required',
            'phone' => 'required',
//            'name'  => 'required'
        ]);
        $gallery = '';

        if ($files = $request->file('image')) {

            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload';
            $files->move($destinationPath, $original_name);
            $gallery = $original_name;
        } else {
            $gallery = 'default.jpg';
        }
        $prefix_pdf = User::where('user_type',3)->orderBy('prefix_pdf','DESC')->first();
        if($prefix_pdf){
            $prefix_pdf = $prefix_pdf->prefix_pdf + 1;
        }else{
            $prefix_pdf = 1;
        }
        $shop = new User;


        $seed = str_split('abcdefghijklmnopqrstuvwxyz'
        .'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
        .'0123456789'); // and any other characters

        shuffle($seed); // probably optional since array_is randomized; this may be redundant
        $rand = '';
        foreach (array_rand($seed, 15) as $k) $rand .= $seed[$k];

        $shop->share_links          =  $rand ;
        $shop->user_type          =   3;
        $shop->prefix_pdf         =   $prefix_pdf;
        $shop->staff_id            =    $request->staff_id;
//        $shop->name               =   $request->name;
//        $shop->bank_name_kh               =   $request->bank_name_kh;
        $shop->type_of_merchant   =   empty($request->type_of_merchant) ? 2 : 1;
        $shop->shop_name          =   $request->shop_name;
//        $shop->bank_account       =   $request->bank_account;
//        $shop->bank_account_kh       =   $request->bank_account_kh;
        $shop->phone              =   $request->phone;
        $shop->user_currency              =   $request->user_currency;
        $shop->facebook_page      =   $request->facebook_page;
        $shop->note               =   $request->note;
        $shop->is_role            =   empty($request->type_of_merchant) ? 'MerchantOut' : 'MerchantIn';
        $shop->address            =   $request->address;
        $shop->avartar              =   $gallery;
        $shop->menu_layout          = 'top';
        $shop->hover_text           = '1e272e';
        $shop->hover_bg             = 'ecf0f1';
        $shop->secondary_background = '34495e';
        $shop->primary_background   = '1e272e';
        $shop->secondary_text       = '34495e';
        $shop->primary_text         = 'f39c12';
        $shop->animation_duration   = '0.2';
        $shop->animation            = 'zoomInUp';
        $shop->email              =   $request->email;
        $shop->category_id          = $request->category_id ? implode(',',$request->category_id) : null;
        $shop->join_date            = date('Y-m-d',strtotime($request->join_date));
        $shop->location             = $request->location;
        $shop->save();


        // }

        // catch (\Exception $e) {
        //     DB::rollback();
        //     return redirect()->back()->with('danger',$e->getMessage()) ;
        // }
        return redirect()->route('merchant.index')->with('success', 'Merchant create successfully');
    }


    public function show($id)
    {
    }

    public function edit($id)
    {
        $lang = \Fun::lang();
        $data = User::whereId($id)->first();
        $users = \DB::table('users')->where('user_type',1)->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
            $q->where('id',Auth::user()->id);
        })->select('name','id')->get();
        $category = \DB::table('nso007_category')->where('status',1)->pluck('name_'.$lang.'','id');
        $array_cat = explode(',',$data->category_id);
        return view('administrator.merchant.edit', compact('data','users','category','array_cat'));
    }


    public function update(Request $request, $id)
    {
        // try {
        // DB::beginTransaction();
        $this->validate($request, [
            // 'type_of_merchant' => 'required',
            'phone' => 'required',
        ]);
        $gallery​ = '';
        if ($files = $request->file('avartar')) {
            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload';
            $files->move($destinationPath, $original_name);
            $gallery = $original_name;
        } else {
            $gallery = $request->arrayImg;
        }
        $shop = User::find($id);
        $shop->user_type          =   3;
        $shop->staff_id            =    $request->staff_id;
//        $shop->name               =   $request->name;
//        $shop->bank_name_kh               =   $request->bank_name_kh;
        $shop->type_of_merchant   =   empty($request->type_of_merchant) ? 2 : 1;
        $shop->shop_name          =   $request->shop_name;
//        $shop->bank_account       =   $request->bank_account;
//        $shop->bank_account_kh       =   $request->bank_account_kh;
        $shop->phone              =   $request->phone;
        $shop->user_currency              =   $request->user_currency;
        $shop->facebook_page      =   $request->facebook_page;
        $shop->note               =   $request->note;
        $shop->address            =   $request->address;
        $shop->avartar            =   $gallery;
        // $shop->is_role            =   ($request->type_of_merchant == 1) ? 'MerchantIn' : 'MerchantOut';
        $shop->is_role            =   empty($request->type_of_merchant) ? 'MerchantOut' : 'MerchantIn';
        $shop->email              =   $request->email;
        if ($request['password']) {
            $shop->password           =   Hash::make($request['password']);
        }
        $shop->category_id          = $request->category_id ? implode(',',$request->category_id) : null;
        $shop->join_date            = date('Y-m-d',strtotime($request->join_date));
        $shop->location             = $request->location;
        $shop->save();
        // }

        // catch (\Exception $e) {
        //     DB::rollback();
        //     return redirect()->back()->with('danger',$e->getMessage()) ;
        // }
        return redirect()->route('merchant.index')->with('success', 'Driver updated successfully');
    }
    public function merchant_status(Request $request)
    {
        $user = User::find($request->user_id);
        $user->status = $request->status;
        $user->save();
        return response()->json(['success' => 'Status change successfully.']);
    }

    public function destroy($id,Request $request)
    {
        if($id){
            User::whereId($id)->update(['status'=>0]);
            return response()->json([
                'success'=>true
            ]);
        }
    }

    public function merchant_info(Request $request)
    {

        $id = $request->showid;
        $driver_info = DB::table('users')
            ->where('users.id', $id)
            ->first();

        echo json_encode($driver_info);
    }
}
