<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use Gate;
use Yajra\DataTables\DataTables;

class LocationController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:List Location', ['only' => ['index']]);
        $this->middleware('permission:Create Location', ['only' => ['create','store']]);
        $this->middleware('permission:Edit Location', ['only' => ['edit','update','location_delete']]);
    }

    public function index(Request $request)
    {
        
        
        if($request->ajax()){
            $search = $request->input('search.value');
            $lang = \Globals::check_lang() ? \Globals::check_lang() : 'en';
            $location = LocationModel::where([['status',1],['type','zone']])
                ->when($search,function($q) use($search,$lang){
                    $q->where('name_'.$lang.'','LIKE','%'.$search.'%');
                })
                ->select('id','name_'.$lang.' as location','description','location_id');
            return  Datatables::of($location)
            ->addColumn('action', function($location) {

            $location_edit  = '';
            if (Gate::check('Edit Location')) {
                // <a href="#" class="button_warning add_location" data-id="'.$location->id.'"><span class="fa fa-plus"></span> '.__('administrator.location').'</a>
                $location_edit  = ' 
                <a href="'. route("location.edit", $location->id) . '" class="button_info">'.__('administrator.edit').'</a>
                <a href="#" class="button_danger button_delete" data-id="'.$location->id.'">'.__('administrator.delete').'</a>
                ';
            }

            return $location_edit. '
                <a href="'. route("location.show", $location->id) . '" class="button_primary">'.__('administrator.show').'</a>';
            })
            ->addColumn('location_count',function($location){
                
                return $location->location_id ? count(explode(',',$location->location_id)) : 0;
            })
            ->editColumn('id', 'R00{{$id}}')
            ->addIndexColumn()
            ->make(true);
        }
       
        return view('administrator.location.index');
    }


    public function create()
    {
        $lang = \Globals::check_lang();
        $array = array();
        $zone = LocationModel::where('type','zone')->pluck('location_id');
        foreach($zone as $key=>$val){
            foreach(explode(',',$val) as $ex){
                array_push($array,$ex);
            }
        }
        $location = LocationModel::where('type','location')->whereNotIn('id',$array)->pluck('name_'.$lang.'','id');
        return view('administrator.location.create',compact('location'));
    }


    public function store(Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            'name_km'     => 'required|max:255|unique:nso007_location,name_km',
            'name_en'  => 'required|max:255|unique:nso007_location,name_en',
        ]);

        $location = new LocationModel;
        $location->name_km   = $request->name_km;
        $location->name_en   = $request->name_en;
        $location->description   = $request->description;
        $location->type   = 'zone';
        $location->location_id = $request->location_id ? implode(',',$request->location_id) : '';
        $location->save();
        return redirect()->route('location.index')->with(['success' => 'Locaion Create Successfull !!']);
    }


    public function show($id)
    {
        $id = $id ;
        session()->put('location_id',$id);
        
        return view('administrator.location.show',compact('id'));

    }

    public function getLocation()
    {
        $id = session()->get('location_id');
        $location_id = LocationModel::find($id)->location_id;
        $query = LocationModel::where('status',1)->whereIn('id',explode(',',$location_id));

        if(\Globals::check_lang() == 'en'){
            $location = $query->select('id','name_en as location','price','name_en','name_km','currency_symbol','status')->get();

        }else{
            $location = $query->select('id','name_km as location','price','name_en','name_km','currency_symbol','status')->get();
        }
        return  Datatables::of($location)

        ->addColumn('action', function($location) {
        $location_edit  = '';
        if (Gate::check('Location Edit')) {
            $location_edit  = '

            <a class="button_info delete_location "   data-id="'.$location->id.'" >'. __('administrator.delete').'</a>
            <a href="#" class="button_warning edit_location" data-id="'.$location->id.'" data-name_en="'.$location->name_en.'" data-name_km="'.$location->name_km.'" data-price="'.$location->price.'" data-currency="'.$location->currency_symbol.'" ><span class="fa fa-edit"></span> '.__('administrator.edit').'</a>

            ';
        }

        return  $location_edit ;
        })
    //   <a href="'. route("location.show", $location->id) . '" class="button_info">'.__('administrator.edit').'</a>
        ->addColumn('price',function($location){
            if($location->currency_symbol == "៛"){
                return number_format($location->price).'៛';
            }
            return '$'.number_format($location->price,2);
        })
        ->addIndexColumn()
        ->make(true);
    }
    // <a href="'. route("location.edit", $location->id) . '" class="button_warning">'.__('administrator.delete').'</a>

    public function edit($id)
    {
        $array = array();
        $list_loc = array();
        $zone = LocationModel::where('type','zone')->pluck('location_id');
        foreach($zone as $key=>$val){
            foreach(explode(',',$val) as $ex){
                if (!empty($ex)) {
                    array_push($array, $ex);
                }
            }
        }
        $not_use_location = LocationModel::where('type','location')->whereNotIn('id',$array)->pluck('id');
        $location = LocationModel::find($id);
        $list_loc = $location->location_id ? explode(',',$location->location_id) : [];
        foreach($not_use_location as $key=>$not){
            if($not){
                array_push($list_loc,$not);
            }
        }
        $lang = \Globals::check_lang();
        $location_select = LocationModel::where('type','location')
            ->whereIn('id',$list_loc)
            ->pluck('name_'.$lang.'','id');
        $find_loc = explode(',',$location->location_id);
        return view('administrator.location.edit',compact('location','location_select','find_loc'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name_km'     => 'required|max:255|unique:nso007_location,name_km,'.$id,
            'name_en'  => 'required|max:255|unique:nso007_location,name_en,'.$id,
        ]);
        // dd($request->location_id);
        $location = LocationModel::find($id);
        $location->name_km   = $request->name_km;
        $location->name_en   = $request->name_en;
        $location->description   = $request->description;
        $location->location_id = $request->location_id ? implode(',',$request->location_id) : '';
        $location->update();
        return redirect()->route('location.index')->with(['success' => 'Locaion Update Successfull !!']);
    }

    public function locationSave(Request $request)
    {
            $this->validate($request, [
                'name_km'     => 'required',
                'name_en'  => 'required',
                'pearent_id'  => 'required',
            ]);
            $parent_location = LocationModel::find($request->pearent_id);
            $location = new LocationModel;
            // $location->pearent_id   = $request->pearent_id;
            $location->name_km   = $request->name_km;
            $location->name_en   = $request->name_en;
            $location->price   = $request->price;
            $location->currency_symbol   = $request->currency_symbol;
            $location->type = "location";
            $location->save();
            $parent_location->location_id = $parent_location->location_id.','.$location->id;
            $parent_location->update();
            return redirect()->back()->with(['success' => 'Locaion Update Successfull !!']);


    }
    public function locationSaveNew(Request $request)
    {
            $this->validate($request, [
                'name_km'     => 'required',
                'name_en'  => 'required',
                'pearent_id'  => 'required',
            ]);

            $location = new LocationModel;
            $location->pearent_id   = $request->pearent_id;
            $location->name_km   = $request->name_km;
            $location->name_en   = $request->name_en;
            $location->price   = $request->price;
            $location->currency_symbol   = $request->currency_symbol;
            $location->type = "location";
            $location->save();
            return redirect()->back()->with(['success' => 'Locaion Update Successfull !!']);


    }
    public function getLocation_edit(Request $request)
    {
        $this->validate($request, [
            'name_en'     => 'required',
            'name_km'  => 'required',
        ]);
        $location = LocationModel::find($request->id);
        $location->name_en  =   $request->name_en;
        $location->name_km  =   $request->name_km;
        $location->price    =   $request->price;
        $location->currency_symbol   = $request->currency_symbol;
        $location->update();
        return redirect()->back()->with(['success' => 'Locaion Update Successfull !!']);
    }
    public function getLocation_new_edit(Request $request){
        $this->validate($request, [
            'name_en'     => 'required',
            'name_km'  => 'required',
            'pearent_id'=>'required'
        ]);
        $location = LocationModel::find($request->id);
        $location->name_en  =   $request->name_en;
        $location->pearent_id  =   $request->pearent_id;
        $location->name_km  =   $request->name_km;
        $location->price    =   $request->price;
        $location->currency_symbol   = $request->currency_symbol;
        $location->update();
        return redirect()->back()->with(['success' => 'Locaion Update Successfull !!']);
    }
    
    public function location_delete(Request $request){

        $location = LocationModel::find($request->id); 
        $location->status  =   2;
        $location->update();
         

        $data="success";
        echo json_encode($data);
    }
   


}
