<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\CategoryModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\ExportStockModel;
use App\InvoicePaymentModel;
use App\User;
use Auth;
use Carbon\Carbon;
use DB;
class DriverTaskController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if($request->ajax()){

            $from_date      = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
            $to_date        = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
            $drivers        = isset($request->drivers) ? $request->drivers : null;
            $status         = isset($request->status) ? $request->status : null;
            $clear         = isset($request->clear) ? $request->clear : null;
            $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
            // $data   =   $this->data_history_driver($from_date, $to_date, $status, $drivers, $driver_voucher);
            $data = DB::table('nso007_delivery_order_detail')
            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
            ->select(
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_delivery_order_detail.clear_box_by',
                'nso007_delivery_order_detail.clear_box_code',
                'nso007_delivery_order_detail.delivery_order_id',
                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.*',
                'nso007_export_stock.total_product AS total_price',
                'nso007_delivery_order_detail.status AS status_detail',
                'nso007_delivery_order_detail.status_paid',
                'nso007_delivery_order_detail.reason AS detail_reason',
                'nso007_delivery_order.driver_name',
                'nso007_delivery_order.inovice As driver_voucher',
            )
                ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                    if (!empty($from_date) && !empty($to_date)) {
                        $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
                    } 
                })
    
    
    
                ->when(request('status'), function ($query) use ($status) {
                    if (!empty($status)) {
                        $status_1 = '';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key] . ',';
                        }
                        $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                    }
                })
    
                ->when(request('clear'), function ($query) use ($clear) {
                    if (!empty($clear)) {
                        if($clear == 'not_clear'){
                            $query->whereNull('nso007_delivery_order_detail.clear_box_code');
    
                        }else{
                            $query->whereNotNull('nso007_delivery_order_detail.clear_box_code');
                        }
                    }
                })
                ->where(function ($query) use ($drivers) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('merchant_id', \Auth::user()->id);
                    } else if (\Globals::is_Driver() == 'Driver') {
                        $query->where('driver_id', \Auth::user()->id);
                    } else {
                        $query->where('driver_id', 'LIKE', $drivers);
                    }
                })
            ->where('driver_id', 'LIKE', $drivers)
            ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
            ->groupBy('nso007_delivery_order.driver_id')
            ->orderBy('nso007_export_stock.box_code','desc');
    
    
                return DataTables::of($data)
                    ->editColumn('total', function ($data) {
                        $taxi_fee =0;
                        $total = 0;
                        $delivery_fee  = 0;
                        $delivery_fee_shop = 0;
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ((100 - $data->discount) * $data->delivery_fee ) / 100;
                            }
                            else {
                                $delivery_fee =  number_format( $data->delivery_fee,2);
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee;
                        }
    
                        if($data->delivery_status == 2){
                            $delivery_fee_shop  =  $delivery_fee ;
                        }
    
    
                        if($data->extra_fee_type == 1) {
                            $extra_fee_shop = $data->extra_fee ;
                            $extra_fee_cus  = 0 ;
                             }
                        else if($data->extra_fee_type == 2)   {
    
                            $extra_fee_shop = 0;
                            $extra_fee_cus  = $data->extra_fee ;
    
                              }
                        else  {
                            $extra_fee_shop = 0;
                            $extra_fee_cus = 0;
                            }
    
                        if($data->taxi_status == 1){
                            $taxi_fee =   $data->taxi_shop_fee  ;
                        } else{
                            $taxi_fee =  0  ;
                        }
    
    
                        if($data->delivery_status == 1){  //shop
                            $total =  $data->total_price ;
                        }else{   //customer
                            $total = $data->total_price  ;
                        }
    
    
                        return  '$'. number_format( $total +  $delivery_fee_shop + $extra_fee_cus,2);
                    })
                    ->editColumn('price', function ($data) {
                        return '$' . number_format($data->total_price, 2);
                    })
                    ->editColumn('reason', function ($data) {
                        return $data->detail_reason == null ? "N/A" :  $data->detail_reason;
                    })
                    ->editColumn('delivery_date', function ($data) {
                        return date('d-m-Y', strtotime($data->delivery_date));
                    })
    
                    ->editColumn('taxi_fee', function ($data) {
                        if ($data->taxi_status == 1) {
                            $taxi_fee = '$' . number_format($data->taxi_shop_fee, 2);
                        } else {
                            $taxi_fee = '$' . number_format($data->taxi_cust_fee, 2);
                        }
                        return $taxi_fee;
                    })
                    ->editColumn('delivery_fee', function ($data) {
                        $delivery_fee  = 0;
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                            }
                            else {
                                $delivery_fee =  number_format( $data->delivery_fee,2);
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee;
                        }
    
    
    
                        if ($data->delivery_status == 1) {
                            $delivery_fee = '$' . number_format($delivery_fee, 2);
                        } else {
                            $delivery_fee = '$' . number_format($delivery_fee, 2);
                        }
                        return $delivery_fee;
                    })
    
                    ->editColumn('extra_fee', function ($data)  {
                        if($data->extra_fee_type == 1) {
                            return  '$'.number_format( $data->extra_fee,2)  . ' s'; }
                        else if($data->extra_fee_type == 2)   {
                            return  '$'.number_format( $data->extra_fee,2) . ' c';    }
                        else  {
                            return '$0';  } 
                    })
    
                    ->editColumn('status', function ($data) {
                        if ($data->status_detail == 1)  // 1 = Processing,
                            return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '</strong>';
                        else if ($data->status_detail == 2)  // 2 = Padding,
                            return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . ' </strong>';
                        else if ($data->status_detail == 3)  //  3 = Done ,
                            return ' <strong class="text-info"><span class="fa fa-check"></span>  ' . __('administrator.done') . ' </strong>';
                        else if ($data->status_detail == 4)  // 4 = Cancel
                            return ' <strong class="text-danger"><span class="fa fa-ban"></span>  ' . __('administrator.cancel') . '</strong>';
                        else {
                            return ' <strong class="text-muted"><span class="fa fa-check"></span>  ' . __('administrator.paid') . '</strong>';
                        }
                    })
                    ->addColumn('clear_box_code',function($data){
                        if( request()->drivers && $data->clear_box_code != 1 ){
                            return '<div><input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                        }
                        
                        if($data->clear_box_code){
                            return '<span class="btn-info btn-xs">  Clear</span>';
                        }
                    })
    
                    ->addColumn('clear_by',function($data){
                        if($data->clear_box_by){
                            return explode(',',$data->clear_box_by)[1];
                        }else{
                            return "N/A";
                        }
                    })  
                    ->rawColumns(['status' => 'status','clear_box_code'=>'clear_box_code','clear_by'=>'clear_by'])
                    ->addIndexColumn()
                    ->make(true);



        }
        return view('administrator.driver_tasks.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
