<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\DriverClearDetailModel;
use App\DriverClearModel;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
use Exception;
use Gate;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Yajra\DataTables\Facades\DataTables;

class DeliveryNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $driver = explode('||',$request->driver_id);
        $driver_id = $driver[0];
        $time_policy = @$driver[1];
        $data = DB::table(DB::raw('(select id,delivery_date,driver_id,time_policy,created_at as ordering from nso007_delivery_order) as do'))
            ->join(
                DB::raw('(select
            delivery_order_id,export_id,status,invoice_payment_id,status_paid,clear_box_code
            from nso007_delivery_order_detail
            where coalesce(clear_box_code,status_paid,invoice_payment_id) IS NULL AND status != "7") as dod'),
                'dod.delivery_order_id',
                'do.id'
            )
            ->join(DB::raw('(select *,id as export_id from nso007_export_stock) as exs'), 'exs.export_id', 'dod.export_id')
            ->leftjoin(DB::raw('(select id as discount_id,discount,discount_type from nso007_discount) as disc'), 'disc.discount_id', 'exs.discount_id')
            ->join(DB::raw('(select id as driver_id,name from users) as driver'), 'driver.driver_id', 'do.driver_id')
            ->select(
                'do.delivery_date',
                'do.driver_id',
                'do.time_policy',
                'driver.name',
                'disc.discount',
                'disc.discount_type',
                'exs.*',
                \DB::raw("COUNT(( CASE WHEN dod.status = 1 THEN dod.status END )) AS processing"),
                \DB::raw("COUNT(( CASE WHEN dod.status = 2 THEN dod.status END )) AS pending"),
                \DB::raw("COUNT(( CASE WHEN dod.status = 3 THEN dod.status END )) AS success"),
                \DB::raw("COUNT(( CASE WHEN dod.status = 4 THEN dod.status END )) AS cancel"),
                \DB::raw("COUNT(( CASE WHEN dod.status = 7 THEN dod.status END )) AS return_to_shop"),
            )
            ->when($driver_id,function($q) use($driver_id){
                $q->where('do.driver_id',$driver_id);
            })
            ->when($driver_id,function($q) use($time_policy){
                $q->where('do.time_policy',$time_policy);
            })
            ->groupBy('delivery_date', 'driver_id', 'time_policy')
            ->orderBy('ordering', 'DESC');
        if ($request->ajax()) {
            return  DataTables::of($data)
                ->editColumn('delivery_date', function ($data) {
                    return date('d-m-Y', strtotime($data->delivery_date));
                })
                ->editColumn('clear_all', function ($data ) {
                    return '<input type="checkbox" class="sub" name="scales" data-date="'.$data->delivery_date.'" data-driver_id="'.$data->driver_id.'" data-time_policy=' . $data->time_policy . '>';
                })
                ->editColumn('name', function ($data) {
                    $time = '';
                    if ($data->time_policy == 1) {
                        $time = "ព្រឹក";
                    }
                    if ($data->time_policy == 2) {
                        $time = "ល្ងាច";
                    }
                    return $data->name ;
                })
                ->editColumn('total', function ($data) {
                    return '<button type="button" class="btn btn-primary">' . $data->processing . '</button>
                <button type="button" class="btn btn-success">' . $data->success . '</button>
                <button type="button" class="btn btn-warning"  style="margin-top:0px !important;">' . $data->pending . '</button>
                <button type="button" class="btn btn-danger">' . $data->cancel . '</button>
                ​';
                // <button type="button" class="btn btn-info">' . $data->return_to_shop . '</button>
                    return $data->success;
                })
                ->addColumn('action', function ($data) {
                    $show = '';
                    $print = '';
                    $clear = '';
                    $print_driver = '';
                    if(Gate::check('Show Voucher')){
                    $show = '
                        <a href="' . route("delivery-order-new.show", $data->driver_id . '?delivery_date=' . $data->delivery_date . '&&time_policy=' . $data->time_policy) . '" class="btn_sm button_danger">' . __('administrator.show') . '</a>
                        ';
                    }
                    if(Gate::check('Print Voucher')){
                    $print = '
                <a href="' . route("delivery-order-print-voucher", $data->driver_id . '?delivery_date=' . $data->delivery_date . '&&time_policy=' . $data->time_policy . '') . '" class="btn_sm button_primary">' . __('administrator.print') . '</a>
                ';
                    }
                    if(Gate::check('Clear Voucher')){
                    $clear = '
                <a href="javascript:;" data-route="' . route("clear-by-driver", $data->driver_id . '?delivery_date=' . $data->delivery_date . '&&time_policy=' . $data->time_policy . '&&type=print') . '" class="btn_sm button_primary bt_clear_driver">' . 'Clear' . '</a>
                ';
                    }
                    if(Gate::check('Print Voucher To Driver')){
                    $print_driver = '
                <a href="' . route("delivery-order-print-voucher-to-driver", $data->driver_id . '?delivery_date=' . $data->delivery_date . '&&time_policy=' . $data->time_policy . '') . '" class="btn_sm button_info"><i class="fa fa-print"></i></a>
                ';
                    }
                    return $show . $print . $clear . $print_driver;
                })
                ->addIndexColumn()
                ->rawColumns(['total', 'action','clear_all'])
                ->make(true);
        }
        return view('administrator.delivery-order-new.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {

        if ($request->ajax()) {
            $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
            $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
            $merchant       =   $id;
            $status         =   isset($request->status) ? $request->status : null;

            $data = DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
                ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
                ->select(
                    'nso007_discount.discount',
                    'nso007_discount.discount_type',
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order_detail.clear_box_by',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.amount_pay_to',
                    'nso007_delivery_order_detail.pay_to',
                    'nso007_delivery_order_detail.invoice_payment_id',
                    'nso007_delivery_order_detail.export_id',
                    'nso007_export_stock_details.currency',
                    'nso007_delivery_order.driver_name',
                    \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
                )
                // ->whereDate('nso007_delivery_order.delivery_date','=',$request->date)
                ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                    if ($from_date) {
                        $query->whereDate('nso007_delivery_order.delivery_date', '>=', $from_date);
                    }
                    if ($to_date) {
                        $query->whereDate('nso007_delivery_order.delivery_date', '<=', $to_date);
                    }
                })

                ->when(request('status'), function ($query) use ($status) {
                    if (!empty($status)) {
                        $status_1 = '';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key] . ',';
                        }
                        $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                    }
                })
                ->where('nso007_delivery_order_detail.status', '!=', 7)
                ->whereNull(['nso007_delivery_order_detail.invoice_payment_id', 'nso007_delivery_order_detail.clear_box_code', 'nso007_delivery_order_detail.status_paid'])
                ->where('nso007_delivery_order.driver_id', $id)
                ->where('nso007_delivery_order.time_policy', $request->time_policy)
                ->where('nso007_delivery_order.delivery_date', $request->delivery_date)
                ->orderBy('nso007_export_stock.box_code', 'desc')
                ->groupBy('nso007_export_stock.box_code');
            return Datatables::of($data)
                ->editColumn('pay_to_delivery', function ($data) {
                    if ($data->pay_to == 'delivery') {
                        return    '$' . numberFormat((float)$data->amount_pay_to);
                    } else {
                        return    '';
                    }
                })

                ->editColumn('pay_to_shop', function ($data) {
                    if ($data->pay_to == 'shop') {
                        return   '$' . numberFormat((float)$data->amount_pay_to);
                    } else {
                        return    '';
                    }
                })


                ->addColumn('clear_box_code', function ($data) {
                    if ($data->clear_box_code) {
                        return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                    }
                })

                ->addColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->export_date)) . ' / ' . date('d-m-Y', strtotime($data->delivery_date));
                })

                ->editColumn('check', function ($data) {
                    return '<input type="checkbox" name="check" class="checkbox payment_" data-box_code="' . $data->box_code . '"  data-export_id="' . $data->id . '" >';
                })

                ->editColumn('total_dollar', function ($data) {
                    $cash = $data->total_dollar ? '$ '.number_format((float)$data->total_dollar,2).'<br>' : "";
                    $aba_shop = $data->pay_to == "shop" ? '$ '.number_format((float)$data->amount_pay_to,2).' ABA<br>' : "";
                    $ac_shop = $data->pay_to == "ac_shop" ? '$ '.number_format((float)$data->amount_pay_to,2).' AC<br>' : "";
                    if ($data->status_detail != 3) {
                        return '';
                    } else {
                        return $cash.$aba_shop.$ac_shop;
                    }
                    if ($data->status_detail != 3) {
                        return '<input class="paid_dollar" value="' . ($data->total_dollar > 0 ? ('$' . numberFormat((float)$data->total_dollar)) : '') . '">';
                    } else {
                        return "<input class='paid_dollar' value='" . $data->total_dollar . "'> ";
                    }
                })
                ->editColumn('total_dollar_hidden', function ($data) {
                    if ($data->status_detail != 3) {
                        return '<samp>' . $data->total_dollar . '</samp>';
                    } else {
                        return $data->total_dollar;
                    }
                })
                ->editColumn('total_riel_hidden', function ($data) {
                    if ($data->status_detail != 3) {
                        return '<samp>' . $data->total_riel . '</samp>';
                    } else {
                        return $data->total_riel;
                    }
                })

                ->editColumn('total_riel', function ($data) {
                    if ($data->status_detail != 3) {
                        return '';
                    } else {
                        return $data->total_riel . ' ៛';
                    }
                    if ($data->status_detail != 3) {
                        return '<samp><input class="paid_riel" value="' . ($data->total_riel > 0 ? ('' . numberFormat((float)$data->total_riel)) . '៛' : '') . '"> </samp>';
                    } else {
                        return '<input class="paid_riel" value="' . numberFormat((float)$data->total_riel) . '"> ';
                    }
                })

                ->editColumn('other_services_fee', function ($data) {
                    $return_1 = '';


                    if ($data->other_services_type == 1) {
                        $return_1 =  $data->other_services_fee >   0 ? ('$' . numberFormat((float)$data->other_services_fee) . 's') : '';
                    } elseif ($data->other_services_type == 2) {
                        $return_1 =  $data->other_services_fee >   0 ? ('$' . numberFormat((float)$data->other_services_fee) . 'c') : '';
                    } else {
                        $return_1 =   '';
                    }


                    if ($data->status_detail != 3) {
                        return '<samp>' . $return_1 . '</samp>';
                    } else {
                        return $return_1;
                    }
                })

                ->editColumn('taxi_fee', function ($data) {
                    $return_ = '';
                    if ($data->taxi_status == 1) {
                        // $return_ = $data->taxi_fee >=1 ?( '$'.numberFormat( $data->taxi_fee).' s') : '';
                        $return_ = '$' . numberFormat((float)$data->taxi_fee) . ' s';
                        if ($data->taxi_fee_symbol == '៛') {
                            $return_ = numberFormat((float)$data->taxi_fee) . '៛ s';
                        }
                    } else {
                        $return_ =   '';
                    }

                    if ($data->status_detail != 3) {
                        return '<samp>' . $return_ . '</samp>';
                    } else {
                        if ($data->taxi_fee_symbol == '៛') {
                            return '<riel>' . $return_ . '</riel>';
                        }
                        return $return_;
                    }
                })

                ->editColumn('description', function ($data) {
                    return '<input class="description border-b" value="' . $data->description . '">';
                    // return ($data->description == null ? "" :  $data->description) ;
                })
                ->editColumn('cus_is_recieve', function ($data) {
                    $checked = $data->cus_is_recieve ? "checked" : "";
                    return '<input class="form-check-input cus_is_recieve" ' . $checked . ' type="checkbox" value="" id="flexCheckDefault">';
                })


                ->editColumn('reason', function ($data) {
                    return ($data->detail_reason == null ? "" :  $data->detail_reason) . '' . ($data->driver_note == null ? "" :  $data->driver_note);
                })

                ->editColumn('status_view', function ($data) {
                    if ($data->status_detail == 1) {  // 1 = Processing,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '</strong>';
                    } elseif ($data->status_detail == 2) {  // 2 = Padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . ' </strong>';
                    } elseif ($data->status_detail == 3) {  //  3 = Done ,
                        return ' <strong class="text-info"><span class="fa fa-check"></span>  ' . __('administrator.done') . ' </strong>';
                    } elseif ($data->status_detail == 4) {  // 4 = Cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span>  ' . __('administrator.cancel') . '</strong>';
                    } else {
                        return ' <strong class="text-muted"><span class="fa fa-check"></span>  ' . __('administrator.paid') . '</strong>';
                    }
                })

                ->editColumn('status_paid', function ($data) {
                    if ($data->status_paid == 'paid') {
                        $paid = '<strong class="" style="color: #37c61a;"><span class=" fa fa-check"></span> ' . __('administrator.paid') . '</strong>';
                    } else {
                        $paid = '';
                    }
                    return $paid;
                })

                ->editColumn('extra_fee', function ($data) {
                    $return_ = '';
                    if ($data->extra_fee_type == 1) {
                        $return_ =  '$' . numberFormat((float)$data->extra_fee)  . ' s';
                    } elseif ($data->extra_fee_type == 2) {
                        $return_ =  '$' . numberFormat((float)$data->extra_fee) . ' c';
                    } else {
                        $return_ = '';
                    }

                    if ($data->status_detail != 3) {
                        return '<samp>' . $return_ . '</samp>';
                    } else {
                        return $return_;
                    }
                })

                ->editColumn('total_price', function ($data) {
                    if ($data->status_detail != 3) {
                        if ($data->total_product_symbol == '៛') {
                            return '<samp>' . numberFormat((float)$data->total_price)  . '៛</samp>';
                        }
                        return '<samp>' . '$' . numberFormat((float)$data->total_price)  . '</samp>';
                    } else {
                        if ($data->total_product_symbol == '៛') {
                            return '<riel>' . numberFormat((float)$data->total_price)  . '៛</riel>';
                        }
                        return '$' . numberFormat((float)$data->total_price);
                    }
                })

                ->addColumn('action', function ($data) {
                    if ($data->discount_type != null || $data->discount_type != '') {
                        if ($data->discount_type == 1) {
                            $delivery_fee = $data->discount;
                        } elseif ($data->discount_type == 2) {
                            $delivery_fee = ((100 -  (float)$data->discount) * (float)$data->delivery_fee / (float)$data->delivery_fee_rate) / 100;
                        } else {
                            $delivery_fee = $data->delivery_fee;
                        }
                    } else {
                        $delivery_fee  =  (float)$data->delivery_fee / (float)$data->delivery_fee_rate;
                    }

                    if ($data->delivery_pay_or_paid == 'paid') {
                        $delivery_fee  =  0;
                    }
                    $other_services_fee =  0;
                    if ($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2) {
                        $other_services_fee = $data->other_services_fee;
                    }
                    if ($data->delivery_status == 2) {
                        $price = $delivery_fee + ((float)$data->total_price / (float)$data->total_product_rate) + (float)$other_services_fee;
                    } else {
                        $price = ((float)$data->total_price / (float)$data->total_product_rate)  +  $other_services_fee;
                    }
                    if ($data->total_product_status == 2) { //paid
                        $price = $price - ((float)$data->total_price / (float)$data->total_product_rate);
                    }

                    $price_riel = $price * (currency() ? currency()->currency_exchange_to : 4000);
                    if ($data->status_detail == 1) {
                        // <label class="btn_sm button_success bt_done" data-status="1" data-pay_to="'.$data->pay_to.'"​​ data-export_id="'.$data->export_id.'" >'.__('administrator.done').'</label>
                        $edit = '
                                <label class="btn_sm button_warning bt_pending" data-status="'.$data->status.'" data-export_id="' . $data->export_id . '">' . __('administrator.pending') . '</label>
                                <label class="btn_sm button_danger bt_cencel" data-status="'.$data->status.'" data-export_id="' . $data->export_id . '" >' . __('administrator.cancel') . '</label>
                                <label class="btn_sm button_primary edit_price_of_car"
                                            data-export_id              ="' . $data->export_id . '"
                                            data-price                  ="' . $price . '"​​
                                            data-delivery_option        ="' . $data->delivery_option . '"​​
                                            data-currency               ="' . $data->currency . '"
                                            data-taxi_status            ="' . $data->taxi_status . '"
                                            data-taxi_shop_fee          ="' . $data->taxi_shop_fee . '"
                                            data-taxi_cust_fee          ="' . $data->taxi_cust_fee . '"​​
                                            data-taxi_number            ="' . $data->taxi_number . '"
                                            data-total_riel             ="' . $data->total_riel . '"
                                            data-total_dollar           ="' . $data->total_dollar . '"​​
                                            data-extra_fee              ="' . $data->extra_fee . '"​​
                                            data-extra_fee_type         ="' . $data->extra_fee_type . '"​​
                                            data-driver_note            ="' . $data->driver_note . '"​​
                                            data-user_currency          ="' . $data->rate . '"​​
                                            data-amount_pay_to          ="' . $data->amount_pay_to . '"​​
                                            data-pay_to                 ="' . $data->pay_to . '"
                                            data-rate                   ="' . $data->rate . '"
                                            data-taxi_fee_symbol        ="' . $data->taxi_fee_symbol . '"

                                    >' . __('administrator.edit_delivey') . '</label>';
                        return $edit;
                        // data-user_currency          ="' . (User::find($data->merchant_id)->user_currency) . '"​​
                    }


                    if ($data->discount_type != null || $data->discount_type != '') {
                        if ($data->discount_type == 1) {
                            $delivery_fee = $data->discount;
                        } elseif ($data->discount_type == 2) {
                            $delivery_fee = ((100 -  (float)$data->discount) * (float)$data->delivery_fee) / 100;
                        } else {
                            $delivery_fee = $data->delivery_fee;
                        }
                    } else {
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if ($data->delivery_pay_or_paid == 'paid') {
                        $delivery_fee  =  0;
                    }

                    $other_services_fee =  0;
                    if ($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2) {
                        $other_services_fee = $data->other_services_fee;
                    }

                    $edit = '';

                    $delete = '';
                    // $delete = '<a data-href="' . route("export_stock_delete_box", [$data->nso007_delivery_order_detail_id,'in_processing']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    // if (!$data->invoice_payment_id) {
                    //     return $delete .''.$edit ;
                    // }
                })

                ->editColumn('delivery_fee', function ($data) {
                    $delivery_fee  = 0;
                    $dis = DiscountModel::find($data->discount_id);
                    if ($dis) {
                        if ($data->discount_type == 1) {
                            $delivery_fee = $data->discount;
                        } elseif ($data->discount_type == 2) {
                            $delivery_fee = ((100 - (float)$data->discount) * (float)$data->delivery_fee) / 100;
                        } else {
                            $delivery_fee = $data->delivery_fee;
                        }
                    } else {
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if ($data->delivery_status == 1) {
                        if ($data->delivery_fee_symbol == '$') {
                            $delivery_fee = '$' . numberFormat((float)$delivery_fee) . ' s';
                        }
                        if ($data->delivery_fee_symbol == '៛') {
                            $delivery_fee = numberFormat((float)$delivery_fee) . '៛ s';;
                        }
                    } else {
                        if ($data->delivery_fee_symbol == '$') {
                            $delivery_fee = '$' . numberFormat((float)$delivery_fee) . ' c';
                        }
                        if ($data->delivery_fee_symbol == '៛') {
                            $delivery_fee = numberFormat((float)$delivery_fee) . '៛ c';;
                        }
                    }

                    if ($data->delivery_pay_or_paid == 'paid') {
                        $delivery_fee =   '  <strike> ' . $delivery_fee . '  </strike>';
                    }

                    if ($data->status_detail != 3) {
                        return '<samp>' . $delivery_fee . '</samp>';
                    } else {
                        if ($data->delivery_fee_symbol == "៛") {
                            return '<riel>' . $delivery_fee . '</riel>';
                        }
                        return $delivery_fee;
                    }
                })
                ->addColumn('car', function ($data) {
                    $text = "ខេត្ត";
                    $text = $data->delivery_option;
                    if ($data->delivery_option == "No") {
                        $text = "ភ្នំពេញ";
                    }
                    return '' . $text . '';
                })
                ->addColumn('cus_collect_dollar', function ($data) {

                    $total = 0;
                    if ($data->total_product_symbol == "$") {
                        if ($data->total_product_status == 1) {
                            $total += (float)$data->total_product;
                        }
                    }
                    if ($data->delivery_status == 2) {
                        if ($data->delivery_fee_symbol == "$") {
                            $total += (float)$data->delivery_fee;
                        }
                    }
                    return '$ ' . number_format($total, 2);
                })
                ->addColumn('cus_collect_riel', function ($data) {

                    $total_col_riel = 0;
                    if ($data->total_product_symbol == "៛") {
                        if ($data->total_product_status == 1) {
                            $total_col_riel += (float)$data->total_product;
                        }
                    }
                    if ($data->delivery_status == 2) {
                        if ($data->delivery_fee_symbol == "៛") {
                            $total_col_riel += (float)$data->delivery_fee;
                        }
                    }
                    return $total_col_riel . ' ៛';
                })
                ->addColumn('taxi_price_dollar', function ($data) {
                    $total_taxi_dol = 0;
                    if ($data->taxi_status == 1) {
                        if ($data->taxi_fee_symbol == "$") {
                            $total_taxi_dol += (float)$data->taxi_shop_fee;
                        }
                    }
                    if ($data->taxi_status == 2) {
                        if ($data->taxi_fee_symbol == "$") {
                            $total_taxi_dol += (float)$data->taxi_cust_fee;
                        }
                    }
                    return '$ ' . $total_taxi_dol;
                })
                ->addColumn('taxi_price_riel', function ($data) {
                    $total_taxi_riel = 0;
                    if ($data->taxi_status == 1) {
                        if ($data->taxi_fee_symbol == "៛") {
                            $total_taxi_riel += (float)$data->taxi_shop_fee;
                        }
                    }
                    if ($data->taxi_status == 2) {
                        if ($data->taxi_fee_symbol == "៛") {
                            $total_taxi_riel += (float)$data->taxi_cust_fee;
                        }
                    }
                    return $total_taxi_riel . '៛';
                })
                ->addColumn('taxi_option', function ($data) {
                    $opt = '<option value="1" >' . __('administrator.pay_shop') . '</option>';
                    if ($data->taxi_status == 2) {
                        $opt .= '<option value="2" selected>' . __('administrator.pay_customer') . '</option>';
                    } else {
                        $opt .= '<option value="2">' . __('administrator.pay_customer') . '</option>';
                    }
                    $select = '
                                <select value="' . $data->taxi_status . '" class="taxi_option">
                                    ' . $opt . '

                                </select>
                            ';
                    return $select;
                })

                ->rawColumns(['cus_is_recieve' => 'cus_is_recieve', 'description' => 'description', 'taxi_option' => 'taxi_option', 'clear_box_code' => "clear_box_code", 'total_riel' => 'total_riel', 'total_dollar' => 'total_dollar', 'status_view' => 'status_view', 'status_paid' => 'status_paid', 'check' => 'check', 'delivery_fee' => 'delivery_fee', 'taxi_fee' => 'taxi_fee', 'extra_fee' => 'extra_fee', 'other_services_fee' => 'other_services_fee', 'total_price' => 'total_price'])
                ->addIndexColumn()
                ->make(true);
        }
        return view('administrator.driver_voucher.show_voucher', compact('id'));
    }
    public function print_voucher($id, Request $request)
    {
        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $merchant       =   $id;
        $status         =   isset($request->status) ? $request->status : null;

        $data = DB::table('nso007_delivery_order_detail')
            ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
            ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
            ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
            ->select(
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_delivery_order_detail.delivery_order_id',
                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                'nso007_delivery_order_detail.clear_box_code',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.*',
                'nso007_export_stock.total_product AS total_price',
                'nso007_delivery_order_detail.status AS status_detail',
                'nso007_delivery_order_detail.status_paid',
                'nso007_delivery_order_detail.reason AS detail_reason',
                'nso007_delivery_order_detail.clear_box_by',
                'nso007_delivery_order_detail.total_dollar',
                'nso007_delivery_order_detail.total_riel',
                'nso007_delivery_order_detail.amount_pay_to',
                'nso007_delivery_order_detail.pay_to',
                'nso007_delivery_order_detail.invoice_payment_id',
                'nso007_delivery_order_detail.export_id',
                'nso007_export_stock_details.currency',
                'nso007_delivery_order.driver_name',
                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
            )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_delivery_order.delivery_date', '>=', $from_date);
                }
                if ($to_date) {
                    $query->whereDate('nso007_delivery_order.delivery_date', '<=', $to_date);
                }
            })

            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })
            ->where('nso007_delivery_order_detail.status', '!=', 7)
            ->whereNull(['nso007_delivery_order_detail.invoice_payment_id', 'nso007_delivery_order_detail.clear_box_code', 'nso007_delivery_order_detail.status_paid'])
            ->where('nso007_delivery_order.driver_id', $id)
            ->where('nso007_delivery_order.time_policy', $request->time_policy)
            ->where('nso007_delivery_order.delivery_date', $request->delivery_date)
            ->orderBy('nso007_export_stock.box_code', 'desc')
            ->groupBy('nso007_export_stock.box_code')
            ->get();
        $driver_id = $id;
        $time_policy = $request->time_policy;
        $delivery_date = $request->delivery_date;
        return view('administrator.driver_voucher.clear_driver_detail', compact('data', 'delivery_date', 'time_policy', 'driver_id'));
    }
    public function clear_driver_voucher($id, Request $request)
    {
        try {
            DB::beginTransaction();
            $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
            $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
            $status         =   isset($request->status) ? $request->status : null;
            $data = DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
                ->select(
                    'nso007_discount.discount',
                    'nso007_discount.discount_type',
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order_detail.clear_box_by',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.amount_pay_to',
                    'nso007_delivery_order_detail.pay_to',
                    'nso007_delivery_order_detail.invoice_payment_id',
                    'nso007_delivery_order_detail.export_id',
                    'nso007_delivery_order.driver_name',
                    \DB::raw('(CASE
                                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                    ELSE nso007_export_stock.taxi_shop_fee
                                    END) AS taxi_fee')
                )
                ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                    if ($from_date) {
                        $query->whereDate('nso007_delivery_order.delivery_date', '>=', $from_date);
                    }
                    if ($to_date) {
                        $query->whereDate('nso007_delivery_order.delivery_date', '<=', $to_date);
                    }
                })

                ->when(request('status'), function ($query) use ($status) {
                    if (!empty($status)) {
                        $status_1 = '';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key] . ',';
                        }
                        $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                    }
                })
                ->where('nso007_delivery_order_detail.status_paid', null)
                ->where('nso007_delivery_order_detail.status', '!=', 0)
                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                ->where('nso007_delivery_order.driver_id', $id)
                ->where('nso007_delivery_order.time_policy', $request->time_policy)
                ->where('nso007_delivery_order.delivery_date', $request->delivery_date)
                ->orderBy('nso007_export_stock.box_code', 'desc')
                ->where('nso007_delivery_order_detail.status', 3)
                ->get();
            if ($data->count()) {
                $increas = '';
                $inovice = DB::table('nso007_driver_clear')->latest('id')->first();

                if ($inovice) {
                    $tran_num = $inovice->clear_box_code;
                    $tran_num = substr($tran_num, -6);
                    $increas = sprintf('DC-' . date('ym') . '%06d', ($tran_num + 1));
                } else {
                    $increas = 'DC-' . date('ym') . '000001';
                }
                $array = [];
                DeliveryOrderDetailModel::whereIn('id', $data->pluck('nso007_delivery_order_detail_id'))->update(['clear_box_code' => $increas, 'clear_box_by' => (\Auth::user()->id . ',' . FindDUser(\Auth::user()->id)->name)]);
                $invoicepayment     =   new DriverClearModel();
                $invoicepayment->clear_box_code    =   $increas;
                $invoicepayment->user_create        =   Auth::user()->id;
                $invoicepayment->date               =   date('Y-m-d');
                $invoicepayment->driver_id          =   $id;
                $invoicepayment->save();
                $order_deatil = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                    ->select('nso007_delivery_order_detail.*')
                    ->whereIn('nso007_delivery_order_detail.export_id', $data->pluck('export_id'))
                    ->get();
                foreach ($order_deatil as $key => $val) {
                    $val->id = null;
                    $save_data = json_decode($val, true);
                    DriverClearDetailModel::insert($save_data);
                }
            }
            DB::commit();
            return response()->json(['status' => 200, 'success' => 'Success']);
        } catch (Exception $e) {
            DB::rollBack();
            throw new Exception($e->getMessage());
        }
    }
    public function clear_driver_voucher_history(Request $request)
    {
        $driver = explode('||',$request->driver_id);
        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));

        $driver_id = $driver[0];
        $time_policy = @$driver[1];
        $data = DB::table('nso007_driver_clear_detail')
            ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_driver_clear_detail.delivery_order_id')
            ->join("users","users.id","nso007_delivery_order.driver_id")
            ->select('nso007_driver_clear_detail.*','nso007_delivery_order.driver_id','users.name as driver_name')
            ->when($driver_id,function($q) use($driver_id){
                $q->where('nso007_delivery_order.driver_id',$driver_id);
            })
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_driver_clear_detail.done_date', '>=', $from_date);
                }
                if ($to_date) {
                    $query->whereDate('nso007_driver_clear_detail.done_date', '<=', $to_date);
                }
            })

            //            ->when($driver_id,function($q) use($time_policy){
//                $q->where('do.time_policy',$time_policy);
//            })
            ->groupBy('nso007_driver_clear_detail.clear_box_code')
            ->orderBy('nso007_driver_clear_detail.id', 'DESC');
        if ($request->ajax()) {
            return  DataTables::of($data)
                ->editColumn('delivery_date', function ($data) {
                    return date('d-m-Y', strtotime($data->done_date));
                })
                ->editColumn('driver_name', function ($data) {
                    return $data->driver_name;
                })
                ->editColumn('clear_box_code', function ($data) {
                    return $data->clear_box_code ;
                })
                ->addColumn('action', function ($data) {
                    $show = '';
                    if(Gate::check('Print Voucher To Driver')){
                        $show = '
                                    <a href="' . route("delivery-order-print-voucher-clear-driver", $data->driver_id . '?delivery_date=' . date('Y-m-d',strtotime($data->done_date)). '&&clear_box_code=' . $data->clear_box_code) . '" class="btn_sm button_info"><i class="fa fa-print"></i></a>
                                ';
                    }
                    return $show;
                })
                ->addIndexColumn()
                ->rawColumns(['total', 'action'])
                ->make(true);
        }
        return view('administrator.delivery-order-new.clear_history');
    }

    public function clear_by_driver($id, Request $request)
    {

        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $merchant       =   $id;
        $status         =   isset($request->status) ? $request->status : null;
        $data = DB::table('nso007_delivery_order_detail')
            ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
            ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
            ->select(
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_delivery_order_detail.delivery_order_id',
                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                'nso007_delivery_order_detail.clear_box_code',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.*',
                'nso007_export_stock.total_product AS total_price',
                'nso007_delivery_order_detail.status AS status_detail',
                'nso007_delivery_order_detail.status_paid',
                'nso007_delivery_order_detail.reason AS detail_reason',
                'nso007_delivery_order_detail.clear_box_by',
                'nso007_delivery_order_detail.total_dollar',
                'nso007_delivery_order_detail.total_riel',
                'nso007_delivery_order_detail.amount_pay_to',
                'nso007_delivery_order_detail.pay_to',
                'nso007_delivery_order_detail.invoice_payment_id',
                'nso007_delivery_order_detail.export_id',
                'nso007_delivery_order.driver_name',
                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
            )
            // ->whereDate('nso007_delivery_order.delivery_date','=',$request->date)
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_delivery_order.delivery_date', '>=', $from_date);
                }
                if ($to_date) {
                    $query->whereDate('nso007_delivery_order.delivery_date', '<=', $to_date);
                }
            })

            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })
            ->where('nso007_delivery_order_detail.status', '!=', 7)
            ->whereNull(['nso007_delivery_order_detail.invoice_payment_id', 'nso007_delivery_order_detail.clear_box_code', 'nso007_delivery_order_detail.status_paid'])
            ->where('nso007_delivery_order.driver_id', $id)
            ->where('nso007_delivery_order.time_policy', $request->time_policy)
            ->where('nso007_delivery_order.delivery_date', $request->delivery_date)
            ->orderBy('nso007_export_stock.box_code', 'desc');
        if ($request->type == "print") {
            $display_data = $data->get();
            $proccessing = false;
            $count_clear = $data->where('nso007_delivery_order_detail.status', '=', 3);
            $export_id = $count_clear->pluck('export_id');
            if ($request->ajax()) {
                if ($count_clear->count() != 0) {
                    $increas = '';
                    $last_id =  DB::table('nso007_driver_clear')->max('id');
                    $inovice = DB::table('nso007_driver_clear')->latest('id')->first();

                    if ($inovice) {
                        $tran_num = $inovice->clear_box_code;
                        $tran_num = substr($tran_num, -6);
                        $increas = sprintf('DC-' . date('ym') . '%06d', ($tran_num + 1));
                    } else {
                        $increas = 'DC-' . date('ym') . '000001';
                    }
                    $array = [];
                    DeliveryOrderDetailModel::whereIn('id', $count_clear->pluck('nso007_delivery_order_detail_id'))->update(['clear_box_code' => $increas, 'clear_box_by' => (\Auth::user()->id . ',' . FindDUser(\Auth::user()->id)->name)]);
                    $invoicepayment     =   new DriverClearModel();
                    $invoicepayment->clear_box_code    =   $increas;
                    $invoicepayment->user_create        =   Auth::user()->id;
                    $invoicepayment->date               =   date('Y-m-d');
                    $invoicepayment->driver_id          =   $id;
                    $invoicepayment->save();
                    $order_deatil = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                        ->select('nso007_delivery_order_detail.*')
                        ->whereIn('nso007_delivery_order_detail.export_id', $export_id)
                        ->get();
                    foreach ($order_deatil as $key => $val) {
                        $val->id = null;
                        $save_data = json_decode($val, true);
                        DriverClearDetailModel::insert($save_data);
                    }
                }
            }
            $data = $display_data;
            $loading = "Not true";
            $driver_id = $id;
            $time_policy = $request->time_policy;
            $delivery_date = $request->delivery_date;
            return view('administrator.driver_voucher.clear_driver_detail', compact('data', 'loading', 'delivery_date', 'time_policy', 'driver_id'));
        }
    }
    public function clear_by_multi_driver(Request $request)
    {
        try {
            DB::beginTransaction();
            foreach($request->obj as $val){
                $data = DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
                ->selectRaw('nso007_export_stock.id')
                ->where('nso007_delivery_order_detail.status', '!=', 7)
                ->whereNull(['nso007_delivery_order_detail.invoice_payment_id', 'nso007_delivery_order_detail.clear_box_code', 'nso007_delivery_order_detail.status_paid'])
                ->where('nso007_delivery_order.driver_id', $val['driver_id'])
                ->where('nso007_delivery_order.time_policy', $val['time_policy'])
                ->where('nso007_delivery_order.delivery_date', $val['date'])
                ->where('nso007_delivery_order_detail.status',3)
                ->orderBy('nso007_export_stock.box_code', 'desc');
                if($data->count()){
                    $increas = '';
                    $last_id =  DB::table('nso007_driver_clear')->max('id');
                    $inovice = DB::table('nso007_driver_clear')->selectRaw("clear_box_code")->orderByDesc('id')->first();

                    if ($inovice) {
                        $tran_num = $inovice->clear_box_code;
                        $tran_num = substr($tran_num, -6);
                        $increas = sprintf('DC-' . date('ym') . '%06d', ($tran_num + 1));
                    } else {
                        $increas = 'DC-' . date('ym') . '000001';
                    }
                    $export_id = $data->pluck('id');
                    $array = [];
                    DeliveryOrderDetailModel::whereIn('export_id', $export_id)->update(['clear_box_code' => $increas, 'clear_box_by' => (\Auth::user()->id . ',' . FindDUser(\Auth::user()->id)->name)]);
                    $invoicepayment     =   new DriverClearModel();
                    $invoicepayment->clear_box_code    =   $increas;
                    $invoicepayment->user_create        =   Auth::user()->id;
                    $invoicepayment->date               =   date('Y-m-d');
                    $invoicepayment->driver_id          =   $val['driver_id'];
                    $invoicepayment->save();
                    $order_deatil = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                        ->select('nso007_delivery_order_detail.*')
                        ->whereIn('nso007_delivery_order_detail.export_id', $export_id)
                        ->chunk(1000,function($order_deatil){
                            foreach ($order_deatil as $key => $val) {
                                $val->id = null;
                                $save_data = json_decode($val, true);
                                DriverClearDetailModel::insert($save_data);
                            }
                        });

                }
            }
        DB::commit();
        return response()->json(['status'=>200]);
        } catch (Exception $e) {
            DB::rollBack();
            throw new Exception($e->getMessage());
        }
    }
    public function edit($id)
    {
        //
    }
    public function update(Request $request, $id)
    {
        //
    }
    public function destroy($id)
    {
        //
    }
    public function update_taxi_option(Request $request)
    {
        ExportStockModel::where('id', $request->export_id)
            ->update([
                'taxi_status' => $request->taxi_opt,
                'taxi_shop_fee' => $request->taxi_price,
                'taxi_cust_fee' => $request->taxi_price
            ]);
        return response()->json(200);
    }
    public function update_description(Request $request)
    {
        ExportStockModel::where('id', $request->export_id)
            ->update([
                'description' => $request->description
            ]);
        return response()->json(200);
    }
    public function update_cus_is_recieve(Request $request)
    {
        ExportStockModel::where('id', $request->export_id)
            ->update([
                'cus_is_recieve' => $request->cus_is_recieve
            ]);
        return response()->json(200);
    }
    public function print_voucher_to_driver($id, Request $request)
    {

        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $merchant       =   $id;
        $status         =   isset($request->status) ? $request->status : null;

        $data = DB::table('nso007_delivery_order_detail')
            ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
            ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
            ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
            ->select(
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_delivery_order_detail.delivery_order_id',
                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                'nso007_delivery_order_detail.clear_box_code',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.*',
                'nso007_export_stock.total_product AS total_price',
                'nso007_delivery_order_detail.status AS status_detail',
                'nso007_delivery_order_detail.status_paid',
                'nso007_delivery_order_detail.reason AS detail_reason',
                'nso007_delivery_order_detail.clear_box_by',
                'nso007_delivery_order_detail.total_dollar',
                'nso007_delivery_order_detail.total_riel',
                'nso007_delivery_order_detail.amount_pay_to',
                'nso007_delivery_order_detail.pay_to',
                'nso007_delivery_order_detail.invoice_payment_id',
                'nso007_delivery_order_detail.export_id',
                'nso007_export_stock_details.currency',
                'nso007_delivery_order.driver_name',
                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
            )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_delivery_order.delivery_date', '>=', $from_date);
                }
                if ($to_date) {
                    $query->whereDate('nso007_delivery_order.delivery_date', '<=', $to_date);
                }
            })

            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })
            ->where('nso007_delivery_order_detail.status', '!=', 7)
            ->whereNull(['nso007_delivery_order_detail.invoice_payment_id', 'nso007_delivery_order_detail.clear_box_code', 'nso007_delivery_order_detail.status_paid'])
            ->where('nso007_delivery_order.driver_id', $id)
            ->where('nso007_delivery_order.time_policy', $request->time_policy)
            ->where('nso007_delivery_order.delivery_date', $request->delivery_date)
            ->orderBy('nso007_export_stock.box_code', 'desc')
            ->groupBy('nso007_export_stock.box_code')
            ->get();
        $driver_id = $id;
        $time_policy = $request->time_policy;
        $delivery_date = $request->delivery_date;
        return view('administrator.driver_voucher.print-voucher-driver', compact('data', 'delivery_date', 'time_policy', 'driver_id'));
    }

    public function print_voucher_clear_driver($id, Request $request)
    {
        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $merchant       =   $id;
        $status         =   isset($request->status) ? $request->status : null;

        $data = DB::table('nso007_driver_clear_detail')
            ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_driver_clear_detail.delivery_order_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_driver_clear_detail.export_id')
            ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
            ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
            ->select(
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_driver_clear_detail.delivery_order_id',
                'nso007_driver_clear_detail.id As nso007_delivery_order_detail_id',
                'nso007_driver_clear_detail.clear_box_code',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.*',
                'nso007_export_stock.total_product AS total_price',
                'nso007_driver_clear_detail.status AS status_detail',
                'nso007_driver_clear_detail.status_paid',
                'nso007_driver_clear_detail.reason AS detail_reason',
                'nso007_driver_clear_detail.clear_box_by',
                'nso007_driver_clear_detail.total_dollar',
                'nso007_driver_clear_detail.total_riel',
                'nso007_driver_clear_detail.amount_pay_to',
                'nso007_driver_clear_detail.pay_to',
                'nso007_driver_clear_detail.invoice_payment_id',
                'nso007_driver_clear_detail.export_id',
                'nso007_export_stock_details.currency',
                'nso007_delivery_order.driver_name',
                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
            )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if ($from_date) {
                    $query->whereDate('nso007_driver_clear_detail.done_date', '>=', $from_date);
                }
                if ($to_date) {
                    $query->whereDate('nso007_driver_clear_detail.done_date', '<=', $to_date);
                }
            })
            ->where('nso007_driver_clear_detail.clear_box_code', $request->clear_box_code)
            ->orderBy('nso007_driver_clear_detail.id', 'desc')
            ->groupBy('nso007_export_stock.box_code')
            ->get();
        $driver_id = $id;
        $delivery_date = $request->delivery_date;

        return view('administrator.driver_voucher.print-clear-voucher-driver', compact('data', 'delivery_date',  'driver_id'));
    }
}
