<?php

namespace App\Http\Controllers\Administrator;


use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderModel;
use App\ExportStockModel;
use App\ThemeModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Auth;
use App\User;
use App\InvoiceModel;
use App\InvoicePaymentModel;
use App\PickupAdminModel;
use App\RequestPickup;
use Carbon\Carbon;
use Session;
use Illuminate\Foundation\Auth\User as AuthUser;
use Illuminate\Support\Facades\Cache;

class DashboardController extends Controller
{
    function __construct()
    {
        // $this->middleware('permission:Dashboard', ['only' => ['index']]);
    }

    public function index()
    {

        if ( Auth::user()->is_role == 'Administrator' ) {
            return view('administrator.dashboard-administrator');
        }else if(Auth::user()->is_role == 'Driver'){
            return redirect()->route('dashboard_driver');
        }
        else if(Auth::user()->is_role == 'MerchantIn'){
            return redirect()->route('dashboard_merchant');
        }
        else{

        }

    }
    public function appearance(){
        $branch = Auth::user();
        $animation = [
        'bounce'=>'bounce',
        'flash'=>'flash',
        'pulse'=>'pulse',
        'rubberBand'=>'rubberBand',
        'shake'=>'shake',
        'swing'=>'swing',
        'tada'=>'tada',
        'wobble'=>'wobble',
        'bounceIn'=>'bounceIn',
        'bounceInDown'=>'bounceInDown',
        'bounceInLeft'=>'bounceInLeft',
        'bounceInRight'=>'bounceInRight',
        'bounceInUp'=>'bounceInUp',
        'bounceOut'=>'bounceOut',
        'bounceOutDown'=>'bounceOutDown',
        'bounceOutLeft'=>'bounceOutLeft',
        'bounceOutRight'=>'bounceOutRight',
        'bounceOutUp'=>'bounceOutUp',
        'fadeIn'=>'fadeIn',
        'fadeInDown'=>'fadeInDown',
        'fadeInDownBig'=>'fadeInDownBig',
        'fadeInLeft'=>'fadeInLeft',
        'fadeInLeftBig'=>'fadeInLeftBig',
        'fadeInRight'=>'fadeInRight',
        'fadeInRightBig'=>'fadeInRightBig',
        'fadeInUp'=>'fadeInUp',
        'fadeInUpBig'=>'fadeInUpBig',
        'fadeOut'=>'fadeOut',
        'fadeOutDown'=>'fadeOutDown',
        'fadeOutDownBig'=>'fadeOutDownBig',
        'fadeOutLeft'=>'fadeOutLeft',
        'fadeOutLeftBig'=>'fadeOutLeftBig',
        'fadeOutRight'=>'fadeOutRight',
        'fadeOutRightBig'=>'fadeOutRightBig',
        'fadeOutUp'=>'fadeOutUp',
        'fadeOutUpBig'=>'fadeOutUpBig',
        'flip'=>'flip',
        'flipInX'=>'flipInX',
        'flipInY'=>'flipInY',
        'flipOutX'=>'flipOutX',
        'flipOutY'=>'flipOutY',
        'lightSpeedIn'=>'lightSpeedIn',
        'lightSpeedOut'=>'lightSpeedOut',
        'rotateIn'=>'rotateIn',
        'rotateInDownLeft'=>'rotateInDownLeft',
        'rotateInDownRight'=>'rotateInDownRight',
        'rotateInUpLeft'=>'rotateInUpLeft',
        'rotateInUpRight'=>'rotateInUpRight',
        'rotateOut'=>'rotateOut',
        'rotateOutDownLeft'=>'rotateOutDownLeft',
        'rotateOutDownRight'=>'rotateOutDownRight',
        'rotateOutUpLeft'=>'rotateOutUpLeft',
        'rotateOutUpRight'=>'rotateOutUpRight',
        'hinge'=>'hinge',
        'rollIn'=>'rollIn',
        'rollOut'=>'rollOut',
        'zoomIn'=>'zoomIn',
        'zoomInDown'=>'zoomInDown',
        'zoomInLeft'=>'zoomInLeft',
        'zoomInRight'=>'zoomInRight',
        'zoomInUp'=>'zoomInUp',
        'zoomOut'=>'zoomOut',
        'zoomOutDown'=>'zoomOutDown',
        'zoomOutLeft'=>'zoomOutLeft',
        'zoomOutRight'=>'zoomOutRight',
        'zoomOutUp'=>'zoomOutUp',
        'slideInDown'=>'slideInDown',
        'slideInLeft'=>'slideInLeft',
        'slideInRight'=>'slideInRight',
        'slideInUp'=>'slideInUp',
        'slideOutDown'=>'slideOutDown',
        'slideOutLeft'=>'slideOutLeft',
        'slideOutRight'=>'slideOutRight',
        'slideOutUp'=>'slideOutUp]'
        ];
        $color = ThemeModel::all();
        return view('administrator.appearance',compact('branch','animation','color'));
    }
    public function appearance_update(Request $request,$id){
        $branch = User::find($id);
        $branch->animation_duration = $request->animation_duration;
        $branch->animation = $request->animation;
        $branch->primary_text = $request->primary_text;
        $branch->primary_background = $request->primary_background;
        $branch->secondary_text = $request->secondary_text;
        $branch->secondary_background = $request->secondary_background;
        $branch->hover_text = $request->hover_text;
        $branch->hover_bg = $request->hover_bg;
        $branch->menu_layout = $request->navbar;
        $branch->update();
        return redirect()->route('admin.appearance')->with('success','Update success');

    }

    public function dashboard(Request $request){
        $search =  $request->search;
        $total_booking = 0;
        $from_date = date('Y-m-d');
        $to_date = date('Y-m-d');
        if($search == 'weedly'){
            $from_date = Carbon::now()->startOfWeek();
            $to_date = Carbon::now()->endOfWeek();
        }
        elseif($search == 'monthly'){
            $from_date = Carbon::now()->startOfMonth();
            $to_date = Carbon::now()->endOfMonth();
        }
        elseif($search == 'yearly'){
            $from_date = Carbon::now()->startOfYear();
            $to_date = Carbon::now()->endOfYear();
        }
        $total_booking              =   ExportStockModel::whereBetween('export_date',[$from_date,$to_date])
                                        ->count();
        $total_delivery             =   DB::table(DB::raw("
            (
                SELECT
                    SUM(items.total) as total_delivery,
                    SUM(items.success) as total_success,
                    SUM(items.proccessing) as total_proccessing,
                    SUM(items.pending) as total_pending,
                    SUM(items.cancel) as total_cancel,
                    SUM(items.delivery_fee) as total_delivery_fee,
                    COALESCE(SUM(items.delivery_fee_success),0) as total_delivery_fee_success
                        FROM
                        (
                            SELECT
                                COUNT(dod.id) as total,
                                COUNT(CASE WHEN dod.status = 3 THEN 1 END) as success,
                                COUNT(CASE WHEN dod.status = 1 THEN 1 END) as proccessing,
                                COUNT(CASE WHEN dod.status = 2 THEN 1 END) as pending,
                                COUNT(CASE WHEN dod.status = 4 THEN 1 END) as cancel,
                                SUM(exs.delivery_fee / exs.delivery_fee_rate) as delivery_fee,
                                SUM(CASE WHEN dod.status = 3 THEN exs.delivery_fee / exs.delivery_fee_rate END) as delivery_fee_success
                            FROM
                                nso007_delivery_order as do
                            INNER JOIN
                                nso007_delivery_order_detail as dod
                            ON
                                dod.delivery_order_id = do.id
                            INNER JOIN
                                nso007_export_stock as exs
                            ON
                                exs.id = dod.export_id
                            WHERE
                                do.delivery_date BETWEEN '".$from_date."' AND '".$to_date."'
                            AND
                                dod.status != 7 GROUP BY dod.export_id
                        ) AS items
            ) as t"))->first();



        $total_driver               =   User::where('user_type',2)->where('status',1)->count();

        $total_marchant_stock_in    =   User::where('user_type',3)->where('type_of_merchant',1)->where('status','=',1)->count();

        $total_merchant_stock_out   =   User::where('user_type',3)->where('type_of_merchant',2)->where('status','=',1)->count();

        $data_total_booking         =   ExportStockModel::
                                        select(DB::raw('YEAR(created_at) yrs, MONTH(created_at) mths,count(id) amount'))
                                        ->when(request('search'), function($query) use($search){
                                            if($search == 'today'){
                                                $query->whereDate('export_date',date('Y-m-d'));
                                            }elseif($search == 'weedly'){
                                                $query->whereBetween('export_date', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()]);
                                            }
                                            elseif($search == 'monthly'){
                                                $query->whereMonth('export_date', '=', date('m'));
                                            }
                                            elseif($search == 'yearly'){
                                                $query->whereYear('export_date', '=', date('Y'));
                                            }
                                        })
                                        ->groupBy('yrs','mths')
                                        ->get();
        $mathly_booking   = [];
        foreach($data_total_booking as $key => $item){
            array_push($mathly_booking ,[
                'label'     => date('F Y', strtotime($item->yrs . "-" . $item->mths)),
                'y'         => $item->amount,
                'indexLabel'=> $item->amount. ''
            ]);
        }


        $monthlyDeliveryData = DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->select(
                    DB::raw('YEAR(nso007_delivery_order.delivery_date) yrs, MONTH(nso007_delivery_order.delivery_date) mths,count(nso007_delivery_order.id) amount'),
                    DB::raw("SUM(nso007_export_stock.delivery_fee / nso007_export_stock.delivery_fee_rate) as total_delivery_fee"),
                    DB::raw("SUM(nso007_export_stock.other_services_fee) as total_other_services_fee"),
                )
                ->when(request('search'), function($query) use($search){
                    if($search == 'today'){
                        $query->whereDate('nso007_delivery_order.delivery_date',date('Y-m-d'));
                    }elseif($search == 'weedly'){
                        $query->whereBetween('nso007_delivery_order.delivery_date', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()]);
                    }
                    elseif($search == 'monthly'){
                        $query->whereMonth('nso007_delivery_order.delivery_date', '=', date('m'));
                    }
                    elseif($search == 'yearly'){
                        $query->whereYear('nso007_delivery_order.delivery_date', '=', date('Y'));
                    }
                })
                ->where('nso007_delivery_order_detail.status',3)
                ->groupBy('yrs','mths')->cursor();


        $menthly_deliery   = [];
        $menthly_revenues = [];
        foreach($monthlyDeliveryData as $key => $item){
            array_push($menthly_deliery ,[
                'label'     => date('F Y', strtotime($item->yrs . "-" . $item->mths)),
                'y'         => $item->amount,
                'indexLabel'=> $item->amount. ''
            ]);
            array_push($menthly_revenues ,[
                'x'         => $item->yrs.'-'.$item->mths.'-'. 01 ,
                'y'         => $item->total_delivery_fee + $item->total_other_services_fee,
            ]);
        }
        $top_10 = $this->top($search)
                    ->groupBy('merchant_id')
                    ->limit(10)
                    ->get();
        $top_5 = $this->top($search)
                    ->groupBy('driver_id')
                    ->limit(10)
                    ->get();
        $url = url('/').'/images/upload/';
        $top_10_driver_pickup = PickupAdminModel::join("users as driver","driver.id","nso007_pickup_admin.driver_id")
                                ->selectRaw("
                                driver.name,driver.phone,SUM(nso007_pickup_admin.exact_qty) as total_box,driver_id,
                                CONCAT('$url','',driver.avartar) AS image
                                ")
                                ->where('nso007_pickup_admin.status',4)
                                ->when(request('search'), function($query) use($search){
                                    if($search == 'today'){
                                        $query->whereDate('nso007_pickup_admin.date',date('Y-m-d'));
                                    }elseif($search == 'weedly'){
                                        $query->whereBetween(DB::raw("(STR_TO_DATE(nso007_pickup_admin.date,'%Y-%m-%d'))"), [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()]);
                                    }
                                    elseif($search == 'monthly'){
                                        $query->whereMonth('nso007_pickup_admin.date', '=', date('m'));
                                    }
                                    elseif($search == 'yearly'){
                                        $query->whereYear('nso007_pickup_admin.date', '=', date('Y'));
                                    }
                                })
                                ->groupBy('nso007_pickup_admin.driver_id')
                                ->limit(10)
                                ->get();



        $data = [
//            'grand_tps_khr'  => $grand_tps_khr,
//            'grand_tps_usd'  => $grand_tps_usd,
//            'grand_spb_usd'  => $grand_spb_usd,
            'total_booking'  => $total_booking,
            'total_delivery'=> $total_delivery,
            'total_driver'=> $total_driver,
            'total_marchant_stock_in'=> $total_marchant_stock_in,
            'total_merchant_stock_out'=> $total_merchant_stock_out,
            'mathly_booking' => $mathly_booking ,
            'menthly_deliery' => $menthly_deliery ,
            'top_10' => $top_10,
            'top_5' =>$top_5,
            'menthly_revenues' => $menthly_revenues ,
            'top_10_driver_pickup'=>$top_10_driver_pickup,
        ];

        return response()->json(['success' => true,'data' =>$data,'top_10'=> $top_10]);
    }
    public function top($search){
        $url = url('/').'/images/upload/';
        return  DB::table("nso007_delivery_order")
                        ->join("nso007_delivery_order_detail","nso007_delivery_order_detail.delivery_order_id","nso007_delivery_order.id")
                        ->join("nso007_export_stock","nso007_export_stock.id","nso007_delivery_order_detail.export_id")
                        ->join('users','nso007_export_stock.merchant_id','users.id')
                        ->join("users as driver","driver.id","nso007_delivery_order.driver_id")
                        ->selectRaw("
                            YEAR(nso007_delivery_order.delivery_date) yrs,MONTH(.nso007_delivery_order.delivery_date) mths,count(nso007_export_stock.id) amount,
                            users.shop_name,users.phone,CONCAT('$url','',users.avartar) AS image,
                            driver.name as driver_name

                        ")
                        ->where('nso007_export_stock.status',3)
                        ->when(request('search'), function($query) use($search){
                            if($search == 'today'){
                                $query->whereDate('nso007_delivery_order.delivery_date',date('Y-m-d'));
                            }elseif($search == 'weedly'){
                                $query->whereBetween('nso007_delivery_order.delivery_date', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()]);
                            }
                            elseif($search == 'monthly'){
                                $query->whereMonth('nso007_delivery_order.delivery_date', '=', date('m'));
                            }
                            elseif($search == 'yearly'){
                                $query->whereYear('nso007_delivery_order.delivery_date', '=', date('Y'));
                            }
                        })
                        ->orderBy('amount','DESC');

    }

    public function change_menu(){

       $check = Session::get('chnage');

       if(  $check == 1 ){
            Session::put('chnage', 0);
       }else{
            Session::put('chnage', 1);
       }
    return redirect()->back()->with('sussess', 'successfully!');

    }



}

