<?php

namespace App\Http\Controllers\Administrator;

use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderModel;
use App\DiscountDaliyModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
use Illuminate\Support\Facades\DB;

class ClearInvoiceNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
        $currency  = CurrencyModel::first();
        $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
        ->select('nso007_invoice_payment.date','nso007_delivery_order_detail.id','nso007_invoice_payment.invoice_payment','nso007_invoice_payment.from_date','nso007_invoice_payment.to_date')
        ->where('nso007_delivery_order_detail.invoice_payment_id',$id)
        ->get();
        $invoice    =  $data[0]->invoice_payment;
        $date = $data[0]->date;
        $payment = InvoicePaymentModel::where('invoice_payment',$data[0]->invoice_payment)->first()  ;
        $discount_daily = 0;
        if( $payment->discount_daily_id != null && $payment->discount_daily_id != '' ){
            $discount_daily = DiscountDaliyModel::find( $payment->discount_daily_id)->discount_amount;
        }
 
        $from_date  =  $data[0]->from_date;
        $to_date    =  $data[0]->to_date;
        $id_ = '';
        foreach ($data as $key => $value) {
            $id_ .= $data[$key]->id.',';
        }

        $user = User::find($payment->shop_id);

        $data = DeliveryOrderModel::
                join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                ->whereIn('nso007_delivery_order_detail.id',explode(',',$id_))
                ->where('nso007_delivery_order_detail.status','!=',7)
                ->orderBy('nso007_delivery_order.inovice','desc')
                ->groupBy('nso007_export_stock_details.export_id')
                ->groupBy('nso007_delivery_order_detail.delivery_order_id')
                ->get();
        return view('administrator.clear_inovice-new.show',compact('user','data','invoice','from_date','to_date','currency','discount_daily','date')); 
    
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
