<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderDetailModel;
use App\DeliveryOrderModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\JournalModel;
use App\User;
use Auth;
use Yajra\DataTables\DataTables;

use Illuminate\Support\Facades\DB;

class ClearInvoiceDriverContrller extends Controller
{

    public function clearinvoicedirver($driver_voucher){
        $deliveryOrderModel = DeliveryOrderModel::
        join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
            ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
            ->join('users AS driver','driver.id','nso007_delivery_order.driver_id')
            ->select('nso007_delivery_order_detail.status',
                    'nso007_delivery_order.inovice AS driver_voucher',
                    'nso007_export_stock.service_charge',
                    'nso007_export_stock.delivery_status',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail.*',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.extra_fee',
                    'nso007_export_stock.extra_fee_type',
                    'nso007_export_stock.customer_receive',
                    'nso007_delivery_order_detail.commission_type AS share_fee_type' ,
                    'nso007_delivery_order_detail.driver_commission AS share_fee' ,
                    'driver.name AS driver_name',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

                )
            ->where('nso007_delivery_order.inovice','LIKE',$driver_voucher)
            ->orderBy('nso007_delivery_order.inovice','desc')
            ->groupBy('nso007_delivery_order_detail.delivery_order_id')
            ->groupBy('nso007_export_stock_details.export_id')
            ->get();
            
            DeliveryOrderModel::where('inovice',$driver_voucher)->update(['status_receive'=>1]);


            return back()->with(['success' => 'Your Create Successfull']);

    }
     
    public function index( Request $request)
    {
        // $drivers = User::where('user_type', 2)->where('status', 1)->pluck('name', 'id')->prepend(__('administrator.please_choose'), '')->toArray(); 

        // if ($request->ajax()) {
            
        //     $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        //     $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        //     $drivers        =   isset($request->drivers) ? $request->drivers : null;
        //     $status         =   isset($request->status) ? $request->status : null;
        //     $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
            
        //     // dd(   $driver_voucher );
        // $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
        //     ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
        //     ->join('users AS merchant', 'merchant.id', 'nso007_export_stock.merchant_id')
        //     ->join('nso007_location', 'nso007_location.id', 'nso007_export_stock.location')
        //     ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
        //     ->join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
        //     ->join('users AS driver', 'driver.id', 'nso007_delivery_order.driver_id')
        //     ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

        // if (\Globals::check_lang() == 'en') {
        //     $data = $data->select(
        //         'nso007_discount.*',
        //         'nso007_export_stock.*', 
        //         'nso007_export_stock.id AS export_id', 
        //         'nso007_delivery_order_detail.status',
        //         'nso007_delivery_order_detail.reason',
        //         'nso007_delivery_order.inovice',
        //         'nso007_delivery_order.delivery_date', 
        //         'nso007_delivery_order_detail.*', 
        //         'merchant.shop_name',
        //         'merchant.id AS merchant_id', 
        //         'driver.id AS driver_id',
        //         'nso007_location.name_en AS name_location',
        //         'nso007_category.name_en AS category_name',
        //         'driver.name AS driver_name',
        //         'nso007_delivery_order_detail.commission_type AS share_fee_type',
        //         'nso007_delivery_order_detail.driver_commission AS share_fee',
        //         'nso007_delivery_order_detail.id AS delivery_order_detail_id',
        //         'nso007_delivery_order.inovice As driver_voucher',
        //         DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
        //     );
        // } else {
        //     $data = $data->select(
        //         'nso007_discount.*',
        //         'nso007_export_stock.*', 
        //         'nso007_export_stock.id AS export_id', 
        //         'nso007_delivery_order_detail.status',
        //         'nso007_delivery_order_detail.reason',
        //         'nso007_delivery_order.inovice',
        //         'nso007_delivery_order.delivery_date', 
        //         'nso007_delivery_order_detail.*', 
        //         'merchant.shop_name',
        //         'merchant.id AS merchant_id',
        //         'driver.id AS driver_id',
        //         'nso007_location.name_km AS name_location',
        //         'nso007_category.name_km AS category_name',
        //         'nso007_delivery_order_detail.commission_type AS share_fee_type',
        //         'nso007_delivery_order_detail.driver_commission AS share_fee',
        //         'nso007_delivery_order.inovice As driver_voucher',
        //         'driver.name AS driver_name',
        //         'nso007_delivery_order_detail.id AS delivery_order_detail_id',
        //         DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

        //     );
        // }
        // $data = $data
        //     ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
        //         if (!empty($from_date) && !empty($to_date)) {
        //             $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
        //         }
        //     })
        //     ->when(request('status'), function ($query) use ($status) {
        //         if (!empty($status)) {
        //             $status_1 = '';
        //             foreach ($status as $key => $value) {
        //                 $status_1  .= $status[$key] . ',';
        //             }
        //             $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
        //         }
        //     })
        //     ->where(function ($query) use ($drivers) {
        //         if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
        //             $query->where('merchant_id', \Auth::user()->id);
        //         } else if (\Globals::is_Driver() == 'Driver') {
        //             $query->where('driver_id', \Auth::user()->id);
        //         } else {
        //             $query->where('driver_id', 'LIKE', $drivers);
        //         }
        //     }) 
        //     ->where('driver_id', 'LIKE', $drivers)
        //     ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
        //     ->orderBy('nso007_delivery_order.inovice', 'desc')
        //     ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        //     ->groupBy('nso007_export_stock_details.export_id')
        //     ->get(); 
            
        //     return DataTables::of($data)
        //     ->editColumn('total', function ($data) {
        //         $taxi_fee =0;
        //         $total = 0;
        //         $delivery_fee  = 0;
        //         $delivery_fee_shop = 0;
        //         if($data->discount_type != null || $data->discount_type != '')
        //         {
        //             if($data->discount_type == 1){
        //                 $delivery_fee = $data->discount;
        //             }
        //             elseif($data->discount_type == 2){
        //                 $delivery_fee = ((100 - $data->discount) * $data->delivery_fee ) / 100;
        //             }
        //             else {
        //                 $delivery_fee =  number_format( $data->delivery_fee,2);
        //             }
        //         }
        //         else{
        //             $delivery_fee  =  $data->delivery_fee;
        //         }

        //         if($data->delivery_status == 2){
        //             $delivery_fee_shop  =  $delivery_fee ;
        //         } 
        //         if($data->extra_fee_type == 1) {
        //             $extra_fee_shop = $data->extra_fee ;
        //             $extra_fee_cus  = 0 ;
        //              }
        //         else if($data->extra_fee_type == 2)   {

        //             $extra_fee_shop = 0;
        //             $extra_fee_cus  = $data->extra_fee ;

        //               }
        //         else  {
        //             $extra_fee_shop = 0;
        //             $extra_fee_cus = 0;
        //             }

        //         if($data->taxi_status == 1){
        //             $taxi_fee =   $data->taxi_shop_fee  ;
        //         } else{
        //             $taxi_fee =  0  ;
        //         }


        //         if($data->delivery_status == 1){  //shop
        //             $total =  $data->total_price ;
        //         }else{   //customer
        //             $total = $data->total_price  ;
        //         }


        //         return  '$'. number_format( $total +  $delivery_fee_shop + $extra_fee_cus,2);
        //     })
        //     ->editColumn('price', function ($data) {
        //         if($data->total_product_symbol == '៛'){
        //             return number_format($data->total_price).'​ ៛';
        //         }
        //         return '$' . number_format($data->total_price, 2);
        //     })
        //     ->editColumn('reason', function ($data) {
        //         return $data->reason == null ? "N/A" :  $data->reason;
        //     })
        //     ->editColumn('delivery_date', function ($data) {
        //         return date('d-m-Y', strtotime($data->delivery_date));
        //     })

        //     ->editColumn('taxi_fee', function ($data) {
        //         if ($data->taxi_status == 1) {
        //             $taxi_fee = '$' . number_format($data->taxi_shop_fee, 2);
        //             if($data->taxi_fee_symbol == '៛'){
        //                 $taxi_fee = number_format($data->taxi_shop_fee).'៛';
        //             }
        //         } else {
        //             $taxi_fee = '$' . number_format($data->taxi_cust_fee, 2);
        //             if($data->taxi_fee_symbol == '៛'){
        //                 $taxi_fee = number_format($data->taxi_cust_fee).'៛';
        //             }
        //         }
        //         return $taxi_fee;
        //     })
        //     ->editColumn('delivery_fee', function ($data) {
        //         $delivery_fee  = 0;
        //         if($data->discount_type != null || $data->discount_type != '')
        //         {
        //             if($data->discount_type == 1){
        //                 $delivery_fee = $data->discount;
        //             }
        //             elseif($data->discount_type == 2){
        //                 $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
        //             }
        //             else {
        //                 $delivery_fee =  number_format($data->delivery_fee,2);
        //             }
        //         }
        //         else{
        //             $delivery_fee  =  $data->delivery_fee;
        //         }



        //         if ($data->delivery_status == 1) {                    
                   
        //             if($data->delivery_fee_symbol == "៛"){
        //                 $delivery_fee = number_format($delivery_fee)."៛";
        //             }else{
        //                 $delivery_fee = '$' . number_format($delivery_fee, 2);
        //             }
        //         } else {
                    
        //             if($data->delivery_fee_symbol == "៛"){
        //                 $delivery_fee = number_format($delivery_fee)."៛";
        //             }else{
        //                 $delivery_fee = '$' . number_format($delivery_fee, 2);
        //             }
        //         }
                
        //         return $delivery_fee;
        //     })

        //     ->editColumn('extra_fee', function ($data)  {
        //         if($data->extra_fee_type == 1) {
        //             return  '$'.number_format( $data->extra_fee,2)  . ' s'; }
        //         else if($data->extra_fee_type == 2)   {
        //             return  '$'.number_format( $data->extra_fee,2) . ' c';    }
        //         else  {
        //             return '$0';  } 
        //     })

        //     ->editColumn('status', function ($data) {
        //         if ($data->status == 1)  // 1 = Processing,
        //             return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '</strong>';
        //         else if ($data->status == 2)  // 2 = Padding,
        //             return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . ' </strong>';
        //         else if ($data->status == 3)  //  3 = Done ,
        //             return ' <strong class="text-info"><span class="fa fa-check"></span>  ' . __('administrator.done') . ' </strong>';
        //         else if ($data->status == 4)  // 4 = Cancel
        //             return ' <strong class="text-danger"><span class="fa fa-ban"></span>  ' . __('administrator.cancel') . '</strong>';
        //         else {
        //             return ' <strong class="text-muted"><span class="fa fa-check"></span>  ' . __('administrator.paid') . '</strong>';
        //         }
        //     })

        //     ->editColumn('checkbox', function ($data)  { 
        //         return '<label class="container"> 
        //                     <input  type="checkbox"  name="check" class="checkbox" data-export_id="'.$data->export_id.'">
        //                     <span class="checkmark"></span>
        //                 </label>' ;
        //         // '<input  type="checkbox"  name="check" class="checkbox" data-export_id="'.$data->export_id.'">'; 
        //     })
        //     ->rawColumns(['status' => 'status','checkbox'=>'checkbox'])
        //     ->addIndexColumn()
        //     ->make(true); 
        // } 

        // return view('administrator.clear-invoice-driver.index', compact('drivers'));


        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $status = $request->status;
        $verify = $request->verify;
     
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));

        if ($request->ajax()) {
            $shop_id       =   isset($request->shop_id)?$request->shop_id:null;
            $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
            ->join('users','users.id','nso007_invoice_payment.user_create')

            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->select('nso007_invoice_payment.*','users.name')
            ->where(function($query) use ($shop_id){
                if($shop_id){
                    $query->where('shop_id','LIKE',$shop_id);
                }
            })

            ->when($from_date,function($q , $from_date){
                $q->where('date','>=',$from_date);
            } )

            ->when($to_date,function($q , $to_date){
                $q->where('date','<=',$to_date);
            } )

            
            ->when($verify,function($q , $verify){
                if($verify == 'verify'){
                    $q->whereNotNull('nso007_invoice_payment.verify_by') ;
                }else{
                    $q->whereNull('nso007_invoice_payment.verify_by' ) ;
                }
            } )
            
            ->where(function($query) use ($status){
                if($status  == 'pay'){
                    $query->whereNull('nso007_invoice_payment.status');
                }else{
                    $query->where('nso007_invoice_payment.status','paid');
                }
            })
            ->groupBy('nso007_delivery_order_detail.invoice_payment_id')
            ->where('nso007_export_stock.type_of_stock',1)
            ->orderBy('nso007_invoice_payment.id','desc')
            ->get();
            return  DataTables::of($data)
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })

            ->editColumn('paid_date', function($data) {
                return  $data->paid_date ? date('d-m-Y H:iA',strtotime($data->paid_date)) : '';
            })

            ->editColumn('paid_by', function($data) {
                return  $data->paid_by ? ($data->paid_by) : '';
            })
       
            ->editColumn('pay_amount', function($data) {
                $data1 = DB::table('nso007_delivery_order_detail')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                -> select(
                        'nso007_export_stock.discount_id',
                        'nso007_export_stock.location_name AS name_location',
                        'nso007_export_stock.description',
                        'nso007_export_stock.*',
                        'nso007_export_stock.total_product AS total_price',
                        'nso007_export_stock.id As export_detail_id',
                        'nso007_delivery_order_detail.status',
                        'nso007_delivery_order_detail.reason',
                        'nso007_delivery_order_detail.*',
                        'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                        \DB::raw('(CASE
                        WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                        WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                        ELSE nso007_export_stock.taxi_shop_fee
                        END) AS taxi_fee')
                )
                ->where('nso007_delivery_order_detail.invoice_payment_id',$data->id)
                ->get();
                // return $data->count();
                // return $data1->first()->total_dollar;

                $other_services_fee             = 0;
                $total_aba_to_delivery          = 0;
                $total_aba_to_shop              = 0;
                $total_riel                     = 0;
                $total_dollar                   = 0;
                $សេវាកម្មដឹកជញ្ជូនសរុប                 = 0;
                $ចេញថ្លៃឡាន                       = 0;
                $សេវារៀបចំ                        = 0;
                $total_product                  = 0;
                $total_discount                 =  0;

                foreach ($data1 as $key => $value) {
                    //////////////// Delivery Fee ////////////////////
                    $delivery_fee   = 0;
                    $discount = 0;
                    if( $value->discount_id != null)
                    {
                        $dis = DB::table('nso007_discount')->find($value->discount_id);
                        if($dis->discount_type == 1){
                            $delivery_fee = $dis->discount;
                        }
                        elseif($dis->discount_type == 2){
                            $delivery_fee = ( (100 - $dis->discount )* $value->delivery_fee / $value->delivery_fee_rate ) / 100;
                        }
                        else{
                            $delivery_fee =$value->delivery_fee;

                            if($value->delivery_status == 1){
                                $discount = ($dis->discount/100)*($value->delivery_fee / $value->delivery_fee_rate);

                            }
                            else{
                                $discount = 0;
                            }
                            /* echo $discount; */
                        }
                    }
                    else{
                        $delivery_fee  =  $value->delivery_fee / $value->delivery_fee_rate;
                    }

                    if($value->delivery_pay_or_paid == '2'){
                        $delivery_fee  = 0;
                    } 
                    //////////////// Extra Fee ////////////////////

                    if($value->extra_fee_type == 1) {
                        $extra_fee_shop = $value->extra_fee ;
                        $extra_fee_cus  = 0 ;
                    }else if($value->extra_fee_type == 2)   {
                        $extra_fee_shop = 0;
                        $extra_fee_cus  = $value->extra_fee ;
                    }else  {
                        $extra_fee_shop = 0;
                        $extra_fee_cus = 0;
                    }

                    //////////////// Taxi Fee ////////////////////


                    if($value->taxi_status == 1){
                        $taxi_fee_shop 	=   $value->taxi_fee / $value->taxi_fee_rate ;
                        if ($value->taxi_pay_or_paid == '2') {
                            $taxi_fee_shop = 0;
                        }
                    } else if($value->taxi_status == 2){
                        $taxi_fee_shop =  0  ; 
                    }
                    else{
                        $taxi_fee_shop =  0  ;
                    }
                    
                    //////////////// Other Services  ////////////////////

                    if($value->other_services_pay_or_paid == 'pay'){
                        $other_services_fee				   += $value->other_services_fee;
                    }

                    if( $value->status == 3 ){
                        if ($value->pay_to == 'delivery'){
                            $total_aba_to_delivery              +=   $value->amount_pay_to;
                        }
                        if ($value->pay_to == 'shop'){
                            $total_aba_to_shop              +=   $value->amount_pay_to;
                        }

                        // $totalPaid  +=  $Paid;
                        $total_riel                   +=  $value->total_riel;
                        $total_dollar                 +=  $value->total_dollar;
                        $សេវាកម្មដឹកជញ្ជូនសរុប               +=  $delivery_fee  + $extra_fee_cus  + $extra_fee_shop;
                        $ចេញថ្លៃឡាន                     += $taxi_fee_shop ;
                        $សេវារៀបចំ                      +=   $value->service_charge ;
                        $total_product                += $value->total_price ;
                        /* $service_charge				   += $value->service_charge; */
                        $total_discount += $discount;
                    }
                }
                $rate = $data1->first()->rate ? $data1->first()->rate : 4000;
                $total_all_service = $សេវាកម្មដឹកជញ្ជូនសរុប  + $សេវារៀបចំ   + $ចេញថ្លៃឡាន  + $other_services_fee + $total_discount;
                $substrack_total_receice_riel = (($total_riel / $rate) - $total_all_service) * $rate;
                if($substrack_total_receice_riel <= 0){
                    $total_dollar += ($substrack_total_receice_riel / $rate);
                }
                // $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel / $rate : 0;
                $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel : 0;
                return '<p><span style="font-size: 15px;"  class="text-danger">'.'$'.number_format($total_dollar,2).' ឬ '.number_format(round( $test, -2,PHP_ROUND_HALF_ODD) ,0).'៛' .'</span></p>';
                return '$'. number_format($total_dollar + $test,2);
                $​តម្លៃផ្ទេរអោយហាងសរុប  = ( $total_dollar + $total_aba_to_delivery)  -  $សេវាកម្មដឹកជញ្ជូនសរុប  - $សេវារៀបចំ   - $ចេញថ្លៃឡាន  - $other_services_fee + $total_discount;
                return '<p><span style="font-size: 15px;"  class="text-danger">'.'$'.number_format($​តម្លៃផ្ទេរអោយហាងសរុប,2).' ឬ '.number_format(round( $total_riel, -2,PHP_ROUND_HALF_ODD) ,0).'៛' .'</span></p>';
            })

            ->addColumn('verify_by1', function ($data) {

                if($data->verify_by){
                    return      $data->verify_by; 
                }
                return      '<span class="class_'.$data->id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("clear-invoice.update",$data->id) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
            })


            ->addColumn('shop', function($data) {

                if($data->shop_id == null){
                    return '';
                }
                $shop = User::find($data->shop_id);
                $data->bank_account = $shop->bank_account;
                return $shop->shop_name;
            })
            ->addColumn('bank_account', function($data) {
                return $data->bank_account ;
            })
            ->addColumn('action', function($data) {
                $edit ='<a href="'. route("clear-invoice-new.show", $data->id) . '" class="btn_sm button_primary">'.__('administrator.show' ).'</a> ';
                // if($data->status !== 'paid'){
                //     $edit .=
                //     '
                //         <a href="#" class="btn_sm button_danger bt_done"  data-id="'.$data->id.'"  >'.__('administrator.paid' ).'</a>
                //        ';
                // }
                return $edit;
                })
            ->rawColumns(['pay_amount'=>'pay_amount','verify_by1'=>'verify_by1'])
                
            ->addIndexColumn()
            ->make(true);
        }
        return view('administrator.report_shop.index',compact('merchant'));
    }
 
    public function create()
    {
        //
    }
 
    public function store(Request $request)
    {
        //
    }
 
    public function show($id,Request $request)
    {  
        $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
            ->join('users AS merchant', 'merchant.id', 'nso007_export_stock.merchant_id')
            ->join('nso007_location', 'nso007_location.id', 'nso007_export_stock.location')
            ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
            ->join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
            ->join('users AS driver', 'driver.id', 'nso007_delivery_order.driver_id')
            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
            ->select('nso007_delivery_order_detail.status',
            'nso007_delivery_order.inovice AS driver_voucher',
            'nso007_export_stock.*', 
            'merchant.name AS merchant_name',
            'nso007_delivery_order.delivery_date AS delivery_date',
            'nso007_delivery_order.inovice AS inovice',
            'nso007_location.name_km AS location_name',
            'nso007_delivery_order_detail.status',
            'nso007_delivery_order_detail.reason', 
            'nso007_delivery_order_detail.*', 
            'nso007_delivery_order_detail.commission_type AS share_fee_type' ,
            'nso007_delivery_order_detail.driver_commission AS share_fee' ,
            'driver.name AS driver_name',
            'nso007_delivery_order_detail.id AS delivery_order_detail_id',
            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

        )
     
         ->whereIn('nso007_delivery_order_detail.export_id', explode(',', $request->export_id))
                ->groupBy('nso007_export_stock.box_code')
                ->get(); 
        echo json_encode($data); 
    }
 
    public function edit($id)
    {
        //
    }
 
    public function update(Request $request, $id)
    {
        //
    }

  
    public function destroy($id)
    {
        //
    }
    public function show_all_dirver111(Request $request){
        dd( $request);
    }



    


}
