<?php

namespace App\Http\Controllers\Administrator;

use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountDaliyModel;
use App\Exports\PaymentExport;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Validation\ValidationException;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\JournalModel;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class ClearInvoiceController extends Controller
{
    function __construct()
    {
        // $this->middleware('permission:PickUp Assign to Driver', ['only' => ['create']]);
        // $this->middleware('permission:PickUp List', ['only' => ['list_pickup']]);
        // $this->middleware('permission:PickUp Create', ['only' => ['store']]);
        // $this->middleware('permission:PickUp Action', ['only' => ['edit','update','box_pickup_delete_main','assign_to_order','assign_driver_pickup','box_pickup_edit']]);
    }
    public function index(Request $request)
    {
        $status = $request->status;
        $verify = $request->verify;

        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));

        if ($request->ajax()) {
            $shop_id       =   isset($request->shop_id) ? $request->shop_id : null;
            $data = InvoicePaymentModel::with(['create_by:id,name','shop:id,shop_name,bank_account,bank_account_kh,bank_name_kh,name as account_name'])
                        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.invoice_payment_id','nso007_invoice_payment.id')
                        ->select('nso007_invoice_payment.*')
                        ->when($shop_id,function($q) use($shop_id){
                            $q->where('nso007_invoice_payment.shop_id',$shop_id);
                        })
                        ->when($from_date&&$to_date,function($q) use($from_date,$to_date){
                            $q->whereBetween('nso007_invoice_payment.date',[$from_date,$to_date]);
                        })
                        ->when($verify, function ($q, $verify) {
                            if ($verify == 'verify') {
                                $q->whereNotNull('nso007_invoice_payment.verify_by');
                            } else {
                                $q->whereNull('nso007_invoice_payment.verify_by');
                            }
                        })
                        ->where(function ($query) use ($status) {
                            if ($status  == 'pay') {
                                $query->whereNull('nso007_invoice_payment.status');
                            } else {
                                $query->where('nso007_invoice_payment.status', 'paid');
                            }
                        })
                        ->where('nso007_delivery_order_detail.status', '!=', 7)
                        ->groupBy('nso007_invoice_payment.id')
                        ->orderBy('nso007_invoice_payment.id', 'desc');
            // $data = DeliveryOrderDetailModel::join('nso007_invoice_payment', 'nso007_invoice_payment.id', 'nso007_delivery_order_detail.invoice_payment_id')
            //     ->join('users', 'users.id', 'nso007_invoice_payment.user_create')
            //     ->select('nso007_invoice_payment.*', 'users.name')
            //     ->where(function ($query) use ($shop_id) {
            //         if ($shop_id) {
            //             $query->where('shop_id', 'LIKE', $shop_id);
            //         }
            //     })

            //     ->when($from_date, function ($q, $from_date) {
            //         $q->where('date', '>=', $from_date);
            //     })

            //     ->when($to_date, function ($q, $to_date) {
            //         $q->where('date', '<=', $to_date);
            //     })


            //     ->when($verify, function ($q, $verify) {
            //         if ($verify == 'verify') {
            //             $q->whereNotNull('nso007_invoice_payment.verify_by');
            //         } else {
            //             $q->whereNull('nso007_invoice_payment.verify_by');
            //         }
            //     })

            //     ->where(function ($query) use ($status) {
            //         if ($status  == 'pay') {
            //             $query->whereNull('nso007_invoice_payment.status');
            //         } else {
            //             $query->where('nso007_invoice_payment.status', 'paid');
            //         }
            //     })
            //     ->where('nso007_delivery_order_detail.status', '!=', 7)
            //     ->groupBy('nso007_delivery_order_detail.invoice_payment_id')
            //     ->orderBy('nso007_invoice_payment.id', 'desc');
            return  DataTables::of($data)
                ->editColumn('create_by.name',function($data){
                    return @$data->create_by->name;
                })  
                ->editColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->date));
                })

                ->editColumn('paid_date', function ($data) {
                    return  $data->paid_date ? date('d-m-Y H:iA', strtotime($data->paid_date)) : '';
                })

                ->editColumn('paid_by', function ($data) {
                    return  $data->paid_by ? ($data->paid_by) : '';
                })

                ->editColumn('pay_amount', function ($data) {
                    if($data->pay_dollar != null || $data->pay_riel != null){
                        return '<p><span style="font-size: 15px;"  class="text-danger">' . '$' . number_format($data->pay_dollar, 2) . ' និង '.number_format(round($data->pay_riel, -2, PHP_ROUND_HALF_ODD), 0).' ៛</span></p>';
                    }else{
                        $data1 = \DB::table('nso007_delivery_order_detail')
                            ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
                            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                            ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
                            ->select(
                                'nso007_discount.discount',
                                'nso007_discount.discount_type',
                                'nso007_delivery_order_detail.delivery_order_id',
                                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                                'nso007_delivery_order_detail.clear_box_code',
                                'nso007_delivery_order.delivery_date',
                                'nso007_export_stock.*',
                                'nso007_export_stock.total_product AS total_price',
                                'nso007_delivery_order_detail.status AS status_detail',
                                'nso007_delivery_order_detail.status_paid',
                                'nso007_delivery_order_detail.reason AS detail_reason',
                                'nso007_delivery_order_detail.clear_box_by',
                                'nso007_delivery_order_detail.total_dollar',
                                'nso007_delivery_order_detail.total_riel',
                                'nso007_delivery_order_detail.amount_pay_to',
                                'nso007_delivery_order_detail.pay_to',
                                'nso007_delivery_order_detail.invoice_payment_id',
                                'nso007_delivery_order.driver_name',
                                \DB::raw('(CASE
                                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                    ELSE nso007_export_stock.taxi_shop_fee
                                    END) AS taxi_fee')
                            )
                            ->where('nso007_delivery_order_detail.invoice_payment_id', $data->id);
                        $total_all_service = 0;
                        $total_delivery_fee = 0;
                        $total_receive_dollar = 0;
                        $total_receive_riel = 0;
                        $total_receive_riel_text = 0;
                        $total_taxi_fee = 0;
                        $total_product_price = 0;
                        $total_delivery_cus_fee = 0;
                        $total_delivery_shop_fee = 0;
                        $total_cus_fee_when_no_recive = 0;
                        foreach ($data1->cursor() as $key => $val) {
                            $rate = $val->rate ? $val->rate : 4000;
                            $delivery_fee = 0;
                            $total_product_receive_usd = 0;
                            $total_product_receive_kh = 0;
                            if ($val->status == 3) {
                                if ($val->taxi_status == 1) {
                                    $total_taxi_fee += $val->taxi_pay_or_paid == 1 ? ($val->taxi_shop_fee / $val->taxi_fee_rate) : 0;
                                }

                                if ($val->discount_type != null || $val->discount_type != '') {
                                    if ($val->discount_type == 1) {
                                        $delivery_fee = $val->discount;
                                    } elseif ($val->discount_type == 2) {
                                        $delivery_fee = ((100 - $val->discount) * $val->delivery_fee) / 100;
                                    } else {
                                        $delivery_fee = $val->delivery_fee;
                                    }
                                } else {
                                    $delivery_fee = $val->delivery_fee;
                                }
                                if ($val->delivery_status == 1) {
                                    $delivery_fee = 0;
                                    if ($val->delivery_pay_or_paid == 1) {
                                        $total_delivery_shop_fee += $val->delivery_fee_symbol == "$" ? $val->delivery_fee : $val->delivery_fee / $rate;
                                    }
                                } elseif ($val->delivery_status == 2) {
                                    $delivery_fee = $delivery_fee;
                                }
                            }
                            if ($val->status == 3) {
                                if ($val->pay_to == 'shop' || $val->pay_to == 'ac_shop') {
                                    $product_price = ($val->total_product / $val->total_product_rate) - $val->amount_pay_to;
                                    if ($product_price < 0) {
                                        $total_product_receive_kh = 0;
                                        $total_receive_riel += 0;
                                        $total_receive_riel_text += 0;
                                        $total_product_price += 0;
                                    }
                                    if ($product_price == 0) {
                                        $total_product_receive_kh = 0;
                                        $total_receive_riel += 0;
                                        $total_receive_riel_text += 0;
                                        $total_product_price += 0;
                                    }
                                    if ($product_price > 0) {
                                        if ($val->total_riel > 0) {
                                            $product_price = $product_price * $val->rate;
                                            $recieve_riel_with_limit_product_price = $val->total_riel - $product_price;
                                            if ($recieve_riel_with_limit_product_price >= 0) {
                                                $total_product_receive_kh = $product_price;
                                                $total_receive_riel += $product_price;
                                                $total_receive_riel_text += $product_price / $val->rate;
                                                $total_product_price += $product_price / $val->rate;
                                            }
                                            if ($recieve_riel_with_limit_product_price < 0) {
                                                $recieve_dollar_with_limit_product_price = $val->total_dollar - abs($recieve_riel_with_limit_product_price / $val->rate);
                                                if ($recieve_dollar_with_limit_product_price >= 0) {
                                                    $total_product_receive_kh = $val->total_riel;
                                                    $total_product_receive_usd = abs($recieve_riel_with_limit_product_price / $val->rate);
                                                    $total_receive_riel += $total_product_receive_kh;
                                                    $total_receive_riel_text += $total_product_receive_kh / $val->rate;
                                                    $total_product_price += $total_product_receive_usd + $total_product_receive_kh / $val->rate;
                                                    $total_receive_dollar += $total_product_receive_usd;
                                                }
                                                // New Condition 2022-11-16
                                                // if កម្រិតនៃការលម្អៀងតូចជាង500រៀល
                                                //ករណីទទួលលុយខ្មែរផងABA SHOPផងតែខ្វះចន្លោះ៥០-៥០០៛
                                                if(abs($recieve_dollar_with_limit_product_price)*4100 < 500){
                                                    $total_product_receive_kh = $val->total_riel;
                                                    $total_receive_riel += $total_product_receive_kh;
                                                    $total_receive_riel_text += $total_product_receive_kh / $val->rate;
                                                    $total_product_price += $total_product_receive_kh / $val->rate;
                                                }
                                            }
                                        } elseif ($val->total_dollar > 0) {
                                            $recieve_dollar_with_limit_product_price = $val->total_dollar - $product_price;
                                            if ($recieve_dollar_with_limit_product_price >= 0) {
                                                $total_product_receive_kh = 0;
                                                $total_product_receive_usd = $product_price;
                                                $total_receive_riel += 0;
                                                $total_receive_riel_text += 0;
                                                $total_product_price += $total_product_receive_usd;
                                                $total_receive_dollar += $total_product_receive_usd;
                                            }
                                        }
                                    }
                                } elseif ($val->pay_to == 'delivery' || $val->pay_to == null) {
                                    if ($val->total_riel > 0) {
                                        $recieve_riel_with_limit_product_price = ($val->total_product_symbol == "$" ? $val->total_product * $val->rate : $val->total_product) - $val->total_riel;
                                        if ($recieve_riel_with_limit_product_price >= 0) {
                                            $recieve_dollar_with_limit_product_price = $val->total_dollar + $val->amount_pay_to - $recieve_riel_with_limit_product_price / $val->rate;
                                            if ($recieve_dollar_with_limit_product_price >= 0) {
                                                $total_product_receive_kh = $val->total_riel;
                                                $total_product_receive_usd = $recieve_riel_with_limit_product_price / $val->rate;
                                                $total_receive_riel += $val->total_riel;
                                                $total_receive_riel_text += $val->total_riel / $val->rate;
                                                $total_product_price += $total_product_receive_usd + $val->total_riel / $val->rate;
                                                $total_receive_dollar += $total_product_receive_usd;
                                            } else if ($recieve_dollar_with_limit_product_price < 0) {
                                                $total_product_receive_kh = $val->total_riel;
                                                $total_product_receive_usd =  0;
                                                $total_receive_riel += $val->total_riel;
                                                $total_receive_riel_text += $total_product_receive_usd + $val->total_riel / $val->rate;
                                                $total_product_price += $total_product_receive_usd + $val->total_riel / $val->rate;
                                                $total_receive_dollar += 0;
                                                // New Condition 2022-11-15
                                                // if កម្រិតនៃការលម្អៀងតូចជាង500រៀល
                                                //ករណីទទួលលុយខ្មែរផងដុល្លារផងតែខ្វះចន្លោះ៥០-៥០០៛
                                                if(abs($recieve_dollar_with_limit_product_price)*4100 < 500){
                                                    // dd(1);
                                                    $total_product_receive_usd =  $val->total_dollar;
                                                    $total_product_price +=  $val->total_dollar;
                                                    $total_receive_dollar +=  $total_product_receive_usd;
                                                }
                                            }
                                        }
                                        if ($recieve_riel_with_limit_product_price < 0) {
                                            $product_price = $val->total_product_symbol == "$" ? $val->total_product * $val->rate : $val->total_product;
                                            $total_product_receive_kh = $product_price;
                                            $total_receive_riel += $product_price;
                                            $total_receive_riel_text += $product_price / $val->rate;
                                            $total_product_price += $product_price / $val->rate;
                                        }
                                    } elseif ($val->total_dollar + $val->amount_pay_to > 0) {
                                        $total_paid_dollar = $val->total_dollar + $val->amount_pay_to;
                                        $product_price = $total_paid_dollar - $val->total_product / $val->total_product_rate;
                                        if ($product_price >= 0) {
                                            $total_product_receive_usd = $val->total_product / $val->total_product_rate;
                                            $total_product_price += $total_product_receive_usd;
                                            $total_receive_dollar += $total_product_receive_usd;
                                        }
                                        // New Condition
                                        // if កម្រិតនៃការលម្អៀងតូចជាង500រៀល
                                        else if($product_price <= 0 && abs($product_price)*4100 < 500){
                                            $total_product_receive_usd = $val->total_product / $val->total_product_rate;
                                            $total_product_price += $total_product_receive_usd;
                                            $total_receive_dollar += $total_product_receive_usd;
                                        }
                                    }
                                }
                            }
                            if ($val->status == 3)
                                if ($val->discount_type != null || $val->discount_type != '') {
                                    if ($val->discount_type == 1) {
                                        $delivery_fee = $val->discount;
                                    } elseif ($val->discount_type == 2) {
                                        $delivery_fee = ((100 - $val->discount) * $val->delivery_fee) / 100;
                                    } else {
                                        $delivery_fee = $val->delivery_fee;
                                    }
                                } else {
                                    $delivery_fee = $val->delivery_fee;
                                }
                            if ($val->delivery_status == 1) {
                                if ($val->delivery_pay_or_paid == 2) {
                                } else {
                                    if ($val->status == 3) {
                                        $total_all_service += $val->delivery_fee / $val->delivery_fee_rate;
                                        $service_taxi_fee = $delivery_fee / $val->delivery_fee_rate;
                                        $total_delivery_fee += $delivery_fee / $val->delivery_fee_rate;
                                    }
                                }
                            } else {
                                if ($val->status == 3) {
                                    $total_all_service += $val->delivery_fee / $val->delivery_fee_rate;
                                    if ($val->pay_to == 'shop' || $val->pay_to == 'ac_shop') {
                                        if ($val->amount_pay_to > $val->total_product) {
                                            $total_delivery_cus_fee += 0;
                                        } else {
                                            $total_delivery_cus_fee += $delivery_fee / $val->delivery_fee_rate;
                                        }
                                    } else {
                                        $total_delivery_cus_fee += $delivery_fee / $val->delivery_fee_rate;
                                    }
                                }
                            }

                            if ($val->taxi_status == 1) {
                                if ($val->taxi_pay_or_paid == 2) {
                                } else {
                                    if ($val->status == 3) {
                                        $total_all_service += $val->taxi_shop_fee / $val->taxi_fee_rate;
                                    }
                                }
                            } else {
                            }
                        }


                        if ($total_receive_dollar > 0) {
                            $total_receive_dollar = $total_receive_dollar;
                        } else {
                            $total_receive_dollar = $total_receive_dollar;
                        }
                        $payment = InvoicePaymentModel::find($data->id); 
                        $payment->pay_dollar = number_format(((((($total_receive_dollar) - $total_delivery_shop_fee) - $total_cus_fee_when_no_recive)-$total_taxi_fee)), 2);
                        $payment->pay_riel = $total_receive_riel;
                        $payment->save();
                        return '<p><span style="font-size: 15px;"  class="text-danger">' . '$' . number_format(((((($total_receive_dollar) - $total_delivery_shop_fee) - $total_cus_fee_when_no_recive)-$total_taxi_fee)), 2) . ' និង '.number_format(round($total_receive_riel, -2, PHP_ROUND_HALF_ODD), 0).' ៛</span></p>';
                    }
                    
                })

                ->addColumn('verify_by1', function ($data) {

                    if ($data->verify_by) {
                        return      $data->verify_by;
                    }
                    if (Gate::check('Verify Payment')) {
                        return      '<span class="class_' . $data->id . '"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="' . route("clear-invoice.update", $data->id) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > '; // '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                    }
                })


                ->addColumn('shop', function ($data) {
                    if ($data->shop_id == null) {
                        return '';
                    }
                    return @$data->shop->shop_name;
                })
                ->addColumn('account_usd', function ($data) {
                    return '<span>'.@$data->shop->account_name.'<br>'.@$data->shop->bank_account.'</span>';
                })
                ->addColumn('account_kh', function ($data) {
                    return '<span>'.@$data->shop->bank_name_kh.'<br>'.@$data->shop->bank_account_kh.'</span>';
                })
                ->addColumn('action', function ($data) {
                    $edit = '';
                    if (Gate::check('Payment')) {
                        $edit = '<a href="' . route("clear-invoice-new.show", $data->id) . '" class="btn_sm button_primary">' . __('administrator.show') . '</a> ';
                    }
                    if ($data->status !== 'paid') {
                        if (Gate::check('Payment')) {
                            $edit .=
                                '
                        <a href="#" class="btn_sm button_danger bt_done"  data-id="' . $data->id . '"  >' . __('administrator.paid') . '</a>
                       ';
                        }
                    }
                    return $edit;
                })
                ->rawColumns(['pay_amount','verify_by1','account_usd','account_kh','action'])

                ->addIndexColumn()
                ->make(true);
        }
        $merchant = User::where('user_type', 3)->where('status', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        return view('administrator.clear_inovice.index', compact('merchant'));
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
    }

    public function show($id)
    {
        $currency  = CurrencyModel::first();
        $data = DeliveryOrderDetailModel::join('nso007_invoice_payment', 'nso007_invoice_payment.id', 'nso007_delivery_order_detail.invoice_payment_id')
            ->select('nso007_delivery_order_detail.id', 'nso007_invoice_payment.invoice_payment', 'nso007_invoice_payment.from_date', 'nso007_invoice_payment.to_date')
            ->where('nso007_delivery_order_detail.invoice_payment_id', $id)
            ->get();
        $invoice    =  $data[0]->invoice_payment;
        $payment = InvoicePaymentModel::where('invoice_payment', $data[0]->invoice_payment)->first();
        $discount_daily = 0;
        if ($payment->discount_daily_id != null && $payment->discount_daily_id != '') {
            $discount_daily = DiscountDaliyModel::find($payment->discount_daily_id)->discount_amount;
        }

        $from_date  =  $data[0]->from_date;
        $to_date    =  $data[0]->to_date;
        $id_ = '';
        foreach ($data as $key => $value) {
            $id_ .= $data[$key]->id . ',';
        }

        $user = User::find($payment->shop_id);

        $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
            ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id');
        if (\Globals::check_lang() == 'en') {
            $data = $data->select(
                'nso007_export_stock.discount_id',
                'nso007_export_stock.location_name AS name_location',
                'nso007_export_stock.description',
                'nso007_export_stock.*',
                'nso007_export_stock.id As export_detail_id',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                // 'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                'nso007_export_stock_details.category_name',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
        } else {
            $data = $data->select(
                'nso007_export_stock.discount_id',
                'nso007_export_stock.location_name',
                'nso007_export_stock.*',
                'nso007_delivery_order_detail.status',
                'nso007_export_stock.id As export_detail_id',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_export_stock.description',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                // 'nso007_delivery_order_detail.status',
                'nso007_export_stock_details.category_name',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
        }
        $data = $data
            ->whereIn('nso007_delivery_order_detail.id', explode(',', $id_))
            ->orderBy('nso007_delivery_order.inovice', 'desc')
            ->groupBy('nso007_export_stock_details.export_id')
            ->groupBy('nso007_delivery_order_detail.delivery_order_id')
            ->get();

        return view('administrator.clear_inovice.show', compact('user', 'data', 'invoice', 'from_date', 'to_date', 'currency', 'discount_daily'));
    }
    public function pay_later($id)
    {

        $currency  = CurrencyModel::first();
        $data = DeliveryOrderDetailModel::join('nso007_invoice_payment', 'nso007_invoice_payment.id', 'nso007_delivery_order_detail.invoice_payment_id')
            ->select('nso007_delivery_order_detail.id', 'nso007_invoice_payment.invoice_payment', 'nso007_invoice_payment.from_date', 'nso007_invoice_payment.to_date')
            ->where('nso007_delivery_order_detail.invoice_payment_id', $id)
            ->get();
        $invoice_payment  = $data[0]->invoice_payment;
        $id_ = '';
        foreach ($data as $key => $value) {
            $id_ .= $data[$key]->id . ',';
        }

        InvoicePaymentModel::where('id', $id)->update(['status' => 'paid', 'paid_date' => date('Y-m-d H:i:s'), 'paid_by' => \Auth::user()->name]);
        DeliveryOrderDetailModel::where('invoice_payment_id', $id)->update(['status_paid' => 'paid']);
        DeliveryOrderDetailCancelModel::where(function ($query)  use ($id) {
            $query->where('invoice_payment_id', $id)->update(['status_paid' => 'paid']);
        });

        DeliveryOrderDetailSuccessModel::where(function ($query)  use ($id) {
            $query->where('invoice_payment_id', $id)->update(['status_paid' => 'paid']);
        });
        return redirect()->back()->with('success', 'Driver created successfully');
    }

    function export_to_excel()
    {

        return view('administrator.clear_inovice.excel')->render();
    }

    public function update(Request $request, $id)
    {
        $auth = \Auth::user();
        try {
            DB::beginTransaction();
            $data = InvoicePaymentModel::find($id);

            $data->verify_by  = $auth->name;
            $data->update();

            DB::commit();
            return response()->json(['success' => 200, 'class' => 'class_' . $id, 'verify_by' => $auth->name]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw ValidationException::withMessages(['field_name' => 'ERRER SERVER']);
        }
    }
    public function export_excel(Request $request){
        if(!$request->export_excel){
            $shop_id = $request->shop_id??'';
            $status = $request->status;
            $verify = $request->verify;
            $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
            $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
            $per_page = $request->per_page??100;
            $data = InvoicePaymentModel::with(['create_by:id,name','shop:id,shop_name,bank_account,bank_account_kh,bank_name_kh,name as account_name'])
                            ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.invoice_payment_id','nso007_invoice_payment.id')
                            ->select('nso007_invoice_payment.*')
                            ->when($shop_id,function($q) use($shop_id){
                                $q->where('nso007_invoice_payment.shop_id',$shop_id);
                            })
                            ->when($from_date&&$to_date,function($q) use($from_date,$to_date){
                                $q->whereBetween('nso007_invoice_payment.date',[$from_date,$to_date]);
                            })
                            ->when($verify, function ($q, $verify) {
                                if ($verify == 'verify') {
                                    $q->whereNotNull('nso007_invoice_payment.verify_by');
                                } else {
                                    $q->whereNull('nso007_invoice_payment.verify_by');
                                }
                            })
                            ->where(function ($query) use ($status) {
                                if ($status  == 'pay') {
                                    $query->whereNull('nso007_invoice_payment.status');
                                } else {
                                    $query->where('nso007_invoice_payment.status', 'paid');
                                }
                            })
                            ->where('nso007_delivery_order_detail.status', '!=', 7)
                            ->groupBy('nso007_invoice_payment.id')
                            ->orderBy('nso007_invoice_payment.id', 'desc')
                            ->take($per_page);  
            return response()->json([
                'success'=>true,
                'view'=>view('administrator.clear_inovice.preview-excel',compact('data'))->render()
            ]);
        }
        return Excel::download(new PaymentExport($request), 'Report-'.date('d-m-Y').'.xlsx');
    }
}
