<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\CategoryModel;
use App\CurrencyModel;
use App\DiscountModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use App\RequestPendingPickup;
use App\RequestPickup;
use App\RequestPickupDetailModel;
use DB;
use Auth;
use Illuminate\Support\Facades\Response;
use App\User;
use Yajra\DataTables\Facades\DataTables;

class AssignToDriverController1 extends Controller
{
    function __construct()
    {

        $this->middleware('permission:PickUp Assign to Driver', ['only' => ['create']]);
        $this->middleware('permission:PickUp List', ['only' => ['list_pickup']]);
        // $this->middleware('permission:PickUp Create', ['only' => ['store']]);
        $this->middleware('permission:PickUp Action', ['only' => ['edit','update','box_pickup_delete_main','assign_to_order','assign_driver_pickup','box_pickup_edit']]);
        $this->middleware('permission:Report Pickup', ['only' => ['history_pickup']]);
    }
    public function create(Request $request)
    {
        $driver = User::where('user_type', 2)->where('status', 1)->pluck('name', 'id')->prepend(__('administrator.driver_name'), '')->toArray();
        $merchant = User::where('user_type', 3)->where('status', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $category = CategoryModel::where('status', 1);
        $from_location = LocationModel::where('status', 1)->where('pearent_id', null);
        $location = LocationModel::where('status', 1)->where('pearent_id', '!=', null);
        $bus = \DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();
        $exchang_rate = CurrencyModel::find(1);
        if (\Globals::check_lang() == 'en') {
            $from_location = $from_location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
            $category =  $category->select('nso007_category.*', 'nso007_category.name_en AS category_name')->paginate(18);
        } else {
            $category =  $category->select('nso007_category.*', 'nso007_category.name_km AS category_name')->paginate(18);
            $from_location = $from_location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        }
        $pickup = RequestPickup::join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->select(
                'nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'shop.phone AS phone_shop',
                'driver.name AS driver_name'
            )
            ->where('nso007_request_pickup.status', '!=', 4) 
            ->groupBy('nso007_request_pickup.id')
            ->groupBy('nso007_request_pickup.date')
            ->orderBy('nso007_request_pickup.id', 'desc')
            ->get(); 
        if ($request->ajax()) {
            return view("administrator.pick-up.result-view-category", compact('category'));
        }
        return view('administrator.pick-up.create', compact('category', 'from_location', 'location', 'merchant', 'bus', 'exchang_rate', 'pickup', 'driver', 'exchang_rate'));
    }
    public function store(Request $request)
    {
        $last_id = RequestPickup::where('invoice_pickup', '!=', 'null')
            ->where('invoice_pickup', '!=', '')
            ->orderBy('invoice_pickup', 'desc')
            ->first();
        $header_invoice = BranchModel::first();

        if ($last_id) {

            $box_code = $last_id->invoice_pickup;
            $tran_num = substr($box_code, 3);
            $increas = $header_invoice->header_invoice_pickup . sprintf('%08d', ($tran_num + 1));
        } else {

            $increas = $header_invoice->header_invoice_pickup . '00000001';
        }

        $data = new RequestPickup;
        $data->invoice_pickup       =  $increas;
        $data->merchant_id          =  $request->merchant;
        $data->date                 =  date('Y-m-d', strtotime($request->date));
        $data->driver_pick_up_id    =  $request->driver_id;
        $data->exchange_rate        =  $request->exchange_rate;
        $data->status               = 2;
        $data->type                 = $request->type;
        $data->description          = $request->description;
        $data->save();
        return redirect()->back();
    }
    public function show($id)
    {
        $exchang_rate = CurrencyModel::find(1);
        $currency  = $exchang_rate->currency_exchange_to;

        $data = RequestPickup::join('nso007_request_pickup_detail', 'nso007_request_pickup_detail.request_pickup_id', 'nso007_request_pickup.id')
            ->join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->join('nso007_location', 'nso007_request_pickup_detail.location_id', 'nso007_location.id')
            ->join('nso007_category', 'nso007_request_pickup_detail.category_id', 'nso007_category.id')

            ->select(
                'nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
            )
            ->where('request_pickup_id', $id)
            ->orderBy('nso007_request_pickup.id', 'desc')
            ->get();

        $master = RequestPickup::join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->select(
                'nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name'
            )
            ->find($id);
        // dd($master);
        return view('administrator.assign-driver.show', compact('currency', 'data', 'master'));
    }
    public function box_pickup_edit(Request $request)
    {
        $data = RequestPickup::join('nso007_request_pickup_detail', 'nso007_request_pickup_detail.request_pickup_id', 'nso007_request_pickup.id')
            ->join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->join('nso007_location', 'nso007_request_pickup_detail.location_id', 'nso007_location.id')
            ->join('nso007_category', 'nso007_request_pickup_detail.category_id', 'nso007_category.id')

            ->select(
                'nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
            )
            ->where('request_pickup_id', $request->id)
            ->orderBy('nso007_request_pickup.id', 'desc')
            ->get();
        // dd($data);
        echo json_encode($data);
    }

    public function box_pickup_show_list(Request $request)
    {
        $data = RequestPickup::join('nso007_request_pickup_detail', 'nso007_request_pickup_detail.request_pickup_id', 'nso007_request_pickup.id')
            ->join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->join('nso007_location', 'nso007_request_pickup_detail.location_id', 'nso007_location.id')
            ->join('nso007_category', 'nso007_request_pickup_detail.category_id', 'nso007_category.id')

            ->select(
                'nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
            )
            ->where('request_pickup_id', $request->id)
            ->orderBy('nso007_request_pickup.id', 'desc')
            ->get();
        echo json_encode($data);
    }
    public function assign_driver_pickup(Request $request)
    {

        $last_id = RequestPickup::where('invoice_pickup', '!=', 'null')
            ->where('invoice_pickup', '!=', '')
            ->orderBy('invoice_pickup', 'desc')
            ->first();
        $header_invoice = BranchModel::first();

        if ($last_id) {

            $box_code = $last_id->invoice_pickup;
            $tran_num = substr($box_code, 3);
            $increas = $header_invoice->header_invoice_pickup . sprintf('%08d', ($tran_num + 1));
        } else {

            $increas = $header_invoice->header_invoice_pickup . '00000001';
        }
        $data = RequestPickup::where('id', $request->list_id_1)->first();
        if ($data->invoice_pickup == null && $data->invoice_pickup == '') {

            RequestPickup::where('id', $request->list_id_1)->update(['driver_pick_up_id' => $request->driver, 'status' => 2, 'invoice_pickup' => $increas]);
        } else {
            RequestPickup::where('id', $request->list_id_1)->update(['driver_pick_up_id' => $request->driver, 'status' => 2]);
        }
        return $last_id;
    }

    public function assign_to_order($id)
    {
        $data = RequestPickup::join('nso007_request_pickup_detail', 'nso007_request_pickup_detail.request_pickup_id', 'nso007_request_pickup.id')
            ->join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->join('nso007_location', 'nso007_request_pickup_detail.location_id', 'nso007_location.id')
            ->join('nso007_category', 'nso007_request_pickup_detail.category_id', 'nso007_category.id')
            ->select(
                'nso007_request_pickup_detail.*',
                'nso007_request_pickup.exchange_rate',
                'nso007_request_pickup.invoice_pickup',
                'shop.shop_name AS shop_name',
                'shop.id AS merchant_id',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
            )
            ->where('request_pickup_id', $id)
            ->orderBy('nso007_request_pickup.id', 'desc')
            ->get();
 
        foreach ($data as $key => $value) {
            $increas = '';
            $last_id = ExportStockModel::max('id');
            $header_invoice = BranchModel::first();

            if ($last_id) {
                $box_code = ExportStockModel::select('box_code')->get()->last();
                $tran_num = substr($box_code->box_code, 3);
                $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
            } else {
                $increas = $header_invoice->header_invoice_import . '00000001';
            }
            $exportstock = new ExportStockModel();

            
            $exportstock->invoice_reference     = $value->invoice_pickup;
            $exportstock->merchant_id           = $value->merchant_id;
            $exportstock->box_code              = $increas;
            $exportstock->export_date           = date('Y-m-d');
            $exportstock->delivery_fee          = $value->delivery_fee;
            $exportstock->delivery_status       = $value->delivery_status;
            $exportstock->from_location         = isset($value->zoon_id) ? $value->zoon_id : '';
            $exportstock->location              = $value->location_id;
            $exportstock->customer_receive      = $value->customer_receive;
            $exportstock->delivery_option       = $value->delivery_option;
            $exportstock->created_by            = Auth::user()->id;
            $exportstock->description           = $value->description;
            $exportstock->taxi_number           = $value->taxi_number;
            $exportstock->type_of_stock         = 2; //Out stock
            if ($exportstock->save()) {
                $exportstockdetails = new ExportStockdetailsMode();
                $exportstockdetails->export_id          = $exportstock->id;
                $exportstockdetails->barcode            = $increas;
                $exportstockdetails->currency           = $value->exchange_rate;
                $exportstockdetails->export_qty         = 1;
                $exportstockdetails->price              = $value->price;
                $exportstockdetails->category_id        = $value->category_id;
                $exportstockdetails->save();
            }
        }
        RequestPickup::where('id', $id)->update(['status' => 4]);
        return redirect()->back();
    }

    public function go_to_order($id,$status)
    {
      
       
        $data = RequestPickup::join('nso007_request_pickup_detail', 'nso007_request_pickup_detail.request_pickup_id', 'nso007_request_pickup.id')
            ->join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->join('nso007_location', 'nso007_request_pickup_detail.location_id', 'nso007_location.id')
            ->join('nso007_category', 'nso007_request_pickup_detail.category_id', 'nso007_category.id')
            ->select(
                'nso007_request_pickup_detail.*',
                'nso007_request_pickup.exchange_rate',
                'nso007_request_pickup.invoice_pickup',
                'shop.shop_name AS shop_name',
                'shop.id AS merchant_id',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
            )
            ->where('request_pickup_id', $id)
            ->orderBy('nso007_request_pickup.id', 'desc')
            ->get(); 
            $discount = DiscountModel::where('date',date('Y-m-d'))->first();  
            
        foreach ($data as $key => $value) {
            $increas = '';
            $last_id = ExportStockModel::max('id');
            $header_invoice = BranchModel::first();
            if ($last_id) {
                $box_code = ExportStockModel::select('box_code')->get()->last();
                $tran_num = substr($box_code->box_code, 3);
                $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
            } else {
                $increas = $header_invoice->header_invoice_import . '00000001';
            }


            RequestPickupDetailModel::whereId($value->id)->update(['box_code'=> $increas]); 
            $exportstock = new ExportStockModel(); 

            if( $discount ){ 
                $arra_  =  explode(',', $discount->shop_id); 
                if (in_array($value->merchant_id, $arra_)) {
                    $exportstock->discount_id  = $discount->id; 
                }    
            }   


            $exportstock->invoice_reference     = $value->invoice_pickup;
            $exportstock->merchant_id           = $value->merchant_id;
            $exportstock->box_code              = $increas;
            $exportstock->export_date           = date('Y-m-d');
         
            $exportstock->customer_receive      = $value->customer_receive;
            $exportstock->delivery_option       = $value->delivery_option;
            $exportstock->created_by            = Auth::user()->id;
            $exportstock->description           = $value->description;
            $exportstock->date_delivery         = $value->date_delivery; 

            $exportstock->from_location         = isset($value->zoon_id) ? $value->zoon_id : '';
            $exportstock->location              = $value->location_id;
    
            $exportstock->taxi_cust_fee         = $value->taxi_cust_fee; 
            $exportstock->taxi_shop_fee         = $value->taxi_shop_fee; 
            $exportstock->taxi_status           = $value->taxi_status; 
            $exportstock->taxi_number           = $value->taxi_number;
            $exportstock->taxi_pay_or_paid      = $value->taxi_pay_or_paid;
             
            $exportstock->delivery_pay_or_paid  = $value->delivery_pay_or_paid; 
            $exportstock->delivery_status       = $value->delivery_status;
            $exportstock->delivery_fee          = $value->delivery_fee;
             
            $exportstock->other_services_fee            = $value->other_services_fee;
            $exportstock->other_services_pay_or_paid    =$value->other_services_pay_or_paid;
            $exportstock->other_services_type           = $value->other_services_type; 
            $exportstock->type_of_stock         = 2; //Out stock


            if ($exportstock->save()) {
                $exportstockdetails = new ExportStockdetailsMode();
                $exportstockdetails->export_id          = $exportstock->id;
                $exportstockdetails->barcode            = $increas;
                $exportstockdetails->currency           = $value->exchange_rate;
                $exportstockdetails->export_qty         = 1;
                $exportstockdetails->price              = $value->price;
                $exportstockdetails->category_id        = $value->category_id;
                $exportstockdetails->save();
            }
        }
  
       
        RequestPickup::where('id', $id)->update(['status' => 4]);

        if($status == 1){
            return redirect()->back();
        }else{
            return redirect()->route('delivery-order.create');

        }
    

    }
    
    public function box_pickup_done(Request $request)
    {

        $reqdetail  = RequestPickup::where('id', $request->id)->update(['status' => 3]);
        return $reqdetail;
    }
    public function box_pickup_delete(Request $request)
    {

        $reqdetail = RequestPickupDetailModel::where('id', '=', $request->id)->delete();
        return $reqdetail;
    }
    public function box_pickup_delete_main(Request $request)
    {  
     
        RequestPickup::where('id', $request->id)->delete();
        RequestPickupDetailModel::where('request_pickup_id', '=', $request->id)->delete();
        $data = "";
        return $data;
    }

    public function find_location(Request $request)
    {
        $location = LocationModel::where('status', 1)->where('pearent_id', $request->id)->get();
        return $location;
    }

    public function find_price_location(Request $request)
    {
        $data = LocationModel::find($request->id);
        $price = $data->price;
        return $price;
    }

    public function update(Request $request)
    {
      
        
        $status = '';
        if (isset($request->request_pickup_id)) {
            DB::table('nso007_request_pickup_detail')->where('request_pickup_id', $request->request_pickup_id)->delete();
            foreach ($request->customer_receive as $key => $value) {
                $mpp = new RequestPickupDetailModel(); 
                $mpp->customer_receive     = $request->customer_receive[$key];
                $mpp->zoon_id               = $request->from_location[$key];
                $mpp->location_id           = $request->location[$key];
                $mpp->delivery_fee          = $request->delivery_fee[$key];
                $mpp->delivery_pay_or_paid          = $request->delivery_pay_or_paid[$key];
                $mpp->price                 = $request->price[$key];
                $mpp->delivery_status       = $request->delivery_status[$key];
                $mpp->category_id           = $request->category_id[$key];
                $mpp->request_pickup_id     = $request->request_pickup_id;
                $mpp->taxi_number           = $request->taxi_number[$key];
                $mpp->description           = $request->description[$key];
                $mpp->date_delivery         = date('Y-m-d', strtotime($request->date_delivery[$key])); 
                $mpp->delivery_option       = $request->delivery_option[$key]; 
                $mpp->taxi_status       = $request->taxi_status[$key]; 
                if($request->delivery_option[$key] != 'No'){
                    if($request->taxi_status[$key] ==1 ){   //shop 
                        $mpp->taxi_shop_fee       = $request->taxi_fee[$key]; 
                    }
                    else{
                        $mpp->taxi_cust_fee       = $request->taxi_fee[$key];  
                    }
                } 
                $mpp->taxi_pay_or_paid       = $request->taxi_pay_or_paid[$key];
                $mpp->other_services_fee       = $request->other_services_fee[$key];
                $mpp->other_services_type       = $request->other_services_type[$key];
                $mpp->other_services_pay_or_paid       = $request->other_services_pay_or_paid[$key]; 
                $mpp->user_id               = \Auth::user()->id;  
                
                $mpp->save();
            }
            $status  = 'success';
        } else {
            $status  = 'not success';
        }
        return $status;
    }

    public function list_pickup(Request $request)
    {
        $data = RequestPickup::join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->select(
                'nso007_request_pickup.id AS pickup_id',
                'nso007_request_pickup.date',
                'shop.shop_name',
                'driver.name as driver_name',
                'nso007_request_pickup.id',
                'nso007_request_pickup.invoice_pickup',
                'nso007_request_pickup.description',
                'nso007_request_pickup.updated_at',
                'nso007_request_pickup.type'
                // 'nso007_request_pickup.type as type_of_pickup',
            )
            ->where('nso007_request_pickup.status', '!=', 1)
            ->where('nso007_request_pickup.status', '!=', 2)
            ->get();

        if ($request->ajax()) {
            if ($request->isMethod('get')) {
                return DataTables::of($data)
                    ->editColumn('count_', function ($data) {
                        $count_  = RequestPickupDetailModel::where('request_pickup_id', $data->id)->count();
                        return   $count_;
                    })
                    ->editColumn('date', function ($data) {
                        return date('d-m-Y', strtotime($data->date));
                    })

                    ->editColumn('status', function ($data) {
                        $status = '';
                        if ($data->type == 1) {
                            return $status = 'Out-Stock';
                        } else if ($data->type == 2) {
                            return $status = 'Import Stock';
                        } else if ($data->type == 3) {
                            return $status = 'Export-stock';
                        }
                        // return $data->type."dd  ";
                    })
                    ->editColumn('driver_pick_up_id', function ($data) {
                        return $data->id;
                    })
                    ->editColumn('driver_pick_up_id', function ($data) {
                        return $data->id;
                    }) 
                    ->editColumn('action', function ($data) {
                        
                        $action = '';
                        if(date('Y-m-d H:i:s') <= date('Y-m-d H:i:s', strtotime("+1 day", strtotime($data->updated_at)) )&& $data->status != 4 ){
                            $action = '
                                <label class="btn btn-info btn-xs bt_delete_main"  data-pickup_id="'.$data->pickup_id.'" ><span class="fa fa-trash">   </span></label>
                            ';
                        }
                        return    $action ;
                    })

                    ->rawColumns(['status' => 'status','action'=>'action'])
                    ->addIndexColumn()
                    ->make(true);
            }
        }
        // dd($data );
        return view('administrator.pick-up.list_pickup');
    }

    public function history_pickup()
    {
        $shop_name = RequestPickup::join('users', 'users.id', 'nso007_request_pickup.merchant_id')
            ->select('users.shop_name as shop_name', 'users.id as id')
            ->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $drivers = User::where('user_type', 2)->where('status', 1)->pluck('name', 'id')->prepend(__('administrator.please_select'), '')->toArray();

        return view('administrator.pick-up.history_pickup', compact(['shop_name','drivers']));
    }
    public function search_history_pickup(Request $request)
    {
        // dd($request);
        $from_date  = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date    = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $merchant   = isset($request->drivers) ? $request->drivers : null;
        $datas = RequestPickup::join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->select(
                'nso007_request_pickup.date',
                'shop.shop_name',
                'driver.name as driver_name',
                'nso007_request_pickup.id',
                'nso007_request_pickup.invoice_pickup',
                'nso007_request_pickup.description',
                'nso007_request_pickup.type'
            )

            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_request_pickup.date', [$from_date, $to_date]);
                }
            })
            ->where(function ($query) use ($merchant) {
                if (!empty($merchant)) {
                    $query->where('nso007_request_pickup.driver_pick_up_id', $merchant);
                }
            })

            ->where('nso007_request_pickup.status', '!=', 1)
            ->where('nso007_request_pickup.status', '!=', 2)
            ->get();

        $search = '<tbody class="tbody">';
        $index = 1;
        $status = '';
        foreach ($datas as $data) {
            if ($data->type == 1) {
                $status = 'Out-Stock';
            } else if ($data->type == 2) {
                $status = 'Import Stock';
            } else if ($data->type == 3) {
                $status = 'Export-stock';
            }
            $search .= '<tr role="row" class="old">';
            $search .= '<td>' . $index++ . '</td>';
            $search .= '<td>' . date('d-m-Y', strtotime($data->date)) . '</td>';
            $search .= '<td>' . $data->shop_name . '</td>';
            $search .= '<td>' . $count_  = RequestPickupDetailModel::where('request_pickup_id', $data->id)->count() . '</td>';
            $search .= '<td>' . $data->description . '</td>';
            $search .= '<td>' . $data->driver_name . '</td>';
            $search .= '<td>' . $data->invoice_pickup . '</td>';
            $search .= '<td>' . $status . '</td>';
            $search .= '<tr>';
        }
        $search .= '</tbody>';
        return response()->json(['search' => $search]);
    }

    public function history_pickup_print(Request $request)
    {
        $from_date  = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date    = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $drivers   = isset($request->drivers) ? $request->drivers : null;
        $datas = RequestPickup::join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')
            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->select(
                'nso007_request_pickup.date',
                'shop.shop_name',
                'driver.name as driver_name',
                'nso007_request_pickup.id',
                'nso007_request_pickup.invoice_pickup',
                'nso007_request_pickup.description',
                'nso007_request_pickup.type'
            )

            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_request_pickup.date', [$from_date, $to_date]);
                }
            })
            ->where(function ($query) use ($drivers) {
                if (!empty($drivers)) {
                    $query->where('nso007_request_pickup.driver_pick_up_id', $drivers);
                }
            })
            ->whereIn('nso007_request_pickup.status', [3, 4])
            ->get();


            $data = RequestPickupDetailModel::
                join('nso007_request_pickup','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
            ->join('users AS shop', 'shop.id', 'nso007_request_pickup.merchant_id')

            ->leftJoin('users AS driver', 'driver.id', 'nso007_request_pickup.driver_pick_up_id')
            ->select(
                'nso007_request_pickup.date',
                'shop.shop_name',
                'driver.name as driver_name',
                'nso007_request_pickup.id',
                'nso007_request_pickup.invoice_pickup',
                'nso007_request_pickup.description',
                'nso007_request_pickup.type'
            )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_request_pickup.date', [$from_date, $to_date]);
                }
            })
            ->where(function ($query) use ($drivers) {
                if (!empty($drivers)) {
                    $query->where('nso007_request_pickup.driver_pick_up_id', $drivers);
                }
            })
            ->whereIn('nso007_request_pickup.status', [3, 4])
            ->get();

        return view('administrator.pick-up.history_pickup_print', compact(['data','datas', 'from_date', 'to_date']));
    }

    public function assign_show( Request $request){
        $data = RequestPickup::
        join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')

        ->select('nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
        )
        ->where('request_pickup_id',$request->driver_pick_up_id)
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();
        // dd($data );
        echo json_encode($data);

    }

    
}
