<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use DataTables;
use Illuminate\Support\Facades\Crypt;

class RoleController extends Controller
{
    function __construct()
    {
        // $this->middleware('permission:Roles List', ['only' => ['index']]);
        // $this->middleware('permission:Roles Create', ['only' => ['create', 'store']]);
        // $this->middleware('permission:Roles Edit', ['only' => ['edit', 'update']]);
    }

    public function index()
    {
        $data = Role::where('branch_id', \Auth::user()->branch_id)->get();
        return view('administrator.roles.index', compact('data'));
    }

    public function create()
    {
        $permission = Permission::get();
        $group_name = Permission::groupBy('group_name')
            ->get('group_name');
        return view('administrator.roles.create', compact('permission','group_name'));
    }
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            $this->validate($request, [
                'name' => 'required',
                'permission' => 'required',

            ]);

            $role = Role::create([
                'name' => $request->input('name'),
                'branch_id' => \Auth::user()->branch_id,
            ]);
            $role->syncPermissions($request->input('permission'));
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger', $e->getMessage());
        }
        return redirect()->back()
            ->with('success', 'Role created successfully !');
    }


    public function show($id)
    {
        $decrypt_id = Crypt::decrypt($id);
        $role = Role::find($decrypt_id);
        $rolePermissions = Permission::join("role_has_permissions", "role_has_permissions.permission_id", "=", "permissions.id")
            ->where("role_has_permissions.role_id", $decrypt_id)
            ->get();
        return view('administrator.roles.show', compact('role', 'rolePermissions'));
    }

    public function edit($id)
    {
        $role = Role::find($id);
        $permission = Permission::get();
        $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id", $id)
            ->pluck('role_has_permissions.permission_id', 'role_has_permissions.permission_id')
            ->all();
        
        $group_name = Permission::groupBy('group_name')
            ->whereNull('sub_group')
            ->get('group_name');
        return view('administrator.roles.edit', compact('role', 'permission', 'rolePermissions','group_name'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'permission' => 'required',
        ]);
        $role = Role::find($id);
        $role->update(['name' => $request->input('name')]);
        $role->syncPermissions($request->input('permission'));
        return redirect()->route('roles.index')
            ->with('success', 'Role updated successfully !');
    }

    public function destroy($id)
    {
        DB::table("roles")->where('id', $id)->delete();
        return redirect()->route('roles.edit')
            ->with('success', 'Role deleted successfully');
    }
}
