<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\ProductModel;
use App\CategoryModel;
use Image;
use Illuminate\Support\Facades\Crypt;
use DB;
use Gate;
use Hash;
use App\LocationModel;
use App\User;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\DataTables;
class ProductsController extends Controller
{
    function __construct()
    {
        // $this->middleware('permission:Product List', ['only' => ['index']]);
        // $this->middleware('permission:Product Create', ['only' => ['create','store']]);
        // $this->middleware('permission:Product Edit', ['only' => ['edit','update']]);
        // $this->middleware('permission:Product Delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {   
        if ($request->ajax()) {
            $query = ProductModel::where('nso007_products.status', 1) ->join('nso007_category', 'nso007_category.id', 'nso007_products.category_id');

            if (\Globals::check_lang() == 'en') {
                $product = $query->select(
                    'nso007_products.id',
                    'nso007_products.name_en as product_name',
                    'nso007_products.price',
                    'nso007_products.barcode',
                    'nso007_products.image',
                    'nso007_products.category_id',
                    'nso007_category.name_en AS category_name'
                )
                                ->get();
            } else {
                $product = $query->select('nso007_products.id', 'nso007_products.name_km as product_name', 'nso007_products.price', 'nso007_products.barcode', 'nso007_products.image', 'nso007_products.category_id', 'nso007_category.name_km AS category_name')
                                ->get();
            }

            return  Datatables::of($product)
        ->editColumn('image', function ($product) {
            $path = "images/upload/" . $product->image;
                    $full_path = File::exists($path) ?  $path : 'images/default.jpg';
                    return '<img src="/' . $full_path . '" alt="" width="35px" height="35px">';
        })
        ->editColumn('price', function ($product) {
            return '$'. number_format($product->price);
        })
        ->addColumn('action', function ($product) {
            $edit ='';
            $delete ='';
            $print = '';
            if (Gate::check('Edit Product')) {
                $edit = '
                <a href="'. route("product.edit", $product->id) . '" class="button_sm  button_primary ">'.__('administrator.edit').'</a>
                ';
            }
            if (Gate::check('Delete Product')) {
                $delete = '<a class="button_info delete_product " data-id="'.$product->id.'"  >'. __('administrator.delete').'</a>';
            }
            if (Gate::check('Print Product')) {
                $print = '<a data-toggle="tooltip" data-placement="top" title="Print" class="btn btn-primary btn-sm" href="'. route("product.show", Crypt::encrypt($product->id)) . '"><span class="fa fa-print"></span></a>';
            }
            return $print.$edit.$delete;
        })

        ->rawColumns(['image'=>'image'])
        ->addIndexColumn()
        ->make(true);
        }
        return view('administrator.product.index');
    }
    public function getProduct(){

        $query = ProductModel::where('nso007_products.status',1) ->join('nso007_category','nso007_category.id','nso007_products.category_id');

        if(\Globals::check_lang() == 'en'){
            $product = $query->select('nso007_products.id','nso007_products.name_en as product_name','nso007_products.price',
                                 'nso007_products.barcode','nso007_products.image','nso007_products.category_id','nso007_category.name_en AS category_name' )
                                ->get();

        }else{
            $product = $query->select('nso007_products.id','nso007_products.name_km as product_name','nso007_products.price'
                                ,'nso007_products.barcode','nso007_products.image','nso007_products.category_id','nso007_category.name_km AS category_name' )
                                ->get();
        }

        return  Datatables::of($product)
        ->editColumn('image', function ($product) {
            $barcode_img =asset("/images/upload/$product->image");
            return  '<img class="img-detail zoom" src="'.$barcode_img.'" width="40">';
        })
        ->editColumn('price', function ($product) {
            return '$'. number_format($product->price);
        })
        ->addColumn('action', function($product) {

            $edit ='';
            $delete ='';

            if (Gate::check('Product Edit')) {
                $edit = '
                <a href="'. route("product.edit", $product->id) . '" class="button_sm  button_primary ">'.__('administrator.edit').'</a>
                ';
            }
            if (Gate::check('Product Delete')) {
                  $delete = '<a class="button_info delete_product " data-id="'.$product->id.'"  >'. __('administrator.delete').'</a>';

            }

            return '
                    <a data-toggle="tooltip" data-placement="top" title="Print" class="btn btn-primary btn-sm" href="'. route("product.show", Crypt::encrypt($product->id)) . '"><span class="fa fa-print"></span></a>

                    '.$edit.''.$delete;
            })

        ->rawColumns(['image'=>'image'])
        ->addIndexColumn()
        ->make(true);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $categories = CategoryModel::where('status',1)->pluck('category_name', 'id')->prepend('Please Select', '')->toArray();

        if(\Globals::check_lang() == 'en'){
            $categories = CategoryModel::where('status',1)->pluck('name_en', 'id')->prepend('Please Select', '')->toArray();
        }else{
            $categories = CategoryModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select', '')->toArray();
        }
        $shop = User::where('user_type',3)
            ->where('type_of_merchant',1)
            ->pluck('shop_name','id');

        return view('administrator.product.create',compact('categories','shop'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
			'name_en' 	=> 'required|unique:nso007_products,name_en',
			'name_km' 	=> 'required|unique:nso007_products,name_km',
			'barcode' 	=> 'required|unique:nso007_products,barcode',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',

        ]);
        $gallery = '';

        if($files = $request->file('image')){

            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload';
            $files->move($destinationPath, $original_name);
            $gallery = $original_name;
        }else{
            $gallery = 'default.jpg';
        }

        $product = new ProductModel;

        $product->image                 = $gallery;
        $product->category_id           = $request->category_id;
        $product->name_en               = $request->name_en;
        $product->name_km               = $request->name_km;
        $product->barcode               = $request->barcode;
        $product->price                 = $request->price;
        $product->shop_id               = implode(',',$request->shop_id);
        $product->save();
        return redirect()->route('product.index')
        ->with('success','Barcode created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $decrypt_id = Crypt::decrypt($id);
        $products = ProductModel::where('nso007_products.id',$decrypt_id) ->join('nso007_category','nso007_category.id','nso007_products.category_id');
            if(\Globals::check_lang() == 'en'){
                $products = $products->select('nso007_products.id','nso007_products.name_en AS products_name','nso007_products.price',
                'nso007_products.barcode','nso007_products.image','nso007_products.category_id','nso007_category.name_en AS category_name')
                                 ->first();
            }else{
                $products = $products->select('nso007_products.id','nso007_products.name_km AS products_name','nso007_products.price',
                'nso007_products.barcode','nso007_products.image','nso007_products.category_id','nso007_category.name_km AS category_name')
                                 ->first();
            }

        return view('administrator.product.show',compact('products'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = ProductModel::find($id);
        if(\Globals::check_lang() == 'en'){
            $categories = CategoryModel::where('status',1)->pluck('name_en', 'id')->prepend('Please Select', '')->toArray();
        }else{
            $categories = CategoryModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select', '')->toArray();
        }
        $shop = User::where('user_type',3)
            ->where('type_of_merchant',1)
            ->pluck('shop_name','id');
        $array_shop = explode(',',$data->shop_id);
        return view('administrator.product.edit',compact('data','array_shop','categories','shop'));



    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
			'name_en' 	=> 'required|unique:nso007_products,name_en,'.$id,
			'name_km' 	=> 'required|unique:nso007_products,name_km,'.$id,
			'barcode' 	=> 'required|unique:nso007_products,barcode,'.$id,
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);
        $gallery​ = '';
        if($files = $request->file('avartar')){
            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload';
            $files->move($destinationPath, $original_name);
            $gallery= $original_name;
        }else{
            $gallery = $request->arrayImg;
        }

        $product = ProductModel::find($id);
        $product->image                 = $gallery;
        $product->category_id           = $request->category_id;
        $product->name_en               = $request->name_en;
        $product->name_km               = $request->name_km;
        $product->barcode               = $request->barcode;
        $product->price                 = $request->price;
        $product->shop_id               = implode(',',$request->shop_id);

        $product->save();
        return redirect()->route('product.index') ->with('success','User updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $product = ProductModel::find($request->id);
        $product->status  =   2;
        $product->update();
        $data="success";
        echo json_encode($data);
    }

}
