<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\DeliveryOrderModel;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoiceModel;
use App\User;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class PaymentController extends Controller
{
    public function index()
    {
        return view('administrator.payment.index',compact( 'merchant'));
    }

    public function create()
    {

        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        return view('administrator.payment.create',compact( 'merchant'));
    }
    public function datatable_payment(Request $request)
    {
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $data           =   $this->data_payment($from_date,$to_date,$status,$merchant);

        if ($request->isMethod('get')){
            return DataTables::of($data)

            ->editColumn('delivery_date', function($data) {
                return date('d-m-Y',strtotime($data->delivery_date));
            })


            ->editColumn('reason', function ($data)  {
                return $data->reason == null ? "N/A" :  $data->reason;
            })

            ->addColumn('pay_all',function($data){
                return '';
                // return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'">';
            })
            ->addColumn('export_id', function ($data)  {

                return $data->export_stock_id;

            })

            ->addColumn('total', function ($data)  {

                return  '$'. number_format( $data->total_price - $data->total_taxi_fee -$data->total_delivery_fee -$data->total_extra_fee -$data->total_service_charge  ,2);

            })
            ->editColumn('total_price', function ($data)  {
                return '$'. number_format(  $data->total_price ,2);
            })

            ->addColumn('total_taxi_fee', function ($data)  {
                return '$'. number_format( $data->total_taxi_fee   ,2);
            })

            ->addColumn('total_delivery_fee', function ($data)  {
                return'$'. number_format($data->total_delivery_fee  ,2);
            })

            ->addColumn('total_extra_fee', function ($data)  {
                return '$'. number_format($data->total_extra_fee  ,2);
            })
            ->addColumn('total_service_charge', function ($data)  {
                return  '$'. number_format($data->total_service_charge  ,2);
            })
            ->addColumn('total_collect', function ($data)  {
                return  '$'. number_format($data->total_collect  ,2);
            })

            ->addColumn('action', function ($data)  {
                return ' <a href="'. route("export-stock.show", $data->export_stock_id) .'" target="_blank" class="button_success fa fa-print "> </a>    ' ;
            })


            ->rawColumns(['action' => 'action','pay_all' => 'pay_all','export_id'=>'export_id','total'=>'total'])
            ->addIndexColumn()
            ->make(true);
        }
        else{
            echo json_encode($data);
        }
    }

    public function data_payment($from_date,$to_date,$status,$merchant){
        $data = DeliveryOrderModel::
            join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
            ->leftjoin(DB::Raw('(SELECT export_id,currency , sum(export_qty * price) AS total_price from nso007_export_stock_details GROUP BY export_id) export_stock_details'),function($join){
                $join->on('nso007_export_stock.id', '=', 'export_stock_details.export_id');
            })  ;

        if(\Globals::check_lang() == 'en'){
        $data = $data-> select(
                'nso007_export_stock.service_charge',
                'nso007_export_stock.delivery_status',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                'nso007_export_stock.taxi_shop_fee',
                'nso007_export_stock.taxi_cust_fee',
                'nso007_export_stock.taxi_status',
                'nso007_export_stock.delivery_fee',
                'nso007_export_stock.extra_fee_type',
                'nso007_export_stock.extra_fee',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                'export_stock_details.currency',
                'export_stock_details.export_id AS export_stock_id',
                \DB::raw('SUM(export_stock_details.total_price ) as total_price'),
                \DB::raw('SUM( export_stock_details.total_price ) as total_collect'),
                \DB::raw("SUM(( CASE WHEN nso007_export_stock.taxi_status = 1 THEN nso007_export_stock.taxi_shop_fee END )) AS total_taxi_fee"),
                \DB::raw("SUM(( CASE WHEN nso007_export_stock.delivery_status = 1 THEN nso007_export_stock.delivery_fee END )) AS total_delivery_fee"),
                \DB::raw("SUM(( CASE WHEN nso007_export_stock.extra_fee_type = 1 THEN nso007_export_stock.extra_fee END )) AS total_extra_fee"),
                \DB::raw('SUM(nso007_export_stock.service_charge) as total_service_charge')

        );
        }else{
            $data = $data-> select(
                'nso007_export_stock.service_charge',
                'nso007_export_stock.delivery_status',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                'nso007_export_stock.taxi_shop_fee',
                'nso007_export_stock.taxi_cust_fee',
                'nso007_export_stock.taxi_status',
                'nso007_export_stock.delivery_fee',
                'nso007_export_stock.extra_fee_type',
                'nso007_export_stock.extra_fee',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_export_stock_details.currency',
                'nso007_export_stock_details.export_id AS export_stock_id',
                \DB::raw('SUM(export_stock_details.total_price ) as total_price'),
                \DB::raw('SUM( export_stock_details.total_price ) as total_collect'),
                \DB::raw("SUM(( CASE WHEN nso007_export_stock.taxi_status = 1 THEN nso007_export_stock.taxi_shop_fee END )) AS total_taxi_fee"),
                \DB::raw("SUM(( CASE WHEN nso007_export_stock.delivery_status = 1 THEN nso007_export_stock.delivery_fee END )) AS total_delivery_fee"),
                \DB::raw("SUM(( CASE WHEN nso007_export_stock.extra_fee_type = 1 THEN nso007_export_stock.extra_fee END )) AS total_extra_fee"),
                \DB::raw('SUM(nso007_export_stock.service_charge) as total_service_charge')
            );
        }
        $data = $data
        // ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
        //     if(!empty($from_date) && !empty($to_date)){
        //         $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
        //     }
        // })
        // ->when(request('status'),function($query) use ($status){
        //     if(!empty($status)){
        //         $status_1 ='';
        //         foreach ($status as $key => $value) {
        //             $status_1  .= $status[$key].',' ;
        //         }
        //         $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
        //     }
        // })

        // ->where(function($query) use ($merchant){

        //     if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
        //         $query->where('merchant_id',\Auth::user()->id);
        //     }else if(\Globals::is_Driver() == 'Driver'){
        //         $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
        //     }else{
        //         $query->where('merchant_id','LIKE',$merchant);
        //     }
        // })

        ->groupBy('nso007_export_stock.merchant_id')
        ->groupBy('nso007_delivery_order.delivery_date')
        ->where('nso007_export_stock.status',3)

        ->get();
        return $data;
    }


    // public function paymente_show(Request $request){

    //     $data = DeliveryOrderModel::
    //     join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //         ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //         ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
    //         ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
    //         ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
    //         ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');

    //     if(\Globals::check_lang() == 'en'){
    //     $data = $data-> select(
    //             'nso007_export_stock.service_charge',
    //             'nso007_export_stock.delivery_status',
    //             'nso007_export_stock.description',
    //             'nso007_delivery_order_detail.status',
    //             'nso007_delivery_order_detail.reason',
    //             'nso007_delivery_order.inovice',
    //             'nso007_delivery_order.delivery_date',
    //             'nso007_export_stock.delivery_option',
    //             'nso007_delivery_order_detail.*',
    //             'nso007_export_stock.box_code',
    //             'nso007_export_stock.taxi_number',
    //             'nso007_export_stock.taxi_shop_fee',
    //             'nso007_export_stock.taxi_cust_fee',
    //             'nso007_export_stock.taxi_status',
    //             'nso007_export_stock.delivery_fee',
    //             'nso007_export_stock.extra_fee_type',
    //             'nso007_export_stock.extra_fee',
    //             'nso007_export_stock.description',
    //             'nso007_export_stock.customer_receive',
    //             'merchant.shop_name',
    //             'merchant.id AS merchant_id',
    //             'nso007_location.name_en AS name_location',
    //             'driver.name AS driver_name',
    //             'nso007_delivery_order_detail.id AS delivery_order_detail_id',
    //             'nso007_export_stock_details.currency',
    //             'nso007_export_stock_details.export_id AS id',
    //             DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

    //     );
    //     }else{

    //         $data = $data-> select(
    //             'nso007_export_stock.service_charge',
    //             'nso007_export_stock.delivery_status',
    //             'nso007_export_stock.description',
    //             'nso007_delivery_order_detail.status',
    //             'nso007_delivery_order_detail.reason',
    //             'nso007_delivery_order.inovice',
    //             'nso007_delivery_order.delivery_date',
    //             'nso007_export_stock.delivery_option',
    //             'nso007_delivery_order_detail.*',
    //             'nso007_export_stock.box_code',
    //             'nso007_export_stock.taxi_number',
    //             'nso007_export_stock.taxi_shop_fee',
    //             'nso007_export_stock.taxi_cust_fee',
    //             'nso007_export_stock.taxi_status',
    //             'nso007_export_stock.delivery_fee',
    //             'nso007_export_stock.description',
    //             'nso007_export_stock.customer_receive',
    //             'nso007_export_stock.extra_fee_type',
    //             'nso007_export_stock.extra_fee',
    //             'merchant.shop_name',
    //             'merchant.id AS merchant_id',
    //             'nso007_location.name_km AS name_location',
    //             'driver.name AS driver_name',
    //             'nso007_export_stock_details.currency',
    //             'nso007_export_stock_details.export_id AS id',
    //             DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
    //         );
    //     }
    //     $data = $data
    //     // ->whereIn('nso007_delivery_order_detail.export_id', explode(',', $request->export_id))
    //     // ->where('nso007_export_stock.status',3)
    //     ->orderBy('nso007_delivery_order.inovice','desc')
    //     ->where('nso007_export_stock.status',3)
    //     ->where('nso007_export_stock.merchant_id',$request->merchant_id)
    //     ->where('nso007_delivery_order.delivery_date',date('Y-m-d', strtotime($request->delivery_date)))
    //     ->groupBy('nso007_export_stock_details.export_id')
    //     ->groupBy('nso007_delivery_order_detail.delivery_order_id')
    //     ->get();
    //     // dd($data);
    //     echo json_encode($data);
    // }
    public function store( $id)
    {
        // dd(explode(',', $id));
        \DB::table('nso007_export_stock')->whereIn('id',explode(',', $id))->update(['status'=>6]);
        \DB::table('nso007_delivery_order_detail')->whereIn('id',explode(',', $id))->update(['status'=>5]);
        return redirect()->back();

    }

    public function show($id)
    {
        $last_id=InvoiceModel::max('id');

        if ($last_id) {
            $box_code = InvoiceModel::select('invoice_number')->get()->last();
            $tran_num = substr($box_code->box_code, 3);
            $increas = 'V-'.sprintf('%08d', ($tran_num+1));
        } else {
            $increas =  'V-'.'00000001';
        }
        $data = new InvoiceModel();
        $data->invoice_number = $increas ;
        $data->save();
        \DB::table('nso007_export_stock')->whereIn('id',explode(',', $id))->update(['invoice_id'=>$data->id]);

        return view('administrator.payment.show');
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
