<?php

namespace App\Http\Controllers\administrator;

use App\BranchModel;
use App\CategoryModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailShopModel;
use App\DiscountModel;
use App\Exports\ExcelExport;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use App\User;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;
class OutStockNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;

        $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');

        if ($request->ajax()) {
            $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.export_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                // ->where('nso007_export_stock.type_of_stock',2)
                ->groupBy('nso007_export_stock.box_code')
                ->whereNotIn('nso007_export_stock.id',$paid)
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc');
            return  Datatables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paid , 7 = return to shop
                    $edit​​ = '';
                    $delete = '';
                    // if ($data->status == 1 || $data->status == 2) {
                    //     if ($data->type_of_stock == 1) {
                    //         $edit = '<a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                    //     } else {
                    //         $edit = '<a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                    //     }

                    // } else {
                    //     $edit = '<a href="#" class="button_dark fa fa-edit"></a>';
                    // }


                    // if ($data->status == 1 ) {
                    //     if(Gate::check('Export List Delete Box')){
                    //         $delete = '<a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    //     }
                    // } else {
                    //     $delete = '<a data-href="#" class="button_dark fa fa-trash   " ></a>';
                    // }

                    //     return $delete .'
                    //     <a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="button_warning fa fa-print bt-print"></a>
                    //     ' . $edit;

                    $pedding = '';
                    $cancel = '';
                    $edit = '';
                    $return_to_shop = '';
                    $print = '';
                    $all = '';
                    $return_to_proccess = '';
                    if (Gate::check('Delete Order')) {
                        $delete = '<li><a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class=" fa fa-trash bt-delete">&nbsp; '. __('administrator.delete') .'</a></li>';
                    }
                    if (Gate::check('Pending Order List')) {
                        $pedding = '<li><a class="bt_pending" data-status="2" data-export_id="'.$data->export_id.'">'.__('administrator.pending').'</a>';
                    }
                    if (Gate::check('Cancel Order List')) {
                        $cancel = '<li><a class="bt_cencel fa fa-ban" data-status="3" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.cancel').'</a></li>';
                    }
                    if (Gate::check('Return To Shop Order List')) {
                        $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                    }
                        if ($data->type_of_stock == 1) {
                            if (Gate::check('Edit Order List')) {
                                $edit = '<li><a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                            }
                        } else {
                            if (Gate::check('Edit Order List')) {
                                $edit = '<li><a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                            }
                        }



                        if (Gate::check('Print Order List')) {
                            $print = '<li><a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="fa fa-print bt-print">&nbsp;'.__('administrator.print').'</a></li>';
                        }
                         $return_to_proccess = '
                        <li><a class="return_to_inpro fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
                    ';
                if($data->status == 1 || $data->status == 2 || $data->status == 4 || $data->status == 3){
                    if ($data->status == 1) {
                            $all.= $delete.$print.$edit;
                    }

                    if($data->status == 2){
                        $all .= $print.$edit.$pedding.$cancel.$return_to_shop;
                    }
                    if($data->status != 4){

                    }
                    // $all = $delete . $print .$edit .$pedding .$cancel.$return_to_shop;



                }
                if($data->status == 4){
                    if(!$data->status_paid){
                        if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                            $all .= $return_to_proccess.$return_to_shop;
                        }
                    }
                }
                if($data->status == 5){
                    $all .= $return_to_proccess;
                }
                if($data->status == 3){
                    // if(!$data->status_paid){
                    //     if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                    //         $all .= $return_to_proccess;
                    //     }
                    // }
                        if(!$data->status_paid){
                            if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                                $all .=$return_to_proccess;
                                // $action = '
                                //     <label class="btn btn-info btn-xs return_to_inpro_for_success"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
                                // ';
                            }
                        }
                }
                if($data->status == 7){
                    $all .= $print.$edit.$delete.$return_to_proccess;
                }

                return '
                <div class="dropdown">
                     <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                     <span class="caret"></span></button>
                     <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                     '.$all.'
                     </ul>
                 </div>
                ';



                //     >'.__('administrator.edit_delivey').'</label>';
                // return $edit;


                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else if($data->status ==5)   // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                    else if($data->status ==6)   // 6 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.paid') . ' </strong>';
                    else if($data->status ==7)   // 7 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>';
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })

                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1)
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->get()->last();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";

                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })
                ->addColumn('print_all',function($data){
                    return '
                    <div class="form-check">
                        <input class="form-check-input checkbox" type="checkbox" value="'.$data->id.'" id="flexCheckDefault">
                        <label class="form-check-label" for="flexCheckDefault">
                        </label>
                    </div>
                    ';
                })
                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name','print_all'=>'print_all'])
                ->addIndexColumn()
                ->make(true);
        }
        // DB::select('select * from pos_sale where FORMAT(rate,2) <= FORMAT('.$rate.',2)');
        return \view('administrator.out-stock-new.index',compact( 'merchant_show'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $exchang_rate = CurrencyModel::find(1);
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($request){
                if($request->get_zone == "province"){
                    $q->where('name_en','Province');
                }else{
                    $q->where('name_en','!=','Province');
                }
            })

            ->select('nso007_location.name_en AS name', 'id','location_id');
        $province_id = LocationModel::where('status', 1)
                            ->where('type','zone')
                            ->select('id')
                            ->where('name_en','=','Province')
                            ->first();
        $province_id = optional($province_id)->id;
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }

        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
            ->whereIn('id',is_array($loc_id_array) ? $loc_id_array : ["no"])
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        if($request->get_zone){
            return response()->json([
                'zone'=>$from_location,
                'location'=>$location
            ]);
        }
        $merchant = User::where('user_type', 3)->where('status', 1)
            // ->where('type_of_merchant', 2)
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();
        $lang = \Globals::check_lang();
        $category = CategoryModel::where('status', 1)
            ->pluck('nso007_category.name_'.$lang.' AS category_name','id')->prepend(__('administrator.category'),'');
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();
        return view('administrator.out-stock-new.create',compact('merchant','from_location','location','category','bus','exchang_rate','province_id'));
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        $export_id = array();
        try {
                foreach ($request->delivery_option as $key1 => $value) {
                    $category = CategoryModel::find($request->category_id[$key1]);
                    if (empty($category)) {
                        $cat = new CategoryModel();
                        $cat->name_en = $request->category_id[$key1];
                        $cat->name_km = $request->category_id[$key1];
                        $cat->image = 'default.jpg';
                        $cat->save();
                        $category_name=$request->category_id[$key1];
                        $category_id_for_detail = $cat->id;
                        $shop = User::find($request->merchant_id[$key1]);
                        $category_id = $shop->category_id.','.$request->category_id[$key1];
                        $shop->category_id = $category_id;
                        $shop->update();
                    } else {
                        $category_name = $category->name_km;
                        $category_id_for_detail = $category->id;
                    }
                    $discount = DiscountModel::where('date', date('Y-m-d'))->first();

                    $last_id = ExportStockModel::max('id');
                    $header_invoice = BranchModel::first();
                    if ($last_id) {
                        $box_code = ExportStockModel::select('box_code')->get()->last();
                        $tran_num = substr($box_code->box_code, 3);
                        $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
                    } else {
                        $increas = $header_invoice->header_invoice_import . '00000001';
                    }
                    $exportstock = new ExportStockModel();
                    if ($discount) {
                        $arra_  =  explode(',', $discount->shop_id);
                        if (in_array($request->merchant_id, $arra_)) {
                            $exportstock->discount_id  = $discount->id;
                        }
                    }
                    $exportstock->merchant_id                   = $request->merchant_id;
                    $exportstock->box_code                      = $increas;
                    $exportstock->export_date                   = date('Y-m-d');
                    $exportstock->delivery_fee                  = $request->delivery_fee[$key1];
                    $exportstock->delivery_fee_rate                  = $request->delivery_fee_rate[$key1];
                    $exportstock->delivery_fee_symbol                  = $request->delivery_fee_symbol[$key1];
                    $exportstock->from_location                 = isset($request->from_location[$key1]) ? $request->from_location[$key1] : '';
                    $exportstock->location                      = $request->location[$key1];
                    $exportstock->customer_receive              = $request->customer_receive[$key1];
                    $exportstock->delivery_status               = $request->delivery_status[$key1];
                    $exportstock->delivery_option               = $request->delivery_option[$key1];
                    $exportstock->created_by                    = Auth::user()->id;
                    $exportstock->description                   = $request->description[$key1];
                    $exportstock->date_delivery                 =  date('Y-m-d');
                    // $exportstock->pay_or_paid                = $request->pay_or_paid;
                    $exportstock->type_of_stock                 = 2; //Out stock
                    $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key1];
                    $exportstock->taxi_number                   = optional($request->taxi_number)[$key1];
                    $exportstock->taxi_status                   = optional($request->taxi_status)[$key1];
                    if (optional($request->taxi_status)[$key1] == 1) {
                        $exportstock->taxi_shop_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1] ;
                    } else {
                        $exportstock->taxi_cust_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1];
                    }
                    $exportstock->taxi_fee_rate                = optional($request->taxi_fee_rate)[$key1];
                    $exportstock->taxi_fee_symbol              = optional($request->taxi_fee_symbol)[$key1];
                    $exportstock->taxi_pay_or_paid              = optional($request->taxi_pay_or_paid)[$key1];
                    $exportstock->other_services_fee            = optional($request->other_service_fee)[$key1] == '' ? 0 : optional($request->other_service_fee)[$key1] ;
                    $exportstock->other_services_type           = $request->other_service_type;
                    $exportstock->other_services_pay_or_paid    = optional($request->other_service_pay_or_paid)[$key1];
                    $exportstock->shop_name                     =  FindShop($request->merchant_id);
                    $exportstock->location_name                 =  FindLoaction($request->location[$key1]);
                    $exportstock->create_by_name                = \Auth::user()->name;
                    $exportstock->update_status_by              = update_status_by("", '', '')      ; //  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
                    $exportstock->total_product                 = $request->price[$key1];
                    $exportstock->total_product_rate            = $request->total_product_rate[$key1];
                    $exportstock->total_product_symbol          = $request->total_product_symbol[$key1];
                    $exportstock->total_product_status          = $request->total_product_status[$key1];
                    $exportstock->recievce_location             = optional($request->recievce_location)[$key1];
                    $exportstock->time                          = $request->time[$key1];
                    $exportstock->rate                          = $request->rate;
                    if ($exportstock->save()) {
                        array_push($export_id,$exportstock->id);
                        $exportstockdetails = new ExportStockdetailsMode();
                        $exportstockdetails->export_id          = $exportstock->id;
                        $exportstockdetails->barcode            = $increas;
                        $exportstockdetails->currency           = $request->currency;
                        $exportstockdetails->export_qty         = 1;
                        $exportstockdetails->price              = $request->price[$key1];
                        $exportstockdetails->category_id        = $category_id_for_detail;
                        $exportstockdetails->category_name      =  $category_name;

                        // $exportstockdetails->category_name      =  FindCategory($request->category_id);
                        $exportstockdetails->save();
                        // }
                    }
                    DB::commit();
                }
            Session::flash('success', 'Create Success');
            return response()->json([
                'export_id'=>$export_id,
                'print'=>$request->print
            ]);
            return redirect()->back()->with('success','Create Success');
        }catch(Exception $e){
            DB::rollback();
            throw new Exception($e->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $exchang_rate = CurrencyModel::find(1);
        // $from_location = LocationModel::where('status', 1)->where('pearent_id', null)
        //     ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        // $location = LocationModel::where('status', 1)->where('pearent_id', '!=', null)
        //     ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            // ->where('pearent_id', null)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
        // ->where('pearent_id', '!=', null)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        $merchant = User::where('user_type', 3)->where('status', 1)
            // ->where('type_of_merchant', 2)
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();

        $lang = \Globals::check_lang();

        $category = CategoryModel::where('status', 1)
            ->pluck('nso007_category.name_'.$lang.' AS category_name','id')->prepend(__('administrator.category'),'');
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();
        $data   =   ExportStockdetailsMode::join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->join('users','users.id','nso007_export_stock.merchant_id')
            ->where('nso007_export_stock_details.export_id', $id)
            ->select(
                'nso007_category.*',
                'nso007_export_stock.*',
                'nso007_export_stock_details.*',
                'nso007_category.name_en As category_name',
                'users.phone as sender_contact'
            )->first();
        $shop = User::find($data->merchant_id);
        $category = CategoryModel::whereIn('id',explode(',',$shop->category_id))
            ->pluck('name_'.$lang.'','id');
        // dd($data);
        return view('administrator.out-stock-new.edit',compact('data','merchant','from_location','location','category','bus','exchang_rate'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if(!$request->delivery_fee){
            return redirect()->back()->with('danger','Please try again');
        }
        $this->validate($request, [
            'merchant_id'           => 'required',
            'category_id'           => 'required',
            'currency'              => 'required',
            'customer_receive'      => 'required',
            'location'              => 'required',
            'delivery_fee'          => 'required',
            // 'price'                 => 'required|numeric',
            'delivery_option'       => 'required',
        ]);
        $category = CategoryModel::find($request->category_id);
        if(empty($category)){
            $cat = new CategoryModel();
            $cat->name_en = $request->category_id;
            $cat->name_km = $request->category_id;
            $cat->image = 'default.jpg';
            $cat->save();
            $request['category_name']=$request->category_id;
            $request['category_id'] = $cat->id;
            $shop = User::find($request->merchant_id);
            $category_id = $shop->category_id.','.$request->category_id;
            $shop->category_id = $category_id;
            $shop->update();
        }else{
            $request['category_name'] = $category->name_km;
        }
        $exportstock = ExportStockModel::whereBox_code($id)
        ->select(
            'nso007_export_stock.*',
            DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            )
        ->first();

        // dd($id);
        update_status_by($id , '','edit_by');

        // { "create_by":"Super Admin","edit_by":"",  "status_proccess":"",  "status_last":""}


        $exportstock->merchant_id           = $request->merchant_id;
        $check_delivery_status              = $exportstock->delivery_status;
        $exportstock->delivery_fee          = $request->delivery_fee;
        $exportstock->delivery_fee_rate                  = $request->delivery_fee_rate;
        $exportstock->delivery_fee_symbol                  = $request->delivery_fee_symbol;
        $exportstock->from_location         = $request->from_location;
        $exportstock->location              = $request->location;
        $exportstock->customer_receive      = $request->customer_receive;
        $exportstock->delivery_status       = $request->delivery_status;
        $exportstock->delivery_option       = $request->delivery_option;
        $exportstock->modify_by            = \Auth::user()->id;
        $exportstock->description           = $request->description;
        $exportstock->type_of_stock           = 2; //Out stock
        $exportstock->delivery_pay_or_paid           = $request->pay_or_paid;
        $exportstock->taxi_number           = $request->taxi_number;
        $exportstock->taxi_status           = $request->taxi_status;
        if($request->taxi_status==1){
            $exportstock->taxi_shop_fee             =  $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }else{
            $exportstock->taxi_cust_fee             = $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }
        $exportstock->taxi_fee_rate              = $request->taxi_fee_rate;
        $exportstock->taxi_fee_symbol              = $request->taxi_fee_symbol;
        $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid;
        $exportstock->other_services_fee            =   $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
        $exportstock->other_services_type           = $request->other_services_type;
        $exportstock->other_services_pay_or_paid    = $request->other_services_pay_or_paid;
        // $exportstock->date_delivery                 = date('Y-m-d');
        $exportstock->shop_name                     =  FindShop($request->merchant_id);
        $exportstock->location_name                 =  FindLoaction($request->location);
        $exportstock->total_product                 = $request->price;
        $exportstock->total_product_rate            = $request->total_product_rate;
        $exportstock->total_product_symbol          = $request->total_product_symbol;
        $exportstock->total_product_status          = $request->total_product_status;
        $exportstock->recievce_location          = $request->recievce_location;
        $exportstock->rate                          = $request->rate;
        $exportstock->time                          = $request->time;
        if ($exportstock->update()) {
            $exportstockdetails = ExportStockdetailsMode::where('export_id', $exportstock->id)->first();
            $price = $exportstockdetails->price;
            $exportstockdetails->currency           = $request->currency;
            $exportstockdetails->export_qty         = 1;
            $exportstockdetails->price              = $request->price;
            $exportstockdetails->category_id        = $request->category_id;
            $exportstockdetails->category_name      =  $request->category_name;
            // $exportstockdetails->category_name      =  FindCategory($request->category_id);

            if ($request->price != $price || $check_delivery_status != $request->delivery_status) {
                DeliveryOrderDetailModel::where('status',1)->where('export_id',$exportstock->id)->update(['total_riel'=>0,'total_dollar'=>0]);
                DeliveryOrderDetailProccessingModel::where('status',1)->where('export_id',$exportstock->id)->update(['total_riel'=>0,'total_dollar'=>0]);
            }
            $exportstockdetails->update();
        }
        return redirect()->route('out-stock-new.index')->with('sussess', 'Import was add already successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function find_merchant($id=null){
        if(empty($id)){
            return [
                'user'=>'',
                'category'=>''
            ];
        }
        $user = User::find($id);
        $lang = \Fun::lang();
        $category = CategoryModel::whereIn('id',explode(',',$user->category_id))
            ->pluck('name_'.$lang.'','id');
        return response()->json([
            'user'=>$user,
            'category'=>$category
        ]);
    }
    function add_box(Request $request){

        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($request){
                if($request->get_zone == "province"){
                    $q->where('name_en','Province');
                }else{
                    $q->where('name_en','!=','Province');
                }
            })

            ->select('nso007_location.name_en AS name', 'id','location_id');
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }
        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
            ->whereIn('id',$loc_id_array)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
            $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();


        $box_col = $request->box_col;
        $none = $request->none;

        return view('administrator.out-stock-new.add-box',compact('from_location','location','bus','box_col','none'))->render();

    }


}
