<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;

class DeliveryOrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = DeliveryOrderModel::
                select('driver.name',"nso007_delivery_order.*")
                ->join('users AS driver','driver.id','nso007_delivery_order.driver_id')
                ->join('nso007_delivery_order_detail_proccessing','nso007_delivery_order.id','nso007_delivery_order_detail_proccessing.delivery_order_id')
                ->groupBy('nso007_delivery_order.id')
                ->orderBy('nso007_delivery_order.inovice', 'desc');
            return  DataTables::of($data)
            ->editColumn('delivery_date', function($data) {
                return date('d-m-Y',strtotime($data->delivery_date));
            })
            ->editColumn('name',function($data){
                $time_policy = "ព្រឹក";
                if($data->time_policy == 2){
                    $time_policy = "ល្ងាច";
                }
                return $data->name.' ('.$time_policy.' )';
            })
            ->addColumn('action', function($data) {
                $edit = '
                <a href="'. route("delivery-order.edit", $data->id) . '" class="btn_sm button_primary">'.__('administrator.edit' ).'</a>
                <a href="'. route("delivery_order_lists", $data->id) . '" class="btn_sm button_danger">'.__('administrator.show' ).'</a>
                <a href="'. route("delivery-order.show",  $data->id) . '" class="btn_sm button_primary">'.__('administrator.print' ).'</a>
                ';
                return $edit;
                })
            ->addIndexColumn()
            ->make(true);
        }
        return view('administrator.V2.delivery-order.index');
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    public function delivery_order_list($id)
    {
            session()->forget('session_id_list_order');
            session()->put('session_id_list_order', $id);
            $data = $this->datable_delivery_order_data($id);
            return view('administrator.V2.delivery-order.delivery-list-show',compact('data'));
    }
    public function datable_delivery_order_data($id){
        $data = DeliveryOrderModel::
                    join('nso007_delivery_order_detail_proccessing','nso007_delivery_order_detail_proccessing.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
                    ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                    ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                    ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                    ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                    ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');
                    if(\Globals::check_lang() == 'en'){
                    $data = $data-> select(
                            'nso007_export_stock.*',
                            'nso007_delivery_order.driver_id',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order.inovice',
                            'nso007_export_stock.delivery_option',
                            'nso007_delivery_order_detail_proccessing.*',
                            'nso007_export_stock.box_code',
                            'nso007_export_stock.taxi_number',
                            'nso007_export_stock.delivery_status',
                            'nso007_export_stock.taxi_shop_fee',
                            'nso007_export_stock.taxi_cust_fee',
                            'nso007_export_stock.taxi_status',
                            'nso007_export_stock.delivery_fee',
                            'nso007_export_stock.description as ex_description',
                            'nso007_export_stock.customer_receive',
                            'nso007_export_stock.type_of_stock',
                            'nso007_export_stock.id',
                            'nso007_discount.*',
                            'nso007_discount.id AS discount_id',
                            'merchant.shop_name',
                            'merchant.user_currency',
                            'merchant.phone',
                            'nso007_export_stock_details.currency',
                            'nso007_location.name_en AS name_location',
                            'nso007_category.name_en AS category_name',
                            'nso007_export_stock.extra_fee_type',
                            'nso007_export_stock.extra_fee',
                            'driver.name AS driver_name',
                            'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
                    );
                    }else{
                        $data = $data-> select(
                            'nso007_export_stock.*',
                            'nso007_delivery_order.driver_id',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order.inovice',
                            'nso007_export_stock.delivery_option',
                            'nso007_delivery_order_detail_proccessing.*',
                            'nso007_export_stock.box_code',
                            'nso007_export_stock.taxi_number',
                            'nso007_export_stock.delivery_status',
                            'nso007_export_stock.taxi_shop_fee',
                            'nso007_export_stock.taxi_cust_fee',
                            'nso007_export_stock.taxi_status',
                            'nso007_export_stock.delivery_fee',
                            'nso007_export_stock.extra_fee_type',
                            'nso007_export_stock.extra_fee',
                            'nso007_export_stock.description as ex_description',
                            'nso007_export_stock.customer_receive',
                            'nso007_export_stock_details.currency',
                            'merchant.shop_name',
                            'nso007_export_stock_details.price',
                            'merchant.user_currency',
                            'merchant.phone',
                            'nso007_location.name_km AS name_location',
                            'nso007_category.name_km AS category_name',
                            'nso007_discount.id AS discount_id',
                            'nso007_discount.*',
                            'driver.name AS driver_name',
                            'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

                        );
                    }
                    $data = $data->groupBy('nso007_export_stock.box_code')
                            ->groupBy('nso007_export_stock_details.export_id')
                            ->orderBy('nso007_location.id', 'desc')
                            ->where('nso007_delivery_order_detail_proccessing.delivery_order_id',$id)
                            ->get(); 
        return $data;
    }
    public function datable_delivery_order_list( Request $request){
        $id  = session()->get('session_id_list_order');
        $data = $this->datable_delivery_order_data( $id );

        if ($request->ajax()) {
            return  Datatables::of($data)
            ->editColumn('delivery_date', function($data) {   return date('d-m-Y',strtotime($data->delivery_date));   })
            ->editColumn('total_price', function($data) {   
                // return '$'.number_format($data->total_price, 2);
                if($data->total_product_symbol == '៛'){
                    return number_format($data->total_price).' ៛'; 
                }    
                return '$'.number_format($data->total_price, 2);     
              })
            ->editColumn('buy_fee', function($data) {
            //    if($data->taxi_status == 1){  $buy_fee = '$'.number_format($data->taxi_shop_fee, 2); }
            //    else{    $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);       }
            //    return $buy_fee;
                    if($data->taxi_status == 1){  
                        if($data->taxi_fee_symbol =='$'){
                            $buy_fee = '$'.number_format($data->taxi_shop_fee, 2); 
                        }
                        if($data->taxi_fee_symbol =='៛'){
                            $buy_fee = number_format($data->taxi_shop_fee).'៛'; 
                        }
                    }
                    else{
                        if ($data->taxi_fee_symbol =='$') {
                            $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);
                        }  
                        if ($data->taxi_fee_symbol =='៛') {
                            $buy_fee = number_format($data->taxi_cust_fee).'៛'; 
                        }
                    }
                    return $buy_fee;
            })

            ->editColumn('delivery_fee', function($data) {
                $delivery_fee  = 0;
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                            }
                            else{
                                $delivery_fee = $data->delivery_fee;
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee;
                        }



                        if ($data->delivery_status == 1) {
                            
                            $delivery_fee_text = '$' . number_format($delivery_fee, 2);
                            if($data->delivery_fee_symbol == '៛'){
                                $delivery_fee_text = number_format($delivery_fee).' ៛';
                            }
                        } else {
                            $delivery_fee_text = '$' . number_format($delivery_fee, 2);
                            if($data->delivery_fee_symbol == '៛'){
                                $delivery_fee_text = number_format($delivery_fee).' ៛';
                            }
                        }
                        return $delivery_fee_text;
            })

            ->addColumn('pay_all',function($data){
                return '<input type="checkbox" name="check" class="checkbox" data-box_code="'.$data->box_code.'"  data-delivery_order_detail_proccessing_id="'.$data->delivery_order_detail_proccessing_id.'" data-export_id="'.$data->export_id.'" >';
            })

            ->addColumn('description',function($data){
                return $data->total_riel > 0 ? $data->ex_description.' ('.$data->total_riel.'៛)':$data->ex_description;
            })
            ->editColumn('other_services_fee', function($data) {
                $other_services_fee = '';
                // if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                //     $other_services_fee  =   $data->other_services_fee ;
                // }

                if($data->other_services_fee > 0 ){
                    if($data->other_services_type == 1){
                        $other_services_fee = '$'.number_format($data->other_services_type, 2) .' s';
                    }
                    else{
                        $other_services_fee ='$'.number_format($data->other_services_type, 2).' c';
                    }

                    if($data->other_services_pay_or_paid == 'paid'){
                        $other_services_fee .=  ' (paid)';
                    }
                }else{
                    $other_services_fee =  '';
                }

                return $other_services_fee ;

            })
            ->addColumn('action', function($data) {
                if($data->discount_type != null || $data->discount_type != '')
                {
                    if($data->discount_type == 1){
                        $delivery_fee = $data->discount;
                    }
                    elseif($data->discount_type == 2){
                        $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee ) / 100;
                    }
                    else{
                        $delivery_fee = $data->delivery_fee;
                    }
                }
                else{
                    $delivery_fee  =  $data->delivery_fee;
                }

                if($data->delivery_pay_or_paid == 'paid'){
                    $delivery_fee  =  0;
                }

                $other_services_fee =  0;
                if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                    $other_services_fee = $data->other_services_fee ;
                }

                $edit = '
                <label class="btn_sm button_success bt_done" data-status="1" data-export_id="'.$data->export_id.'" >'.__('administrator.done').'</label>
                <label class="btn_sm button_warning bt_pending" data-status="2" data-export_id="'.$data->export_id.'">'.__('administrator.pending').'</label>
                <label class="btn_sm button_danger bt_cencel" data-status="3" data-export_id="'.$data->export_id.'" >'.__('administrator.cancel').'</label>
                <label class="btn_sm button_primary edit_price_of_car"
                            data-export_id="'.$data->export_id.'"
                            data-price="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                            data-delivery_option="'.$data->delivery_option.'"​​
                            data-currency="'.$data->currency.'"​​
                            data-taxi_status="'.$data->taxi_status.'"​​
                            data-taxi_shop_fee="'.$data->taxi_shop_fee.'"​​
                            data-taxi_cust_fee="'.$data->taxi_cust_fee.'"​​
                            data-taxi_number="'.$data->taxi_number.'"​​
                            data-total_riel="'.$data->total_riel.'"​​
                            data-total_dollar="'.$data->total_dollar.'"​​
                            data-extra_fee="'.$data->extra_fee.'"​​
                            data-extra_fee_type="'.$data->extra_fee_type.'"​​
                            data-driver_note="'.$data->driver_note.'"​​
                            data-user_currency="'.$data->user_currency.'"​​

                    >'.__('administrator.edit_delivey').'</label>';
                return $edit;
            })
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })
            ->rawColumns(['pay_all'=>'pay_all'])
            ->addIndexColumn()
            ->make(true);
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
