<?php

namespace App\Http\Controllers\Administrator;
use App\Fun\Fun;
use App\CurrencyModel;
use App\User;
use App\ExportStockdetailsMode;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
Use DB;
Use Auth;
use App\DeliveryOrderModel;
use Exception;
use App\ExportStockModel;
use App\DeliveryOrderDetailModel;
use Illuminate\Validation\ValidationException;

use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailShopModel;
use App\DeliveryOrderHistoryModel;
use App\Helpers\Globals;
use App\InvoicePaymentModel;
use App\StockModel;
use Illuminate\Support\Facades\Gate;
use phpDocumentor\Reflection\Location;
use Yajra\DataTables\DataTables;

class DeliveryController extends Controller
{
    function __construct()
    {
        Fun::lang();
        $this->middleware('permission:Driver Voucher', ['only' => ['index']]);
        $this->middleware('permission:New Order', ['only' => ['create','store']]);
        $this->middleware('permission:Report Delivery', ['only' => ['history_delivery']]);
    }

    public function index (Request $request)
    {
        if ($request->ajax()) {
            $data = DeliveryOrderModel::
                select('driver.name',"nso007_delivery_order.*")
                ->join('users AS driver','driver.id','nso007_delivery_order.driver_id')
                ->join('nso007_delivery_order_detail_proccessing','nso007_delivery_order.id','nso007_delivery_order_detail_proccessing.delivery_order_id')
                ->groupBy('nso007_delivery_order.id')
                ->orderBy('nso007_delivery_order.inovice', 'desc');
            return  Datatables::of($data)
            ->editColumn('delivery_date', function($data) {
                return date('d-m-Y',strtotime($data->delivery_date));
            })
            ->addColumn('action', function($data) {
                $edit = '
                <a href="'. route("delivery-order.edit", $data->id) . '" class="btn_sm button_primary">'.__('administrator.edit' ).'</a>
                <a href="'. route("delivery_order_list", $data->id) . '" class="btn_sm button_danger">'.__('administrator.show' ).'</a>
                <a href="'. route("delivery-order.show",  $data->id) . '" class="btn_sm button_primary">'.__('administrator.print' ).'</a>
                ';
                return $edit;
                })
            ->addIndexColumn()
            ->make(true);
        }
        return view('administrator.delivery-order.index');
    }
    public function create( Request $request)
    {
        $shop_id = $request->shop_id;
        $zone_id = $request->zone_id;
        $from_loc = $request->from_location;
        // $drivers = User::where('user_type',2)
        //     ->where('status',1)->pluck('name', 'id')
        //     ->prepend(__('administrator.please_select' ), '')
        //     ->toArray();
        $drivers = User::where('user_type',2)
            ->where('status',1)
            ->select('name', 'id')
            ->get();
        $array = array();
        
        $index = $drivers->count() * 2;
        $in = 0;
        $time_policy = array(['id'=>'1','name'=>'ព្រឹក'],['id'=>'2','name'=>'ល្ងាច']);
        for($d=0;$d<$drivers->count();$d++){
            for($i=0;$i<2;$i++){
                array_push($array, ['id' => $drivers[$in]['id'], 'name' => $drivers[$in]['name'],'time_policy_id'=>$time_policy[$i]['id'],'time_policy_name'=>$time_policy[$i]['name']]);
            }
            $in +=1;
        }
        $drivers = $array;
        $data =ExportStockdetailsMode::
                join('nso007_export_stock','nso007_export_stock.id','nso007_export_stock_details.export_id')
                ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                ->select(
                    'nso007_category.image',
                    'nso007_export_stock.*',
                    'nso007_export_stock.location_name As name_location',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.*',
                    'nso007_export_stock.type_of_stock',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                    )
                // ->where('nso007_export_stock.type_of_stock',2)
                ->groupBy('nso007_export_stock.box_code')
                ->orderBy('nso007_export_stock.created_at','desc')
                ->Where('nso007_export_stock.status',1);
            $lang = Globals::check_lang();
            $zone = $data
                ->when($from_loc,function($q) use($from_loc){
                    $q->whereIn('nso007_export_stock.from_location',$from_loc);
                })->get()->pluck('location_name','location');
            // dd($zone);
           
            $shop = $data->get()->pluck('shop_name','merchant_id');
            $loc_array = array();
            foreach($data->get() as $zone_loc){
                $parent_zone = \DB::table('nso007_location')->whereRaw('FIND_IN_SET('.$zone_loc->location.',location_id)')
                    ->get('id')->first();
                if($parent_zone){
                    array_push($loc_array,$parent_zone->id);
                }
            }
            
            $loc_zone = \DB::table('nso007_location')->whereIn('id',$loc_array)
                                ->pluck('name_'.$lang.'','id');    

            $data = $data
                ->when($shop_id,function($q) use($shop_id){
                    $q->where('nso007_export_stock.merchant_id',$shop_id);
                })
                ->when($zone_id,function($q) use($zone_id){
                    $q->whereIn('nso007_export_stock.location',$zone_id);
                })
                ->when($from_loc,function($q) use($from_loc){
                    $q->whereIn('nso007_export_stock.from_location',$from_loc);
                })
                ->paginate(24);
            if ($request->ajax()) {
                if($request->need_location){
                    return $zone;
                }
                return view("administrator.delivery-order.result-create",compact('data'));
            }
            return view('administrator.delivery-order.create',compact('data','drivers','shop','zone','loc_zone'));
    }
    public function store(Request $request)
    {

       foreach(explode('||',$request->driver_id) as $key=>$val){
           if ($key == 0) {
               $request['driver_id']=$val;
           }else{
               $request['time_policy']=$val;
           }
        }
        

 
        if($request->export_id == null ){
            return redirect()->back()->with('danger','Not Box');
        }
        $dpl = DeliveryOrderDetailModel::whereIn('export_id',$request->export_id)
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                    ->select('box_code')
                    ->first();
        if($dpl){
            return redirect()->back()->with('danger','This Box '.$dpl->box_code.' Has Been Assign');
        }
        // try {
            $this->validate($request, [
                'delivery_date'         => 'required',
                'driver_id'             => 'required',
                'export_id.*'           => 'required',
            ]);
            $increas = '';
            $last_id =  DeliveryOrderModel::max('id');

            if ($last_id) {
                  $inovice = DeliveryOrderModel::latest('id')->first();
                $tran_num = $inovice->inovice;
                $tran_num = explode('DV', $tran_num);
                $increas = sprintf('DV'.'%08d', ($tran_num[1]+1));
            } else {
                $increas = 'DV00000001';
            }
            $deliveryorder = new  DeliveryOrderModel();
            $deliveryorder->inovice         = $increas;
            $deliveryorder->driver_id       = $request->driver_id;
            $deliveryorder->time_policy       = $request->time_policy;
            $deliveryorder->driver_name       = FindDriver($request->driver_id);

            $deliveryorder->delivery_date   =    date('Y-m-d', strtotime($request->delivery_date));
            $driver  =   User::find($request->driver_id);
            if ($deliveryorder->save()) {
                foreach ($request->export_id as $key => $value) {
                    update_status_by($request->export_id[$key]  , '2','status_proccess'); 
                    $delivery_order_detail =array(
                        'delivery_order_id'         =>  $deliveryorder->id ,
                        'export_id'                 =>  $request->export_id[$key] ,
                        'status'                    =>  1,
                        'driver_commission'         =>  $driver->share_fee,
                        'commission_type'           =>  $driver->share_fee_type,
                    );
                    DeliveryOrderDetailModel::insert($delivery_order_detail);
                    $delivery_order_detail['date'] = date('Y-m-d');
                    DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);

                }
            }
            session()->forget('box_session');
        return redirect()->back()->with('sussess','Import was add already successfully!');
    }
    public function show($id)
    {

        $data = DeliveryOrderModel::
                    join('nso007_delivery_order_detail_proccessing','nso007_delivery_order_detail_proccessing.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
                    ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                    ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                    ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                    ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                    ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');
                    if(\Globals::check_lang() == 'en'){
                    $data = $data-> select(
                            'nso007_export_stock.*',
                            'nso007_delivery_order.driver_id',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order.inovice',
                            'nso007_delivery_order_detail_proccessing.*',
                            'nso007_discount.*',
                            'nso007_discount.id AS discount_id',
                            'merchant.shop_name',
                            'merchant.phone',
                            'nso007_export_stock_details.currency',
                            'nso007_location.name_en AS name_location',
                            'nso007_category.name_en AS category_name',
                            'driver.name AS driver_name',
                            'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
                    );
                    }else{
                        $data = $data-> select(
                            'nso007_export_stock.*',
                            'nso007_delivery_order.driver_id',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order.inovice',
                            'nso007_delivery_order_detail_proccessing.*',
                            'merchant.shop_name',
                            'nso007_export_stock_details.price',
                            'merchant.phone',
                            'nso007_location.name_km AS name_location',
                            'nso007_category.name_km AS category_name',
                            'nso007_discount.id AS discount_id',
                            'nso007_discount.*',
                            'driver.name AS driver_name',
                            'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

                        );
                    }
                    $data = $data->groupBy('nso007_export_stock.box_code')
                            ->groupBy('nso007_export_stock_details.export_id')
                            ->orderBy('nso007_location.id', 'asc')
                            ->where('nso007_delivery_order_detail_proccessing.delivery_order_id',$id)
                            ->get();
        $total = 0 ;
        $total_delivery_fee = 0;
        $total_taxi_cust_fee = 0;
        foreach ($data as $key => $value) {
            $total += $value->price ;
            $total_delivery_fee += $value->delivery_fee;
            $total_taxi_cust_fee += $value->taxi_cust_fee;
        }
        return view('administrator.delivery-order.show',compact('data','total','total_delivery_fee','total_taxi_cust_fee'));
    }


    public function autocomplete(Request $request)
    {   
        $data = [];
        if (!empty($request->value)) {
            $arraySeesion = [];
            if (!empty(session()->get('box_session'))) {
                foreach (session()->get('box_session') as $key => $value) {
                    array_push($arraySeesion, $key);
                }
            }
            $value = $request->value;
            $data = ExportStockModel::
            select(
                'nso007_export_stock.*', 
                'nso007_location.name_km',
                'nso007_location.name_en',
                ) 
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->where('nso007_export_stock.status',1)
            ->where(function ($query) use ($value) {
                if($value){
                    $query->orWhere('nso007_export_stock.customer_receive', 'LIKE', '%' . $value . '%');
                    $query->orWhere('nso007_location.name_km', 'LIKE', '%' . $value . '%');
                    $query->orWhere('nso007_location.name_en', 'LIKE', '%' . $value . '%');
                }
            })
            ->whereNotIn('nso007_export_stock.box_code', $arraySeesion)
        ->get();
 
        }
        $view = view('administrator.delivery-order.search', compact('data'))->render();
        return response()->json(['html' => $view]);
    }
    public function get_list_view(){
        $tr = '';
        $i = 0;
        foreach (session('box_session') as $id => $box_sessions) {
            $i++;
            $tr.='
                <tr >
                    <td width="6%">'.$i.'</td>
                    <td width="16%">
                        <input type="text" name="box_code[]" class="form-control box_code" value="'.$box_sessions['box_code'].'" readonly>
                        <input type="hidden" name="export_id[]" value="'.$box_sessions['export_id'].'"    >
                    </td>
                    <td width="16%">
                        <input type="text" name="name_location[]" class="form-control all_key name_location"  value="'.$box_sessions['name_location'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="text" name="customer_receive[]" class="form-control all_key customer_receive" value="'.$box_sessions['customer_receive'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="number" name="price[]" class="form-control price number-only all_key" value="'.$box_sessions['price'].'" required  readonly >
                    </td>
                    <td width="16%">
                        <input type="number" name="delivery_fee[]" class="form-control number-only delivery_fee all_key" value="'.$box_sessions['delivery_fee'].'" readonly required>
                    </td>
                    <td width="9%">

                        <a class="btn-remove" data-id="'.$box_sessions['box_code'].'" ><span class="fa fa-close fa-2x  text-red"></span></a>
                    </td>
                </tr>
                    ';
        }
        echo $tr;
    }
    public function get_item_show_hide(){

        $array =[];
        foreach (session('box_session') as $id => $box_sessions) {
            $array[] =  $box_sessions['box_code'];
        }
        return response()->json($array);
    }

    public function delivery_order_removecart(Request $request)
    {

        if($request->type=='remove-one'){
            session()->forget('box_session.'.$request->id);
        }
        else if($request->type=='remove-one-all'){
            session()->forget('box_session');
        }
        else if($request->type=='remove-one-edit'){

            if($request->status=="can_delect"){
                session()->forget('box_code_edit.'.$request->id);

            }else{
                $box_code_edit = session()->get('box_code_edit');
                $box_code_delete = session()->get('box_code_delete');

                if(isset($box_code_delete[$request->id])) {
                    session()->put('box_code_delete', $box_code_delete);
                }
                else{
                    $box_code_delete[$request->id] = [
                        "box_code"              =>   $box_code_edit[$request->id]['box_code'],
                        "name_location"         =>   $box_code_edit[$request->id]['name_location'],
                        "customer_receive"      =>   $box_code_edit[$request->id]['customer_receive'],
                        "price"                 =>   $box_code_edit[$request->id]['price'],
                        "export_id"             =>   $box_code_edit[$request->id]['export_id'],
                        "delivery_fee"          =>   $box_code_edit[$request->id]['delivery_fee'],
                        'status'                =>   "not_delect"
                    ];

                    session()->put('box_code_delete', $box_code_delete);
                    session()->forget('box_code_edit.'.$request->id);
                    // dd(session()->put('box_code_delete', $box_code_delete));
                }
            }
        }

    }

    ////////////////////////////////EDIT////////////////////////////////
    public function edit( Request $request, $id)
    {
        $delivery_order_detail =$this->datable_delivery_order_data($id);
        // dd(session()->get("box_code_edit"));
            if (!empty(session()->get("box_code_edit"))) {
                $session_id =session()->get('session_inovice_delivery_order');
                if($session_id!=$delivery_order_detail[0]->inovice){

                    session()->forget('session_inovice_delivery_order');
                    session()->forget('box_code_edit');
                    session()->forget('box_code_delete');

                        if(empty(session()->get('box_code_edit'))){
                        foreach ($delivery_order_detail as $key => $delivery_order_details) {
                            $box_code_edit[$delivery_order_details->box_code] = [
                                "box_code"              => $delivery_order_details->box_code,
                                "name_location"         => $delivery_order_details->name_location,
                                "customer_receive"      => $delivery_order_details->customer_receive,
                                "price"                 => $delivery_order_details->total_price,
                                "export_id"             => $delivery_order_details->export_id,
                                "delivery_fee"          => $delivery_order_details->delivery_fee,
                                'status'                =>"not_delect"  ,
                            ];
                            session()->put('box_code_edit', $box_code_edit);
                        }
                    }
                    session()->put('session_inovice_delivery_order', $delivery_order_detail[0]->inovice);
                }
            }

                else{
                if(empty(session()->get('box_code_edit'))){
                    session()->forget('box_code_delete');
                    $session_id =session()->get('session_inovice_delivery_order');
                    if ($session_id!=$delivery_order_detail[0]->inovice) {
                        foreach ($delivery_order_detail as $key => $delivery_order_details) {
                            $box_code_edit[$delivery_order_details->box_code] = [
                                "box_code"              => $delivery_order_details->box_code,
                                "name_location"         => $delivery_order_details->name_location,
                                "customer_receive"      => $delivery_order_details->customer_receive,
                                "price"                 => $delivery_order_details->total_price,
                                "export_id"             => $delivery_order_details->export_id,
                                "delivery_fee"          => $delivery_order_details->delivery_fee,
                                'status'                =>"not_delect"  ,
                            ];
                            session()->put('box_code_edit', $box_code_edit);
                        }
                        session()->put('session_inovice_delivery_order', @$delivery_order_details[0]->inovice);
                    }
                }
            }

        $drivers = User::where('user_type',2)->where('status',1)->pluck('name', 'id')->prepend(__('administrator.please_select' ), '')->toArray();
        $data =ExportStockdetailsMode::
                join('nso007_export_stock','nso007_export_stock.id','nso007_export_stock_details.export_id')
                ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                ->select(
                    'nso007_category.image',
                    'nso007_export_stock.*', 'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.*',
                    'users.name AS user_create',
                    'merchant.shop_name',
                    'nso007_location.name_km AS name_location',
                    'nso007_export_stock.type_of_stock',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                    )
                ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                ->join('users','users.id','nso007_export_stock.created_by')
                ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                ->groupBy('nso007_export_stock.box_code')
                ->orderBy('nso007_export_stock.created_at','desc')
                ->Where('nso007_export_stock.status',1)
                ->paginate(12);
        if ($request->ajax()) {
            return view("administrator.delivery-order.result-create",compact('data'));
        }
        return view('administrator.delivery-order.edit',compact('delivery_order_detail','data','drivers'));
    }

    public function update(Request $request, $delivery_order_id)
    {
        $this->validate($request, [
            'delivery_date'         => 'required',
            'driver_id'             => 'required',
            'export_id.*'           => 'required',
        ]);

        if($request->old_drive_id  ==  $request->driver_id){
            $deliveryorder =   DeliveryOrderModel::find($delivery_order_id);
            $deliveryorder->driver_id       = $request->driver_id;
            $deliveryorder->driver_name       = FindDriver($request->driver_id);
            $deliveryorder->delivery_date   =  date('Y-m-d',strtotime($request->delivery_date));
            $deliveryorder->update();

            if (session('box_code_delete')) {
                foreach (session('box_code_delete') as $id => $box_sessions) {
                    // ExportStockModel::find($box_sessions['export_id'])->update(['status'=>1]);
                    update_status_by($box_sessions['export_id']  , '1','status_proccess');

                    DeliveryOrderDetailProccessingModel::where('export_id', $box_sessions['export_id'])->delete();
                    DeliveryOrderDetailModel::where('export_id', $box_sessions['export_id'])->delete();
                }
            }
            $data = \DB::table('users')->find($request->driver_id);


            foreach ($request->export_id as $key => $value) {
                        if($request->status[$key] == 'can_delect'){
                            // ExportStockModel::where('id',$request->export_id[$key])->update(['status' => 2]);
                            update_status_by($request->export_id[$key]  , '2','status_proccess');

                            // dd($id );
                            $delivery_order_detail =array(
                                'delivery_order_id'         =>  $delivery_order_id ,
                                'export_id'                 =>  $request->export_id[$key] ,
                                'status'                    =>  1,
                                'commission_type'           =>  $data->share_fee_type  ,
                                'driver_commission'         =>  $data->share_fee
                            );
                            DeliveryOrderDetailModel::insert($delivery_order_detail);
                            $delivery_order_detail['date'] = date('Y-m-d');
                            DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);
                        }
                    }
                $deliveryorderdetail =   DeliveryOrderDetailModel::where('delivery_order_id',$delivery_order_id)->get();
                foreach ($deliveryorderdetail as $key => $value) {
                        \DB::table('nso007_delivery_order_detail')
                        ->where('id', $deliveryorderdetail[$key ]->id)
                        ->where('status',1)
                        ->update(['driver_commission'=>$data->share_fee, 'commission_type'=>$data->share_fee_type]);
                }

                \DB::table('nso007_delivery_order_detail')
                ->where('delivery_order_id',$delivery_order_id)->update(['delivery_order_id'=>$deliveryorder->id,'driver_commission'=> $data->share_fee,'commission_type'=>$data->share_fee_type]);
                \DB::table('nso007_delivery_order_detail_proccessing')
                ->where('delivery_order_id',$delivery_order_id)->update(['delivery_order_id'=>$deliveryorder->id,'driver_commission'=> $data->share_fee,'commission_type'=>$data->share_fee_type]);
        }
        else{
            $count_Proce = \DB::table('nso007_delivery_order_detail')
                    ->whereIn('status', [2,3,4])
                    ->where('delivery_order_id',$delivery_order_id)->get();
            $count = $count_Proce->count();
            if($count == 0) {
            $deliveryorder =   DeliveryOrderModel::find($delivery_order_id);
                $deliveryorder->driver_id       = $request->driver_id;
                $deliveryorder->driver_name       = FindDriver($request->driver_id);

                $deliveryorder->delivery_date   = date('Y-m-d',strtotime($request->delivery_date));
                $deliveryorder->update();
                if (session('box_code_delete')) {
                    foreach (session('box_code_delete') as $id => $box_sessions) {
                        // ExportStockModel::find($box_sessions['export_id'])->update(['status'=>1]);
                        update_status_by($box_sessions['export_id']  , '1','status_proccess');
                        DeliveryOrderDetailProccessingModel::where('export_id', $box_sessions['export_id'])->delete();
                        DeliveryOrderDetailModel::where('export_id', $box_sessions['export_id'])->delete();
                    }
                }
                $data = \DB::table('users')->find($request->driver_id);
                foreach ($request->export_id as $key => $value) {
                            if($request->status[$key] == 'can_delect'){
                                // ExportStockModel::where('id',$request->export_id[$key])->update(['status' => 2]);
                                    update_status_by($request->export_id[$key]  , '2','status_proccess');

                                // dd($id );
                                $delivery_order_detail =array(
                                    'delivery_order_id'         =>  $delivery_order_id ,
                                    'export_id'                 =>  $request->export_id[$key] ,
                                    'status'                    =>  1,
                                    'commission_type'           =>  $data->share_fee_type  ,
                                    'driver_commission'         =>  $data->share_fee
                                );

                                DeliveryOrderDetailModel::insert($delivery_order_detail);
                                $delivery_order_detail['date'] = date('Y-m-d');
                                DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);
                            }
                        }
                        \DB::table('nso007_delivery_order_detail')
                        ->whereNotIn('status', [2,3,4])
                        ->where('delivery_order_id',$delivery_order_id)->update(['delivery_order_id'=>$deliveryorder->id,'driver_commission'=> $data->share_fee,'commission_type'=>$data->share_fee_type]);
                        \DB::table('nso007_delivery_order_detail_proccessing')
                        ->whereNotIn('status', [2,3,4])
                        ->where('delivery_order_id',$delivery_order_id)->update(['delivery_order_id'=>$deliveryorder->id,'driver_commission'=> $data->share_fee,'commission_type'=>$data->share_fee_type]);
            }else{
                $increas = '';
                $last_id =  DeliveryOrderModel::max('id');

                if ($last_id) {
                    $inovice = DeliveryOrderModel::select('inovice')->get()->last();
                    $tran_num = $inovice->inovice;
                    $tran_num = explode('DV', $tran_num);
                    $increas = sprintf('DV'.'%08d', ($tran_num[1]+1));
                } else {
                    $increas = 'DV00000001';
                }

                $deliveryorder = new  DeliveryOrderModel();
                $deliveryorder->driver_id       = $request->driver_id;
                $deliveryorder->driver_name       = FindDriver($request->driver_id);
                $deliveryorder->inovice         = $increas;
                $deliveryorder->delivery_date   = date('Y-m-d',strtotime($request->delivery_date));
                $deliveryorder->save();
                if (session('box_code_delete')) {
                    foreach (session('box_code_delete') as $id => $box_sessions) {
                        // ExportStockModel::find($box_sessions['export_id'])->update(['status'=>1]);
                        update_status_by($box_sessions['export_id']  , '1','status_proccess');
                        DeliveryOrderDetailProccessingModel::where('export_id', $box_sessions['export_id'])->delete();
                        DeliveryOrderDetailModel::where('export_id', $box_sessions['export_id'])->delete();
                    }
                }
                $data = \DB::table('users')->find($request->driver_id);
                foreach ($request->export_id as $key => $value) {
                            if($request->status[$key] == 'can_delect'){
                                // ExportStockModel::where('id',$request->export_id[$key])->update(['status' => 2]);
                            update_status_by($request->export_id[$key]  , '2','status_proccess');

                            // dd($id );
                            $delivery_order_detail =array(
                                'delivery_order_id'         => $deliveryorder->id ,
                                'export_id'                 =>  $request->export_id[$key] ,
                                'status'                    =>  1,
                                'commission_type'           =>  $data->share_fee_type  ,
                                'driver_commission'         =>  $data->share_fee
                            );
                            DeliveryOrderDetailModel::insert($delivery_order_detail);
                            $delivery_order_detail['date'] = date('Y-m-d');
                            DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);
                        }
            }

        \DB::table('nso007_delivery_order_detail')
        ->whereNotIn('status', [2,3,4])
        ->where('delivery_order_id',$delivery_order_id)->update(['delivery_order_id'=>$deliveryorder->id,'driver_commission'=> $data->share_fee,'commission_type'=>$data->share_fee_type]);
        \DB::table('nso007_delivery_order_detail_proccessing')
        ->whereNotIn('status', [2,3,4])
        ->where('delivery_order_id',$delivery_order_id)->update(['delivery_order_id'=>$deliveryorder->id,'driver_commission'=> $data->share_fee,'commission_type'=>$data->share_fee_type]);
    }
}

session()->forget('box_code_delete');
session()->forget('session_inovice_delivery_order');
session()->forget('box_code_edit');
// }
// catch (\Exception $e) {
//     DB::rollback();
//     return redirect()->back()->with('danger',$e->getMessage());
// }
return redirect()->route('delivery-order.index')->with('sussess','Import was add already successfully!');

}

    public function get_list_view_edit(){

        $tr = '';
        $i = 0;
        foreach (session('box_code_edit') as $id => $box_sessions) {
            $i++;
            $tr.='
                <tr >
                    <td width="5%">'.$i.'</td>
                    <td width="16%">
                        <input type="text" name="box_code[]" class="form-control box_code" value="'.$box_sessions['box_code'].'" readonly>
                        <input type="hidden" name="export_id[]" value="'.$box_sessions['export_id'].'">
                        <input type="hidden" name="status[]" value="'.$box_sessions['status'].'">
                    </td>
                    <td width="16%">
                        <input type="text" name="name_location[]" class="form-control all_key name_location"  value="'.$box_sessions['name_location'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="text" name="customer_receive[]" class="form-control all_key customer_receive" value="'.$box_sessions['customer_receive'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="number" name="price[]" class="form-control price number-only all_key" value="'.$box_sessions['price'].'" required  readonly >
                    </td>
                    <td width="16%">
                        <input type="number" name="delivery_fee[]" class="form-control number-only delivery_fee all_key" value="'.$box_sessions['delivery_fee'].'" readonly required>
                    </td>
                    <td width="9%">
                        <a class="btn-remove" data-id="'.$box_sessions['box_code'].'"  data-status="'.$box_sessions['status'].'"><span class="fa fa-close fa-2x  text-red"></span></a>
                    </td>
                </tr>
                    ';
        }
        echo $tr;
    }
    
    public  function get_product( Request $request){
        $box_code = (empty($request->id)?$request->get('term') :$request->id);
        $Incorrect = '';
        if(\Globals::check_lang() == 'en'){
            $data = ExportStockModel::select(
                        // 'nso007_category.image',
                        'nso007_export_stock.id AS export_id',
                        'nso007_export_stock.*', 
                        'nso007_export_stock.delivery_fee AS delivery_fees',
                        'nso007_export_stock.id AS export_stock_id',
                        'nso007_export_stock.location_name AS name_location',
                        'nso007_export_stock.type_of_stock',
                        'nso007_export_stock.total_product AS total_price'
                    )
                    ->Where('nso007_export_stock.status',1)
                    ->where('nso007_export_stock.box_code',$box_code )
                    ->first();
        }else{
            $data = ExportStockModel::select(
                            'nso007_export_stock.id AS export_id',
                            // 'nso007_category.image',
                            'nso007_export_stock.*', 
                            'nso007_export_stock.delivery_fee AS delivery_fees',
                            'nso007_export_stock.id AS export_stock_id',
                            'nso007_export_stock.location_name AS name_location',
                            'nso007_export_stock.type_of_stock',
                            'nso007_export_stock.total_product AS total_price'
                        )
                        ->Where('nso007_export_stock.status',1)
                        ->where('nso007_export_stock.box_code',$box_code )
                        ->first();
        }

        $status = '';
        $box_session = session()->get('box_session');
        if(!$data) {
            $status = 'Product Code is Incorrect!';
            $Incorrect = "Incorrect";
        }
        else{
            if(isset($box_session[$box_code])) {
                session()->put('box_session', $box_session);
                $status = 'alert_already_exist';
                $Incorrect = "Incorrect";
            }
            else{
                if($data->box_code){
                    $box_session[$box_code] = [
                        "box_code"              => $data->box_code,
                        "name_location"         => $data->name_location,
                        "customer_receive"      => $data->customer_receive,
                        "price"                 => $data->total_price,
                        "export_id"             => $data->export_id,
                        "delivery_fee"          => $data->delivery_fees,
                    ];
                    session()->put('box_session', $box_session);
                    $status ='success';
                }
                else{
                    $status ='incorrect';
                }
            }
        }
        return response()->json(['status'=>$status,'incorrect'=>$Incorrect ? $Incorrect : '']);
    }
    public  function get_product_array( Request $request){
        $box_code = (empty($request->id)?$request->get('term') :$request->id);
        $lang = Globals::check_lang();
        $data = ExportStockModel::select(
                    // 'nso007_category.image',
                    'nso007_export_stock.id AS export_id',
                    'nso007_export_stock.*', 
                    'nso007_export_stock.delivery_fee AS delivery_fees',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock.type_of_stock',
                    'nso007_export_stock.total_product AS total_price'
                )
                ->Where('nso007_export_stock.status',1)
                ->whereIn('nso007_export_stock.box_code',$box_code )
                ->get();
        $status = '';
        $box_session = session()->get('box_session');

        if(!$data) {
            $status = 'Product Code is Incorrect!';
        }
        else{
            foreach ($data as $key=>$val) {
                
                if (isset($box_session[$val->box_code])) {
                    session()->put('box_session', $box_session);
                    $status = 'alert_already_exist';
                } else {
                    
                    if ($val->box_code) {
                        $box_session[$val->box_code] = [
                        "box_code"              => $val->box_code,
                        "name_location"         => $val->name_location,
                        "customer_receive"      => $val->customer_receive,
                        "price"                 => $val->total_price,
                        "export_id"             => $val->export_id,
                        "delivery_fee"          => $val->delivery_fees,
                    ];
                        session()->put('box_session', $box_session);
                        $status ='success';
                    } else {
                        $status ='incorrect';
                    }
                }
            }
        }
        return response()->json($status);
    }


    public  function get_product_edit( Request $request){
        $status = '';
            if($request->type){
                $box_code_edit = session()->get('box_code_edit');
                if(isset($box_code_edit[$request->id])) {
                    session()->put('box_code_edit', $box_code_edit);
                    $status = 'alert_already_exist';
                }
                else{
                        $box_code_edit[$request->id] = [
                            "box_code"              =>$request->id,
                            "name_location"         =>$request->name_location,
                            "customer_receive"      =>$request->customer_receive,
                            "price"                 =>$request->price,
                            "export_id"             =>$request->export_id,
                            "delivery_fee"          =>$request->delivery_fee,
                            'status'                =>"not_delect"
                        ];
                        session()->put('box_code_edit', $box_code_edit);
                        session()->forget('box_code_delete.'.$request->id);
                        $status = 'success';
                }
            }else{
                $box_code = (empty($request->id)?$request->get('term') :$request->id);

                if(\Globals::check_lang() == 'en'){
                    $data = ExportStockModel::select(
                                // 'nso007_category.image',
                                'nso007_export_stock.id AS export_id',
                                'nso007_export_stock.*', 
                                'nso007_export_stock.delivery_fee AS delivery_fees',
                                'nso007_export_stock.id AS export_stock_id',
                                'nso007_export_stock.location_name AS name_location',
                                'nso007_export_stock.type_of_stock',
                                'nso007_export_stock.total_product AS total_price'
                            )
                            ->Where('nso007_export_stock.status',1)
                            ->where('nso007_export_stock.box_code',$box_code )
                            ->first();
                }else{
                    $data = ExportStockModel::select(
                                    'nso007_export_stock.id AS export_id',
                                    // 'nso007_category.image',
                                    'nso007_export_stock.*', 
                                    'nso007_export_stock.delivery_fee AS delivery_fees',
                                    'nso007_export_stock.id AS export_stock_id',
                                    'nso007_export_stock.location_name AS name_location',
                                    'nso007_export_stock.type_of_stock',
                                    'nso007_export_stock.total_product AS total_price'
                                )
                                ->Where('nso007_export_stock.status',1)
                                ->where('nso007_export_stock.box_code',$box_code )
                                ->first();
                }

                $box_code_edit = session()->get('box_code_edit');
                if(!$data) {
                    $status = 'Product Code is Incorrect!';
                }
                else{
                    if(isset($box_code_edit[$box_code])) {
                        session()->put('box_code_edit', $box_code_edit);
                        $status = 'alert_already_exist';
                    }
                    else{
                        if($data->box_code){
                            $box_code_edit[$box_code] = [
                                "box_code"              => $data->box_code,
                                "name_location"         => $data->name_location,
                                "customer_receive"      => $data->customer_receive,
                                "price"                 => $data->price,
                                "export_id"             => $data->export_id,
                                "delivery_fee"          => $data->delivery_fee,
                                'status'                =>"can_delect"
                            ];
                            session()->put('box_code_edit', $box_code_edit);
                            $status = 'success';
                        }
                        else{
                            $status = 'incorrect';
                        }
                    }
                }
            }

        echo $status;
    }

    // public function autocomplete(Request $request)
    // {
    //     if (!empty($request->value)) {
    //         $arraySeesion = [];
    //         if (!empty(session()->get('box_session'))) {
    //             foreach (session()->get('box_session') as $key => $value) {
    //                 array_push($arraySeesion, $key);
    //             }
    //         }
    //         $value = $request->value;
    //         $data = ExportStockModel::
    //         select(
    //             'nso007_export_stock.*', 
    //             'nso007_location.name_km',
    //             'nso007_location.name_en',
    //             ) 
    //         ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
    //         ->where('nso007_export_stock.status',1)
    //         ->where(function ($query) use ($value) {
    //             if($value){
    //                 $query->orWhere('nso007_export_stock.customer_receive', 'LIKE', '%' . $value . '%');
    //                 $query->orWhere('nso007_location.name_km', 'LIKE', '%' . $value . '%');
    //                 $query->orWhere('nso007_location.name_en', 'LIKE', '%' . $value . '%');
    //             }
    //         })
    //         ->whereNotIn('nso007_export_stock.box_code', $arraySeesion)
    //         ->get(); 
    //     }
    //     $view = view('administrator.delivery-order.search', compact('data'))->render();
    //     return response()->json(['html' => $view]);
    // }


    public function autocomplete_edit(Request $request)
    {
        if (!empty($request->value)) {
            $arraySeesion = [];
            if (!empty(session()->get('box_code_edit'))) {
                foreach (session()->get('box_code_edit') as $key => $value) {
                    array_push($arraySeesion, $key);
                }
            }
            $value = $request->value;
            $data = ExportStockModel::
            select(
                'nso007_export_stock.*', 
                'nso007_location.name_km',
                'nso007_location.name_en',
                ) 
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->where('nso007_export_stock.status',1)
            ->where(function ($query) use ($value) {
                if($value){
                    $query->orWhere('nso007_export_stock.customer_receive', 'LIKE', '%' . $value . '%');
                    $query->orWhere('nso007_location.name_km', 'LIKE', '%' . $value . '%');
                    $query->orWhere('nso007_location.name_en', 'LIKE', '%' . $value . '%');
                }
            })
            ->whereNotIn('nso007_export_stock.box_code', $arraySeesion)
            ->get(); 
        }
        $view = view('administrator.delivery-order.search', compact('data'))->render();
        return response()->json(['html' => $view]);
    }

    public function get_list_view_delete(){
        $box_code_delete = session()->get('box_code_delete');
        $tr = '';
        foreach ($box_code_delete as $id => $box_sessions) {
            $barcode_img =asset("/images/upload/category/default.jpg");
            $tr.='
                <div class="col-sm-3 col-xs-6 paddin-5"​​​>
                    <div class="item-show">
                        <a class="add-product cursor"
                            data-name_location="'.$box_sessions['name_location'].'"
                            data-customer_receive="'.$box_sessions['customer_receive'].'"
                            data-price="'.$box_sessions['price'].'"
                            data-export_id="'.$box_sessions['export_id'].'"
                            data-delivery_fee="'.$box_sessions['delivery_fee'].'"
                            data-id="'.$box_sessions['box_code'].'"
                            data-type="1"  >
                        <img src="'.$barcode_img.'" >
                        <span class="item-show-name">
                            '.$box_sessions['box_code'].' </br>
                            '.$box_sessions['customer_receive'].'</br>
                            '.$box_sessions['name_location'].'
                        </span>

                        </a>
                    </div>
                </div>
                ';
        }
        echo $tr;
    }

    public function reset_session(Request $request){
        session()->forget('box_code_delete');
        session()->forget('box_code_edit');
        session()->forget('session_inovice_delivery_order');
    }

    public function delivery_order_list($id)
    {
            session()->forget('session_id_list_order');
            session()->put('session_id_list_order', $id);
            $data = $this->datable_delivery_order_data($id);
            // dd($data);
            return view('administrator.delivery-order.delivery-list-show',compact('data'));
    }


    public function datable_delivery_order_data($id){
        $data = DeliveryOrderModel::
                    join('nso007_delivery_order_detail_proccessing','nso007_delivery_order_detail_proccessing.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
                    ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                    ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                    ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                    ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                    ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');
                    if(\Globals::check_lang() == 'en'){
                    $data = $data-> select(
                            'nso007_export_stock.*',
                            'nso007_delivery_order.driver_id',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order.inovice',
                            'nso007_export_stock.delivery_option',
                            'nso007_delivery_order_detail_proccessing.*',
                            'nso007_export_stock.box_code',
                            'nso007_export_stock.taxi_number',
                            'nso007_export_stock.delivery_status',
                            'nso007_export_stock.taxi_shop_fee',
                            'nso007_export_stock.taxi_cust_fee',
                            'nso007_export_stock.taxi_status',
                            'nso007_export_stock.delivery_fee',
                            'nso007_export_stock.description as ex_description',
                            'nso007_export_stock.customer_receive',
                            'nso007_export_stock.type_of_stock',
                            'nso007_export_stock.id',
                            'nso007_discount.*',
                            'nso007_discount.id AS discount_id',
                            'merchant.shop_name',
                            'merchant.user_currency',
                            'merchant.phone',
                            'nso007_export_stock_details.currency',
                            'nso007_location.name_en AS name_location',
                            'nso007_category.name_en AS category_name',
                            'nso007_export_stock.extra_fee_type',
                            'nso007_export_stock.extra_fee',
                            'driver.name AS driver_name',
                            'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
                    );
                    }else{
                        $data = $data-> select(
                            'nso007_export_stock.*',
                            'nso007_delivery_order.driver_id',
                            'nso007_delivery_order.delivery_date',
                            'nso007_delivery_order.inovice',
                            'nso007_export_stock.delivery_option',
                            'nso007_delivery_order_detail_proccessing.*',
                            'nso007_export_stock.box_code',
                            'nso007_export_stock.taxi_number',
                            'nso007_export_stock.delivery_status',
                            'nso007_export_stock.taxi_shop_fee',
                            'nso007_export_stock.taxi_cust_fee',
                            'nso007_export_stock.taxi_status',
                            'nso007_export_stock.delivery_fee',
                            'nso007_export_stock.extra_fee_type',
                            'nso007_export_stock.extra_fee',
                            'nso007_export_stock.description as ex_description',
                            'nso007_export_stock.customer_receive',
                            'nso007_export_stock_details.currency',
                            'merchant.shop_name',
                            'nso007_export_stock_details.price',
                            'merchant.user_currency',
                            'merchant.phone',
                            'nso007_location.name_km AS name_location',
                            'nso007_category.name_km AS category_name',
                            'nso007_discount.id AS discount_id',
                            'nso007_discount.*',
                            'driver.name AS driver_name',
                            'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                            DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

                        );
                    }
                    $data = $data->groupBy('nso007_export_stock.box_code')
                            ->groupBy('nso007_export_stock_details.export_id')
                            ->orderBy('nso007_location.id', 'desc')
                            ->where('nso007_delivery_order_detail_proccessing.delivery_order_id',$id)
                            ->get(); 
        return $data;
    }
    public function datable_delivery_order_list( Request $request){
        $id  = session()->get('session_id_list_order');
        $data = $this->datable_delivery_order_data( $id );
        // dd( $data);

        if ($request->ajax()) {
            return  Datatables::of($data)
            ->editColumn('delivery_date', function($data) {   return date('d-m-Y',strtotime($data->delivery_date));   })
            ->editColumn('total_price', function($data) {   return '$'.number_format($data->total_price, 2);      })
            ->editColumn('buy_fee', function($data) {
               if($data->taxi_status == 1){  $buy_fee = '$'.number_format($data->taxi_shop_fee, 2); }
               else{    $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);       }
               return $buy_fee;
            })

            ->editColumn('delivery_fee', function($data) {
                $delivery_fee  = 0;
                if($data->discount_type != null || $data->discount_type != '')
                {
                    if($data->discount_type == 1){
                        $delivery_fee = $data->discount;
                    }
                    elseif($data->discount_type == 2){
                        $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                    }
                    else{
                        $delivery_fee = $data->delivery_fee;
                    }
                }
                else{
                    $delivery_fee  =  $data->delivery_fee;
                }



                if ($data->delivery_status == 1) {
                    $delivery_fee = '$' . number_format($delivery_fee, 2);
                } else {
                    $delivery_fee = '$' . number_format($delivery_fee, 2);
                }
                return $delivery_fee;
            })

            ->addColumn('pay_all',function($data){
                return '<input type="checkbox" name="check" class="checkbox" data-box_code="'.$data->box_code.'"  data-delivery_order_detail_proccessing_id="'.$data->delivery_order_detail_proccessing_id.'" data-export_id="'.$data->export_id.'" >';
            })

            ->addColumn('description',function($data){
                return $data->total_riel > 0 ? $data->ex_description.' ('.$data->total_riel.'៛)':$data->ex_description;
            })
            ->editColumn('other_services_fee', function($data) {
                $other_services_fee = '';
                // if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                //     $other_services_fee  =   $data->other_services_fee ;
                // }

                if($data->other_services_fee > 0 ){
                    if($data->other_services_type == 1){
                        $other_services_fee = '$'.number_format($data->other_services_type, 2) .' s';
                    }
                    else{
                        $other_services_fee ='$'.number_format($data->other_services_type, 2).' c';
                    }

                    if($data->other_services_pay_or_paid == 'paid'){
                        $other_services_fee .=  ' (paid)';
                    }
                }else{
                    $other_services_fee =  '';
                }

                return $other_services_fee ;

            })
            ->addColumn('action', function($data) {
                if($data->discount_type != null || $data->discount_type != '')
                {
                    if($data->discount_type == 1){
                        $delivery_fee = $data->discount;
                    }
                    elseif($data->discount_type == 2){
                        $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee ) / 100;
                    }
                    else{
                        $delivery_fee = $data->delivery_fee;
                    }
                }
                else{
                    $delivery_fee  =  $data->delivery_fee;
                }

                if($data->delivery_pay_or_paid == 'paid'){
                    $delivery_fee  =  0;
                }

                $other_services_fee =  0;
                if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                    $other_services_fee = $data->other_services_fee ;
                }

                $edit = '
                <label class="btn_sm button_success bt_done" data-status="1" data-export_id="'.$data->export_id.'" >'.__('administrator.done').'</label>
                <label class="btn_sm button_warning bt_pending" data-status="2" data-export_id="'.$data->export_id.'">'.__('administrator.pending').'</label>
                <label class="btn_sm button_danger bt_cencel" data-status="3" data-export_id="'.$data->export_id.'" >'.__('administrator.cancel').'</label>
                <label class="btn_sm button_primary edit_price_of_car"
                            data-export_id="'.$data->export_id.'"
                            data-price="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                            data-delivery_option="'.$data->delivery_option.'"​​
                            data-currency="'.$data->currency.'"​​
                            data-taxi_status="'.$data->taxi_status.'"​​
                            data-taxi_shop_fee="'.$data->taxi_shop_fee.'"​​
                            data-taxi_cust_fee="'.$data->taxi_cust_fee.'"​​
                            data-taxi_number="'.$data->taxi_number.'"​​
                            data-total_riel="'.$data->total_riel.'"​​
                            data-total_dollar="'.$data->total_dollar.'"​​
                            data-extra_fee="'.$data->extra_fee.'"​​
                            data-extra_fee_type="'.$data->extra_fee_type.'"​​
                            data-driver_note="'.$data->driver_note.'"​​
                            data-user_currency="'.$data->user_currency.'"​​

                    >'.__('administrator.edit_delivey').'</label>';
                return $edit;
            })
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })
            ->rawColumns(['pay_all'=>'pay_all'])
            ->addIndexColumn()
            ->make(true);
        }
    }

    public function delivery_order_action($id,$status,$reason = null,Request $request)
    {
        if ($status == 1) {
            // this box code is success
            $money = \DB::table('nso007_export_stock')
                    ->join('nso007_export_stock_details', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                    ->select(
                        'nso007_export_stock.*' ,
                        'nso007_discount.*', 
                        \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                        \DB::raw("( CASE WHEN nso007_export_stock.extra_fee_type = 2 THEN nso007_export_stock.extra_fee END ) AS total_extra_fee_cus"),

                        \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                        'nso007_export_stock.delivery_fee',
                        'nso007_export_stock.delivery_status',
                        'nso007_export_stock.id'
                        )
                    ->whereIn('nso007_export_stock.id', explode(',', $id))
                    ->groupBy('nso007_export_stock.id')
                    ->get();


                $total = 0;
                foreach ($money as $key => $value) {
                    if($value->discount_type != null || $value->discount_type != '')
                        {
                            if($value->discount_type == 1){
                                $delivery_fee = $value->discount;
                            }
                            else{
                                $delivery_fee = (( 100 - $value->discount) * $value->delivery_fee ) / 100;
                            }
                        }
                        else{
                            $delivery_fee  =  $value->delivery_fee;
                        }

                        if($value->delivery_pay_or_paid == 'paid'){
                            $delivery_fee  =  0;
                        }

                        $other_services_fee =  0;
                        if($value->other_services_fee > 0 && $value->other_services_pay_or_paid == 'pay' && $value->other_services_type == 2){
                            $other_services_fee = $value->other_services_fee ;
                        }

                    if ($value->delivery_status == 1) {
                        $total = $value->total  + $value->total_extra_fee_cus + $other_services_fee;
                    } else {
                        $total = $value->total + $delivery_fee + $value->total_extra_fee_cus + $other_services_fee;
                    }
                    $checkMoney = \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->first();
  

                    if($checkMoney->pay_to == ''){
                        if ($checkMoney->total_riel != 0 || $checkMoney->total_dollar != 0) {
                            \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3]);
                        } else {
                            \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3,'total_dollar'=>$total,'total_riel'=>0]);
                        }
                    }else{
                            \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3]);
                    }
 
                }
                \DB::table('nso007_export_stock')->whereIn('id', explode(',', $id))->update(['status'=>3]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->whereIn('export_id', explode(',', $id))->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->whereIn('export_id', explode(',', $id))->delete();
                $success = json_decode($data, true);
                DeliveryOrderDetailSuccessModel::insert($success);

            }else if($status == 2){
                // this box code is padding
                // \DB::table('nso007_export_stock')->where('id',$id)->update(['status'=>4]);
                // update_status_by($id,4);
                update_status_by($id,4,'status_last');


                \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',1)->update(['status'=>2,'reason'=>$reason]);
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->update(['reason'=>$reason,'date'=>date('Y-m-d')]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->delete();
                $padding = json_decode($data, true);
                DeliveryOrderDetailPaddingModel::insert($padding);
                historyBox($id,4,$reason);

            }else if($status == 3){
                //this box code is cancel
                // \DB::table('nso007_export_stock')->where('id',$id)->update(['status'=>5]);
                // update_status_by($id,4);
                update_status_by($id,5,'status_last');
                historyBox($id,5,$reason);
                \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',1)->update(['reason'=>$reason,'status'=>4]);
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->update(['reason'=>$reason,'date'=>date('Y-m-d')]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->delete();

                // JournalModel::where('status_ref', 'taxi shop pay')->where('journal_referenceid', $id)->delete();
                // JournalModel::where('status_ref', 'taxi shop paid')->where('journal_referenceid', $id)->delete();
                // JournalModel::where('status_ref', 'other services shop paid')->where('journal_referenceid', $id)->delete();
                // JournalModel::where('status_ref', 'other services shop pay')->where('journal_referenceid', $id)->delete();

                $cancel = json_decode($data, true);
                DeliveryOrderDetailCancelModel::insert($cancel);
                $cancels =   \DB::table('nso007_export_stock')
                            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                            ->join('users','users.id','nso007_export_stock.merchant_id')
                            ->join('nso007_products','nso007_products.barcode','nso007_export_stock_details.barcode')
                            ->select(
                                'users.id as merchant_id','nso007_products.barcode',
                                'nso007_export_stock_details.export_qty'
                            )
                            ->where('nso007_export_stock.id',$id)->get();
                foreach ($cancels as $key => $value) {
                    \DB::table('nos007__stocks')
                    ->where('merchant_id',$value->merchant_id)
                    ->where('barcode',$value->barcode)
                    ->increment('stock_qty',$value->export_qty);
                }
            }
        //     \DB::commit();
        // } catch( \Exception $e){
        //     \DB::rollback();
        //     return redirect()->back()->with('danger',$e->getMessage());
        // }
        if($request->ajax()){
            return response()->json(200);
        }
        return redirect()->back();
    }
    public function delivery_order_action_ajax($id,$status,$reason = null)
    {
        if ($status == 1) {
            // this box code is success
            $money = \DB::table('nso007_export_stock')
                    ->join('nso007_export_stock_details', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                    ->select(
                        'nso007_export_stock.*' ,
                        'nso007_discount.*', 
                        \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                        \DB::raw("( CASE WHEN nso007_export_stock.extra_fee_type = 2 THEN nso007_export_stock.extra_fee END ) AS total_extra_fee_cus"),

                        \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                        'nso007_export_stock.delivery_fee',
                        'nso007_export_stock.delivery_status',
                        'nso007_export_stock.id'
                        )
                    ->whereIn('nso007_export_stock.id', explode(',', $id))
                    ->groupBy('nso007_export_stock.id')
                    ->get();


                $total = 0;
                foreach ($money as $key => $value) {
                    if($value->discount_type != null || $value->discount_type != '')
                        {
                            if($value->discount_type == 1){
                                $delivery_fee = $value->discount;
                            }
                            else{
                                $delivery_fee = (( 100 - $value->discount) * $value->delivery_fee ) / 100;
                            }
                        }
                        else{
                            $delivery_fee  =  $value->delivery_fee;
                        }

                        if($value->delivery_pay_or_paid == 'paid'){
                            $delivery_fee  =  0;
                        }

                        $other_services_fee =  0;
                        if($value->other_services_fee > 0 && $value->other_services_pay_or_paid == 'pay' && $value->other_services_type == 2){
                            $other_services_fee = $value->other_services_fee ;
                        }

                    if ($value->delivery_status == 1) {
                        $total = $value->total  + $value->total_extra_fee_cus + $other_services_fee;
                    } else {
                        $total = $value->total + $delivery_fee + $value->total_extra_fee_cus + $other_services_fee;
                    }
                    $checkMoney = \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->first();
  

                    if($checkMoney->pay_to == ''){
                        if ($checkMoney->total_riel != 0 || $checkMoney->total_dollar != 0) {
                            \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3]);
                        } else {
                            \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3,'total_dollar'=>$total,'total_riel'=>0]);
                        }
                    }else{
                            \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3]);
                    }
 
                }
                \DB::table('nso007_export_stock')->whereIn('id', explode(',', $id))->update(['status'=>3]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->whereIn('export_id', explode(',', $id))->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->whereIn('export_id', explode(',', $id))->delete();
                $success = json_decode($data, true);
                DeliveryOrderDetailSuccessModel::insert($success);

            }else if($status == 2){
                // this box code is padding
                // \DB::table('nso007_export_stock')->where('id',$id)->update(['status'=>4]);
                // update_status_by($id,4);
                update_status_by($id,4,'status_last');
                historyBox($id,4,$reason);

                \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',1)->update(['status'=>2,'reason'=>$reason]);
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->update(['reason'=>$reason,'date'=>date('Y-m-d')]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->delete();
                $padding = json_decode($data, true);
                DeliveryOrderDetailPaddingModel::insert($padding);
                // collect($padding)->map(function ($q) {
                //     $q['id'] = null;
                //     $q['status'] = 2;
                //     DeliveryOrderHistoryModel::insert($q);
                //  });


            }else if($status == 3){
                //this box code is cancel
                // \DB::table('nso007_export_stock')->where('id',$id)->update(['status'=>5]);
                // update_status_by($id,4);
                update_status_by($id,5,'status_last');
                historyBox($id,5,$reason);
                \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',1)->update(['reason'=>$reason,'status'=>4]);
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->update(['reason'=>$reason,'date'=>date('Y-m-d')]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->delete();

                // JournalModel::where('status_ref', 'taxi shop pay')->where('journal_referenceid', $id)->delete();
                // JournalModel::where('status_ref', 'taxi shop paid')->where('journal_referenceid', $id)->delete();
                // JournalModel::where('status_ref', 'other services shop paid')->where('journal_referenceid', $id)->delete();
                // JournalModel::where('status_ref', 'other services shop pay')->where('journal_referenceid', $id)->delete();

                $cancel = json_decode($data, true);
                DeliveryOrderDetailCancelModel::insert($cancel);
                $cancels =   \DB::table('nso007_export_stock')
                            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                            ->join('users','users.id','nso007_export_stock.merchant_id')
                            ->join('nso007_products','nso007_products.barcode','nso007_export_stock_details.barcode')
                            ->select(
                                'users.id as merchant_id','nso007_products.barcode',
                                'nso007_export_stock_details.export_qty'
                            )
                            ->where('nso007_export_stock.id',$id)->get();
                foreach ($cancels as $key => $value) {
                    \DB::table('nos007__stocks')
                    ->where('merchant_id',$value->merchant_id)
                    ->where('barcode',$value->barcode)
                    ->increment('stock_qty',$value->export_qty);
                }
            }
        //     \DB::commit();
        // } catch( \Exception $e){
        //     \DB::rollback();
        //     return redirect()->back()->with('danger',$e->getMessage());
        // }
        return response()->json(['success'=>true],200);
    }


    
    public function deliveryActionEditPrice(Request $request){
        try {
            \DB::beginTransaction();
            if($request->status == 'no_taxi'){
                $export_stock = ExportStockModel::find($request->id);
                $export_stock->driver_note  = $request->driver_note ;

                if($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0){
                    $export_stock->extra_fee_type       =   $request->extra_fee_type;
                    $export_stock->extra_fee            =   $request->extra_fee;
                    $export_stock->update();
                }
                else{
                    $export_stock->extra_fee_type       =   null;
                    $export_stock->extra_fee            =   0;
                    $export_stock->update();
                } 


                $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id',$request->id)->where('status',1)->first();
                $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetail->pay_to                    =       $request->pay_to;
                $deliveryorderdetail->status                    =       3;
                $deliveryorderdetail->rate                      =       $request->rate;
                $deliveryorderdetail->update();

                $deliveryorderdetailProcc = DeliveryOrderDetailProccessingModel::where('export_id',$request->id)->first();
                $deliveryorderdetailProcc->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetailProcc->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetailProcc->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetailProcc->pay_to                    =       $request->pay_to;
                $deliveryorderdetailProcc->rate                      =       $request->rate;
                $deliveryorderdetail->status                    =       3;

                $deliveryorderdetailProcc->update();
            }
            else{ 
                $export_stock = ExportStockModel::find($request->id);
                $export_stock->driver_note  = $request->driver_note ;


                if($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0){
                    $export_stock->extra_fee_type       =   $request->extra_fee_type;
                    $export_stock->extra_fee            =   $request->extra_fee;
                    $export_stock->update();
                }
                else{
                    $export_stock->extra_fee_type       =   null;
                    $export_stock->extra_fee            =   0;
                    $export_stock->update();
                } 

                $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id',$request->id)->where('status',1)->first();
                $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetail->pay_to                    =       $request->pay_to;
                $deliveryorderdetail->status                    =       3;
                $deliveryorderdetail->rate                      =       $request->rate;
                $deliveryorderdetail->update();

                $deliveryorderdetailProcc = DeliveryOrderDetailProccessingModel::where('export_id',$request->id)->first();
                $deliveryorderdetailProcc->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetailProcc->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetailProcc->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetailProcc->pay_to                    =       $request->pay_to;
                $deliveryorderdetailProcc->rate                      =       $request->rate;
                $deliveryorderdetail->status                    =       3;

                $deliveryorderdetailProcc->update();


                $export_stock = ExportStockModel::find($request->id);
                if($request->taxi_status == 1){
                    $export_stock->taxi_shop_fee    =   $request->taxi_fee;
                    $export_stock->taxi_cust_fee    =   0;
                }else{
                    $export_stock->taxi_cust_fee    =   $request->taxi_fee;
                    $export_stock->taxi_shop_fee    =   0;
                }
                $export_stock->taxi_number      = $request->taxi_number;
                $export_stock->taxi_status      =  $request->taxi_status;
                $export_stock->update();
            }


            \DB::table('nso007_export_stock')->where('id',  $request->id)->update(['status'=>3]);
            $data_ = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id', $request->id)->get();
            \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id', $request->id)->delete();

            DeliveryOrderDetailModel::where('export_id',$request->id)->where('status',2)->delete();

            
            $success = json_decode($data_, true);
            DeliveryOrderDetailSuccessModel::insert($success);
            historyBox($request->id,3,null);
            \DB::commit();
                return response ()->json(200) ;
            } catch (\Exception $e) {
                throw new Exception($e->getMessage());
                // throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
        }
    }
    public function deliveryActionChangePrice(Request $request){
        if ($request->from_status == 2) {
            try {
                \DB::beginTransaction();
                if ($request->status == 'no_taxi') {
                    $export_stock = ExportStockModel::find($request->id);
                    $export_stock->driver_note  = $request->driver_note ;

                    if ($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0) {
                        $export_stock->extra_fee_type       =   $request->extra_fee_type;
                        $export_stock->extra_fee            =   $request->extra_fee;
                        $export_stock->update();
                    } else {
                        $export_stock->extra_fee_type       =   null;
                        $export_stock->extra_fee            =   0;
                        $export_stock->update();
                    }
                    $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id', $request->id)->where('status', 1)->first();
                    $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                    $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                    $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                    $deliveryorderdetail->pay_to                    =       $request->pay_to;
                    $deliveryorderdetail->status                    =       3;
                    $deliveryorderdetail->rate                      =       $request->rate;
                    $deliveryorderdetail->update();

                    $deliveryorderdetailProcc = DeliveryOrderDetailProccessingModel::where('export_id', $request->id)->first();
                    $deliveryorderdetailProcc->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                    $deliveryorderdetailProcc->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                    $deliveryorderdetailProcc->amount_pay_to             =       $request->amount_pay_to_aba;
                    $deliveryorderdetailProcc->pay_to                    =       $request->pay_to;
                    $deliveryorderdetailProcc->rate                      =       $request->rate;
                    $deliveryorderdetail->status                    =       3;

                    $deliveryorderdetailProcc->update();
                } else {
                    $export_stock = ExportStockModel::find($request->id);
                    $export_stock->driver_note  = $request->driver_note ;


                    if ($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0) {
                        $export_stock->extra_fee_type       =   $request->extra_fee_type;
                        $export_stock->extra_fee            =   $request->extra_fee;
                        $export_stock->update();
                    } else {
                        $export_stock->extra_fee_type       =   null;
                        $export_stock->extra_fee            =   0;
                        $export_stock->update();
                    }

                    $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id', $request->id)->where('status', 1)->first();
                    $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                    $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                    $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                    $deliveryorderdetail->pay_to                    =       $request->pay_to;
                    $deliveryorderdetail->status                    =       3;
                    $deliveryorderdetail->rate                      =       $request->rate;
                    $deliveryorderdetail->update();

                    $deliveryorderdetailProcc = DeliveryOrderDetailProccessingModel::where('export_id', $request->id)->first();
                    $deliveryorderdetailProcc->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                    $deliveryorderdetailProcc->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                    $deliveryorderdetailProcc->amount_pay_to             =       $request->amount_pay_to_aba;
                    $deliveryorderdetailProcc->pay_to                    =       $request->pay_to;
                    $deliveryorderdetailProcc->rate                      =       $request->rate;
                    $deliveryorderdetail->status                    =       3;

                    $deliveryorderdetailProcc->update();


                    $export_stock = ExportStockModel::find($request->id);
                    if ($request->taxi_status == 1) {
                        $export_stock->taxi_shop_fee    =   $request->taxi_fee;
                        $export_stock->taxi_cust_fee    =   0;
                    } else {
                        $export_stock->taxi_cust_fee    =   $request->taxi_fee;
                        $export_stock->taxi_shop_fee    =   0;
                    }
                    $export_stock->taxi_number      = $request->taxi_number;
                    $export_stock->taxi_status      =  $request->taxi_status;
                    $export_stock->update();
                }


                \DB::table('nso007_export_stock')->where('id', $request->id)->update(['status'=>3]);
                $data_ = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id', $request->id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id', $request->id)->delete();

                DeliveryOrderDetailModel::where('export_id', $request->id)->where('status', 2)->delete();

            
                $success = json_decode($data_, true);
                DeliveryOrderDetailSuccessModel::insert($success);
                historyBox($request->id, 3, null);
                \DB::commit();
                return response()->json(200) ;
            } catch (\Exception $e) {
                throw new Exception($e->getMessage());
                // throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
            }
        }else{
            try {
                \DB::beginTransaction();
                if ($request->status == 'no_taxi') {
                    $export_stock = ExportStockModel::find($request->id);
                    $export_stock->driver_note  = $request->driver_note ;

                    if ($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0) {
                        $export_stock->extra_fee_type       =   $request->extra_fee_type;
                        $export_stock->extra_fee            =   $request->extra_fee;
                        $export_stock->update();
                    } else {
                        $export_stock->extra_fee_type       =   null;
                        $export_stock->extra_fee            =   0;
                        $export_stock->update();
                    }
                    $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id', $request->id)->first();
                    $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                    $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                    $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                    $deliveryorderdetail->pay_to                    =       $request->pay_to;
                    $deliveryorderdetail->rate                      =       $request->rate;
                    $deliveryorderdetail->update();
                    
                } else {
                    $export_stock = ExportStockModel::find($request->id);
                    $export_stock->driver_note  = $request->driver_note ;
                    if ($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0) {
                        $export_stock->extra_fee_type       =   $request->extra_fee_type;
                        $export_stock->extra_fee            =   $request->extra_fee;
                        $export_stock->update();
                    } else {
                        $export_stock->extra_fee_type       =   null;
                        $export_stock->extra_fee            =   0;
                        $export_stock->update();
                    }

                    $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id', $request->id)->first();
                    $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                    $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                    $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                    $deliveryorderdetail->pay_to                    =       $request->pay_to;
                    $deliveryorderdetail->rate                      =       $request->rate;
                    $deliveryorderdetail->update();

                    $export_stock = ExportStockModel::find($request->id);
                    if ($request->taxi_status == 1) {
                        $export_stock->taxi_shop_fee    =   $request->taxi_fee;
                        $export_stock->taxi_cust_fee    =   0;
                    } else {
                        $export_stock->taxi_cust_fee    =   $request->taxi_fee;
                        $export_stock->taxi_shop_fee    =   0;
                    }
                    $export_stock->taxi_number      = $request->taxi_number;
                    $export_stock->taxi_status      =  $request->taxi_status;
                    $export_stock->update();
                }
                \DB::commit();
                return response()->json(200) ;
            } catch (\Exception $e) {
                throw new Exception($e->getMessage());
                // throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
            }
        }
    }


    public function delivery_payable_show(Request $request){
        $data = DeliveryOrderModel::
        join('nso007_delivery_order_detail_proccessing','nso007_delivery_order_detail_proccessing.delivery_order_id','nso007_delivery_order.id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
        if(\Globals::check_lang() == 'en') {
        $data = $data-> select(
                'nso007_export_stock.delivery_option',
                'nso007_delivery_order_detail_proccessing.*',
                'nso007_export_stock.box_code',
                'nso007_export_stock.taxi_shop_fee',
                'nso007_export_stock.taxi_cust_fee',
                'nso007_export_stock.taxi_status',
                'nso007_export_stock.delivery_fee',
                'nso007_export_stock.description',
                'nso007_export_stock.customer_receive',
                'nso007_location.name_en AS name_location',
                \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) AS price')
                )   ;
        }else{
            $data = $data-> select(
                'nso007_export_stock.delivery_option',
                'nso007_delivery_order_detail_proccessing.*',
                'nso007_export_stock.box_code',
                'nso007_export_stock.taxi_shop_fee',
                'nso007_export_stock.taxi_cust_fee',
                'nso007_export_stock.taxi_status',
                'nso007_export_stock.delivery_fee',
                'nso007_export_stock.description',
                'nso007_export_stock.customer_receive',
                'nso007_location.name_km AS name_location',
                \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) AS price')
                ) ;
        }
        $data = $data->whereIn('nso007_delivery_order_detail_proccessing.export_id', explode(',', $request->export_id))
                ->groupBy('nso007_export_stock.box_code')
                ->get(); 
        echo json_encode($data);
    }

    public function list_delivery_seccess (Request $request){
        if ($request->ajax()) { 
            $driver_id = $request->driver_id;
            $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
            $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
            $merchant       =   isset($request->merchant)?$request->merchant:null;
            $status         =   isset($request->status)?$request->status:null ;
            $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ; 
            $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
            $data = DeliveryOrderModel::
                    join('nso007_delivery_order_detail_success','nso007_delivery_order_detail_success.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

            if(\Globals::check_lang() == 'en'){
                $data = $data-> select(
                        'nso007_export_stock.*',
                        'nso007_export_stock.total_product AS total_price',
                        'nso007_delivery_order.driver_name',
                        'nso007_delivery_order.driver_id',
                        'nso007_delivery_order.time_policy',
                        'nso007_delivery_order.delivery_date',
                        'nso007_delivery_order.inovice',
                        'nso007_delivery_order_detail_success.delivery_order_id',  
                        'nso007_delivery_order_detail_success.export_id',
                        'nso007_delivery_order_detail_success.date',
                        'nso007_delivery_order_detail_success.total_riel',
                        'nso007_delivery_order_detail_success.total_dollar', 
                        'nso007_delivery_order_detail_success.pay_to',
                        'nso007_delivery_order_detail_success.amount_pay_to', 
                        'nso007_export_stock.description as ex_description',
                        'nso007_discount.discount_type',
                        'nso007_discount.discount',
                        'nso007_delivery_order_detail_success.status_paid',  
                        'nso007_export_stock.location_name AS name_location',
                        'nso007_delivery_order_detail_success.id AS delivery_order_detail_proccessing_id',
                );
            }else{
                $data = $data-> select(
                        'nso007_export_stock.*',
                        'nso007_delivery_order.driver_id',
                        'nso007_delivery_order.time_policy',
                        'nso007_delivery_order.delivery_date',
                        'nso007_delivery_order.driver_name',
                        'nso007_delivery_order.inovice',
                        'nso007_delivery_order_detail_success.delivery_order_id',  
                        'nso007_delivery_order_detail_success.export_id',
                        'nso007_delivery_order_detail_success.date',
                        'nso007_delivery_order_detail_success.total_riel',
                        'nso007_delivery_order_detail_success.total_dollar', 
                        'nso007_delivery_order_detail_success.pay_to',
                        'nso007_delivery_order_detail_success.amount_pay_to', 
                        'nso007_export_stock.description as ex_description', 
                        'nso007_delivery_order_detail_success.status_paid',
                        'nso007_export_stock.location_name AS name_location',
                        'nso007_discount.discount_type',
                        'nso007_discount.discount',
                        'nso007_delivery_order_detail_success.id AS delivery_order_detail_proccessing_id',
                    );
                }
            $data = $data
                    ->whereNotIn('nso007_export_stock.id',$paid)
                    ->where(function ($query) {
                        if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                            $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                        }
                    })
    
                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                        }
                    })
                    ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                        if($pro_or_city != null){
                            $operator = "!=";
                            if($pro_or_city != "No"){
                                $operator = "=";
                            }
                            $query->where('nso007_export_stock.delivery_option',$operator,"No");
                        }
                    })
                    ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                        if(!empty($from_date) && !empty($to_date)){
                            $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                        }
                    })
                    ->where(function($query) use ($merchant){
    
                        if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                            $query->where('merchant_id',\Auth::user()->id);
                        }else if(\Globals::is_Driver() == 'Driver'){
                            $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                        }else{
                            $query->where('merchant_id','LIKE',$merchant);
                        }
                    })
                    ->where('nso007_delivery_order.driver_id','LIKE',$driver_id)
                    ->groupBy('nso007_export_stock.box_code')
                    ->orderBy('nso007_export_stock.location', 'desc');

                return  Datatables::of($data)
                    ->editColumn('delivery_date', function($data) {   
                        return date('d-m-Y',strtotime($data->delivery_date));   
                    })
                    ->editColumn('total_price', function($data) {   
                        if($data->total_product_symbol == '៛'){
                            return number_format($data->total_price).'៛'; 
                        }
                        return '$'.number_format($data->total_price, 2);      
                    })
                    ->editColumn('buy_fee', function($data) {
                       if($data->taxi_status == 1){ 
                            $buy_fee = '$'.number_format($data->taxi_shop_fee, 2); 
                            if($data->taxi_fee_symbol == '៛'){
                                $buy_fee = number_format($data->taxi_shop_fee).' ៛'; 
                            }
                        }
                       else{   
                            $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);   
                            if($data->taxi_fee_symbol == '៛'){
                                $buy_fee = number_format($data->taxi_cust_fee).' ៛'; 
                            } 
                           }
                       return $buy_fee;
                    })

                    ->editColumn('delivery_fee', function($data) {
                        $delivery_fee  = 0;
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                            }
                            else{
                                $delivery_fee = $data->delivery_fee;
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee;
                        }

                        if ($data->delivery_status == 1) {
                            if($data->delivery_fee_symbol == '៛'){
                                $delivery_fee = number_format($delivery_fee).'៛';
                            }
                            if($data->delivery_fee_symbol == '$'){
                                $delivery_fee = '$' . number_format($delivery_fee, 2);
                            }
                            
                        } else {
                            if($data->delivery_fee_symbol == '៛'){
                                $delivery_fee = number_format($delivery_fee).'៛';
                            }
                            if($data->delivery_fee_symbol == '$'){
                                $delivery_fee = '$' . number_format($delivery_fee, 2);
                            }
                        }
                        return $delivery_fee;
                    })
 
                    ->addColumn('driver_name',function($data){
                        if ($data->status == 1) 
                            return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                        else
                            $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                                ->where('export_id',$data->id)
                                ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                                ->get()->last();
                            $text = '';
                                if($delivery->time_policy == "1")
                                    $text = "(ព្រឹក)";
                                else
                                    $text = "(ល្ងាច)";
                            
                            return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';


                        return '<button type="button" class="btn btn-primary btn-sm change-driver"   data-delivery_date="'.$data->delivery_date.'"  data-export_id="'.$data->export_id.'" data-driver_id="'.$data->driver_id.'" data-time="'.$data->time_policy.'">'.$data->driver_name.'</button>';
                    }) 

                    ->addColumn('description',function($data){
                        return $data->total_riel > 0 ? $data->ex_description.' ('.$data->total_riel.'៛)':$data->ex_description;
                    })

                    ->editColumn('other_services_fee', function($data) {
                        $other_services_fee = ''; 
                        if($data->other_services_fee > 0 ){
                            if($data->other_services_type == 1){
                                $other_services_fee = '$'.number_format($data->other_services_type, 2) .' s';
                            }
                            else{
                                $other_services_fee ='$'.number_format($data->other_services_type, 2).' c';
                            } 
                            if($data->other_services_pay_or_paid == 'paid'){
                                $other_services_fee .=  ' (paid)';
                            }
                        }else{
                            $other_services_fee =  '';
                        } 
                        return $other_services_fee ; 
                    })
                  
                    ->editColumn('total_collection', function($data) {
                        return  '$'. $data->total_dollar .'/'. $data->total_riel.'៛';
                    })
                    
                    ->editColumn('date', function($data) {
                        return date('d-m-Y',strtotime($data->date));
                    })

                    ->addColumn('action', function($data) {
                        $action = '';
                        if(!$data->status_paid){
                            if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                                $action = '
                                    <label class="btn btn-info btn-xs return_to_inpro_for_success"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
                                ';
                            }
                        }

                        return    $action ;
                    })

                    ->rawColumns(['pay_all'=>'pay_all','driver_name'=>'driver_name'])
                    ->addIndexColumn()
                    ->make(true);
                }
       

        return  view('administrator.delivery-order.list-delivery-success');
    }
    public function in_stock_delivery(Request $request){
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;
        $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
        
        if ($request->ajax()) {
            $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.export_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                // ->where('nso007_export_stock.type_of_stock',2)
                ->where('nso007_export_stock.status',1)
                ->groupBy('nso007_export_stock.box_code')
                ->whereNotIn('nso007_export_stock.id',$paid)
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc'); 
            return  Datatables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paid , 7 = return to shop
                    $edit​​ = '';
                    $delete = '';
                    // if ($data->status == 1 || $data->status == 2) {
                    //     if ($data->type_of_stock == 1) {
                    //         $edit = '<a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                    //     } else {
                    //         $edit = '<a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                    //     }

                    // } else {
                    //     $edit = '<a href="#" class="button_dark fa fa-edit"></a>';
                    // }


                    // if ($data->status == 1 ) {
                    //     if(Gate::check('Export List Delete Box')){
                    //         $delete = '<a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    //     }
                    // } else {
                    //     $delete = '<a data-href="#" class="button_dark fa fa-trash   " ></a>';
                    // }

                    //     return $delete .'
                    //     <a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="button_warning fa fa-print bt-print"></a>
                    //     ' . $edit;

                $pedding = '';
                $cancel = '';
                $edit = '';
                $return_to_shop = '';
                $print = '';
                $all = '';
                $return_to_proccess = '';
                if (Gate::check('Delete Order')) {
                    $delete = '<li><a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class=" fa fa-trash bt-delete">&nbsp; '. __('administrator.delete') .'</a></li>';
                }
                if (Gate::check('Pending Order List')) {
                    $pedding = '<li><a class="bt_pending" data-status="2" data-export_id="'.$data->export_id.'">'.__('administrator.pending').'</a>';
                }
                if (Gate::check('Cancel Order List')) {
                    $cancel = '<li><a class="bt_cencel fa fa-ban" data-status="3" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.cancel').'</a></li>';
                }  
                if (Gate::check('Return To Shop Order List')) {
                    $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                }        // $edit = '<li><a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                if (Gate::check('Print Order List')) {
                    $print = '<li><a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="fa fa-print bt-print">&nbsp;'.__('administrator.print').'</a></li>';
                }      $return_to_proccess = '
                        <li><a class="return_to_inpro fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
                    ';
                    if ($data->type_of_stock == 1) {
                        if (Gate::check('Edit Order List')) {
                            $edit = '<li><a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                        }
                    } else {
                        if (Gate::check('Edit Order List')) {
                            $edit = '<li><a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                        }
                    }
                if($data->status == 1 || $data->status == 2 || $data->status == 4 || $data->status == 3){
                    if ($data->status == 1) {
                            $all.= $delete.$print.$edit;
                    }
                   
                    if($data->status == 2){
                        $all .= $print.$edit.$pedding.$cancel.$return_to_shop;
                    }
                    if($data->status != 4){
                        
                    }
                    // $all = $delete . $print .$edit .$pedding .$cancel.$return_to_shop;
                    


                }
                if($data->status == 4){
                    if(!$data->status_paid){
                        if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                            $all .= $return_to_proccess.$return_to_shop;
                        }
                    }
                }
                if($data->status == 5){
                    $all .= $return_to_proccess;
                }
                if($data->status == 3){
                    // if(!$data->status_paid){
                    //     if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                    //         $all .= $return_to_proccess;
                    //     }
                    // }
                        if(!$data->status_paid){
                            if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                                $all .=$return_to_proccess;
                                // $action = '
                                //     <label class="btn btn-info btn-xs return_to_inpro_for_success"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
                                // ';
                            }
                        }
                }
                if($data->status == 7){
                    $all .= $print.$edit.$delete.$return_to_proccess;
                }
                
                return '
                <div class="dropdown">
                     <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                     <span class="caret"></span></button>
                     <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                     '.$all.'
                     </ul>
                 </div>
                ';

                

                //     >'.__('administrator.edit_delivey').'</label>';
                // return $edit;

                
                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else if($data->status ==5)   // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                    else if($data->status ==6)   // 6 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.paid') . ' </strong>';
                    else if($data->status ==7)   // 7 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>';
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })
                
                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1) 
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->get()->last();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";
                        
                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })

                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name'])
                ->addIndexColumn()
                ->make(true);
        }
    }
    
    // public function list_delivery_seccess (Request $request){
    //     if ($request->ajax()) { 
    //         $driver_id = $request->driver_id; 
    //         $data = DeliveryOrderModel::
    //                 join('nso007_delivery_order_detail_success','nso007_delivery_order_detail_success.delivery_order_id','nso007_delivery_order.id')
    //                 ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
    //                 ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
    //                 ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

    //         if(\Globals::check_lang() == 'en'){
    //             $data = $data-> select(
    //                     'nso007_export_stock.*',
    //                     'nso007_delivery_order.driver_name',
    //                     'nso007_delivery_order.driver_id',
    //                     'nso007_delivery_order.delivery_date',
    //                     'nso007_delivery_order.inovice',
    //                     'nso007_delivery_order_detail_success.delivery_order_id',  
    //                     'nso007_delivery_order_detail_success.export_id',
    //                     'nso007_delivery_order_detail_success.date',
    //                     'nso007_delivery_order_detail_success.total_riel',
    //                     'nso007_delivery_order_detail_success.total_dollar', 
    //                     'nso007_delivery_order_detail_success.pay_to',
    //                     'nso007_delivery_order_detail_success.amount_pay_to', 
    //                     'nso007_export_stock.description as ex_description',
    //                     'nso007_discount.discount_type',
    //                     'nso007_discount.discount',
    //                     'nso007_export_stock_details.currency',
    //                     'nso007_delivery_order_detail_success.status_paid',  
    //                     'nso007_export_stock.location_name AS name_location',
    //                     'nso007_export_stock_details.category_name',
    //                     'nso007_delivery_order_detail_success.id AS delivery_order_detail_proccessing_id',
    //                     DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
    //             );
    //         }else{
    //             $data = $data-> select(
    //                     'nso007_export_stock.*',
    //                     'nso007_delivery_order.driver_id',
    //                     'nso007_delivery_order.delivery_date',
    //                     'nso007_delivery_order.driver_name',
    //                     'nso007_delivery_order.inovice',
    //                     'nso007_delivery_order_detail_success.delivery_order_id',  
    //                     'nso007_delivery_order_detail_success.export_id',
    //                     'nso007_delivery_order_detail_success.date',
    //                     'nso007_delivery_order_detail_success.total_riel',
    //                     'nso007_delivery_order_detail_success.total_dollar', 
    //                     'nso007_delivery_order_detail_success.pay_to',
    //                     'nso007_delivery_order_detail_success.amount_pay_to', 
    //                     'nso007_export_stock.description as ex_description', 
    //                     'nso007_export_stock_details.currency',
    //                     'nso007_delivery_order_detail_success.status_paid',
    //                     'nso007_export_stock_details.category_name',
    //                     'nso007_export_stock_details.price',
    //                     'nso007_export_stock.location_name AS name_location',
    //                     'nso007_discount.discount_type',
    //                     'nso007_discount.discount',
    //                     'nso007_delivery_order_detail_success.id AS delivery_order_detail_proccessing_id',
    //                     DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price') 
    //                 );
    //             }
    //         $data = $data
    //                 ->where('nso007_delivery_order.driver_id','LIKE',$driver_id)
    //                 ->groupBy('nso007_export_stock.box_code')
    //                 ->groupBy('nso007_export_stock_details.export_id')
    //                 ->orderBy('nso007_export_stock.location', 'desc');

    //             return  Datatables::of($data)
    //                 ->editColumn('delivery_date', function($data) {   return date('d-m-Y',strtotime($data->delivery_date));   })
    //                 ->editColumn('total_price', function($data) {   return '$'.number_format($data->total_price, 2);      })
    //                 ->editColumn('buy_fee', function($data) {
    //                    if($data->taxi_status == 1){  $buy_fee = '$'.number_format($data->taxi_shop_fee, 2); }
    //                    else{    $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);       }
    //                    return $buy_fee;
    //                 })

    //                 ->editColumn('delivery_fee', function($data) {
    //                     $delivery_fee  = 0;
    //                     if($data->discount_type != null || $data->discount_type != '')
    //                     {
    //                         if($data->discount_type == 1){
    //                             $delivery_fee = $data->discount;
    //                         }
    //                         elseif($data->discount_type == 2){
    //                             $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
    //                         }
    //                         else{
    //                             $delivery_fee = $data->delivery_fee;
    //                         }
    //                     }
    //                     else{
    //                         $delivery_fee  =  $data->delivery_fee;
    //                     }

    //                     if ($data->delivery_status == 1) {
    //                         $delivery_fee = '$' . number_format($delivery_fee, 2);
    //                     } else {
    //                         $delivery_fee = '$' . number_format($delivery_fee, 2);
    //                     }
    //                     return $delivery_fee;
    //                 })
 
    //                 ->addColumn('driver_name',function($data){
    //                     return '<button type="button" class="btn btn-primary btn-sm change-driver"   data-delivery_date="'.$data->delivery_date.'"  data-export_id="'.$data->export_id.'" data-driver_id="'.$data->driver_id.'">'.$data->driver_name.'</button>';
    //                 }) 

    //                 ->addColumn('description',function($data){
    //                     return $data->total_riel > 0 ? $data->ex_description.' ('.$data->total_riel.'៛)':$data->ex_description;
    //                 })

    //                 ->editColumn('other_services_fee', function($data) {
    //                     $other_services_fee = ''; 
    //                     if($data->other_services_fee > 0 ){
    //                         if($data->other_services_type == 1){
    //                             $other_services_fee = '$'.number_format($data->other_services_type, 2) .' s';
    //                         }
    //                         else{
    //                             $other_services_fee ='$'.number_format($data->other_services_type, 2).' c';
    //                         } 
    //                         if($data->other_services_pay_or_paid == 'paid'){
    //                             $other_services_fee .=  ' (paid)';
    //                         }
    //                     }else{
    //                         $other_services_fee =  '';
    //                     } 
    //                     return $other_services_fee ; 
    //                 })
                  
    //                 ->editColumn('date', function($data) {
    //                     return date('d-m-Y',strtotime($data->date));
    //                 })

    //                 ->addColumn('action', function($data) {
    //                     $action = '';
    //                     if($data->status_paid){
    //                         if(date('Y-m-d H:i:s') <= date('Y-m-d H:i:s', strtotime("+1 day", strtotime($data->updated_at)) )&& $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
    //                             $action = '
    //                                 <label class="btn btn-info btn-xs return_to_inpro"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
    //                             ';
    //                         }
    //                     }

    //                     return    $action ;
    //                 })

    //                 ->rawColumns(['pay_all'=>'pay_all','driver_name'=>'driver_name'])
    //                 ->addIndexColumn()
    //                 ->make(true);
    //             }
       

    //     return  view('administrator.delivery-order.list-delivery-success');
    // }
    public function list_delivery_cancel(Request $request){
        if ($request->ajax()) {
            $driver_id = $request->driver_id;
            $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
            $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
            $merchant       =   isset($request->merchant)?$request->merchant:null;
            $status         =   isset($request->status)?$request->status:null ;
            $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ; 
            $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
            $data = DeliveryOrderModel::
            join('nso007_delivery_order_detail_cancel','nso007_delivery_order_detail_cancel.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_cancel.export_id')
                ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');
            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail_cancel.*',
                    'nso007_export_stock.box_code',
                    'nso007_export_stock.status',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.description',
                    'nso007_export_stock.customer_receive',
                    'merchant.shop_name',
                    'nso007_export_stock.delivery_fee_symbol',
                    'nso007_export_stock.total_product_symbol',
                    'nso007_export_stock.taxi_fee_symbol',
                    'nso007_location.name_en AS name_location',
                    'nso007_category.name_en AS category_name',
                    'nso007_export_stock_details.price AS price',
                    'driver.name AS driver_name',
                    'nso007_delivery_order_detail_cancel.id AS delivery_order_detail_proccessing_id',
                    'driver.phone',
                    'nso007_delivery_order_detail_cancel.updated_at AS updated',

                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

            );
            }else{
                $data = $data-> select(
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail_cancel.*',
                    'nso007_export_stock.box_code',
                    'nso007_export_stock.status',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.description',
                    'nso007_export_stock.customer_receive',
                    'nso007_export_stock.delivery_fee_symbol',
                    'nso007_export_stock.total_product_symbol',
                    'nso007_export_stock.taxi_fee_symbol',
                    'merchant.shop_name',
                    'nso007_location.name_km AS name_location',
                    'nso007_category.name_km AS category_name',
                    'nso007_export_stock_details.price AS price',
                    'driver.name AS driver_name',
                    'nso007_delivery_order_detail_cancel.id AS delivery_order_detail_proccessing_id',
                    'driver.phone',
                    'nso007_delivery_order_detail_cancel.updated_at AS updated',

                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
                );
            }

            $data = $data->groupBy('nso007_export_stock.box_code')
                    ->whereNotIn('nso007_export_stock.id',$paid)
                    ->where(function ($query) {
                        if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                            $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                        }
                    })

                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                        }
                    })
                    ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                        if($pro_or_city != null){
                            $operator = "!=";
                            if($pro_or_city != "No"){
                                $operator = "=";
                            }
                            $query->where('nso007_export_stock.delivery_option',$operator,"No");
                        }
                    })
                    ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                        if(!empty($from_date) && !empty($to_date)){
                            $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                        }
                    })
                    ->where(function($query) use ($merchant){

                        if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                            $query->where('merchant_id',\Auth::user()->id);
                        }else if(\Globals::is_Driver() == 'Driver'){
                            $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                        }else{
                            $query->where('merchant_id','LIKE',$merchant);
                        }
                    })


            ->orderBy('nso007_delivery_order.inovice', 'desc')
            ->groupBy('nso007_export_stock_details.export_id')

            ->get();
            return  Datatables::of($data)
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })
            ->editColumn('price', function($data) {
                if($data->total_product_symbol == '៛'){
                    return number_format($data->price).' ៛';
                }
                return '$'.number_format($data->price, 2);
            })
            ->editColumn('bus_fee', function($data) {
                if($data->taxi_status == 1){
                    if($data->taxi_fee_symbol == '៛'){
                        $buy_fee = number_format($data->taxi_shop_fee).'៛';
                    }
                    if($data->taxi_fee_symbol == '$'){
                        $buy_fee = '$'.number_format($data->taxi_shop_fee, 2);
                    }
                     
                }
                else{
                    if($data->taxi_fee_symbol == '៛'){
                        $buy_fee =number_format($data->taxi_cust_fee).'៛';
                    }
                    if ($data->taxi_fee_symbol == '$') {
                        $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);
                    }
                }
                return $buy_fee;
             })
             ->editColumn('delivery_fee', function($data) {
                $delivery_fee  = 0;
                if($data->discount_type != null || $data->discount_type != '')
                {
                    if($data->discount_type == 1){
                        $delivery_fee = $data->discount;
                    }
                    elseif($data->discount_type == 2){
                        $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                    }
                    else{
                        $delivery_fee = $data->delivery_fee;
                    }
                }
                else{
                    $delivery_fee  =  $data->delivery_fee;
                }



                if ($data->delivery_status == 1) {
                    if($data->delivery_fee_symbol == '៛'){
                        $delivery_fee = number_format($delivery_fee).'៛';
                    }
                    if($data->delivery_fee_symbol == '$'){
                        $delivery_fee = '$' . number_format($delivery_fee, 2);
                    }
                    
                } else {
                    if($data->delivery_fee_symbol == '៛'){
                        $delivery_fee = number_format($delivery_fee).'៛';
                    }
                    if($data->delivery_fee_symbol == '$'){
                        $delivery_fee = '$' . number_format($delivery_fee, 2);
                    }
                }
                return $delivery_fee;
            })
            ->addColumn('action', function($data) {
                $action = '';
                if(date('Y-m-d H:i:s') <= date('Y-m-d H:i:s', strtotime("+1 day", strtotime($data->updated_at) )) && $data->status_paid != 'paid' ){
                    // $action = '
                    //     <label class="btn btn-info btn-xs return_to_inpro"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
                    // ';
                    $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                    $return_to_proccess = '
                        <li><a class="return_to_inpro_for_all fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
                    ';
                    $action = $return_to_proccess.$return_to_shop;
                }
                return '
                <div class="dropdown">
                     <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                     <span class="caret"></span></button>
                     <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                     '.$action.'
                     </ul>
                 </div>
                ';
                })
            ->addIndexColumn()
            ->make(true);
        }
        return  view('administrator.delivery-order.list-delivery-cancel');
    }
    public function list_delivery_padding(Request $request){
        if ($request->ajax()) {
            $driver_id = $request->driver_id;
            $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
            $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
            $merchant       =   isset($request->merchant)?$request->merchant:null;
            $status         =   isset($request->status)?$request->status:null ;
            $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ; 
            $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
            $data = DeliveryOrderModel::
            join('nso007_delivery_order_detail_padding','nso007_delivery_order_detail_padding.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_padding.export_id')
                ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');
            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail_padding.*',
                    'nso007_export_stock.box_code',
                    'nso007_export_stock.status',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_fee_symbol',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.description',
                    'nso007_export_stock.delivery_fee_symbol',
                    'nso007_export_stock.total_product_symbol',
                    'nso007_export_stock.customer_receive',
                    'merchant.shop_name',
                    'nso007_location.name_en AS name_location',
                    'nso007_category.name_en AS category_name',
                    'nso007_export_stock_details.price AS price',
                    'driver.name AS driver_name',
                    'driver.phone',
                    'nso007_delivery_order_detail_padding.id AS delivery_order_detail_pendding_id',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

            );
            }else{
                $data = $data-> select(
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail_padding.*',
                    'nso007_export_stock.box_code',
                    'nso007_export_stock.status',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_fee_symbol',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.description',
                    'nso007_export_stock.delivery_fee_symbol',
                    'nso007_export_stock.total_product_symbol',
                    'nso007_export_stock.customer_receive',
                    'merchant.shop_name',
                    'nso007_location.name_km AS name_location',
                    'nso007_category.name_km AS category_name',
                    'nso007_export_stock_details.price AS price',
                    'driver.name AS driver_name',
                    'driver.phone',
                    'nso007_delivery_order_detail_padding.id AS delivery_order_detail_pendding_id',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

                );
            }

            $data = $data->groupBy('nso007_export_stock.box_code')
                    ->whereNotIn('nso007_export_stock.id',$paid)
                    ->where(function ($query) {
                        if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                            $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                        }
                    })

                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                        }
                    })
                    ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                        if($pro_or_city != null){
                            $operator = "!=";
                            if($pro_or_city != "No"){
                                $operator = "=";
                            }
                            $query->where('nso007_export_stock.delivery_option',$operator,"No");
                        }
                    })
                    ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                        if(!empty($from_date) && !empty($to_date)){
                            $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                        }
                    })
                    ->where(function($query) use ($merchant){

                        if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                            $query->where('merchant_id',\Auth::user()->id);
                        }else if(\Globals::is_Driver() == 'Driver'){
                            $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                        }else{
                            $query->where('merchant_id','LIKE',$merchant);
                        }
                    })

                ->groupBy('nso007_export_stock_details.export_id')
                ->orderBy('nso007_delivery_order.inovice', 'desc')
                ->get();
            return  Datatables::of($data)
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })
            ->editColumn('price', function($data) {
                if($data->total_product_symbol == '៛'){
                    return number_format($data->price).'៛';
                }
                return '$'.number_format($data->price, 2);
            })
            ->editColumn('bus_fee', function($data) {
                if($data->taxi_status == 1){
                    if($data->taxi_fee_symbol == '៛'){
                        $buy_fee = number_format($data->taxi_shop_fee).'៛';
                    }
                    if ($data->taxi_fee_symbol == '$') {
                        $buy_fee = '$'.number_format($data->taxi_shop_fee, 2);
                    }
                }
                else{
                    if ($data->taxi_fee_symbol == '$') {
                        $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);
                    }
                    if($data->taxi_fee_symbol == '៛'){
                        $buy_fee =number_format($data->taxi_cust_fee).' ៛';
                    }
                }
                return $buy_fee;
             })
             ->editColumn('delivery_fee', function($data) {
                $delivery_fee  = 0;
                if($data->discount_type != null || $data->discount_type != '')
                {
                    if($data->discount_type == 1){
                        $delivery_fee = $data->discount;
                    }
                    elseif($data->discount_type == 2){
                        $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                    }
                    else{
                        $delivery_fee = $data->delivery_fee;
                    }
                }
                else{
                    $delivery_fee  =  $data->delivery_fee;
                }



                if ($data->delivery_status == 1) {
                    if($data->delivery_fee_symbol == '៛'){
                        $delivery_fee = number_format($delivery_fee).'៛';
                    }
                    if($data->delivery_fee_symbol == '$'){
                        $delivery_fee = '$' . number_format($delivery_fee, 2);
                    }
                    
                } else {
                    if($data->delivery_fee_symbol == '៛'){
                        $delivery_fee = number_format($delivery_fee).'៛';
                    }
                    if($data->delivery_fee_symbol == '$'){
                        $delivery_fee = '$' . number_format($delivery_fee, 2);
                    }
                }
                return $delivery_fee;
            })
            ->addColumn('action', function($data) {
                $return_to_order = '<li><a class="bt_add_to_stock fa fa-undo" data-delivery_order_detail_pendding_id="'.$data->delivery_order_detail_pendding_id.'" data-export_id="'.$data->export_id.'" >&nbsp;'. 'Return To Order'.'</a></li>';
                $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                $return_to_proccess = '
                <li><a class="return_to_inpro_for_all fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
            ';
                return '
                <div class="dropdown">
                     <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                     <span class="caret"></span></button>
                     <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                     '. $return_to_proccess.$return_to_shop.$return_to_order .'
                     </ul>
                 </div>
                ';
                return  '
                    <label class="btn btn-danger btn-xs bt_cencel_for_padding" data-delivery_order_detail_pendding_id="'.$data->delivery_order_detail_pendding_id.'" data-export_id="'.$data->export_id.'" ><span class=" fa fa-ban"> '.__('administrator.cancel').'</span></label>
                    <label class="btn btn-info btn-xs bt_add_to_stock" data-delivery_order_detail_pendding_id="'.$data->delivery_order_detail_pendding_id.'" data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.return_to_order').'  </span></label>
                ';
                })
            ->addIndexColumn()
            ->make(true);
        }
        return  view('administrator.delivery-order.list-delivery-padding');
    }
    public function delivery_order_cencel(Request $request){

        // JournalModel::where('status_ref', 'taxi shop pay')->where('journal_referenceid', $request->export_id)->delete();
        // JournalModel::where('status_ref', 'taxi shop paid')->where('journal_referenceid', $request->export_id)->delete();

        // JournalModel::where('status_ref', 'other services shop paid')->where('journal_referenceid', $request->export_id)->delete();
        // JournalModel::where('status_ref', 'other services shop pay')->where('journal_referenceid', $request->export_id)->delete();

        $delivery_order_detail_padding = DeliveryOrderDetailPaddingModel::findOrFail($request->delivery_order_detail_pendding_id);
        $data = $delivery_order_detail_padding->attributesToArray();
        $data['reason'] = $request->reason;
        if(DeliveryOrderDetailCancelModel::insert($data)){
            DeliveryOrderDetailPaddingModel::find($request->delivery_order_detail_pendding_id)->delete();
            $deliveryorderdetail =DeliveryOrderDetailModel::find($request->export_id);
            $deliveryorderdetail->reason =$request->reason;
            $deliveryorderdetail->status = 4;
            if ($deliveryorderdetail->update()) {
                $data = ExportStockModel::where('nso007_export_stock.id',$request->export_id)
                        ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                        ->get();
                if ($data[0]->type_of_stock==1) {
                    foreach ($data as $key => $datas) {
                        StockModel::where([['merchant_id',$datas->merchant_id],['barcode',$datas->barcode]])->increment('stock_qty', $datas->export_qty);
                    }
                }
                ExportStockModel::find($request->export_id)->update(['status'=>5]);
            }
        }
             return redirect()->back()->with('success','Driver created successfully');
    }

    public function add_to_stock(Request $request){
        ExportStockModel::find($request->export_id_1)->update(['status'=>1]);
        DeliveryOrderDetailModel::where('export_id',$request->export_id_1)->update(['status'=>0]);
        DeliveryOrderDetailPaddingModel::find($request->delivery_order_detail_pendding_id_1)->delete();
        if($request->ajax()){
            return response()->json(200);
        }
        return redirect()->back()->with('success','Driver created successfully');
    }

    public function data_history_delivery($from_date,$to_date,$status,$merchant){
        $data = DeliveryOrderModel::
        join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
            ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
            ->join('users AS driver','driver.id','nso007_delivery_order.driver_id')
            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

        if(\Globals::check_lang() == 'en'){
        $data = $data-> select(
                'nso007_export_stock.*',
                'merchant.name',
                'merchant.bank_account AS shop_bank_account',
                'merchant.phone AS shop_number',
                'nso007_delivery_order.driver_id',
                'nso007_discount.*',
                'nso007_export_stock.service_charge',
                'nso007_export_stock.delivery_status',
                'nso007_export_stock.description',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.delivery_option',
                'nso007_delivery_order_detail.*',
                'nso007_export_stock.box_code',
                'nso007_export_stock.taxi_number',
                'nso007_export_stock.taxi_shop_fee',
                'nso007_export_stock.taxi_cust_fee',
                'nso007_export_stock.taxi_status',
                'nso007_export_stock.delivery_fee',
                'nso007_export_stock.extra_fee_type',
                'nso007_export_stock.extra_fee',
                'nso007_export_stock.description',
                'nso007_export_stock.customer_receive',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_location.name_en AS name_location',
                'nso007_category.name_en AS category_name',
                'driver.name AS driver_name',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

        );
        }else{

            $data = $data-> select(
                'nso007_export_stock.*',
                'merchant.name',
                'merchant.bank_account AS shop_bank_account',
                'merchant.phone AS shop_number',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_delivery_order.driver_id',
                'nso007_discount.*',
                'nso007_delivery_order.driver_id',
                'nso007_discount.*',
                'nso007_export_stock.service_charge',
                'nso007_export_stock.delivery_status',
                'nso007_export_stock.description',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order.delivery_date',
                'nso007_export_stock.delivery_option',
                'nso007_delivery_order_detail.*',
                'nso007_export_stock.box_code',
                'nso007_export_stock.taxi_number',
                'nso007_export_stock.taxi_shop_fee',
                'nso007_export_stock.taxi_cust_fee',
                'nso007_export_stock.taxi_status',
                'nso007_export_stock.delivery_fee',
                'nso007_export_stock.description',
                'nso007_export_stock.customer_receive',
                'nso007_export_stock.extra_fee_type',
                'nso007_export_stock.extra_fee',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_location.name_km AS name_location',
                'nso007_category.name_km AS category_name',
                'driver.name AS driver_name',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
            );
        }
        $data = $data
        ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
            if(!empty($from_date) && !empty($to_date)){
                $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
            }
        })
        ->when(request('status'),function($query) use ($status){
            if(!empty($status)){
                $status_1 ='';
                foreach ($status as $key => $value) {
                    $status_1  .= $status[$key].',' ;
                }
                $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
            }
        })
        ->where(function($query) use ($merchant){

            if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                $query->where('merchant_id',\Auth::user()->id);
            }else if(\Globals::is_Driver() == 'Driver'){
                $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
            }else{
                $query->where('merchant_id','LIKE',$merchant);
            }
        })
        // ->where('merchant_id','LIKE',$merchant)
        ->orderBy('nso007_export_stock.box_code','desc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->get();
        return $data;
    }
    public function history_delivery_print(Request $request ,$type)
    {
        $currency  = CurrencyModel::first();
        $invoice = '';
        $from_date  = empty  ($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date    = empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant   = isset($request->merchant)?$request->merchant:null;
        $status     = isset($request->status)?$request->status:null ;
        $referance  = isset($request->referance)?$request->referance:null ;
        $data = DeliveryOrderModel::
        join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
            ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
            ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
            ->join('users AS driver','driver.id','nso007_delivery_order.driver_id')
            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

        if(\Globals::check_lang() == 'en'){
        $data = $data-> select(
                'nso007_export_stock.*',
                'nso007_export_stock.discount_id',
                'nso007_discount.date as discount_date',
                'nso007_discount.discount_type as discount_type',
                'nso007_discount.discount as discount_amount',
                'merchant.name',
                'merchant.bank_account AS shop_bank_account',
                'merchant.phone AS shop_number',
                'nso007_delivery_order.driver_id',
                'nso007_discount.*',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_location.name_en AS name_location',
                'nso007_category.name_en AS category_name',
                'driver.name AS driver_name',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                        WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                        WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                        ELSE nso007_export_stock.taxi_shop_fee
                        END) AS taxi_fee')

        );
        }else{

            $data = $data-> select(
                'nso007_export_stock.*',
                'nso007_export_stock.discount_id',
                'nso007_discount.date as discount_date',
                'nso007_discount.discount_type as discount_type',
                'nso007_discount.discount as discount_amount',
                'merchant.name',
                'merchant.bank_account AS shop_bank_account',
                'merchant.phone AS shop_number',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_delivery_order.driver_id',
                'nso007_discount.*',
                'nso007_delivery_order.driver_id',
                'nso007_discount.*',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'nso007_location.name_km AS name_location',
                'nso007_category.name_km AS category_name',
                'driver.name AS driver_name',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                ELSE nso007_export_stock.taxi_shop_fee
                END) AS taxi_fee')
            );
        }
        $data = $data
        ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
            if(!empty($from_date) && !empty($to_date)){
                $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
            }
        })
        ->when(request('status'),function($query) use ($status){
            if(!empty($status)){
                $status_1 ='';
                foreach ($status as $key => $value) {
                    $status_1  .= $status[$key].',' ;
                }
                $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
            }
        })
        ->where(function($query) use ($merchant){

            if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                $query->where('merchant_id',\Auth::user()->id);
            }else if(\Globals::is_Driver() == 'Driver'){
                $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
            }else{
                $query->where('merchant_id','LIKE',$merchant);
            }
        })
        // ->where('merchant_id','LIKE',$merchant)
        ->orderBy('nso007_delivery_order.inovice','desc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->get();
        if($type ==2){
            $increas = '';
            $last_id =  DB::table('nso007_invoice_payment')->max('id');
            $inovice = DB::table('nso007_invoice_payment')->select('invoice_payment')->get()->last();
            if ($inovice) {
                $tran_num = $inovice->invoice_payment;
                $tran_num =substr($tran_num, -6);
                $increas = sprintf('IV-'.date('ym').'%06d', ($tran_num+1));
            } else {
                $increas = 'IV-'.date('ym').'000001';
            }
            $invoicepayment     =   new InvoicePaymentModel();
            $invoicepayment->invoice_payment    =   $increas;
            $invoicepayment->user_create        =   Auth::user()->id;
            $invoicepayment->date               =   date('Y-m-d');
            $invoicepayment->from_date          =   $from_date;
            $invoicepayment->to_date            =   $to_date ;
            $deliveryOrder=  DeliveryOrderModel::
            join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->leftJoin('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                ->select('nso007_delivery_order_detail.status','nso007_delivery_order_detail.export_id')
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
                    }
                })

            ->where(function($query) use ($merchant){
                if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                    $query->where('merchant_id',\Auth::user()->id);
                }else if(\Globals::is_Driver() == 'Driver'){
                    $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
                }else{
                    $query->where('merchant_id','LIKE',$merchant);
                }
            })

            // ->where(function($query){
            //     if(\Auth::user()->branch_id != 1){
            //         $query->where('nso007_export_stock.branch_id',\Auth::user()->branch_id);
            //     }
            // })

            ->when(request('referance'),function($query) use ($referance){
                if(!empty($referance)){
                    $query->where('nso007_export_stock.referance',$referance);
                }
            })

            ->where(function($query){
                $query->orwhere('nso007_delivery_order_detail.status',3);
            })
            ->whereNull('nso007_delivery_order_detail.status_paid');

            $deliveryOrder1  = $deliveryOrder;
            $deliveryOrder2  = $deliveryOrder->get();
            $id_ = '';
            if( $deliveryOrder1->count() != 0 ){
                $invoicepayment->save();
                $invoice        = $invoicepayment->invoice_payment;
                $deliveryOrder->update(['nso007_delivery_order_detail.invoice_payment_id'=>$invoicepayment->id]);
                foreach ($deliveryOrder2 as $key => $value) {
                    $id_ .= $deliveryOrder2[$key]->export_id.',';
                }
                DeliveryOrderDetailCancelModel::WhereIn('nso007_delivery_order_detail_cancel.export_id',explode(',',$id_ ))->update(['nso007_delivery_order_detail_cancel.invoice_payment_id'=>$invoicepayment->id]);;
                DeliveryOrderDetailSuccessModel::WhereIn('nso007_delivery_order_detail_success.export_id',explode(',',$id_ ))->update(['nso007_delivery_order_detail_success.invoice_payment_id'=>$invoicepayment->id]); ;
            }

        }

        $package = ExportStockModel::join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
        ->select('nso007_export_stock.*' ,
            'nso007_discount.*',
            'nso007_category.name_km AS category',
            'nso007_location.name_km AS location',
            'nso007_export_stock_details.*',
            'nso007_export_stock.delivery_fee AS delivery_fee1',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'))
        ->where('nso007_export_stock.status' ,1)
        ->where('users.id', $merchant)
        ->groupBy('nso007_export_stock.box_code')->get();

        return  view('administrator.report.history_delivery_print',compact('data','from_date','to_date','invoice','currency','merchant','package'));
    }

    public function in_processing(Request $request)
    {

        if ($request->ajax()) {
            
            $driver_id = $request->driver_id;
            $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
            $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
            $merchant       =   isset($request->merchant)?$request->merchant:null;
            $status         =   isset($request->status)?$request->status:null ;
            $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;
            $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
            $data = DeliveryOrderModel::
                    join('nso007_delivery_order_detail_proccessing','nso007_delivery_order_detail_proccessing.delivery_order_id','nso007_delivery_order.id')
                    ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
                    ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                    ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_export_stock.*',
                    'nso007_delivery_order.driver_name',
                    'nso007_delivery_order.driver_id',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order.inovice',
                    // 'nso007_delivery_order_detail_proccessing.*',
                    'nso007_delivery_order_detail_proccessing.delivery_order_id',  
                    'nso007_delivery_order_detail_proccessing.export_id',
                    'nso007_delivery_order_detail_proccessing.date',
                    'nso007_delivery_order_detail_proccessing.total_riel',
                    'nso007_delivery_order_detail_proccessing.total_dollar', 
                    'nso007_delivery_order_detail_proccessing.pay_to',
                    'nso007_delivery_order_detail_proccessing.amount_pay_to', 
                    'nso007_export_stock.description as ex_description',
                    'nso007_discount.discount_type',
                    'nso007_discount.discount',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock_details.category_name',
                    'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
            );
            }else{
                $data = $data-> select(
                    'nso007_export_stock.*',
                    'nso007_delivery_order.driver_id',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order.driver_name',
                    'nso007_delivery_order.inovice',
                    // 'nso007_delivery_order_detail_proccessing.*',
                    'nso007_delivery_order_detail_proccessing.delivery_order_id',  
                    'nso007_delivery_order_detail_proccessing.export_id',
                    'nso007_delivery_order_detail_proccessing.date',
                    'nso007_delivery_order_detail_proccessing.total_riel',
                    'nso007_delivery_order_detail_proccessing.total_dollar',

                    'nso007_delivery_order_detail_proccessing.pay_to',
                    'nso007_delivery_order_detail_proccessing.amount_pay_to',
     
                    'nso007_export_stock.description as ex_description',

                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.price',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_discount.discount_type',
                    'nso007_discount.discount',
                    'nso007_delivery_order_detail_proccessing.id AS delivery_order_detail_proccessing_id',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

                );
            }
            $data = $data
                    ->whereNotIn('nso007_export_stock.id',$paid)
                    ->where(function ($query) {
                        if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                            $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                        }
                    })

                    ->when(request('status'),function($query) use ($status){
                        if(!empty($status)){
                            $status_1 ='';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key].',' ;
                            }
                            $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                        }
                    })
                    ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                        if($pro_or_city != null){
                            $operator = "!=";
                            if($pro_or_city != "No"){
                                $operator = "=";
                            }
                            $query->where('nso007_export_stock.delivery_option',$operator,"No");
                        }
                    })
                    ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                        if(!empty($from_date) && !empty($to_date)){
                            $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                        }
                    })
                    ->where(function($query) use ($merchant){

                        if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                            $query->where('merchant_id',\Auth::user()->id);
                        }else if(\Globals::is_Driver() == 'Driver'){
                            $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                        }else{
                            $query->where('merchant_id','LIKE',$merchant);
                        }
                    })
                    ->where('nso007_delivery_order.driver_id','LIKE',$driver_id)
                    ->groupBy('nso007_export_stock.box_code')
                    ->groupBy('nso007_export_stock_details.export_id')
                    ->orderBy('nso007_export_stock.location', 'desc');

                return  Datatables::of($data)
                    ->editColumn('delivery_date', function($data) {   return date('d-m-Y',strtotime($data->delivery_date));   })
                    ->editColumn('total_price', function($data) {   
                        if($data->total_product_symbol == '៛'){
                            return number_format($data->total_price).' ៛'; 
                        }
                        return '$'.number_format($data->total_price, 2);      
                    })
                    ->editColumn('buy_fee', function($data) {
                       if($data->taxi_status == 1){  
                           if($data->taxi_fee_symbol =='$'){
                                $buy_fee = '$'.number_format($data->taxi_shop_fee, 2); 
                            }
                           if($data->taxi_fee_symbol =='៛'){
                                $buy_fee = number_format($data->taxi_shop_fee).'៛'; 
                            }
                        }
                       else{
                            if ($data->taxi_fee_symbol =='$') {
                                $buy_fee ='$'.number_format($data->taxi_cust_fee, 2);
                            }  
                            if ($data->taxi_fee_symbol =='៛') {
                                $buy_fee = number_format($data->taxi_cust_fee).'៛'; 
                            }
                        }
                       return $buy_fee;
                    })

                    ->editColumn('delivery_fee', function($data) {
                        $delivery_fee  = 0;
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ( (100 - $data->discount) * $data->delivery_fee ) / 100;
                            }
                            else{
                                $delivery_fee = $data->delivery_fee;
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee;
                        }



                        if ($data->delivery_status == 1) {
                            
                            $delivery_fee_text = '$' . number_format($delivery_fee, 2);
                            if($data->delivery_fee_symbol == '៛'){
                                $delivery_fee_text = number_format($delivery_fee).' ៛';
                            }
                        } else {
                            $delivery_fee_text = '$' . number_format($delivery_fee, 2);
                            if($data->delivery_fee_symbol == '៛'){
                                $delivery_fee_text = number_format($delivery_fee).' ៛';
                            }
                        }
                        return $delivery_fee_text;
                    })

                    
                    ->addColumn('driver_name',function($data){
                        if ($data->status == 1) 
                            return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                        else
                            $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                                ->where('export_id',$data->id)
                                ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                                ->get()->last();
                                $text = '';
                                if($delivery->time_policy == "1")
                                    $text = "(ព្រឹក)";
                                else
                                    $text = "(ល្ងាច)";
                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.' '.$text.'</button>';
                        // return '<button type="button" class="btn btn-primary btn-sm change-driver"   data-delivery_date="'.$data->delivery_date.'"  data-export_id="'.$data->export_id.'" data-driver_id="'.$data->driver_id.'">'.$data->driver_name.'</button>';
                    })

                    ->addColumn('pay_all',function($data){
                        return '<input type="checkbox" name="check" class="checkbox" data-box_code="'.$data->box_code.'"  data-delivery_order_detail_proccessing_id="'.$data->delivery_order_detail_proccessing_id.'" data-export_id="'.$data->export_id.'" >';
                    })

                    ->addColumn('description',function($data){
                        return $data->total_riel > 0 ? $data->ex_description.' ('.$data->total_riel.'៛)':$data->ex_description;
                    })
                    ->editColumn('other_services_fee', function($data) {
                        $other_services_fee = '';
                        // if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                        //     $other_services_fee  =   $data->other_services_fee ;
                        // }

                        if($data->other_services_fee > 0 ){
                            if($data->other_services_type == 1){
                                $other_services_fee = '$'.number_format($data->other_services_type, 2) .' s';
                            }
                            else{
                                $other_services_fee ='$'.number_format($data->other_services_type, 2).' c';
                            }

                            if($data->other_services_pay_or_paid == 'paid'){
                                $other_services_fee .=  ' (paid)';
                            }
                        }else{
                            $other_services_fee =  '';
                        }

                        return $other_services_fee ;

                    })
                    ->addColumn('action', function($data) {
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee / $data->delivery_fee_rate ) / 100;
                            }
                            else{
                                $delivery_fee = $data->delivery_fee / $data->delivery_fee_rate;
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee / $data->delivery_fee_rate;
                        }

                        if($data->delivery_pay_or_paid == 'paid'){
                            $delivery_fee  =  0;
                        }

                        $other_services_fee =  0;
                        if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                            $other_services_fee = $data->other_services_fee ;
                        }
                        $total_price = $data->total_price / $data->total_product_rate;
                        if($data->total_product_status == 2){
                            $total_price = 0;
                        }
                        if($data->delivery_status == 2){
                            $price = $delivery_fee + $total_price + $other_services_fee;
                        }else{
                            $price = $total_price +  $other_services_fee;
                        }
                        $price_riel = $price * (currency() ? currency()->currency_exchange_to : 4000);
                        // <label class="btn_sm button_success bt_done" data-status="1" data-pay_to="'.$data->pay_to.'"​​ data-export_id="'.$data->export_id.'" >'.__('administrator.done').'</label>
                        
                        $edit = '
                        <label class="btn_sm button_warning bt_pending" data-status="2" data-export_id="'.$data->export_id.'">'.__('administrator.pending').'</label>
                        <label class="btn_sm button_danger bt_cencel" data-status="3" data-export_id="'.$data->export_id.'" >'.__('administrator.cancel').'</label>
                        <label class="btn_sm button_primary edit_price_of_car"
                        data-export_id              ="'.$data->export_id.'"
                        data-price                  ="'. $price.'"​​
                        data-delivery_option        ="'.$data->delivery_option.'"​​
                        data-currency               ="'.$data->currency.'"
                        data-taxi_status            ="'.$data->taxi_status.'"
                        data-taxi_shop_fee          ="'.$data->taxi_shop_fee.'"
                        data-taxi_cust_fee          ="'.$data->taxi_cust_fee.'"​​
                        data-taxi_number            ="'.$data->taxi_number.'"
                        data-total_riel             ="'.$data->total_riel.'"
                        data-total_dollar           ="'.$data->total_dollar.'"​​
                        data-extra_fee              ="'.$data->extra_fee.'"​​
                        data-extra_fee_type         ="'.$data->extra_fee_type.'"​​
                        data-driver_note            ="'.$data->driver_note.'"​​
                        data-user_currency          ="'.(User::find($data->merchant_id)->user_currency).'"​​
                        data-amount_pay_to          ="'.$data->amount_pay_to.'"​​
                        data-pay_to                 ="'.$data->pay_to.'" 
                        data-rate                   ="'.$data->rate.'" 
                        data-taxi_fee_symbol        ="'.$data->taxi_fee_symbol.'"



                            >'.__('administrator.edit_delivey').'</label>';
                        return $edit;
                    })
                    ->editColumn('date', function($data) {
                        return date('d-m-Y',strtotime($data->date));
                    })
                    ->rawColumns(['pay_all'=>'pay_all','driver_name'=>'driver_name'])
                    ->addIndexColumn()
                    ->make(true);
                }
        return  view('administrator.delivery-order.list-delivery-in_processing');

    }
  
    public function get_item_show_hide_edit(){ 
        $array =[];
        foreach (session('box_code_edit') as $id => $box_sessions) {
            $array[] =  $box_sessions['box_code'];
        } 
        return response()->json($array);
    }

    public function delivery_return_processing($id,$status,Request $request)
    {
        if($status ==  1){   //DONE
            \DB::table('nso007_export_stock')
                ->where('id', $id)->update(['status'=>2]);
            \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)->where('status',3)
                ->update(['status'=>1,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
            $data = \DB::table('nso007_delivery_order_detail_success')
                ->where('export_id' ,$id)->get();
            \DB::table('nso007_delivery_order_detail_success')->where('export_id', $id)->delete();
            $data[0]->invoice_payment_id= null;
            $success = json_decode($data, true);
            DeliveryOrderDetailProccessingModel::insert($success);
        }       
       
        else{   
            //CENCEL
            $export_stock =   \DB::table('nso007_export_stock')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
            ->where('nso007_export_stock.id',$id)->get();
            foreach ($export_stock as $key => $value) {
                if($export_stock[0]->type_of_stock != 2){
                    \DB::table('nos007__stocks')
                    ->where('merchant_id',$value->merchant_id)
                    ->where('barcode',$value->barcode)
                    ->decrement('stock_qty',$value->export_qty);
                }
            }

            \DB::table('nso007_export_stock')->where('id', $id)->update(['status'=>2]);
            \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',4)->update(['status'=>1,'invoice_payment_id'=>null]);
            $data = \DB::table('nso007_delivery_order_detail_cancel')->where('export_id' ,$id)->get();
            $data[0]->reason= "";
            $data[0]->invoice_payment_id= null;
            \DB::table('nso007_delivery_order_detail_cancel')->where('export_id', $id)->delete();
            $success = json_decode($data, true);
            DeliveryOrderDetailProccessingModel::insert($success);
        }
        historyBox($id,2,$reason=null);
        if($request->ajax()){
            return response()->json(200);
        }
        return redirect()->back()->with('success','Driver created successfully');
    }
    public function return_to_processing($id,$status,$from_status,Request $request)
    {
        if($status ==  1){   //DONE
            \DB::table('nso007_export_stock')
                ->where('id', $id)->update(['status'=>2]);            
            if ($from_status == 3) {
                \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)
                // ->where('status',3)
                ->update(['status'=>1,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_success')
                ->where('export_id', $id)->get();
                \DB::table('nso007_delivery_order_detail_success')->where('export_id', $id)->delete();
            }
            if ($from_status == 4) {
                \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)
                // ->where('status',4)
                ->update(['status'=>1,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_padding')
                ->where('export_id', $id)->get();
                $history = json_encode($data,true);
                

                \DB::table('nso007_delivery_order_detail_padding')->where('export_id', $id)->delete();
                // collect($history)->map(function ($q) {
                //     $q['id'] = null;
                //     $q['status'] = 1;
                //     DeliveryOrderHistoryModel::insert($q);
                //  });
            }
            if ($from_status == 7) {
                \DB::table('nso007_delivery_order_detail')
                        ->where('export_id',$id)
                        ->update(['status'=>1,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_return_to_shop')
                    ->where('export_id', $id)->get();
                \DB::table('nso007_delivery_order_detail_return_to_shop')->where('export_id', $id)->delete();
            }
            if(empty($data)){
                $data = \DB::table('nso007_delivery_order_detail')
                            ->where('export_id',$id)
                            ->get();
            }
            $data[0]->invoice_payment_id= null;
            $success = json_decode($data, true);
            DeliveryOrderDetailProccessingModel::insert($success);
        }       
       
        else{   
            //CENCEL
            $export_stock =   \DB::table('nso007_export_stock')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
            ->where('nso007_export_stock.id',$id)->get();
            foreach ($export_stock as $key => $value) {
                if($export_stock[0]->type_of_stock != 2){
                    \DB::table('nos007__stocks')
                    ->where('merchant_id',$value->merchant_id)
                    ->where('barcode',$value->barcode)
                    ->decrement('stock_qty',$value->export_qty);
                }
            }

            \DB::table('nso007_export_stock')->where('id', $id)->update(['status'=>2]);
            \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',4)->update(['status'=>1,'invoice_payment_id'=>null]);
            $data = \DB::table('nso007_delivery_order_detail_cancel')->where('export_id' ,$id)->get();
            $data[0]->reason= "";
            $data[0]->invoice_payment_id= null;
            \DB::table('nso007_delivery_order_detail_cancel')->where('export_id', $id)->delete();
            $success = json_decode($data, true);
            DeliveryOrderDetailProccessingModel::insert($success);
        }
        historyBox($id,2,$reason=null);
        if($request->ajax()){
            return response()->json(200);
        }
        return redirect()->back()->with('success','Driver created successfully');
    }
    public function return_to_shop($id,$status,$from_status,Request $request)
    {
    
        if($status ==  1){   //DONE
            \DB::table('nso007_export_stock')
                ->where('id', $id)->update(['status'=>7]);
            if ($from_status == 3) {
                \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)->where('status',3)
                ->update(['status'=>7,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_success')
                ->where('export_id', $id)->get();
                \DB::table('nso007_delivery_order_detail_success')->where('export_id', $id)->delete();
            }
            if ($from_status == 4) {
                // status from export 1 = default , 2 = processing , 3 = done ,4= padding ,5 = cancel , 6 = paid , 7=return to shop
                // status from nso007_delivery_order_detail 1 = processing , 2 = padding , 3 = done ,4= cancel ,5 = paid  , 7=return to shop
                \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)->where('status',2)
                ->update(['status'=>7,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_padding')
                ->where('export_id', $id)->get();
                \DB::table('nso007_delivery_order_detail_padding')->where('export_id', $id)->delete();
            }
            if ($from_status == 2) {
                \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)->where('status',1)
                ->update(['status'=>7,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')
                ->where('export_id', $id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id', $id)->delete();
            }
            if ($from_status == 5) {
                \DB::table('nso007_delivery_order_detail')
                ->where('export_id',$id)->where('status',4)
                ->update(['status'=>7,'invoice_payment_id'=>'','invoice_payment_id'=>null]);
                $data = \DB::table('nso007_delivery_order_detail_cancel')
                ->where('export_id', $id)->get();
                \DB::table('nso007_delivery_order_detail_cancel')->where('export_id', $id)->delete();
            }
            $data[0]->invoice_payment_id= null;
            $success = json_decode($data, true);
            DeliveryOrderDetailShopModel::insert($success);

        }       
       
        else{ 
            //CENCEL
            $export_stock =   \DB::table('nso007_export_stock')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
            ->where('nso007_export_stock.id',$id)->get();
            foreach ($export_stock as $key => $value) {
                if($export_stock[0]->type_of_stock != 2){
                    \DB::table('nos007__stocks')
                    ->where('merchant_id',$value->merchant_id)
                    ->where('barcode',$value->barcode)
                    ->decrement('stock_qty',$value->export_qty);
                }
            }

            \DB::table('nso007_export_stock')->where('id', $id)->update(['status'=>7]);
            \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',4)->update(['status'=>7,'invoice_payment_id'=>null]);
            $data = \DB::table('nso007_delivery_order_detail_cancel')->where('export_id' ,$id)->get();
            $data[0]->reason= "";
            $data[0]->invoice_payment_id= null;
            \DB::table('nso007_delivery_order_detail_cancel')->where('export_id', $id)->delete();
            $success = json_decode($data, true);
            DeliveryOrderDetailShopModel::insert($success);
        }
        historyBox($id,7,$reason=null);
        if($request->ajax()){
            return response()->json(200);
        }
        return redirect()->back()->with('success','Driver created successfully');
    }
    public function report_for_shop( Request $request)
    {
        $merchant1 = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        if ($request->ajax()) {
            if ($request->isMethod('get')){
            $from_date  = empty  ($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
            $to_date    = empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
            $merchant   = isset($request->merchant)?$request->merchant:null;
            $status     = isset($request->status)?$request->status:null ;
            $referance  = isset($request->referance)?$request->referance:null ;



            $data = DeliveryOrderModel::
            join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('users AS merchant','merchant.id','nso007_export_stock.merchant_id')
                ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                ->join('nso007_category','nso007_category.id','nso007_export_stock_details.category_id')
                ->join('users AS driver','driver.id','nso007_delivery_order.driver_id');

            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_export_stock.service_charge',
                    'nso007_export_stock.delivery_status',
                    'nso007_export_stock.description',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail.*',
                    'nso007_export_stock.box_code',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.extra_fee_type',
                    'nso007_export_stock.extra_fee',
                    'nso007_export_stock.description',
                    'nso007_export_stock.customer_receive',
                    'merchant.shop_name',
                    'merchant.id AS merchant_id',
                    'nso007_location.name_en AS name_location',
                    'nso007_category.name_en AS category_name',
                    'driver.name AS driver_name',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')

            );
            }else{

                $data = $data-> select(
                    'nso007_export_stock.service_charge',
                    'nso007_export_stock.delivery_status',
                    'nso007_export_stock.description',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.delivery_option',
                    'nso007_delivery_order_detail.*',
                    'nso007_export_stock.box_code',
                    'nso007_export_stock.taxi_number',
                    'nso007_export_stock.taxi_shop_fee',
                    'nso007_export_stock.taxi_cust_fee',
                    'nso007_export_stock.taxi_status',
                    'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.description',
                    'nso007_export_stock.customer_receive',
                    'nso007_export_stock.extra_fee_type',
                    'nso007_export_stock.extra_fee',
                    'merchant.shop_name',
                    'merchant.id AS merchant_id',
                    'nso007_location.name_km AS name_location',
                    'nso007_category.name_km AS category_name',
                    'driver.name AS driver_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price')
                );
            }
            $data = $data
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                if(!empty($from_date) && !empty($to_date)){
                    $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
                }
            })
            ->when(request('status'),function($query) use ($status){
                if(!empty($status)){
                    $status_1 ='';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key].',' ;
                    }
                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                }
            })
            ->where(function($query) use ($merchant){
                if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                    $query->where('merchant_id',\Auth::user()->id);
                }else if(\Globals::is_Driver() == 'Driver'){
                    $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
                }else{
                    $query->where('merchant_id','LIKE',$merchant);
            }
        })
        // ->where('merchant_id','LIKE',$merchant)
         ->orderBy('nso007_export_stock.box_code','asc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->get();
                return DataTables::of($data)
                ->editColumn('total', function ($data)  {
                    $taxi_fee =0;
                    $total = 0;
                    if($data->taxi_status == 1){
                        $taxi_fee =   $data->taxi_shop_fee  ;
                    } else{
                        $taxi_fee =  0  ;
                    }
                    if($data->delivery_status == 1){  //shop
                        $total =  $data->total_price - $data->delivery_fee;
                    }else{   //customer
                        $total = $data->total_price + $data->delivery_fee;
                    }
                    return  '$'. number_format( $total -  $taxi_fee  ,2);
                })

                ->editColumn('delivery_date', function($data) {
                    return date('d-m-Y',strtotime($data->delivery_date));
                })
                ->editColumn('total_price', function ($data)  {
                    return '$'.number_format( $data->total_price,2);
                })
                ->editColumn('reason', function ($data)  {
                    return $data->reason == null ? "N/A" :  $data->reason;
                })
                ->editColumn('taxi_fee', function ($data)  {
                     if($data->taxi_status == 1){
                        $taxi_fee = '$'.number_format( $data->taxi_shop_fee,2);
                     }
                     else{
                        $taxi_fee = '$'.number_format( $data->taxi_cust_fee,2);
                     }
                     return $taxi_fee;
                })
                ->editColumn('delivery_fee', function ($data)  {
                    $delivery_fee  = 0;
                    if($data->discount_type != null || $data->discount_type != '')
                    {
                        if($data->discount_type == 1){
                            $delivery_fee = $data->discount;
                        }
                        elseif($data->discount_type == 2){
                            $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                        }
                        else{
                            $delivery_fee =$data->delivery_fee;
                        }
                    }
                    else{
                        $delivery_fee  =  $data->delivery_fee;
                    }



                    if ($data->delivery_status == 1) {
                        $delivery_fee = '$' . number_format($delivery_fee, 2);
                    } else {
                        $delivery_fee = '$' . number_format($delivery_fee, 2);
                    }
                    return $delivery_fee;
                })

                ->editColumn('status', function ($data)  {
                    if($data->status == 1)  // 1 = Processing,
                            return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> '.__('administrator.processing').'</strong>';
                    else if($data->status == 2)  // 2 = Padding,
                            return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> '.__('administrator.padding').' </strong>';
                     else if($data->status == 3)  //  3 = Done ,
                        return ' <strong class="text-info"><span class="fa fa-check"></span>  '.__('administrator.done').' </strong>';
                    else if($data->status == 4)  // 4 = Cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span>  '.__('administrator.cancel').'</strong>';
                    else{
                        return ' <strong class="text-muted"><span class="fa fa-check"></span>  '.__('administrator.paid').'</strong>';

                    }
                })
                ->editColumn('status_paid', function ($data)  {
                    if($data->status_paid == 'paid'){
                        $paid = '<strong class="" style="color: #37c61a;"><span class=" fa fa-check"></span> '.__('administrator.paid').'</strong>';
                     }
                     else{
                        $paid = '';
                     }
                     return $paid;
                })

                ->rawColumns(['status' => 'status','status_paid'=>'status_paid'])
                ->addIndexColumn()
                ->make(true);
            }
        }
        return view('administrator.report.report_for_shop', compact('merchant1'));
    }

    function changeDriver(Request $request){
        
        foreach(explode('||',$request->driver_id) as $key=>$val){
            if($key == 0){
                $request['driver_id'] = $val;
            }else{
                $request['time_policy'] = $val;
            }
        }
        if($request->old_driver_id == null){
            $increas = '';
            $last_id =  DeliveryOrderModel::max('id');

            if ($last_id) {
                  $inovice = DeliveryOrderModel::latest('id')->first();
                $tran_num = $inovice->inovice;
                $tran_num = explode('DV', $tran_num);
                $increas = sprintf('DV'.'%08d', ($tran_num[1]+1));
            } else {
                $increas = 'DV00000001';
            }
            $deliveryorder = new  DeliveryOrderModel();
            $deliveryorder->inovice         = $increas;
            $deliveryorder->driver_id       = $request->driver_id;
            $deliveryorder->time_policy       = $request->time_policy;
            $deliveryorder->driver_name       = FindDriver($request->driver_id);

            $deliveryorder->delivery_date   =    date('Y-m-d', strtotime($request->delivery_date));
            $driver  =   User::find($request->driver_id);
            if ($deliveryorder->save()) {
                update_status_by($request->export_id , '2','status_proccess'); 
                $delivery_order_detail =array(
                    'delivery_order_id'         =>  $deliveryorder->id ,
                    'export_id'                 =>  $request->export_id ,
                    'status'                    =>  1,
                    'driver_commission'         =>  $driver->share_fee,
                    'commission_type'           =>  $driver->share_fee_type,
                );
                DeliveryOrderDetailModel::UpdateOrCreate(
                    ['export_id'=>$request->export_id]
                    ,$delivery_order_detail);
                $delivery_order_detail['date'] = date('Y-m-d');
                DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);
            }
            return response()->json(['success' => true]);
        }
        // try{
        DB::beginTransaction();
        $export_stock = ExportStockModel::find($request->export_id);
        if($export_stock->status == 2 || $export_stock->status == 3){
            $last_id =  DeliveryOrderModel::max('id');
            if ($last_id) {
                $inovice = DeliveryOrderModel::select('inovice')->get()->last();
                $tran_num = $inovice->inovice;
                $tran_num = explode('DV', $tran_num);
                $increas = sprintf('DV'.'%08d', ($tran_num[1]+1));
            } else {
                $increas = 'DV00000001';
            }
            $deliveryorder = new  DeliveryOrderModel();
            $deliveryorder->driver_id       = $request->driver_id;
            $deliveryorder->driver_name     = FindDriver($request->driver_id);
            $deliveryorder->inovice         = $increas;
            $deliveryorder->delivery_date   = $request->delivery_date;
            $deliveryorder->time_policy       = $request->time_policy;
            $deliveryorder->save();

            $data = \DB::table('users')->find($request->driver_id);

            $deliveryOrderDetail = DeliveryOrderDetailModel:: where('export_id',$request->export_id)
                                ->whereNotIn('status', [2,4,5]) 
                                ->first();

                                $deliveryOrderDetail->delivery_order_id     = $deliveryorder->id ;
                                $deliveryOrderDetail->driver_commission     = $data->share_fee ;
                                $deliveryOrderDetail->commission_type       = $data->share_fee_type ;
                                $deliveryOrderDetail->delivery_order_id     = $deliveryorder->id;
                                $deliveryOrderDetail->update();




            // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paid
          
            // 1 = Processing, 2 = Padding, 3 = Done , 4 = Cancel

            if($export_stock->status == 2){   // Proccess

                    $deliveryOrderDetailProccessin = DeliveryOrderDetailProccessingModel:: where('export_id',$request->export_id)
                            ->whereNotIn('status', [2,3,4,5]) 
                            ->first();
                    $deliveryOrderDetailProccessin->delivery_order_id     = $deliveryorder->id ;
                    $deliveryOrderDetailProccessin->driver_commission     = $data->share_fee ;
                    $deliveryOrderDetailProccessin->commission_type       = $data->share_fee_type ;
                    $deliveryOrderDetailProccessin->delivery_order_id     = $deliveryorder->id;
                    $deliveryOrderDetailProccessin->update();

                }else{
                    $deliveryOrderDetailSuccess = DeliveryOrderDetailSuccessModel:: where('export_id',$request->export_id)
                                ->first();
                        $deliveryOrderDetailSuccess->delivery_order_id     = $deliveryorder->id ;
                        $deliveryOrderDetailSuccess->driver_commission     = $data->share_fee ;
                        $deliveryOrderDetailSuccess->commission_type       = $data->share_fee_type ;
                        $deliveryOrderDetailSuccess->delivery_order_id     = $deliveryorder->id;
                        $deliveryOrderDetailSuccess->update();
                }

                DB::commit();
                return response()->json(['success' => true]);
            }else{
                DB::rollBack();
                return response()->json(['success' => false,'error' => 'please check and try again']);
            }
           
        // }catch(Exception $e){
        //     DB::rollBack();
        //     return response()->json(['success' => false,'error' => $e->getMessage()]);
        // }
    }
}