<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use DB;
class DailyReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index( Request $request)
    {

        $merchant_id = empty($request->merchant) ? '' : $request->merchant;

        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
 
        $to_date        =   empty($request->to_date) ? '' :date('Y-m-d',strtotime($request->to_date));
        $from_date        =   empty($request->from_date)? '' : date('Y-m-d',strtotime($request->from_date));

        $total_delivery_fee = 0;
        $data = \DB::table('nso007_delivery_order_detail')
        
        ->select('nso007_export_stock.*',
                \DB::raw('(CASE
                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                ELSE nso007_export_stock.taxi_shop_fee
                END) AS taxi_fee'),
                'nso007_delivery_order_detail.total_dollar', 
                'nso007_delivery_order_detail.total_riel', 
                'nso007_delivery_order_detail.amount_pay_to', 
                'nso007_delivery_order_detail.pay_to', 
                )
        ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')  
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->when(request('from_date','to_date'), function($query) use($from_date,$to_date){
            if($from_date){
                $query->whereDate('nso007_delivery_order.delivery_date','>=',$from_date) ;
            }
            if($to_date){
                $query->whereDate('nso007_delivery_order.delivery_date','<=',$to_date);
            }
        })
        ->where('nso007_export_stock.merchant_id','LIKE','%'.$merchant_id.'%') 
        ->where('nso007_delivery_order_detail.status', 3)
        ->get();
        
        $total_delivery_fee   = 0;
        $total_cod = 0  ;
        $total_other_services_fee = 0;
        $total_extra_fee_cus= 0  ;
        $total_product = 0;
        $total_taxi = 0;
        $total_riel = 0;
        $total_dollar = 0;
 
        $total_aba_to_delivery = 0;
        $total_aba_to_shop = 0;
        foreach ($data as $key => $value) { 
            if($key == $key){ 


                $total_riel += $value->total_riel;
                $total_dollar += $value->total_dollar;


                if ($value->pay_to == 'delivery'){
                    $total_aba_to_delivery              +=   $value->amount_pay_to;
                }
                if ($value->pay_to == 'shop'){
                    $total_aba_to_shop              +=   $value->amount_pay_to;
                }

                $delivery_fee   = 0;
                $discount = 0;

                //////////////// Delivery Fee ////////////////////
                if( $value->discount_id != null)
                {
                    $dis = DB::table('nso007_discount')->find($value->discount_id);
                    if($dis->discount_type == 1){
                        $delivery_fee = $dis->discount;
                    }
                    elseif($dis->discount_type == 2){
                        $delivery_fee = ( (100 - $dis->discount )* ($value->delivery_fee / $value->delivery_fee_rate) ) / 100;
                    }
                    else{
                        $delivery_fee =$value->delivery_fee;

                        if($value->delivery_status == 1){
                            $discount = ($dis->discount/100)* ($value->delivery_fee / $value->delivery_fee_rate);

                        }
                        else{
                            $discount = 0;
                        }
                        /* echo $discount; */
                    }
                }
                else{
                    $delivery_fee  =  $value->delivery_fee / $value->delivery_fee_rate;
                }

                if($value->delivery_pay_or_paid == 'paid'){
                    $delivery_fee  = 0;
                }  
                $total_delivery_fee   += $delivery_fee;


                if($value->delivery_status == 1){
                    $delivery_fee  = 0;
                }

                //////////////// Extra Fee ////////////////////

                // if($value->extra_fee_type == 1) {
                //     $extra_fee_shop = $value->extra_fee ;
                //     $extra_fee_cus  = 0 ;
                // }else if($value->extra_fee_type == 2)   {
                //     $extra_fee_shop = 0;
                //     $extra_fee_cus  = $value->extra_fee ;
                // }else  {
                //     $extra_fee_shop = 0;
                //     $extra_fee_cus = 0;
                // }

                //////////////// Other Services  ////////////////////

                $total_other_services_fee += $value->other_services_fee  ;
                if($value->other_services_type == 1 ){
                    $value->other_services_fee  = 0;
                }
  
                //////////////// Taxi Fee ////////////////////

                if($value->taxi_status == 1){ 
                    $total_taxi +=  $value->taxi_fee / $value->taxi_fee_rate;
                }

                //////////////// Total ////////////////////

                $total_product += ($value->total_product / $value->total_product_rate) + $delivery_fee  + $value->other_services_fee ;
                
            }

        }
        
        $total_cod = $total_product  ;

        return view('administrator.report.dily-report.index',compact('to_date','from_date', 'merchant_id', 'merchant', 'total_aba_to_delivery','total_aba_to_shop', 'total_delivery_fee','total_cod','total_other_services_fee','total_taxi','total_riel','total_dollar'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
            dd(1);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
