<?php



namespace App\Http\Controllers\Administrator;



use App\CurrencyModel;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use DB;
use DataTables;
use App\HistoryCurrentcy;



class CurrencyController extends Controller

{



    public function index()

    {
        $data = CurrencyModel::get();
        return view('administrator.currency.index',compact('data'));

    }

    public function create()

    {
        return view('administrator.currency.create');

    }

    public function store(Request $request)

    {
        // id" => "1"
        // "currency_exchange_to" => "4000"
        // "buy_currency" => "4100"

        $data = DB::table('nso007_currency')->where('id',$request->id)->update( ['buy_currency'=>$request->buy_currency ,'currency_exchange_to'=>$request->currency_exchange_to]);

        $message = array();
        if($data == true){
            $message = array('message' => 'Success');
        }else{
            $message = array('message' => 'Not Success');
        }
        echo json_encode($message);

        return redirect()->route('currency.index')->with('success','Currency was saved successful ...');

    }

    public function show($id)

    {
        //
    }

    public function edit($id)
    {
        $currency = CurrencyModel::find($id);
        return view('administrator.currency.edit',compact('currency'));
    }


    public function update(Request $request, $id)
    {

        $this->validate($request,[

            'name' => 'required',

            'rate' => 'required',

            'code' => 'required',
            'symbol' => 'required',
        ]);

        $currency = CurrencyModel::find($id);

        $currency->name = $request->name;

        $currency->rate = $request->rate;

        $currency->code = $request->code;

        $currency->symbol = $request->symbol;

        $currency->save();

        return redirect()->route('currency.index')->with('success','Currency was updated successful ...');

    }



    public function destroy($id)

    {

        //

    }

    public function history()
    {
        $history = HistoryCurrentcy::get();
        return view('administrator.currency.history', compact('history'));

    }

}

