<?php

namespace App\Http\Controllers\Administrator;

use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderModel;
use App\DiscountDaliyModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
use Illuminate\Support\Facades\DB;

class ClearInvoiceNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
        $currency  = CurrencyModel::first();
        $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
        ->select('nso007_delivery_order_detail.id','nso007_invoice_payment.invoice_payment','nso007_invoice_payment.from_date','nso007_invoice_payment.to_date')
        ->where('nso007_delivery_order_detail.invoice_payment_id',$id)
        ->get();
        $invoice    =  $data[0]->invoice_payment;
        $payment = InvoicePaymentModel::where('invoice_payment',$data[0]->invoice_payment)->first()  ;
        $discount_daily = 0;
        if( $payment->discount_daily_id != null && $payment->discount_daily_id != '' ){
            $discount_daily = DiscountDaliyModel::find( $payment->discount_daily_id)->discount_amount;
        }
 
        $from_date  =  $data[0]->from_date;
        $to_date    =  $data[0]->to_date;
        $id_ = '';
        foreach ($data as $key => $value) {
            $id_ .= $data[$key]->id.',';
        }

        $user = User::find($payment->shop_id);

        $data = DeliveryOrderModel::
                join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock.description',
                    'nso007_export_stock.*',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
            }else{
                $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name',
                    'nso007_export_stock.*',
                    'nso007_delivery_order_detail.status',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.description',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_export_stock.created_at',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                );
            }
            $data = $data
        ->whereIn('nso007_delivery_order_detail.id',explode(',',$id_))
        ->orderBy('nso007_delivery_order.inovice','desc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->get();
        return view('administrator.clear_inovice-new.show',compact('user','data','invoice','from_date','to_date','currency','discount_daily')); 
    
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
