<?php

namespace App\Http\Controllers\Administrator;

use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountDaliyModel;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Validation\ValidationException;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\JournalModel;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class ClearInvoiceController extends Controller
{
    function __construct()
    {
        // $this->middleware('permission:PickUp Assign to Driver', ['only' => ['create']]);
        // $this->middleware('permission:PickUp List', ['only' => ['list_pickup']]);
        // $this->middleware('permission:PickUp Create', ['only' => ['store']]);
        // $this->middleware('permission:PickUp Action', ['only' => ['edit','update','box_pickup_delete_main','assign_to_order','assign_driver_pickup','box_pickup_edit']]);
    }
    public function index(Request $request)
    {
        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $status = $request->status;
        $verify = $request->verify;
     
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));

        if ($request->ajax()) {
            $shop_id       =   isset($request->shop_id)?$request->shop_id:null;
            $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
            ->join('users','users.id','nso007_invoice_payment.user_create')
            ->select('nso007_invoice_payment.*','users.name')
            ->where(function($query) use ($shop_id){
                if($shop_id){
                    $query->where('shop_id','LIKE',$shop_id);
                }
            })

            ->when($from_date,function($q , $from_date){
                $q->where('date','>=',$from_date);
            } )

            ->when($to_date,function($q , $to_date){
                $q->where('date','<=',$to_date);
            } )

            
            ->when($verify,function($q , $verify){
                if($verify == 'verify'){
                    $q->whereNotNull('nso007_invoice_payment.verify_by') ;
                }else{
                    $q->whereNull('nso007_invoice_payment.verify_by' ) ;
                }
            } )
            
            ->where(function($query) use ($status){
                if($status  == 'pay'){
                    $query->whereNull('nso007_invoice_payment.status');
                }else{
                    $query->where('nso007_invoice_payment.status','paid');
                }
            })
            
            ->groupBy('nso007_delivery_order_detail.invoice_payment_id')
            ->orderBy('nso007_invoice_payment.id','desc')
            ->get();
            return  DataTables::of($data)
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })

            ->editColumn('paid_date', function($data) {
                return  $data->paid_date ? date('d-m-Y H:iA',strtotime($data->paid_date)) : '';
            })

            ->editColumn('paid_by', function($data) {
                return  $data->paid_by ? ($data->paid_by) : '';
            })
       
            ->editColumn('pay_amount', function($data) {
                $data1 = DB::table('nso007_delivery_order_detail')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                -> select(
                        'nso007_export_stock.discount_id',
                        'nso007_export_stock.location_name AS name_location',
                        'nso007_export_stock.description',
                        'nso007_export_stock.*',
                        'nso007_export_stock.total_product AS total_price',
                        'nso007_export_stock.id As export_detail_id',
                        'nso007_delivery_order_detail.status',
                        'nso007_delivery_order_detail.reason',
                        'nso007_delivery_order_detail.*',
                        'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                        \DB::raw('(CASE
                        WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                        WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                        ELSE nso007_export_stock.taxi_shop_fee
                        END) AS taxi_fee')
                )
                ->where('nso007_delivery_order_detail.invoice_payment_id',$data->id)
                ->get();
                // return $data->count();
                // return $data1->first()->total_dollar;

                $other_services_fee             = 0;
                $total_aba_to_delivery          = 0;
                $total_aba_to_shop              = 0;
                $total_riel                     = 0;
                $total_dollar                   = 0;
                $សេវាកម្មដឹកជញ្ជូនសរុប                 = 0;
                $ចេញថ្លៃឡាន                       = 0;
                $សេវារៀបចំ                        = 0;
                $total_product                  = 0;
                $total_discount                 =  0;

                foreach ($data1 as $key => $value) {
                    //////////////// Delivery Fee ////////////////////
                    $delivery_fee   = 0;
                    $discount = 0;
                    if( $value->discount_id != null)
                    {
                        $dis = DB::table('nso007_discount')->find($value->discount_id);
                        if($dis->discount_type == 1){
                            $delivery_fee = $dis->discount;
                        }
                        elseif($dis->discount_type == 2){
                            $delivery_fee = ( (100 - $dis->discount )* $value->delivery_fee / $value->delivery_fee_rate ) / 100;
                        }
                        else{
                            $delivery_fee =$value->delivery_fee / $value->delivery_fee_rate;

                            if($value->delivery_status == 1){
                                $discount = ($dis->discount/100)*($value->delivery_fee / $value->delivery_fee_rate);
                            }
                            else{
                                $discount = 0;
                            }
                            /* echo $discount; */
                        }
                    }
                    else{
                        $delivery_fee  =  $value->delivery_fee / $value->delivery_fee_rate;
                    }

                    if($value->delivery_pay_or_paid == '2'){
                        $delivery_fee  = 0;
                    } 
                    //////////////// Extra Fee ////////////////////

                    if($value->extra_fee_type == 1) {
                        $extra_fee_shop = $value->extra_fee ;
                        $extra_fee_cus  = 0 ;
                    }else if($value->extra_fee_type == 2)   {
                        $extra_fee_shop = 0;
                        $extra_fee_cus  = $value->extra_fee ;
                    }else  {
                        $extra_fee_shop = 0;
                        $extra_fee_cus = 0;
                    }

                    //////////////// Taxi Fee ////////////////////


                    if($value->taxi_status == 1){
                        $taxi_fee_shop 	=   $value->taxi_fee / $value->taxi_fee_rate ;
                        if ($value->taxi_pay_or_paid == '2') {
                            $taxi_fee_shop = 0;
                        }
                    } else if($value->taxi_status == 2){
                        $taxi_fee_shop =  0  ; 
                    }
                    else{
                        $taxi_fee_shop =  0  ;
                    }
                    
                    //////////////// Other Services  ////////////////////

                    if($value->other_services_pay_or_paid == 'pay'){
                        $other_services_fee				   += $value->other_services_fee;
                    }

                    if( $value->status == 3 ){
                        if ($value->pay_to == 'delivery'){
                            $total_aba_to_delivery              +=   $value->amount_pay_to;
                        }
                        if ($value->pay_to == 'shop'){
                            $total_aba_to_shop              +=   $value->amount_pay_to;
                        }

                        // $totalPaid  +=  $Paid;
                        $total_riel                   +=  $value->total_riel;
                        $total_dollar                 +=  $value->total_dollar;
                        $សេវាកម្មដឹកជញ្ជូនសរុប               +=  $delivery_fee  + $extra_fee_cus  + $extra_fee_shop;
                        $ចេញថ្លៃឡាន                     += $taxi_fee_shop ;
                        $សេវារៀបចំ                      +=   $value->service_charge ;
                        $total_product                += $value->total_price ;
                        /* $service_charge				   += $value->service_charge; */
                        $total_discount += $discount;
                    }
                }
                $rate = $data1->first()->rate ? $data1->first()->rate : 4000;
                $total_all_service = $សេវាកម្មដឹកជញ្ជូនសរុប  + $សេវារៀបចំ   + $ចេញថ្លៃឡាន  + $other_services_fee + $total_discount;
                $substrack_total_receice_riel = (($total_riel / $rate) - $total_all_service) * $rate;
                if($substrack_total_receice_riel <= 0){
                    $total_dollar += ($substrack_total_receice_riel / $rate);
                }
                // $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel / $rate : 0;
                $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel : 0;
                return '<p><span style="font-size: 15px;"  class="text-danger">'.'$'.number_format($total_dollar,2).' ឬ '.number_format(round( $test, -2,PHP_ROUND_HALF_ODD) ,0).'៛' .'</span></p>';
                return '$'. number_format($total_dollar + $test,2);
                $​តម្លៃផ្ទេរអោយហាងសរុប  = ( $total_dollar + $total_aba_to_delivery)  -  $សេវាកម្មដឹកជញ្ជូនសរុប  - $សេវារៀបចំ   - $ចេញថ្លៃឡាន  - $other_services_fee + $total_discount;
                return '<p><span style="font-size: 15px;"  class="text-danger">'.'$'.number_format($​តម្លៃផ្ទេរអោយហាងសរុប,2).' ឬ '.number_format(round( $total_riel, -2,PHP_ROUND_HALF_ODD) ,0).'៛' .'</span></p>';
            })

            ->addColumn('verify_by1', function ($data) {

                if($data->verify_by){
                    return      $data->verify_by; 
                }
                if(Gate::check('Verify Payment')){
                    return      '<span class="class_'.$data->id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("clear-invoice.update",$data->id) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                }
             })


            ->addColumn('shop', function($data) {

                if($data->shop_id == null){
                    return '';
                }
                $shop = User::find($data->shop_id);
                $data->bank_account = $shop->bank_account;
                return $shop->shop_name;
            })
            ->addColumn('bank_account', function($data) {
                return $data->bank_account ;
            })
            ->addColumn('action', function($data) {
                $edit = '';
                if (Gate::check('Payment')) {
                    $edit ='<a href="'. route("clear-invoice-new.show", $data->id) . '" class="btn_sm button_primary">'.__('administrator.show').'</a> ';
                }
                if($data->status !== 'paid'){
                    if (Gate::check('Payment')) {
                        $edit .=
                    '
                        <a href="#" class="btn_sm button_danger bt_done"  data-id="'.$data->id.'"  >'.__('administrator.paid').'</a>
                       ';
                    }
                }
                return $edit;
                })
            ->rawColumns(['pay_amount'=>'pay_amount','verify_by1'=>'verify_by1'])
                
            ->addIndexColumn()
            ->make(true);
        }
        return view('administrator.clear_inovice.index',compact('merchant'));
    }

    public function create()
    {
        //
    } 

    public function store(Request $request)
    {
        
    }

    public function show($id)
    {
        $currency  = CurrencyModel::first();
        $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
        ->select('nso007_delivery_order_detail.id','nso007_invoice_payment.invoice_payment','nso007_invoice_payment.from_date','nso007_invoice_payment.to_date')
        ->where('nso007_delivery_order_detail.invoice_payment_id',$id)
        ->get();
        $invoice    =  $data[0]->invoice_payment;
        $payment = InvoicePaymentModel::where('invoice_payment',$data[0]->invoice_payment)->first()  ;
        $discount_daily = 0;
        if( $payment->discount_daily_id != null && $payment->discount_daily_id != '' ){
            $discount_daily = DiscountDaliyModel::find( $payment->discount_daily_id)->discount_amount;
        }
 
        $from_date  =  $data[0]->from_date;
        $to_date    =  $data[0]->to_date;
        $id_ = '';
        foreach ($data as $key => $value) {
            $id_ .= $data[$key]->id.',';
        }

        $user = User::find($payment->shop_id);

        $data = DeliveryOrderModel::
                join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock.description',
                    'nso007_export_stock.*',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
            }else{
                $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name',
                    'nso007_export_stock.*',
                    'nso007_delivery_order_detail.status',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.description',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                );
            }
            $data = $data
        ->whereIn('nso007_delivery_order_detail.id',explode(',',$id_))
        ->orderBy('nso007_delivery_order.inovice','desc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->get();

        return view('administrator.clear_inovice.show',compact('user','data','invoice','from_date','to_date','currency','discount_daily' ));
    }
    public function pay_later($id){

        $currency  = CurrencyModel::first();
        $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
        ->select('nso007_delivery_order_detail.id','nso007_invoice_payment.invoice_payment','nso007_invoice_payment.from_date','nso007_invoice_payment.to_date')
        ->where('nso007_delivery_order_detail.invoice_payment_id',$id)
        ->get();
        $invoice_payment  = $data[0]->invoice_payment;
        $id_ = '';
        foreach ($data as $key => $value) {
            $id_ .= $data[$key]->id.',';
        }
       
        InvoicePaymentModel::where('id',$id)->update(['status'=>'paid','paid_date'=>date('Y-m-d H:i:s'),'paid_by'=>\Auth::user()->name]);
        DeliveryOrderDetailModel::where('invoice_payment_id',$id)->update(['status_paid'=>'paid']);
        DeliveryOrderDetailCancelModel:: where(function($query)  use ($id){
            $query->where('invoice_payment_id',$id)->update(['status_paid'=>'paid']);
            });

        DeliveryOrderDetailSuccessModel::  where(function($query)  use ($id){
            $query->where('invoice_payment_id',$id)->update(['status_paid'=>'paid']);
            });
        return redirect()->back()->with('success','Driver created successfully');


    }

    function export_to_excel(){
        
        return view('administrator.clear_inovice.excel')->render();

    } 
   
    public function update(Request $request, $id)
    {
        $auth = \Auth::user();
        try {
            \DB::beginTransaction();
                $data = InvoicePaymentModel::find($id);

                $data->verify_by  = $auth->name;
                $data->update();

                \DB::commit();
                return response()->json(['success' => 200 ,'class'=> 'class_'.$id ,'verify_by'=> $auth->name]);
            } catch (\Exception $e) {
                throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
        } 
    }
}
