<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailSuccessModel;
use App\HistoryDeleteModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;


class ClearDataController extends Controller
{
    public function index()
    {
        $data = DeliveryOrderDetailModel::
                select('status','export_id',\DB::raw('count(nso007_delivery_order_detail.export_id) as count_'))
                ->where('nso007_delivery_order_detail.created_at','>=',date('Y-m-d', strtotime("-30 day", strtotime(date('Y-m-d')))))
                ->groupBy('nso007_delivery_order_detail.export_id')
                ->get();
        $status ='';
        foreach ($data as $key => $value) {
            if($value->count_ > 1){  //1 = Processing, 2 = Padding, 3 = Done , 4 = Cancel  ,5= paid
                $data1 = DeliveryOrderDetailModel::
                        whereExport_id($value->export_id);
                if($data1->whereStatus(1)->count() > 1){
                    $status .= $data1->get()[0]->id.',' ;
                }

                $data1 = DeliveryOrderDetailModel::
                        whereExport_id($value->export_id);
                if($data1->whereStatus(3)->count() > 1){
                    $status .= $data1->get()[0]->id .',' ;
                }
            }
        }
        $delivery = DeliveryOrderDetailModel::
        select('nso007_delivery_order_detail.*','nso007_export_stock.box_code')
        ->join('nso007_export_stock','nso007_delivery_order_detail.export_id','nso007_export_stock.id')
        ->whereIn('nso007_delivery_order_detail.id',explode(',',$status))
        ->get();
        return view('layouts.clear-data',compact('delivery'));
    }
    public function show($id)
    {
        $delivery = DeliveryOrderDetailModel::whereIn('id',explode(',',$id))->get();
        foreach ($delivery as $key1 => $value) {
            $history  = new HistoryDeleteModel();
            $history->date = date('y-m-d');
            $history->delete_by =\Auth::id();
            $history->history_data = json_encode($value, true);
            $history->save();
            DeliveryOrderDetailModel::where('id',$value->id)->delete();

            if( $value->status == 1){
                $delivery_pro = DeliveryOrderDetailProccessingModel::where('export_id',$value->export_id)->get();
                if($delivery_pro->count()  > 1){
                    DeliveryOrderDetailProccessingModel::where('id',$delivery_pro[0]->id)->delete();
                }
            }
            if( $value->status == 3){
                $delivery_su = DeliveryOrderDetailSuccessModel::where('export_id',$value->export_id)->get();
                if($delivery_su->count()  > 1){
                    DeliveryOrderDetailSuccessModel::where('id',$delivery_su[0]->id)->delete();
                }
            }
        }
        return redirect()->back()
        ->with('success','Stockout created successfully');
    }
}
