<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderModel;
use App\ExportStockdetailsMode;
use App\Helpers\Globals;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Yajra\DataTables\Facades\DataTables;

class AssignDriverController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend("All Shop", '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;
        $zone = $request->zone;
        $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
        $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.export_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                // ->where('nso007_export_stock.type_of_stock',2)
                ->where('nso007_export_stock.status',1)
                ->groupBy('nso007_export_stock.box_code')
                ->whereNotIn('nso007_export_stock.id',$paid)
                ->when($zone,function($q) use($zone){
                        $q->whereIn('nso007_export_stock.from_location',$zone);
                    })
                ->when($request->location,function($q) use($request){
                    $q->whereIn('nso007_export_stock.location',$request->location);
                })
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc'); 
                $lang = Globals::check_lang();
                $from_loc = $request->from_location;
                $zone = $data
                    ->when($from_loc,function($q) use($from_loc){
                        $q->whereIn('nso007_export_stock.from_location',$from_loc);
                    })->get()->pluck('location_name','location');
               
                $shop = $data->get()->pluck('shop_name','merchant_id')->prepend(''.'All Shop'.'','');
                $loc_array = array();
                foreach($data->get() as $zone_loc){
                    $parent_zone = \DB::table('nso007_location')->whereRaw('FIND_IN_SET('.$zone_loc->location.',location_id)')
                        ->get('id')->first();
                    if($parent_zone){
                        array_push($loc_array,$parent_zone->id);
                    }
                }
                
                $loc_zone = \DB::table('nso007_location')->whereIn('id',$loc_array)
                                    ->pluck('name_'.$lang.'','id'); 
        if ($request->ajax()) {
            // $data = $data->when($zone,function($q) use($zone){
            //     $q->whereIn('nso007_export_stock.from_location',$zone);
            // });

            if($request->need_location){
                return $zone;
            }
            return  DataTables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action1', function ($data) {
                    // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paid , 7 = return to shop
                    $edit​​ = '';
                    $delete = '';
                    // if ($data->status == 1 || $data->status == 2) {
                    //     if ($data->type_of_stock == 1) {
                    //         $edit = '<a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                    //     } else {
                    //         $edit = '<a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                    //     }

                    // } else {
                    //     $edit = '<a href="#" class="button_dark fa fa-edit"></a>';
                    // }


                    // if ($data->status == 1 ) {
                    //     if(Gate::check('Export List Delete Box')){
                    //         $delete = '<a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    //     }
                    // } else {
                    //     $delete = '<a data-href="#" class="button_dark fa fa-trash   " ></a>';
                    // }

                    //     return $delete .'
                    //     <a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="button_warning fa fa-print bt-print"></a>
                    //     ' . $edit;

                $pedding = '';
                $cancel = '';
                $edit = '';
                $return_to_shop = '';
                $print = '';
                $all = '';
                $return_to_proccess = '';
                $delete = '<li><a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class=" fa fa-trash bt-delete">&nbsp; '. __('administrator.delete') .'</a></li>';
                $pedding = '<li><a class="bt_pending" data-status="2" data-export_id="'.$data->export_id.'">'.__('administrator.pending').'</a>';
                        $cancel = '<li><a class="bt_cencel fa fa-ban" data-status="3" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.cancel').'</a></li>';
                        $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                        $edit = '<li><a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                        $print = '<li><a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="fa fa-print bt-print">&nbsp;'.__('administrator.print').'</a></li>';
                        $return_to_proccess = '
                        <li><a class="return_to_inpro fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
                    ';
                if($data->status == 1 || $data->status == 2 || $data->status == 4 || $data->status == 3){
                    if ($data->status == 1) {
                        if (\Gate::check('Export List Delete Box')) {
                            $all.= $delete.$print.$edit;
                        }
                    }
                   
                    if($data->status == 2){
                        $all .= $print.$edit.$pedding.$cancel.$return_to_shop;
                    }
                    if($data->status != 4){
                        
                    }
                    // $all = $delete . $print .$edit .$pedding .$cancel.$return_to_shop;
                    


                }
                if($data->status == 4){
                    if(!$data->status_paid){
                        if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                            $all .= $return_to_proccess.$return_to_shop;
                        }
                    }
                }
                if($data->status == 5){
                    $all .= $return_to_proccess;
                }
                if($data->status == 3){
                    // if(!$data->status_paid){
                    //     if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                    //         $all .= $return_to_proccess;
                    //     }
                    // }
                        if(!$data->status_paid){
                            if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                                $all .=$return_to_proccess;
                                // $action = '
                                //     <label class="btn btn-info btn-xs return_to_inpro_for_success"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
                                // ';
                            }
                        }
                }
                if($data->status == 7){
                    $all .= $print.$edit.$delete.$return_to_proccess;
                }
                
                return '
                <div class="dropdown">
                     <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                     <span class="caret"></span></button>
                     <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                     '.$all.'
                     </ul>
                 </div>
                ';

                

                //     >'.__('administrator.edit_delivey').'</label>';
                // return $edit;

                
                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else if($data->status ==5)   // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                    else if($data->status ==6)   // 6 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.paid') . ' </strong>';
                    else if($data->status ==7)   // 7 = paid
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>';
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })
                ->addColumn('all', function ($data) {
                    return '
                    <div class="form-check">
                        <input class="form-check-input export" type="checkbox" value="'.$data->id.'">
                    </div>
                    ';
                })
                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1) 
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->get()->last();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";
                        
                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })

                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" value="'.$data->export_stock_id.'" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name','all'=>'all'])
                ->addIndexColumn()
                ->make(true);
        }
        return view('administrator.assign-driver-v2.index',compact('shop','zone','loc_zone'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            "driver_id"=>"required",
            "export_id.*"=>"required",
        ]);
        if(empty($request->export_id)){
            throw ValidationException::withMessages(['export_id' => 'The field export_id is required']);

        }
        foreach(explode('||',$request->driver_id) as $key=>$val){
            if ($key == 0) {
                $request['driver_id']=$val;
            }else{
                $request['time_policy']=$val;
            }
 
        }
        $request['date'] = date('Y-m-d',strtotime($request->date));
        $last_id =  DeliveryOrderModel::max('id');

        if ($last_id) {
              $inovice = DeliveryOrderModel::latest('id')->first();
            $tran_num = $inovice->inovice;
            $tran_num = explode('DV', $tran_num);
            $increas = sprintf('DV'.'%08d', ($tran_num[1]+1));
        } else {
            $increas = 'DV00000001';
        }
        $deliveryorder = new  DeliveryOrderModel();
        $deliveryorder->inovice         = $increas;
        $deliveryorder->driver_id       = $request->driver_id;
        $deliveryorder->time_policy       = $request->time_policy;
        $deliveryorder->driver_name       = FindDriver($request->driver_id);

        $deliveryorder->delivery_date   =    date('Y-m-d', strtotime($request->date));
        $driver  =   User::find($request->driver_id);
        if ($deliveryorder->save()) {
            foreach ($request->export_id as $key => $value) {
                update_status_by($request->export_id[$key]  , '2','status_proccess'); 
                $delivery_order_detail =array(
                    'delivery_order_id'         =>  $deliveryorder->id ,
                    'export_id'                 =>  $request->export_id[$key] ,
                    'status'                    =>  1,
                    'driver_commission'         =>  $driver->share_fee,
                    'commission_type'           =>  $driver->share_fee_type,
                );
                DeliveryOrderDetailModel::insert($delivery_order_detail);
                $delivery_order_detail['date'] = $request->date;
                DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);

            }
        }
        session()->forget('box_session');
        return response()->json(['success' => 'success'], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
