<?php

namespace App\Http\Controllers\Administrator;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Hash;
use Image;
class AccountProfileController extends Controller
{
    
    public function account_profile()
    {
        return view('administrator.account-profile.index');
    }


    public function change_password(Request $request){
        $user = User::find(Auth::user()->id);
        if (Hash::check($request->password, $user->password)) {
            $user->password = Hash::make($request->get('new_password'));
            if ($request->new_password != $request->confirm_password) {
                return redirect()->route('account_profile')
                        ->with('danger','New password and confirm password not match !!!');

            }
            if( $user->save()){
                return redirect()->route('account_profile')
                        ->with('success','Password updated successfully');
            }
        }
        else{
            return redirect()->route('account_profile')
                        ->with('danger','Old password not match with password');
        }

    }

}

