<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\JournalModel;
use App\AccountChartModel;

class IncomeStatementController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:IncomeStatement', ['only' => ['IncomeStatement']]);
    }

    public function IncomeStatement(Request $request)
    {
    	$from_date = empty($request->from_date)? date('Y-m-d',strtotime('first day of this month')):date('Y-m-d',strtotime($request->from_date));
        $to_date = empty($request->to_date)? date('Y-m-d',strtotime('last day of this month')):date('Y-m-d',strtotime($request->to_date));

        $income = JournalModel::leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                ->select(
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'nso007_journal.journal_acccode',
                    \DB::raw('SUM(nso007_journal.journal_debit) AS in_total')
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->whereIn('nso007_journal.journal_acccode',[4001])
                ->groupBy('nso007_journal.journal_acccode')
                ->get();

        $expense = JournalModel::leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                ->select(
                    \DB::raw('SUM(nso007_journal.journal_credit) AS ex_total'),
                    'nso007_journal.journal_acccode',
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->whereIn('nso007_journal.journal_acccode',[5002,5003,5004,5005,5006,5007,5009,5010,5011,])
                ->groupBy('nso007_journal.journal_acccode')
                ->get();

         
        $total_income = 0 ;
        $total_expense = 0 ;
        foreach ($income as $key => $in) {
        	$total_income += $in->in_total ;
        }
        foreach ($expense as $key => $in) {
        	$total_expense += $in->ex_total ;
        }
        $statement =  [
        	'income' => $income,
        	'expense' => $expense,
        	'total_income' => $total_income,
        	'total_expense' => $total_expense,
        ]; 
        if($request->isMethod('get')){
    		return view('accounting.report.income-statement',compact('statement','total_income','total_expense'));
        }else{
        	echo json_encode($statement);
        }
    }

    public function reportIncomeStatementPrint(Request $request)
    {
    	$from_date = empty($request->from_date)? date('Y-m-d',strtotime('first day of this month')):date('Y-m-d',strtotime($request->from_date));
        $to_date = empty($request->to_date)? date('Y-m-d',strtotime('last day of this month')):date('Y-m-d',strtotime($request->to_date));

        $income = JournalModel::leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
        ->select(
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'nso007_journal.journal_acccode',
                    'nso007_journal.journal_debit AS in_total',
                    'nso007_journal.journal_paydate'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->where('nso007_account_chart.acctype',40)
                ->get();

        $expense = JournalModel::leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
        ->select(
                    'nso007_journal.journal_acccode',
                    'nso007_account_chart.acc_name_en',
                    'nso007_journal.journal_credit AS ex_total',
                    'nso007_account_chart.acc_name_km',
                    'nso007_journal.journal_paydate'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->where('nso007_account_chart.acctype',50)
                ->get();

        // dd($expense);
        $total_income = 0 ;
        $total_expense = 0 ;
        foreach ($income as $key => $in) {
        	$total_income += $in->in_total ;
        }
        foreach ($expense as $key => $in) {
        	$total_expense += $in->ex_total ;
        }
        $statement =  [
        	'income' => $income,
        	'expense' => $expense,
        	'total_income' => $total_income,
        	'total_expense' => $total_expense,
        ]; 
    	return view('accounting.report.income-statement-print',compact('statement','total_income','total_expense','from_date','to_date'));
        
    }

    
}

