<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use App\JournalModel;
use App\AccountChartModel;
class CashOnHandController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Cash On Hand', ['only' => ['index','reportCashOnHandPrint']]);
    }

    public function index(Request $request)
    {
    	return view('accounting.report.report-cash-on-hand');
    }

    public function getCashOnHand(Request $request)
    {
    	$from_date = empty($request->from_date)? date('Y-m-d',strtotime('first day of this month')):date('Y-m-d',strtotime($request->from_date));
        $to_date = empty($request->to_date)? date('Y-m-d',strtotime('last day of this month')):date('Y-m-d',strtotime($request->to_date));

        $data = JournalModel::leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                ->select(
                    'nso007_journal.*',
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'nso007_account_chart.id AS account_code'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->where('nso007_account_chart.id','LIKE',isset($request->account_code)?$request->account_code:null)
                ->whereIn('nso007_account_chart.acctype',[40,50])
                ->orderBy('nso007_journal.journal_paydate','ASC')
                ->get();

        if($request->isMethod('get')){
            return  DataTables::of($data)
                    ->addColumn('account_name',function($data){
                        if(\Globals::check_lang() =='en'){
                            return $data->account_code.' '.$data->acc_name_en;
                        }else{
                            return $data->account_code.' '.$data->acc_name_km;
                        }
                    })
                    ->addColumn('cash_in',function($data){
                        return '$'.number_format($data->journal_debit,2);
                    })
                    ->addColumn('cash_out',function($data){
                        return '$'.number_format($data->journal_credit,2);
                    })
                    ->addColumn('journal_paydate',function($data){
                        return date('d-m-Y',strtotime($data->journal_paydate));
                    })
                    ->addIndexColumn()
                    ->make(true);
        }else{
            echo json_encode($data);
        }
    }

    public function reportCashOnHandPrint(Request $request)
    {
    	$from_date = empty($request->from_date)? date('Y-m-d',strtotime('first day of this month')):date('Y-m-d',strtotime($request->from_date));
        $to_date = empty($request->to_date)? date('Y-m-d',strtotime('last day of this month')):date('Y-m-d',strtotime($request->to_date));

        $data = JournalModel::leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                ->select(
                    'nso007_journal.*',
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'nso007_account_chart.id AS account_code'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->where('nso007_account_chart.id','LIKE',isset($request->account_code)?$request->account_code:null)
                ->whereIn('nso007_account_chart.acctype',[40,50])
                ->orderBy('nso007_journal.journal_paydate','ASC')
                ->get();

        return view('accounting.report.report-cash-on-hand-print',compact('data','from_date','to_date'));
    }
}
