<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AccountReceivableModel;
use Yajra\DataTables\DataTables;
use App\User;
class AccountReceivableController extends Controller
{

    public function index(Request $request)
    {
        $data = AccountReceivableModel::leftJoin('users AS customer','customer.id','nso007_account_receivable.customer_id')
                ->select('nso007_account_receivable.*','customer.name AS customer_name','customer.phone')
                ->get();

        if($request->ajax()){
            return  DataTables::of($data)
                    ->addColumn('receivable_amount',function($data){
                        return '$'.number_format($data->receivable_amount,2);
                    })
                    ->addColumn('receivable_refunds',function($data){
                        return '$'.number_format($data->receivable_refunds,2);
                    })
                    ->addColumn('receivable_refunds',function($data){
                        return '$'.number_format($data->receivable_refunds,2);
                    })
                    ->addColumn('receivable_remain',function($data){
                        return '$'.number_format(($data->receivable_amount-$data->receivable_refunds),2);
                    })
                    ->addColumn('action',function($data){
                        return '<a href="'.route('account-receivable.edit',$data->id).'" class="button_primary">'.__('administrator.edit').'</a>';
                    })
                    ->addIndexColumn()
                    ->make(true);
        }
        return view('accounting.account-receivable.index');
    }


    public function create()
    {
        $merchant = User::where('user_type',3)->where('status',0)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        return view('accounting.account-receivable.create',compact('merchant'));
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'customer_id'      => 'required',
            'receivable_date'      => 'required',
            'receivable_amount'     => 'required',
        ]);

        $receivable = new AccountReceivableModel;
        $receivable->receivable_date       = date('Y-m-d',strtotime($request->receivable_date));
        $receivable->customer_id           = $request->customer_id;
        $receivable->receivable_amount     = $request->receivable_amount;
        $receivable->receivable_invoice    = $request->receivable_invoice;
        $receivable->description           = $request->description;
        $receivable->save();

        return redirect()->route('account-receivable.index')->with(['success' => 'Your Create Successfull']);
    }


    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $receivable = AccountReceivableModel::find($id);
        $merchant = User::where('user_type',3)->where('status',0)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        return view('accounting.account-receivable.edit',compact('merchant','receivable'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'customer_id'      => 'required',
            'receivable_date'      => 'required',
            'receivable_amount'     => 'required',
        ]);

       $receivable = AccountReceivableModel::find($id);
        $receivable->receivable_date       = date('Y-m-d',strtotime($request->receivable_date));
        $receivable->customer_id           = $request->customer_id;
        $receivable->receivable_amount     = $request->receivable_amount;
        $receivable->receivable_invoice    = $request->receivable_invoice;
        $receivable->description           = $request->description;
        $receivable->save();

        return redirect()->route('account-receivable.index')->with(['success' => 'Your Create Successfull']);
    }


    public function destroy($id)
    {
        //
    }
}
