<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AccountPayableModel;
use Yajra\DataTables\DataTables;
use App\User;
class AccountPayableController extends Controller
{
    public function index(Request $request)
    {
        $data = AccountPayableModel::leftJoin('users AS customer','customer.id','nso007_account_payable.merchant_id')
                ->select('nso007_account_payable.*','customer.name AS customer_name','customer.phone')
                ->get();

        if($request->ajax()){
            return  DataTables::of($data)
                    ->addColumn('payable_amount',function($data){
                        return '$'.number_format($data->payable_amount,2);
                    })
                    ->addColumn('payable_refunds',function($data){
                        return '$'.number_format($data->payable_refunds,2);
                    })
                    ->addColumn('payable_refunds',function($data){
                        return '$'.number_format($data->payable_refunds,2);
                    })
                    ->addColumn('payable_remain',function($data){
                        return '$'.number_format(($data->payable_amount-$data->payable_refunds),2);
                    })
                    ->addColumn('action',function($data){
                        return '<a href="'.route('account-payable.edit',$data->id).'" class="button_primary">'.__('administrator.edit').'</a>';
                    })
                    ->addIndexColumn()
                    ->make(true);
        }
        return view('accounting.account-payable.index');
    }


    public function create()
    {
        $merchant = User::where('user_type',3)->where('status',0)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        return view('accounting.account-payable.create',compact('merchant'));
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'merchant_id'      => 'required',
            'payable_date'      => 'required',
            'payable_amount'     => 'required',
        ]);

        $payable = new AccountPayableModel;
        $payable->payable_date       = date('Y-m-d',strtotime($request->payable_date));
        $payable->merchant_id           = $request->merchant_id;
        $payable->payable_amount     = $request->payable_amount;
        $payable->payable_invoice    = $request->payable_invoice;
        $payable->description           = $request->description;
        $payable->save();

        return redirect()->route('account-payable.index')->with(['success' => 'Your Create Successfull']);
    }


    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $payable = AccountPayableModel::find($id);
        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        return view('accounting.account-payable.edit',compact('merchant','payable'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'merchant_id'      => 'required',
            'payable_date'      => 'required',
            'payable_amount'     => 'required',
        ]);

        $payable = AccountPayableModel::find($id);
        $payable->payable_date       = date('Y-m-d',strtotime($request->payable_date));
        $payable->merchant_id           = $request->merchant_id;
        $payable->payable_amount     = $request->payable_amount;
        $payable->payable_invoice    = $request->payable_invoice;
        $payable->description           = $request->description;
        $payable->save();

        return redirect()->route('account-payable.index')->with(['success' => 'Your Create Successfull']);
    }


    public function destroy($id)
    {
        //
    }
}
