<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AccountTypeModel;
use App\AccountChartModel;
use Yajra\DataTables\DataTables;
class AccountChartController extends Controller
{

    public function index(Request $request)
    {
        if($request->ajax()){
            $data = AccountChartModel::leftJoin('nso007_account_type','nso007_account_type.id','nso007_account_chart.acctype')
                    ->select(
                        'nso007_account_chart.*',
                        'nso007_account_type.acctype_name_en',
                        'nso007_account_type.acctype_name_km'
                    )
                    ->get();
            return  DataTables::of($data)
                    ->addColumn('accType',function($data){
                        if(\Globals::check_lang() =='en'){
                            return $data->acctype_name_en;
                        }else{
                            return $data->acctype_name_km;
                        }
                    })
                    ->addColumn('accName',function($data){
                        if(\Globals::check_lang() =='en'){
                            return $data->acc_name_en;
                        }else{
                            return $data->acc_name_km;
                        }
                    })
                    ->addColumn('action',function($data){
                        return '<a href="'.route('account-chart.edit',$data->id).'" class="button_primary">'.__('administrator.edit').'</a>';
                    })
                    ->addIndexColumn()
                    ->make(true);
        }
        return view('accounting.account-chart.index');
    }

    public function create()
    {
        if(\Globals::check_lang() =='en'){
            $account_type = AccountTypeModel::select(
            \DB::raw('CONCAT(id," ",acctype_name_en) AS account_mixed'),'id')
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        }else{
            $account_type = AccountTypeModel::select(
            \DB::raw('CONCAT(id," ",acctype_name_km) AS account_mixed'),'id')
            ->pluck('account_mixed','id')
            ->prepend('សូមជ្រើសរើស', '');
        }
        return view('accounting.account-chart.create',compact('account_type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $type_code = $request->acctype;
        $this->validate($request, [
            'acctype'      => 'required',
            'acc_name_en'      => 'required',
            'acc_name_km'     => 'required',
        
        ]);
        $chart = new AccountChartModel;
        $chart->id = $chart->increase_account_chart($type_code.'');
        $chart->acctype = $type_code;
        $chart->acc_name_en = $request->acc_name_en;
        $chart->acc_name_km = $request->acc_name_km;
        $chart->acc_des = $request->acc_des;
        $chart->acc_delete = 1;
        $chart->save();

        return redirect()->route('account-chart.index')
            ->with('success','Account Chart created successfully');
        
    }

    public function edit($id){
        $account_chart = AccountChartModel::find($id);
        if(\Globals::check_lang() =='en'){
            $account_type = AccountTypeModel::select(
            \DB::raw('CONCAT(id," ",acctype_name_en) AS account_mixed'),'id')
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        }else{
            $account_type = AccountTypeModel::select(
            \DB::raw('CONCAT(id," ",acctype_name_km) AS account_mixed'),'id')
            ->pluck('account_mixed','id')
            ->prepend('សូមជ្រើសរើស', '');
        }
        return view('accounting.account-chart.edit',compact('account_type','account_chart'));
    }


    public function update(Request $request,$id)
    {

        $type_code = $request->acctype;
        $current_accout_chart = AccountChartModel::find($id);
        $current_accout_chart->acctype;
        if($current_accout_chart->acctype == $type_code){
            $increase = $current_accout_chart->id;
        }else{
            $increase = $current_accout_chart->increase_account_chart($type_code);
        }
        $this->validate($request, [
            'acctype'      => 'required',
            'acc_name_en'      => 'required',
            'acc_name_km'     => 'required',
        ]);
       
        $current_accout_chart->id = $increase;
        $current_accout_chart->acctype = $type_code;
        $current_accout_chart->acc_name_en = $request->acc_name_en;
        $current_accout_chart->acc_name_km = $request->acc_name_km;
        $current_accout_chart->acc_des = $request->acc_des;
        $current_accout_chart->update();

         return redirect()->route('account-chart.index')
            ->with('success','Account Chart created successfully');
        
    }
}
