<?php

namespace App\Helpers;

use App\HrExchangeRateModel;
use App\HrOvertimeRequestModel;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class IDate

{

  public static function dateDiff($f_date, $t_date)
  {
      $sql = "SELECT DATEDIFF('{$t_date}', '{$f_date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function dateTimeDiff($f_date, $t_date)
  {
      $sql = "SELECT TIMESTAMPDIFF(MINUTE,'{$f_date}', '{$t_date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function dateDiffFromNow($date)
  {
      $sql = "SELECT DATEDIFF('{$date}', now()) as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  
  public static function getDayName($date)
  {
      $sql = "SELECT DAYNAME('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }


  public static function getYear($date)
  {
      $sql = "SELECT YEAR('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function getMonth($date)
  {
      $sql = "SELECT MONTH('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function getLastDayMonth($date)
  {
      $sql = "SELECT LAST_DAY('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function getDayFullMonth($date)
  {
      $sql = "SELECT DAY(LAST_DAY('{$date}')) as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return 0;
      }
  }

  public static function getFirstYear($date)
  {
      $sql = "SELECT year('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d . "/1/1";
      } else {
          return null;
      }
  }

  public static function getMonthName($date)
  {
      $sql = "SELECT MONTHNAME('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function getMonthNameS($date)
  {
      $sql = "SELECT DATE_FORMAT('{$date}', '%b-%y')  as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d;
      } else {
          return null;
      }
  }

  public static function getLastYear($date)
  {
      $sql = "SELECT year('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $d[0]->d . "/12/31";
      } else {
          return null;
      }
  }


  public static function getDayNameKH($date)
  {
      $days = array(
          'sunday' => 'អាទិត្យ',
          'monday' => 'ចន្ទ',
          'tuesday' => 'អង្គារ',
          'wednesday' => 'ពុធ',
          'thursday' => 'ព្រហស្បតិ៍',
          'friday' => 'សុក្រ',
          'saturday' => 'សៅរ៍'
      );

      $sql = "SELECT DAYNAME('{$date}') as d";
      $d = DB::select($sql);
      if (count($d) > 0) {
          return $days[strtolower($d[0]->d)];
      } else {
          return null;
      }
  }
  public static function getMonthNameKH($date)
  {
      $days = array(
          'january' => 'មករា',
          'february' => 'កុម្ភះ',
          'march' => 'មីនា',
          'april' => 'មេសា',
          'may' => 'ឧសភា',
          'june' => 'មិថុនា',
          'july' => 'កក្កដា',
          'august' => 'សីហា',
          'september' => 'កញ្ញា',
          'october' => 'តុលា',
          'november' => 'វិច្ឆិកា',
          'december' => 'ធ្នូ'
      );

      $sql = "SELECT MONTHNAME('{$date}') as m";
      $m = DB::select($sql);
      if (count($m) > 0) {
          return $days[strtolower($m[0]->m)];
      } else {
          return null;
      }
  }

  public static function getRequestOT($emp_id, $from_date, $to_date)
  {

    $ot_100 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_normal')
        ->where('status', 1)
        ->where('ot_rate', 1)
        ->sum('total_hour');
    $ot_150 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_normal')
        ->where('status', 1)
        ->where('ot_rate', 1.5)
        ->sum('total_hour');
    $ot_200 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_normal')
        ->where('status', 1)
        ->where('ot_rate', 2)
        ->sum('total_hour');
    $ot_sun_100 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_sunday')
        ->where('status', 1)
        ->where('ot_rate', 1)
        ->sum('total_hour');
    $ot_sun_150 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_sunday')
        ->where('status', 1)
        ->where('ot_rate', 1.5)
        ->sum('total_hour');
    $ot_sun_200 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_sunday')
        ->where('status', 1)
        ->where('ot_rate', 2)
        ->sum('total_hour');
    $ot_hol_100 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_holiday')
        ->where('status', 1)
        ->where('ot_rate', 1)
        ->sum('total_hour');
    $ot_hol_150 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_holiday')
        ->where('status', 1)
        ->where('ot_rate', 1.5)
        ->sum('total_hour');
    $ot_hol_200 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_holiday')
        ->where('status', 1)
        ->where('ot_rate', 2)
        ->sum('total_hour');
    $ot_night_shift_100 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_night_shift')
        ->where('status', 1)
        ->where('ot_rate', 1)
        ->sum('total_hour');
    $ot_night_shift_150 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_night_shift')
        ->where('status', 1)
        ->where('ot_rate', 1.5)
        ->sum('total_hour');
    $ot_night_shift_200 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_night_shift')
        ->where('status', 1)
        ->where('ot_rate', 2)
        ->sum('total_hour');
    $ot_eight_100 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_eight')
        ->where('status', 1)
        ->where('ot_rate', 1)
        ->sum('total_hour');
    $ot_eight_150 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_eight')
        ->where('status', 1)
        ->where('ot_rate', 1.5)
        ->sum('total_hour');
    $ot_eight_200 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_eight')
        ->where('status', 1)
        ->where('ot_rate', 2)
        ->sum('total_hour');
    $ot_over_night_100 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_over_night')
        ->where('status', 1)
        ->where('ot_rate', 1)
        ->sum('total_hour');
    $ot_over_night_150 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_over_night')
        ->where('status', 1)
        ->where('ot_rate', 1.5)
        ->sum('total_hour');
    $ot_over_night_200 = HrOvertimeRequestModel::where('emp_id', $emp_id)
        ->whereDate('date', '>=', $from_date)
        ->whereDate('date', '<=', $to_date)
        ->where('ot_type', '=', 'ot_over_night')
        ->where('status', 1)
        ->where('ot_rate', 2)
        ->sum('total_hour');
    
    return [
        'ot_100' => $ot_100 > 0 ? $ot_100 : 0,
        'ot_150' => $ot_150 > 0 ? $ot_150 : 0,
        'ot_200' => $ot_200 > 0 ? $ot_200 : 0,
        'ot_sun_100' => $ot_sun_100 > 0 ? $ot_sun_100 : 0,
        'ot_sun_150' => $ot_sun_150 > 0 ? $ot_sun_150 : 0,
        'ot_sun_200' => $ot_sun_200 > 0 ? $ot_sun_200 : 0,
        'ot_hol_100' => $ot_hol_100 > 0 ? $ot_hol_100 : 0,
        'ot_hol_150' => $ot_hol_150 > 0 ? $ot_hol_150 : 0,
        'ot_hol_200' => $ot_hol_200 > 0 ? $ot_hol_200 : 0,
        'ot_night_shift_100' => $ot_night_shift_100 > 0 ? $ot_night_shift_100 : 0,
        'ot_night_shift_150' => $ot_night_shift_150 > 0 ? $ot_night_shift_150 : 0,
        'ot_night_shift_200' => $ot_night_shift_200 > 0 ? $ot_night_shift_200 : 0,
        'ot_eight_100' => $ot_eight_100 > 0 ? $ot_eight_100 : 0,
        'ot_eight_150' => $ot_eight_150 > 0 ? $ot_eight_150 : 0,
        'ot_eight_200' => $ot_eight_200 > 0 ? $ot_eight_200 : 0,
        'ot_over_night_100' => $ot_over_night_100 > 0 ? $ot_over_night_100 : 0,
        'ot_over_night_150' => $ot_over_night_150 > 0 ? $ot_over_night_150 : 0,
        'ot_over_night_200' => $ot_over_night_200 > 0 ? $ot_over_night_200 : 0
    ];
  }
  public static function getNormalExRate(){
    $m = HrExchangeRateModel::orderBy('date','DESC')
        ->where('general_rate','>',0)
        ->limit(1)->first();
    return $m != null ?($m->rate>0?$m->rate:4000):4000;
}
    

}