<?php


namespace App\Helpers;

use App\HrEmployeeBenefitModel;
use App\HrOvertimeRequestModel;
use App\User;

class GenSalaryNoFp
{
  public static function getOT($f_date, $t_date, $row)
  {
    $ot_100 = 0; $ot_150 = 0; $ot_200 = 0;
    $ot_sun_100 = 0;  $ot_sun_150 = 0;  $ot_sun_200 = 0;
    $ot_hol_100 = 0;  $ot_hol_150 = 0;  $ot_hol_200 = 0;
    $ot_eight_100 = 0; $ot_eight_150 = 0; $ot_eight_200 = 0;
    $ot_night_shift_100 = 0; $ot_night_shift_150 = 0; $ot_night_shift_200 = 0;
    $ot_over_night_100 = 0; $ot_over_night_150 = 0; $ot_over_night_200 = 0;  $total_ot = 0;
    
    $monthly_rate = $row->getOriginal('basic_salary');
    
    $ot = IDate::getRequestOT($row->id,$f_date,$t_date);
    
    if(is_array($ot))
    {
        $ot_100 = $ot['ot_100'] >0 ? $ot['ot_100']: 0;
        $ot_150 = $ot['ot_150'] >0 ? $ot['ot_150']: 0;
        $ot_200 = $ot['ot_200'] >0 ? $ot['ot_200']:0;

        $ot_sun_100 = $ot['ot_sun_100'] >0 ? $ot['ot_sun_100']:0;
        $ot_sun_150 = $ot['ot_sun_150'] >0 ? $ot['ot_sun_150']:0;
        $ot_sun_200 = $ot['ot_sun_200'] >0 ? $ot['ot_sun_200']:0;

        $ot_hol_100 = $ot['ot_hol_100'] >0 ? $ot['ot_hol_100']:0;
        $ot_hol_150 = $ot['ot_hol_150'] >0 ? $ot['ot_hol_150']:0;
        $ot_hol_200 = $ot['ot_hol_200'] >0 ? $ot['ot_hol_200']:0;

        $ot_night_shift_100 = $ot['ot_night_shift_100'] >0 ? $ot['ot_night_shift_100']: 0;
        $ot_night_shift_150 = $ot['ot_night_shift_150'] >0 ? $ot['ot_night_shift_150']: 0;
        $ot_night_shift_200 = $ot['ot_night_shift_200'] >0 ? $ot['ot_night_shift_200']:0;

        $ot_eight_100 = $ot['ot_eight_100'] >0 ? $ot['ot_eight_100']:0;
        $ot_eight_150 = $ot['ot_eight_150'] >0 ? $ot['ot_eight_150']:0;
        $ot_eight_200 = $ot['ot_eight_200'] >0 ? $ot['ot_eight_200']:0;

        $ot_over_night_100 = $ot['ot_over_night_100'] >0 ? $ot['ot_over_night_100']:0;
        $ot_over_night_150 = $ot['ot_over_night_150'] >0 ? $ot['ot_over_night_150']:0;
        $ot_over_night_200 = $ot['ot_over_night_200'] >0 ? $ot['ot_over_night_200']:0;

    
    }

    if($monthly_rate >0) {
        $monthly_rate_ot_100 = round((($monthly_rate / 26) / 8) * 1, 2);
        $monthly_rate_ot_150 = round((($monthly_rate / 26) / 8) * 1.5, 2);
        $monthly_rate_ot_200 = round((($monthly_rate / 26) / 8) * 2, 2);

        $ot_100 = round($ot_100 * $monthly_rate_ot_100, 2);
        $ot_150 = round($ot_150 * $monthly_rate_ot_150, 2);
        $ot_200 = round($ot_200 * $monthly_rate_ot_200, 2);
        $ot_100 = $ot_100 > 0 ? $ot_100 : 0;
        $ot_150 = $ot_150 > 0 ? $ot_150 : 0;
        $ot_200 = $ot_200 > 0 ? $ot_200 : 0;

        $ot_sun_100 = round($ot_sun_100 * $monthly_rate_ot_100, 2);
        $ot_sun_150 = round($ot_sun_150 * $monthly_rate_ot_150, 2);
        $ot_sun_200 = round($ot_sun_200 * $monthly_rate_ot_200, 2);
        $ot_sun_100 = $ot_sun_100 > 0 ? $ot_sun_100 : 0;
        $ot_sun_150 = $ot_sun_150 > 0 ? $ot_sun_150 : 0;
        $ot_sun_200 = $ot_sun_200 > 0 ? $ot_sun_200 : 0;

        $ot_hol_100 = round($ot_hol_100 * $monthly_rate_ot_100, 2);
        $ot_hol_150 = round($ot_hol_150 * $monthly_rate_ot_150, 2);
        $ot_hol_200 = round($ot_hol_200 * $monthly_rate_ot_200, 2);
        $ot_hol_100 = $ot_hol_100 > 0 ? $ot_hol_100 : 0;
        $ot_hol_150 = $ot_hol_150 > 0 ? $ot_hol_150 : 0;
        $ot_hol_200 = $ot_hol_200 > 0 ? $ot_hol_200 : 0;

        $ot_eight_100 = round($ot_eight_100 * $monthly_rate_ot_100, 2);
        $ot_eight_150 = round($ot_eight_150 * $monthly_rate_ot_150, 2);
        $ot_eight_200 = round($ot_eight_200 * $monthly_rate_ot_200, 2);
        $ot_eight_100 = $ot_eight_100 > 0 ? $ot_eight_100 : 0;
        $ot_eight_150 = $ot_eight_150 > 0 ? $ot_eight_150 : 0;
        $ot_eight_200 = $ot_eight_200 > 0 ? $ot_eight_200 : 0;

        $ot_night_shift_100 = round($ot_night_shift_100 * $monthly_rate_ot_100, 2);
        $ot_night_shift_150 = round($ot_night_shift_150 * $monthly_rate_ot_150, 2);
        $ot_night_shift_200 = round($ot_night_shift_200 * $monthly_rate_ot_200, 2);
        $ot_night_shift_100 = $ot_night_shift_100 > 0 ? $ot_night_shift_100 : 0;
        $ot_night_shift_150 = $ot_night_shift_150 > 0 ? $ot_night_shift_150 : 0;
        $ot_night_shift_200 = $ot_night_shift_200 > 0 ? $ot_night_shift_200 : 0;

        $ot_over_night_100 = round($ot_over_night_100 * $monthly_rate_ot_100, 2);
        $ot_over_night_150 = round($ot_over_night_150 * $monthly_rate_ot_150, 2);
        $ot_over_night_200 = round($ot_over_night_200 * $monthly_rate_ot_200, 2);
        $ot_over_night_100 = $ot_over_night_100 > 0 ? $ot_over_night_100 : 0;
        $ot_over_night_150 = $ot_over_night_150 > 0 ? $ot_over_night_150 : 0;
        $ot_over_night_200 = $ot_over_night_200 > 0 ? $ot_over_night_200 : 0;


        $total_ot = round($ot_100 + $ot_150 + $ot_200 +
            $ot_sun_100 + $ot_sun_150 + $ot_sun_200 +
            $ot_hol_100 + $ot_hol_150 + $ot_hol_200 +
            $ot_eight_100 + $ot_eight_150 + $ot_eight_200 +
            $ot_night_shift_100 + $ot_night_shift_150 + $ot_night_shift_200 + 
            $ot_over_night_100 + $ot_over_night_150 + $ot_over_night_200, 2);
        $total_ot = $total_ot > 0 ? $total_ot : 0;
    }
    return  [
        'total_ot' => $total_ot,
        'ot_hol_200_amt' => $ot_hol_200,
        'ot_hol_150_amt' => $ot_hol_150,
        'ot_hol_100_amt' => $ot_hol_100,
        'ot_sun_200_amt' => $ot_sun_200,
        'ot_sun_150_amt' => $ot_sun_150,
        'ot_sun_100_amt' => $ot_sun_100,
        'ot_200_amt' => $ot_200,
        'ot_150_amt' => $ot_150,
        'ot_100_amt' => $ot_100,
        'ot_eight_100' => $ot_eight_100,
        'ot_eight_150' => $ot_eight_150,
        'ot_eight_200' => $ot_eight_200,
        'ot_night_shift_100' => $ot_night_shift_100,
        'ot_night_shift_150' => $ot_night_shift_150,
        'ot_night_shift_200' => $ot_night_shift_200,
        'ot_over_night_100' => $ot_over_night_100,
        'ot_over_night_150' => $ot_over_night_150,
        'ot_over_night_200' => $ot_over_night_200
    ];

  }
  
  public static function getBenefit($emp_id)
  {
    $emp_benefit = 0;
    $benefit = HrEmployeeBenefitModel::where('emp_id', $emp_id)->get();          
      foreach($benefit as $ben)
      {
          $emp_benefit += $ben->amount;  
          $emp_benefit = isset($emp_benefit) ? $emp_benefit: 0;
      }
      return [
        'emp_benefit' => $emp_benefit
      ];
  }
  
  public static function getGrossPay($row, $total_ot, $emp_benefit, $basic_salary)
  {

      $position_allowance = $row->position_allowance?$row->position_allowance: 0; 
      $meal_transport_allowance = $row->meal_transport_allowance?$row->meal_transport_allowance:0;
      $other_allowance = $row->other_allowance?$row->other_allowance:0;
      $increment = $row->increment?$row->increment:0;


      $gross_pay = $total_ot + $emp_benefit + $basic_salary 
                  + $position_allowance + $meal_transport_allowance + $other_allowance
                  + $increment;

      $gross_pay = $gross_pay > 0 ? $gross_pay : 0;

      return ['gross_pay' => $gross_pay];
  }
  
  public static function getIncomeTax($row, $gross_pay)
  {

    $fringe_tax = 0;
    $exchange_khmer = IDate::getNormalExRate();
    $spouse_child= self::getSpouseChild($row->id);
    $taxable_salary_khmer = round(($gross_pay - $spouse_child) * $exchange_khmer,2);

    $taxable_salary = $gross_pay - $spouse_child;
    $taxable_salary = $taxable_salary>0?$taxable_salary:0;

    $income_tax_rate = self::getIncomeTaxRate($taxable_salary);
    $income_tax_rate = $income_tax_rate>0?$income_tax_rate:0;

    $income_tax_deduction = self::getIncomeTaxDeduction($taxable_salary);
    $income_tax_deduction = $income_tax_deduction>0?$income_tax_deduction:0;


    $salary_tax = self::calculateTax($taxable_salary);
    $salary_tax = $salary_tax>0?$salary_tax:0;
    
    $income_tax = $salary_tax + $fringe_tax ;
    $income_tax = $income_tax >0?$income_tax:0;

    return [
        'taxable_salary' => $taxable_salary,
        'income_tax' => $income_tax,
        'income_tax_rate' => $income_tax_rate,
        'exchange_khmer' => $exchange_khmer,
        'income_tax_deduction' => $income_tax_deduction,
        'taxable_salary_khmer' => $taxable_salary_khmer,
        'salary_tax' => $salary_tax,
        'fringe_tax' => $fringe_tax,
        'gross_pay' => $gross_pay
    ];

  }
  
  public static function getIncomeTaxRate($salary,$exchange_rate=4000)
  {
    $exchange_rate = IDate::getNormalExRate();

    $sal_KH = $salary * $exchange_rate ;
    $re = 0;
    if($sal_KH <=1200000){
        $re = 0;
    }elseif ($sal_KH >1200000 && $sal_KH <= 2000000){
        $re = 5 ;
    }elseif ($sal_KH >2000000 && $sal_KH <= 8500000){
        $re = 10;
    }elseif ($sal_KH >8500000 && $sal_KH <= 12500000) {
        $re = 15;
    }else{
        $re = 20;
    }
    return $re;
  }

  public static function getIncomeTaxDeduction($salary,$exchange_rate=4000)
  {
    $exchange_rate = IDate::getNormalExRate();

    $sal_KH = $salary * $exchange_rate ;
    $re = 0;
    if($sal_KH <=1200000){
        $re = 0;
    }elseif ($sal_KH >1200000 && $sal_KH <= 2000000){
        $re = 60000 ;
    }elseif ($sal_KH >2000000 && $sal_KH <= 8500000){
        $re = 160000;
    }elseif ($sal_KH >8500000 && $sal_KH <= 12500000) {
        $re = 585000;
    }else{
        $re = 1210000;
    }
    return $re;
  }

  public static function calculateTax($salary,$exchange_rate=4000)
  {

    $exchange_rate = IDate::getNormalExRate();
    $sal_KH = $salary * $exchange_rate ;
    $re = 0;
    if($sal_KH <=1200000){
        $re = 0;
    }elseif ($sal_KH >1200000 && $sal_KH <= 2000000){
        $re = $sal_KH * 0.05 - 60000 ;
    }elseif ($sal_KH >2000000 && $sal_KH <= 8500000){
        $re = $sal_KH* 0.1 - 160000;
    }elseif ($sal_KH >8500000 && $sal_KH <= 12500000){
        $re = $sal_KH* 0.15 - 585000;
    }else{
        $re = $sal_KH* 0.2 - 1210000;
    }
    return number_format($re / $exchange_rate,2);
  }

  public static function getSpouseChild($emp_id)
  {
    
    $s = 0;
    $c = 0;
    $total_amt = 0;
    $total = 0;
    $emp = User::where('id', $emp_id)->first();
    $exchange_rate = IDate::getNormalExRate();

    if ($emp != null) {
        $s = isset($emp->spouse) > 0 ? $emp->spouse : 0;
        $c = isset($emp->child) > 0 ? $emp->child : 0;
    }
    $total = $c + $s;
    $total = $total > 0 ? $total : 0;
    $total_amt = ($total * 150000) / $exchange_rate;
    return $total_amt > 0 ? $total_amt : 0;

  }
  
  
}