<?php

namespace App\Exports;

use App\InvoicePaymentModel;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ReturnExport implements FromView
{
    private $request;
    public function __construct($request)
    {
        $this->request = $request;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function view(): View
    {
        $request = $this->request;
        $from_date      =   $request->from_date ? date('Y-m-d',strtotime($request->from_date)) : date("Y-m-d",strtotime("-1 week"));
        $to_date        =   $request->to_date ? date('Y-m-d',strtotime($request->to_date)) : date('Y-m-d');
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:[] ;

        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;

        $data = DB::table(DB::raw("(
                SELECT
                exs.id,exs.box_code,exs.export_date,exs.status,exs.type_of_stock,exs.id as export_id,
                exs.date_delivery,exs.total_product_symbol,exs.delivery_fee_symbol,
                exs.delivery_fee,exs.shop_name,exs.customer_receive,exs.location_name,
                exs.delivery_fee_rate,exs.delivery_pay_or_paid,exs.other_services_fee,
                exs.total_product_rate,exs.total_product_status,exs.delivery_status,
                exs.delivery_option,exs.taxi_status,exs.taxi_shop_fee,exs.taxi_cust_fee,
                exs.taxi_number,exs.extra_fee,exs.extra_fee_type,exs.driver_note,exs.merchant_id,exs.rate,
                exs.taxi_fee_symbol,exs.updated_at,exs.description,exs.total_product as total_price,
                exs.is_return_to_shop,
                nso007_discount.discount_type,nso007_discount.discount,items.*,
                    CASE
                        WHEN
                            delivery_option = 'No'
                        THEN
                            CONCAT(delivery_option,' (ភ្នំពេញ) ')
                        ELSE
                            CONCAT(delivery_option,' (ខេត្ត) ')
                        END
                    AS delivery_option_text
                from
                    nso007_export_stock as exs
                LEFT JOIN (
                    SELECT
                        dod.export_id as item_id,dod.delivery_order_id,
                        do.driver_name,do.driver_id,do.time_policy,do.delivery_date,
                        CASE WHEN do.time_policy = 1 THEN '(ព្រឹក)' ELSE '(ល្ងាច)' END as time_text,
                        dod.status_paid,dod.invoice_payment_id,dod.total_riel,dod.total_dollar,dod.amount_pay_to,dod.pay_to,
                        dod.reason
                    FROM
                        nso007_delivery_order_detail as dod
                    INNER JOIN
                        nso007_delivery_order  as do
                    ON
                        do.id = dod.delivery_order_id
                )
                as items
                ON
                    items.item_id = exs.id
                LEFT JOIN
                    nso007_discount
                ON
                    nso007_discount.id = exs.discount_id
                WHERE
                    items.status_paid IS NULL

            ) as nso007_export_stock"))
            ->when(request('status'),function($query) use ($status){
                if($status == 7){
                    $query->whereRaw('CASE WHEN nso007_export_stock.is_return_to_shop = 1 THEN nso007_export_stock.is_return_to_shop = 1 ELSE nso007_export_stock.status = 7 END');
                }else if ($status == 8){
                    $query->where('nso007_export_stock.status',7);
                    $query->where('nso007_export_stock.is_return_to_shop',0);
                }else{
                    $query->where('nso007_export_stock.status',$status);
                }
            })
            ->when($merchant,function($query) use ($merchant){
                $query->where('nso007_export_stock.merchant_id',$merchant);
            })
            ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                if($pro_or_city != null){
                    $operator = "!=";
                    if($pro_or_city != "No"){
                        $operator = "=";
                    }
                    $query->where('nso007_export_stock.delivery_option',$operator,"No");
                }
            })
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date,$status){
                if(!empty($from_date) && !empty($to_date) && $status == 1){
                    $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                }
                if(!empty($from_date) && !empty($to_date) && $status != 1 && $status != null){
                    $query->whereBetween('nso007_export_stock.delivery_date',[$from_date,$to_date]);
                }
            })
            ->orderBy('nso007_export_stock.updated_at', 'desc')->get();

        $merchants=DB::table('nso007_export_stock')
            ->join('users', 'users.id', 'nso007_export_stock.merchant_id')
            ->select('users.shop_name')->where('nso007_export_stock.merchant_id', $merchant)
            ->first();
        return view('administrator.export-stock.export-excel',compact('data','merchants','from_date','to_date'));
    }
}
