<?php

namespace App\Exports;

use App\InvoicePaymentModel;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PaymentExport implements FromView
{
    private $request;
    public function __construct($request)
    {
        $this->request = $request;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function view(): View
    {
        $request = $this->request;
        $shop_id = $request->shop_id??'';
        $status = $request->status;
        $verify = $request->verify;
        $from_date      =   empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        =   empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $per_page = $request->per_page??100;
        $data = InvoicePaymentModel::with(['create_by:id,name','shop:id,shop_name,bank_account,bank_account_kh,bank_name_kh,name as account_name'])
                        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.invoice_payment_id','nso007_invoice_payment.id')
                        ->select('nso007_invoice_payment.*')
                        ->when($shop_id,function($q) use($shop_id){
                            $q->where('nso007_invoice_payment.shop_id',$shop_id);
                        })
                        ->when($from_date&&$to_date,function($q) use($from_date,$to_date){
                            $q->whereBetween('nso007_invoice_payment.date',[$from_date,$to_date]);
                        })
                        ->when($verify, function ($q, $verify) {
                            if ($verify == 'verify') {
                                $q->whereNotNull('nso007_invoice_payment.verify_by');
                            } else {
                                $q->whereNull('nso007_invoice_payment.verify_by');
                            }
                        })
                        ->where(function ($query) use ($status) {
                            if ($status  == 'pay') {
                                $query->whereNull('nso007_invoice_payment.status');
                            } else {
                                $query->where('nso007_invoice_payment.status', 'paid');
                            }
                        })
                        ->where('nso007_delivery_order_detail.status', '!=', 7)
                        ->groupBy('nso007_invoice_payment.id')
                        ->orderBy('nso007_invoice_payment.id', 'desc')
                        ->take($per_page);
        return view('administrator.clear_inovice.export-excel',compact('data'));
    }
}
