<?php

namespace App\Exports;

use App\DeliveryOrderModel;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;

class DriverBoxExport implements FromView
{
    private $from_date,$to_date,$driver_id;
    public function __construct($from_date,$to_date,$driver_id)
    {
        $this->from_date = $from_date;
        $this->to_date = $to_date;
        $this->driver_id = $driver_id;
    }
    public function view(): View
    {
            $from_date = $this->from_date ? date('Y-m-d', strtotime($this->from_date)) : '';
            $to_date = $this->to_date ? date('Y-m-d', strtotime($this->to_date)) : '';
            $driver_id = $this->driver_id;
            $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
            ->join("users","users.id","nso007_delivery_order.driver_id")
            ->selectRaw(
                '
                    nso007_delivery_order.*,
                    COUNT(nso007_delivery_order_detail.export_id) as total_box,
                    users.name as driver_name
                '                    
            )
            ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
                    $q->whereBetween(DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
            })
            ->where('nso007_delivery_order_detail.status',3)
            ->when($driver_id,function($q) use($driver_id){
                $q->where('nso007_delivery_order.driver_id',$driver_id);
            })
            ->groupBy([DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date, '%Y %m')"), 'driver_id'])
            ->orderBy("nso007_delivery_order.delivery_date","DESC");
            return view('administrator.driver-report.export', compact('data','from_date','to_date'));
    }
}
