<?php
	namespace App\Classes;
	use DB;
	use App\ExternalClientPaymentModel;
	use App\SaleStockModel;
	use App\CommissionAdminModel;
	use App\CommissionAdminReportModel;

	class Commission
	{
		// Commission external project
		public function set_commission_external_client_payment($item_code, $payment_amount)
		{
			$payment 		= $payment_amount;
            $get_commission = 0;

			$sale_id 		= $this->get_sale_id_by_itemcode($item_code);
			$commission_sale= $this->get_commission_by_saleid($sale_id);
			$sale_record 	= $this->get_sale_stock_record_by_id($sale_id);

			$sale_amount 	= $sale_record->sale_amount;
			$sale_payment 	= $sale_record->sale_payment;

			$admin_condition= $this->get_external_item_condition_in_salestock($sale_id);

			$condition		= ($sale_amount * $admin_condition / 100);
            $commission 	= ($sale_amount * $commission_sale / 100);
			$paid_amount	= $sale_payment;

            if ($paid_amount < $condition) {
                if (($paid_amount + $payment) <= $condition) {
                    $payment_commission	= $payment / $condition;
                    $get_commission 	= $commission * $payment_commission;
                } elseif (($paid_amount + $payment) > $condition) {
                    $payment_commission	= ($condition - $paid_amount) / $condition;
                    $get_commission 	= $commission * $payment_commission;
                }
            }

            if (!empty($get_commission)) {
            	$this->increment_admin_commission_receive($sale_id, $get_commission);
            }
            $this->increment_sale_payment_client_external($sale_id, $payment);
		}
		public function get_sale_id_by_itemcode($item_code)
		{
			$data = DB::select("
				SELECT detail.saledetail_saleid AS sale_id FROM nso007_sale_detail_stock AS detail
				INNER JOIN nso007_item_stock AS item ON detail.saledetail_itemid = item.id
				WHERE item.item_name = '$item_code'
			");
			return $data[0]->sale_id;
		}
		public function get_max_no_by_saleid($sale_id)
		{
			$max_id = ExternalClientPaymentModel::where('sale_id', $sale_id)
	        ->max('payment_no');
	        return $max_id;
		}
		public function get_commission_by_saleid($id)
		{
			$data = CommissionAdminModel::where('sale_id', $id)->select('commission')->get();
			return $data[0]->commission;
		}
		public function get_itemid_by_itemcode($item_code)
		{
			$data = DB::select("SELECT id FROM nso007_item_stock WHERE item_name = '$item_code'");
        	$id = $data[0]->id;
			return $id;
		}
		public function get_sale_stock_record_by_id($id)
		{
			$data = SaleStockModel::select(
	            'sale_amount',
	            'sale_discount',
	            'sale_receive',
	            'sale_remain',
	            'sale_payment'
	        )->find($id);
	        return $data;
		}
		public function increment_admin_commission_receive($id, $commission)
		{
			CommissionAdminModel::where('sale_id', $id)->increment('commission_received', $commission);
			$commission_data = CommissionAdminModel::where('sale_id', $id)->select('id')->get();
        	$commission_id = $commission_data[0]->id;
	        $data = array(
	            'commission_id' 	=> $commission_id,
	            'commission_amount' => $commission
	        );
			CommissionAdminReportModel::insert($data);
		}
		public function increment_sale_payment_client_external($sale_id, $payment)
		{
			SaleStockModel::where('id', $sale_id)->increment('sale_payment', $payment);
		}
		public function get_external_item_commission_in_salestock($sale_stock_last_id)
		{
			$data = SaleStockModel::find($sale_stock_last_id);
			return $data->admin_commission;
		}
		public function get_external_item_condition_in_salestock($sale_stock_last_id)
		{
			$data = SaleStockModel::find($sale_stock_last_id);
			return $data->admin_commission_condition;
		}
		public function get_item_commission_in_salestock($sale_stock_last_id)
		{
			$data = SaleStockModel::find($sale_stock_last_id);
			return $data->agency_commission;
		}
		public function get_item_condition_in_salestock($sale_stock_last_id)
		{
			$data = SaleStockModel::find($sale_stock_last_id);
			return $data->agency_commission_condition;
		}
		public function get_item_code_by_saleid($sale_id)
		{
			$data = DB::select("
				SELECT
				item.item_name
				FROM nso007_sale_detail_stock AS detail
				INNER JOIN nso007_item_stock AS item ON detail.saledetail_itemid = item.id
				WHERE detail.saledetail_saleid = $sale_id
			");
			return $data[0]->item_name;
		}
	}
?>