<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Cash Flow Type</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
              <li class="breadcrumb-item active">Accounting</li>
              <li class="breadcrumb-item active">Cash Flow Type</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group row m-2">
                    <div class="col-xs-12 col-sm-3 col-md-3">
                         <strong>Start Date</strong> <?php echo Form::text('start_date', null, array('placeholder' => 'Start Date','class' => 'form-control date_picker start_date','autocomplete' => 'off')); ?>

                    </div>
                    <div class="col-xs-12 col-sm-3 col-md-3">
                        <div class="form-group">
                            <strong>End Date</strong> <?php echo Form::text('end_date', null, array('placeholder' => 'End Date','class' => 'form-control date_picker end_date','autocomplete' => 'off')); ?>

                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-4 col-md-4" style="margin-top: 20px;">
                        <button type="button" class="btn btn-lg btn-primary search" onclick="searching()"><span class="fa fa-search"></span></button>&nbsp
                       <!--  <button type="submit" class="btn-lg btn-primary search" style="padding-top: 7px;padding-bottom: 7px;"><span class="fa fa-print"></span></button> -->
                    </div>
                </div>
            </form>
            <!-- /.card-header -->
            <div class="card-body">
              <div class="box-body table-responsive" id="Cash_Flow_Table"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
    $(document).ready(function(){
        var route = "<?php echo e(route('accounting-report.cash-flow-list')); ?>";
        $.ajax({
            method: "get",
            dataType: "text",
            url: route,
            data:{
                '_token':"<?php echo e(csrf_token()); ?>"
            },
            success:function(data)
            {
                $('#Cash_Flow_Table').append(data);
            }
        });
    });
    function searching(){
        var start   = $('.start_date').val();
        var end     = $('.end_date').val();
        var route   = "<?php echo e(route('accounting-report.cash-flow-list')); ?>";
        if(start != "" || end != ""){
            $.ajax({
                dataType: "text",
                method: 'POST',
                url: route,
                data:{
                    '_token':"<?php echo e(csrf_token()); ?>",
                    start_date:start,
                    end_date:end,
                },
                success:function(data){
                    $('#Cash_Flow_Table').empty().append(data);
                }
            });
        }else{
            alert("Please Select Start Date And End Date");
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/accounting/reports/cash-flow.blade.php ENDPATH**/ ?>