<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Ledger</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
              <li class="breadcrumb-item active">Accounting</li>
              <li class="breadcrumb-item active">Ledger</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <form action="<?php echo e(route('print.ledger')); ?>" method="POST" id="form-print-ledger">
                <?php echo csrf_field(); ?>
                <div class="title-bar p-4">
                    <button type="button" class="btn btn-tab btn-ms btn-warning float-right" style="margin-left:5px!important;" id="btn-print-ledger" title="Print"><i class="fa fa-print"></i></button>
                    <span class="btn-toggle btn btn-primary btn-ms float-right"><i class="fa fa-search"></i></span>
                </div>
                <div class="toggle-div m-4" style="display: none">
                    <div class="form-group row">
                        <div class="col-sm-3 col-xs-12">
                            <label for="">Reference Number</label>
                            <?php if(isset($acc_code)): ?>
                                <?php echo Form::select('acc_chart', $account_chart, $acc_code, ['class' => 'form-control select2 acc_type','required','id'=>'acc_code']); ?>

                            <?php else: ?>
                                <?php echo Form::select('acc_chart', $account_chart, null, ['class' => 'form-control select2 acc_type','required','id'=>'acc_code']); ?>

                            <?php endif; ?>
                        </div>
                        <div class="col-sm-3 col-xs-12">
                            <label for="">Start Date</label>
                            <?php
                            $from = date('d-m-Y', strtotime('first day of this month'));
                            $to = date('d-m-Y', strtotime('last day of this month'));
                            ?>
                            <input type="text" name="start_date" class="form-control date_picker start_date" value="<?php echo e($from); ?>">
                        </div>
                        <div class="col-sm-3 col-xs-12">
                            <label for="">End Date</label>
                            <input type="text" name="end_date" class="form-control date_picker end_date" value="<?php echo e($to); ?>">
                        </div>
                        <div class="col-sm-3 col-xs-12">
                            <button type="button" class="btn btn-warning" style="margin-top: 30px;" onclick="search_ledger()"> Search <span class="fa fa-search"></span></button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="table_journal" class="table table-striped table-bordered table table-condensed table-hover">
                <thead>
                <tr>
                    <th>No</th>
                    <th>Project</th>
                    <th>Type</th>
                    <th>Date</th>
                    <th>Reference Number</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Created By</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Amount</th>
                </tr>
                </thead>
                <tbody id="tbody"></tbody>
                <tfoot id="tfoot">
                <tr>

                </tr>
                </tfoot>
            </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
                <h3 class="modal-title text-danger">Warning...!</h3>
            </div>
            <br />
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-10">
                        <h4>Receivable amount must be smaller than or equal available amount.</h4>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
    $(document).on('click', '.btn-toggle', function() {
        $('.toggle-div').toggle('fast');
    });
    // $(document).ready(function(){
    //     $("#table_journal").DataTable();
    // });
    $(document).ready(function() {
        var acc_code = $('#acc_code').find(":selected").val();
        var end_date = $('.end_date').val();
        var start_date = $('.start_date').val();
        if (acc_code != "" && end_date != "" && start_date != "") {
            var tr = "";
            var total_debit = 0;
            var total_credit = 0;
            $('#tbody').empty();
            $('#tfoot').empty();
            $.ajax({
                url: "<?php echo e(route('get-accounting-report.ledger')); ?>",
                method: "POST",
                dataType: "text",
                data: {
                    acc_code: acc_code,
                    start_date: start_date,
                    end_date: end_date,
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(data) {
                    $('#tbody').append(data);
                }
            });
        } else {
            $.ajax({
                url: "<?php echo e(route('get-accounting-report.ledger')); ?>",
                method: "get",
                dataType: "text",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(data) {
                    $('#tbody').append(data);
                }
            });
        }

    });
    $(document).on("click","#btn-print-ledger",function(e){
        if($("#acc_code").val()==""){
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Reference Number is empty !',
                footer: 'Please Select Reference Number'
            })
        }
        else{
            $("#form-print-ledger").submit();
        }
    });

    function search_ledger() {

        var acc_code        = $('#acc_code').find(":selected").val();
        var end_date        = $('.end_date').val();
        var start_date      = $('.start_date').val();
        var tr              = "";
        var total_debit     = 0;
        var total_credit    = 0;
        $('#tbody').empty();
        $('#tfoot').empty();
        $.ajax({
            url: "<?php echo e(route('get-accounting-report.ledger')); ?>",
            method: "POST",
            dataType: "text",
            data: {
                acc_code: acc_code,
                start_date: start_date,
                end_date: end_date,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function(data) {
                $('#tbody').append(data);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/accounting/reports/ledger.blade.php ENDPATH**/ ?>