<?php $__env->startSection("content"); ?>
<?php echo $__env->make('block.create',compact('project'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('block.edit',compact('project'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.List")); ?> <?php echo e(__("application.Block")); ?> </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Manage POS Stock")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Block")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Zone-Create')): ?>
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="#block-add" data-toggle="modal"> <?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <?php endif; ?>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-block" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Project")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Description")); ?></th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/js/location.js')); ?>"></script>
<script>
    function block_save(){
      $('.main-spinner').show();
      var id=$("#block-id").val();
      var name=$("#block-name").val();
      var des=$("#block-des").val();
      var project=$("#block-project").val();
      var route="<?php echo e(route('block.update',':id')); ?>";
      route=route.replace(":id",id);
      $.ajax({
        url:route,
        type:"PATCH",
        dataType:"JSON",
        data:{
          "_token":"<?php echo e(csrf_token()); ?>",
          "name":name,
          "description":des,
          'project':project
        },
        success:function(data){
          $('.main-spinner').hide();
          window.location.reload();
          toastr.success("Update successfully !");
        },
        error:function(){
          toastr.error("Error with your input.");
        }
      });
    }
    function edit_block(obj){
      if($(obj).closest('tr').hasClass("child")){
        var id=$(obj).closest('tr').prev().attr('id');
      }else{
        var id=$(obj).closest('tr').attr('id');
      }
      $('.main-spinner').show();
      $.ajax({
        url:"<?php echo e(route('block.get_block')); ?>",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"<?php echo e(csrf_token()); ?>",
          'id':id
        },
        success:function(data){
          $('.main-spinner').hide();
          $("#edit-block").modal("show");
          $("#block-id").val(data['block'].id);
          $("#block-name").val(data['block'].name);
          $("#block-des").val(data['block'].description);
          var opt="";
          $.each(data['project'],function(index,val){
            if(val.id==data['block'].project_id){
              opt+=`<option value="${val.id}" selected>${val.name}</option>`;
            }else{
              opt+=`<option value="${val.id}">${val.name}</option>`;
            }
            
          });
          $("#block-project").empty();
          $("#block-project").append(opt);
        },
        error:function(data){
          console.log("Eror");
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-block').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            "scrollY": screen.height,
            "scrollX": true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "<?php echo e(route('block.get_block')); ?>",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {data: 'name','name':'nso007_block.name'},
                {data: 'project_name'},
                {data: 'description','name':'nso007_block.description'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/block/index.blade.php ENDPATH**/ ?>