<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php echo $__env->make('hr.generate-salary.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__('administrator.generate-salary')); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.generate-salary')); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Salary Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-generate-salary.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatables" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.employee')); ?></th>
                                        <th><?php echo e(__('administrator.month')); ?></th>
                                        <th><?php echo e(__('administrator.year')); ?></th>
                                        <th><?php echo e(__('administrator.basic_salary')); ?></th>
                                        <th><?php echo e(__('administrator.advance_salary')); ?></th>
                                        <th><?php echo e(__('administrator.take_leave')); ?></th>
                                        <th><?php echo e(__('administrator.benefit')); ?></th>
                                        <th><?php echo e(__('administrator.total_ot')); ?></th>
                                        <th><?php echo e(__('administrator.net_pay_kh')); ?></th>
                                        <th><?php echo e(__('administrator.net_pay')); ?></th>
                                        <th><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn-delete-gen', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatables').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "<?php echo e(route('datatable.hr-gen-salary')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'emp_id'},
                        {data: 'f_month'},
                        {data: 'f_year'},
                        {data: 'basic_salary'},
                        {data: 'advance_salary'},
                        {data: 'take_leave'},
                        {data: 'benefit'},
                        {data: 'total_ot'},
                        {data: 'net_pay_kh'},
                        {data: 'net_pay'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/generate-salary/index.blade.php ENDPATH**/ ?>