<?php $__env->startSection("content"); ?>
<?php echo $__env->make('agencies.show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('agencies.confim_inactive', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.List")); ?>​ <?php echo e(__("application.Agency")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Manage Agency")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Show")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.Agency")); ?>​ <?php echo e(__("application.Active")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Agency-Create')): ?>
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="<?php echo e(route('agency.create')); ?>"> <?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <?php endif; ?>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-agency" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  
                  <th><?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Phone")); ?></th>
                  <th><?php echo e(__("application.ID Card")); ?></th>
                  <th><?php echo e(__("application.Address")); ?></th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<div class="modal fade" id="delete-agency">
  <div class="modal-dialog modal-md">
    <div class="modal-content bg-danger">
      <div class="modal-header">
        <h4 class="modal-title">Delete Deposit</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h4>Are you sure?</h4>
        <input type="hidden" id="deposit-delete-id" name="deposit">
      </div>
      <div class="modal-footer justify-content-between">
        <div>&nbsp;</div>
        <input type="hidden" id="id-submit">
        <button type="button" class="btn btn-success btn-md" onclick="submit_delete()">OK</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
    function Delete(agency_id){
      $("#delete-agency").modal('show');
      $("#id-submit").val(agency_id);
    }
    function submit_delete(){
      var id = $("#id-submit").val();
      var route = "<?php echo e(route('agency.destroy',':id')); ?>";
      route = route.replace(":id",id);
      $.ajax({
        dateType:"JSON",
        type: "DELETE",
        url: route,
        success:function(data){
          alert("OK");
        }
      });
    }
    function set_inactive(id){
      $("#ag-id").val(id);
    }
    function processInactive(){
      var id = $("#ag-id").val();
      $('.main-spinner').show();
      $.ajax({
        type:"POST",
        dataType:"JSON",
        url:"<?php echo e(route('agencies.set_to_inactive')); ?>",
        data:{
          "_token":"<?php echo e(csrf_token()); ?>",
          "id":id
        },
        success:function(data){
          window.location.reload();
          toastr.success("Agency change to inactive successfully !");
          $('.main-spinner').hide();
        }
      });
    }
    function show_info(id){
      $('.main-spinner').show();
      var route="<?php echo e(route('agency.show',':id')); ?>";
      route=route.replace(":id",id);
      $.ajax({
        url:route,
        type:"GET",
        dataType:"JSON",
        success:function(data){
          $('.main-spinner').hide();
          $(".show-name").show();
          $("#ag-name").empty();
          $("#ag-name").append(data.name);
          if(data.name==null){
            $(".show-name").hide();
          }
          $(".show-gender").show();
          $("#ag-gender").empty();
          $("#ag-gender").append(data.gender);
          if(data.gender==null){
            $(".show-gender").hide();
          }
          $(".show-phone").show();
          $("#ag-phone").empty();
          $("#ag-phone").append(data.phone);
          if(data.phone==null){
            (".show-phone").hide();
          }
          $(".show-des").show();
          $("#ag-dob").empty();
          $("#ag-dob").append(data.date_of_birth);
          if(data.date_of_birth==null){
            $(".show-des").hide();
          }
          $(".show-nation").show();
          $("#ag-nation").empty();
          $("#ag-nation").append(data.nationality);
          if(data.nationality==null){
            $(".show-nation").hide();
          }
          $(".show-idcard").show();
          $("#ag-idcard").empty();
          $("#ag-idcard").append(data.id_card_number);
          if(data.id_card_number==null){
            $(".show-idcard").hide();
          }
          $(".show-idcard-date-valid").show();
          $("#ag-idcard-date-valid").empty();
          $("#ag-idcard-date-valid").append(data.id_card_date_valid);
          if(data.id_card_date_valid==null){
            $(".show-idcard-date-valid").hide();
          }
          $(".show-email").show();
          $("#ag-mail").empty();
          $("#ag-mail").append(data.email);
          if(data.email==null){
            $(".show-email").hide();
          }
          $("#ag-address").empty();
          var address="";
          if(data.house_number!=null) address+=data.house_number;
          if(data.street_number!=null) address+=" "+data.street_number;
          if(data.get_village['village_km']!=null) address+="​ ភូមិ​​ "+data.get_village['village_km'];
          if(data.get_commune['commune_km']!=null) address+=",​ ឃុំ "+data.get_commune['commune_km'];
          if(data.get_district['district_km']!=null) address+=", ស្រុក"+data.get_district['district_km'];
          if(data.get_province['province_km']!=null) address+=", ខេត្ត"+data.get_province['province_km'];
          $("#ag-address").append(address);
          $(".show-des").show();
          $("#ag-des").empty();
          $("#ag-des").append(data.description);
          if(data.description==null){
            $(".show-des").hide();
          }
          $("#ag-status").empty();
          $("#ag-status").append("<p class='text-success'>Actived</p>");
           var resource="";
          if(data.image!=''){
            var resource="assets/img/upload/"+data.image;
            document.getElementById("image-field").src=resource;
          }else{
             document.getElementById("image-field").src="assets/img/defaultphoto.png";
          }
          
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-agency').DataTable({
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "<?php echo e(route('datatable.datatable_get_agency')); ?>",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                // {"data": "image",
                //   "render": function(data, type, row) {
                //     return '<img src="' + data + '" border="0" width="100px" height="80px" class="img-rounded" align="center" />';
                //   }
                // }, 
                {data: 'name','name':'nso007_agency.name'}, 
                {data: 'phone','name':'nso007_agency.phone'}, 
                {data: 'id_card_number','name':'nso007_agency.id_card_number'}, 
                {data: 'address','name':'nso007_agency.address'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  function changeStatus(obj){
    $('.main-spinner').show();
    var id=$(obj).attr("id");
    var state=$(obj).attr("state");
    console.log(state);
    var route = "<?php echo e(route('user.update_status',':id')); ?>";
    route = route.replace(':id',id);
    $.ajax({
      type:"GET",
      dataType:"JSON",
      url:route,
      data:{
        '_token':"<?php echo e(csrf_token()); ?>"
      },
      success:function(data){
        $('.main-spinner').hide();
        if(data=="OK"){
          $("#"+id).empty();
          if(state==1){
            $("#"+id).append('<i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i>');
            $("#"+id).attr("state","0");
          }else if(state==0){
            $("#"+id).append('<i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i>');
            $("#"+id).attr("state","1");
          }
          toastr.success("User change state successfully !");
        }
      }
    });
  }
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/agencies/index.blade.php ENDPATH**/ ?>