<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Ledger</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
              <li class="breadcrumb-item active">Accounting</li>
              <li class="breadcrumb-item active">Ledger</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <?php echo $__env->make("accounting.journal.form-seach-journal-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo Form::open(array('route' => 'voucher.print','method'=>'POST','id'=>'print-voucher')); ?>

              <input type="hidden" name="voucher" id="voucher">
            <?php echo Form::close(); ?>

            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="table_journal" class="table table-bordered table-striped table table-condensed table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Project</th>
                        <th>Type</th>
                        <th>Date</th>
                        <th>Reference Number</th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Created By</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody id="tbody"></tbody>
                <tfoot id="tfoot">
                    <tr>

                    </tr>
                </tfoot>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h3 class="modal-title text-danger">Warning...!</h3>
            </div>
            <br />
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-10">
                        <h4>Receivable amount must be smaller than or equal available amount.</h4>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).on('click', '.btn-action', function() {
        $('#block-action').toggle("fast");
    });
    $("form").submit(function(e) {

    });
    $(document).ready(function() {
        var acc_code = $('#acc_code').find(":selected").val();
        var end_date = $('.end_date').val();
        var start_date = $('.start_date').val();
        if (acc_code != "" && end_date != "" && start_date != "") {
            var tr = "";
            var total_debit = 0;
            var total_credit = 0;
            $('#tbody').empty();
            $('#tfoot').empty();
            disable_datatable_features();
            $.ajax({
                url: "<?php echo e(route('get-accounting-report.ledger')); ?>",
                method: "POST",
                dataType: "text",
                data: {
                    acc_code: acc_code,
                    start_date: start_date,
                    end_date: end_date,
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(data) {
                    $('#tbody').append(data);
                }
            });
        } else {
            $.ajax({
                url: "<?php echo e(route('get-accounting-report.ledger')); ?>",
                method: "get",
                dataType: "text",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(data) {
                    $('#tbody').append(data);
                }
            });
        }

    });

    function search_ledger() {

        var acc_code        = $('#acc_code').find(":selected").val();
        var end_date        = $('.end_date').val();
        var start_date      = $('.start_date').val();
        var tr              = "";
        var total_debit     = 0;
        var total_credit    = 0;
        $('#tbody').empty();
        $('#tfoot').empty();
        disable_datatable_features();
        $.ajax({
            url: "<?php echo e(route('get-accounting-report.ledger')); ?>",
            method: "POST",
            dataType: "text",
            data: {
                acc_code: acc_code,
                start_date: start_date,
                end_date: end_date,
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function(data) {
                $('#tbody').append(data);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/accounting/report/ledger.blade.php ENDPATH**/ ?>