<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Income Statement</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
              <li class="breadcrumb-item active">Accounting</li>
              <li class="breadcrumb-item active">Income Statement</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <form action="<?php echo e(route('print.income-statement')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo e(method_field('POST')); ?>

                <div class="title-bar m-4">
                    <?php
                    $start  = new DateTime('first day of this month');
                    $from   = $start->format('d-m-Y');
                    $end    = new DateTime('last day of this month');
                    $to     = $end->format('d-m-Y');
                    ?>
                    <span class="title-tab">
                        <button type="submit" class="btn btn-tab btn-ms btn-warning float-right"><i class="fa fa-print"></i></button>
                        <button type="button" onclick="tableToExcel('table_journal','k-land')" class=" btn btn-info btn-ms float-right " style="margin-right:5px" ><i class="far fa-file-excel"></i></button>
                        <span class="btn-toggle btn btn-primary btn-ms float-right" style="margin-right:5px"><i class="fa fa-search"></i></span>
                        <input type="hidden" name="report" value="Trial Balance">
                    </span>
                    <!-- <button type="submit" class="float-right btn btn-xs btn-warning" data-toggle="tooltip" data-placement="top" title="Print Voucher"><i class="fa fa-print" aria-hidden="true"></i></button> -->
                </div>
                <div class="toggle-div m-4" style="display:none">
                    <div class="form-group row">
                        <div class="form-group  col-sm-6 col-xs-6">
                            <label>Select Project</label>
                            <?php echo Form::select('journal_by_project[]', $projects, null, ['class' => 'form-control select2','id'=>'project_id','multiple']); ?>

                        </div>
                        <div class="form-group  col-sm-6 col-xs-12">
                            <label>Type</label>
                            <?php echo Form::select('type_cash', ['1'=>'Cash Approval (Full Price)','2'=>'Cash Basic (Real Price)'], 1, ['class' => 'form-control select2','id'=>'type_cash']); ?>

                        </div>
                        <div class="col-sm-6 col-xs-12">
                            <label for="">Account Name (Income)</label>
                            <?php echo Form::select('journal_acccode_income[]',\Globals::get_account_code(4,0), null, ['class' => 'form-control select2','id'=>'journal_acccode_income','multiple']); ?>

                        </div>
                        <div class="col-sm-6 col-xs-12">
                            <label for="">Account Name (Expense)</label>
                            <?php echo Form::select('journal_acccode_expense[]',\Globals::get_account_code(5,0), null, ['class' => 'form-control select2','id'=>'journal_acccode_expense','multiple']); ?>

                        </div>
                        <div class="form-group  col-sm-12 col-xs-12">
                            <label><?php echo e(__('application.last months')); ?></label>
                            <?php echo Form::select('last_months',\Globals::last_month_count(), null, ['placeholder'=>'Please Select','class' => 'form-control select2','id'=>'last_months']); ?>

                        </div>
                        <div class="col-sm-6 col-xs-12">
                            <label for="">Start Date</label>
                            <input type="text" name="from" class="form-control date_picker start_date">
                        </div>
                        <div class="col-sm-6 col-xs-12">
                            <label for="">End Date</label>
                            <input type="text" name="to" class="form-control date_picker end_date">
                        </div>
                        <div class="col-sm-12 col-xs-12" style="text-align: right">
                            <button type="button" class="btn-warning btn" style="margin-top: 30px" onclick="search()"><i class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.card-header -->
            <div class="card-body">
                <table id="table_journal" class="table table-bordered table-striped table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Account Name</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>

                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $.ajax({
            url: "<?php echo e(route('accounting-report.get-income-statement')); ?>",
            method: "get",
            dataType: "text",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
            },
            success: function(data) {
                $('#tbody').append(data);
            }
        });
    });

    $(document).on('click', '.clickable-row', function() {
        window.location = $(this).data("href");
    });
    $(document).on('click', '.btn-toggle', function() {
        $('.toggle-div').toggle('fast');
    });

    function search() {
        var from = $('.start_date').val();
        var to = $('.end_date').val();
        var project_id = $('#project_id').val();
        $.ajax({
            url: "<?php echo e(route('accounting-report.get-income-statement')); ?>",
            method: "POST",
            dataType: "text",
            data: {
                from: from,
                to: to,
                project_id: project_id,
                type_cash: $("#type_cash").val(),
                _token: '<?php echo e(csrf_token()); ?>',
                last_months: $("#last_months").val(),
                journal_acccode_income : $("#journal_acccode_income").val(),
                journal_acccode_expense : $("#journal_acccode_expense").val()
            },
            success: function(data){
                $('#start_date').text(from);
                $('#end_date').text(to);
                $('#tbody').empty();
                $('#tbody').append(data);
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/accounting/reports/income-statement.blade.php ENDPATH**/ ?>